/*
 * Decompiled with CFR 0.152.
 */
package com.pip.image;

import com.pip.image.RGBImage;
import javax.microedition.lcdui.Font;

public abstract class RGBGraphics {
    protected int clipX;
    protected int clipY;
    protected int clipWidth;
    protected int clipHeight;
    protected int drawWidth;
    protected int drawHeight;
    private int[] oldClip = null;

    protected void saveClip() {
        this.oldClip = new int[4];
        this.oldClip[0] = this.clipX;
        this.oldClip[1] = this.clipY;
        this.oldClip[2] = this.clipWidth;
        this.oldClip[3] = this.clipHeight;
    }

    protected void restoreClip() {
        if (this.oldClip == null) {
            return;
        }
        this.clipX = this.oldClip[0];
        this.clipY = this.oldClip[1];
        this.clipWidth = this.oldClip[2];
        this.clipHeight = this.oldClip[3];
        this.oldClip = null;
    }

    protected int correctX(int x, int width, int anchor) {
        if ((anchor & 1) != 0) {
            return x - width / 2;
        }
        if ((anchor & 4) != 0) {
            return x;
        }
        return x - width;
    }

    protected int correctY(int y, int height, int anchor) {
        if ((anchor & 2) != 0) {
            return y - height / 2;
        }
        if ((anchor & 0x10) != 0) {
            return y;
        }
        return y - height;
    }

    protected int deCorrectX(int x, int width, int anchor) {
        if ((anchor & 1) != 0) {
            return x + width / 2;
        }
        if ((anchor & 4) != 0) {
            return x;
        }
        return x + width;
    }

    protected int deCorrectY(int y, int height, int anchor) {
        if ((anchor & 2) != 0) {
            return y + height / 2;
        }
        if ((anchor & 0x10) != 0) {
            return y;
        }
        return y + height;
    }

    public int getClipHeight() {
        return this.clipHeight;
    }

    public int getClipWidth() {
        return this.clipWidth;
    }

    public int getClipX() {
        return this.clipX;
    }

    public int getClipY() {
        return this.clipY;
    }

    public void setClip(int x, int y, int width, int height) {
        this.clipX = x;
        this.clipY = y;
        this.clipWidth = width;
        this.clipHeight = height;
        this.clipRect(0, 0, this.drawWidth, this.drawHeight);
    }

    public void clipRect(int x, int y, int width, int height) {
        int newX1 = Math.max(x, this.clipX);
        int newY1 = Math.max(y, this.clipY);
        int newX2 = Math.min(x + width, this.clipX + this.clipWidth);
        int newY2 = Math.min(y + height, this.clipY + this.clipHeight);
        if (newX1 < 0) {
            newX1 = 0;
        } else if (newX1 > this.drawWidth) {
            newX1 = this.drawWidth - 1;
        }
        if (newY1 < 0) {
            newY1 = 0;
        } else if (newY1 > this.drawHeight) {
            newY1 = this.drawHeight - 1;
        }
        if (newX2 < 0) {
            newX2 = 0;
        } else if (newX2 > this.drawWidth) {
            newX2 = this.drawWidth - 1;
        }
        if (newY2 < 0) {
            newY2 = 0;
        } else if (newY2 > this.drawHeight) {
            newY2 = this.drawHeight - 1;
        }
        this.clipX = newX1;
        this.clipY = newY1;
        this.clipWidth = Math.max(0, newX2 - newX1);
        this.clipHeight = Math.max(0, newY2 - newY1);
    }

    public void setColor(int r, int g, int b) {
        this.setColor((r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF);
    }

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawChar(char var1, int var2, int var3, int var4);

    public abstract void drawChars(char[] var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawImage(RGBImage var1, int var2, int var3, int var4);

    public abstract void drawCircle(int var1, int var2, int var3);

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public abstract void drawRect(int var1, int var2, int var3, int var4);

    public abstract void drawRegion(RGBImage var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void drawRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawString(String var1, int var2, int var3, int var4);

    public abstract void drawSubstring(String var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillRect(int var1, int var2, int var3, int var4);

    public abstract void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillTriangle(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract int getBlueComponent();

    public abstract int getColor();

    public abstract int getDisplayColor(int var1);

    public abstract Font getFont();

    public abstract int getGrayScale();

    public abstract int getGreenComponent();

    public abstract int getRedComponent();

    public abstract int getStrokeStyle();

    public abstract int getTranslateX();

    public abstract int getTranslateY();

    public abstract void setColor(int var1);

    public abstract void setFont(Font var1);

    public abstract void setGrayScale(int var1);

    public abstract void setStrokeStyle(int var1);

    public abstract void translate(int var1, int var2);
}

