/*
 * Decompiled with CFR 0.152.
 */
package com.pip.image;

import com.pip.image.PipImage;
import com.pip.sanguo.GameMain;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageSet {
    public PipImage pipImg;
    Image[] img;
    int tileNum;
    long[] tileRects;
    public String fileName = "";

    public ImageSet(String imgFile, int rows, int cols) {
        byte[] data = GameMain.resourceManager.findResource(imgFile);
        Image img = Image.createImage((byte[])data, (int)0, (int)data.length);
        int tileWidth = img.getWidth() / cols;
        int tileHeight = img.getHeight() / rows;
        this.initSimpleFrameSet(img, tileWidth, tileHeight, rows, cols);
    }

    public ImageSet(String imgFile, int fw, int fh, int ns) {
        byte[] data = GameMain.resourceManager.findResource(imgFile);
        Image img = Image.createImage((byte[])data, (int)0, (int)data.length);
        int rows = img.getHeight() / fh;
        int cols = img.getWidth() / fw;
        this.initSimpleFrameSet(img, fw, fh, rows, cols);
    }

    private void initSimpleFrameSet(Image img, int fw, int fh, int rows, int cols) {
        this.img = new Image[]{img};
        this.tileNum = rows * cols;
        this.tileRects = new long[this.tileNum];
        long tileWidth = fw;
        long tileHeight = fh;
        for (int i = 0; i < this.tileNum; ++i) {
            long tileX = (long)(i % cols) * tileWidth;
            long tileY = (long)(i / cols) * tileHeight;
            this.tileRects[i] = tileX << 48 | tileY << 32 | tileWidth << 16 | tileHeight;
        }
    }

    private void initMergPip(PipImage pipImage) {
        this.img = pipImage.getMergeImage();
        int[] frameInfo = pipImage.getMergeFrameInfo();
        this.tileNum = frameInfo.length >> 1;
        this.tileRects = new long[this.tileNum];
        for (int i = 0; i < this.tileNum; ++i) {
            long tileX = frameInfo[i << 1] >> 16 & 0xFFFF;
            long tileY = frameInfo[i << 1] & 0xFFFF;
            long tileWidth = frameInfo[(i << 1) + 1] >> 16 & 0xFFFF;
            long tileHeight = frameInfo[(i << 1) + 1] & 0xFFFF;
            this.tileRects[i] = tileX << 48 | tileY << 32 | tileWidth << 16 | tileHeight;
        }
    }

    public ImageSet(String imgFile) throws IOException {
        this.fileName = imgFile;
        byte[] data = GameMain.resourceManager.findResource(imgFile);
        if (data[0] == -119 && data[1] == 80 && data[2] == 78 && data[3] == 71) {
            Image img = Image.createImage((byte[])data, (int)0, (int)data.length);
            this.initSimpleFrameSet(img, img.getWidth(), img.getHeight(), 1, 1);
        } else {
            this.pipImg = new PipImage(new ByteArrayInputStream(data));
            this.pipImg.fileName = this.fileName;
            if (this.pipImg.isMergeImage()) {
                this.initMergPip(this.pipImg);
                this.pipImg = null;
            }
        }
    }

    public ImageSet(byte[] data) throws IOException {
        if (data[0] == -119 && data[1] == 80 && data[2] == 78 && data[3] == 71) {
            Image img = Image.createImage((byte[])data, (int)0, (int)data.length);
            this.initSimpleFrameSet(img, img.getWidth(), img.getHeight(), 1, 1);
        } else {
            this.pipImg = new PipImage(new ByteArrayInputStream(data));
            if (this.pipImg.isMergeImage()) {
                this.initMergPip(this.pipImg);
                this.pipImg = null;
            }
        }
    }

    public void drawFrame(Graphics g, int fid, int x, int y) {
        this.drawFrame(g, fid, x, y, 0, 20);
    }

    public void drawFrame(Graphics g, int fid, int x, int y, int trans) {
        this.drawFrame(g, fid, x, y, trans, 20);
    }

    public void drawFrame(Graphics g, int fid, int x, int y, int trans, int anchor) {
        int mx = x;
        int my = y;
        if (this.pipImg != null) {
            ++GameMain.drawTimes;
            this.pipImg.draw(g, fid, x, y, trans, anchor);
            return;
        }
        long rct = this.tileRects[fid];
        int fx = (int)(rct >> 48);
        int iid = fx >> 14 & 3;
        fx &= 0x3FFF;
        short fy = (short)(rct >> 32);
        short fw = (short)(rct >> 16);
        short fh = (short)rct;
        if (trans < 4) {
            if ((anchor & 1) > 0) {
                mx -= fw / 2;
            } else if ((anchor & 8) > 0) {
                mx -= fw;
            }
            if ((anchor & 2) > 0) {
                my -= fh / 2;
            } else if ((anchor & 0x20) > 0) {
                my -= fh;
            }
        } else {
            if ((anchor & 1) > 0) {
                mx -= fh / 2;
            } else if ((anchor & 8) > 0) {
                mx -= fh;
            }
            if ((anchor & 2) > 0) {
                my -= fw / 2;
            } else if ((anchor & 0x20) > 0) {
                my -= fw;
            }
        }
        this.drawPNGFrame(g, this.img[iid], fid, fx, fy, fw, fh, trans, mx, my);
    }

    public int getFrameCount() {
        if (this.pipImg != null) {
            return this.pipImg.getFrameCount();
        }
        return this.tileNum;
    }

    public int getBlockCount() {
        if (this.pipImg != null) {
            return this.pipImg.getBlockCount();
        }
        return 0;
    }

    public int getFrameWidth(int frame) {
        if (this.pipImg != null) {
            return this.pipImg.getWidth(frame);
        }
        return (int)(this.tileRects[frame] >> 16 & 0xFFFFL);
    }

    public int getFrameHeight(int frame) {
        if (this.pipImg != null) {
            return this.pipImg.getHeight(frame);
        }
        return (int)(this.tileRects[frame] & 0xFFFFL);
    }

    public void drawPNGFrame(Graphics g, Image image, int fid, int x_src, int y_src, int width, int height, int trans, int x_dest, int y_dest) {
        ++GameMain.drawTimes;
        g.drawRegion(image, x_src, y_src, width, height, trans, x_dest, y_dest, 20);
    }
}

