/*
 * Decompiled with CFR 0.152.
 */
package com.pip.gui;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.gui.GContainer;
import com.pip.gui.GWidget;
import com.pip.gui.IGPaint;
import com.pip.image.ImageSet;
import com.pip.ui.VMGame;
import javax.microedition.lcdui.Font;

public class GTextArea
extends GContainer
implements IGPaint {
    String text;
    String[] lines = new String[0];
    public int color;
    public boolean is3d;
    public int showLines;
    public int totalLines;
    public int lastPageLine;
    public int currentLine;
    public int curPage;
    public int totalPage;
    public int[] colors;
    ImageSet cornerRes;
    public int index;
    public int lineSpace;

    public GTextArea(VMGame _vmGame, int self, int[] vmData, String name) {
        super(_vmGame, self, vmData, name);
        this.vmData[16] = this.font.getHeight();
    }

    public GWidget getClone(VMGame _vmGame) {
        GTextArea gTextArea = new GTextArea(_vmGame, 0, this.getVMDataCopy(), this.name);
        this.setCloneData(gTextArea);
        gTextArea.text = this.text;
        gTextArea.color = this.color;
        gTextArea.is3d = this.is3d;
        gTextArea.showLines = this.showLines;
        gTextArea.totalLines = this.totalLines;
        gTextArea.lastPageLine = this.lastPageLine;
        gTextArea.currentLine = this.currentLine;
        gTextArea.curPage = this.curPage;
        gTextArea.totalPage = this.totalPage;
        gTextArea.lineSpace = this.lineSpace;
        if (this.lines != null) {
            gTextArea.lines = new String[this.lines.length];
            System.arraycopy(this.lines, 0, gTextArea.lines, 0, gTextArea.lines.length);
        }
        if (this.colors != null) {
            gTextArea.colors = new int[this.colors.length];
            System.arraycopy(this.colors, 0, gTextArea.colors, 0, gTextArea.colors.length);
        }
        return gTextArea;
    }

    public void setData(String text, int color, boolean is3d) {
        this.text = text;
        this.color = color;
        this.is3d = is3d;
    }

    public void setBounds(int _x, int _y, int _w, int _h) {
        super.setBounds(_x, _y, _w, _h);
        this.setLines();
    }

    public void setLineSpace(int lineSpace) {
        this.lineSpace = lineSpace;
    }

    public void setBack(int[] colors, String cornerResName, int index) {
        this.colors = colors;
        if (cornerResName != null) {
            this.cornerRes = (ImageSet)Tool.getGlobalObject(cornerResName);
            this.index = index;
        }
    }

    public void setText(String text) {
        this.text = text;
        this.setLines();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setLines();
    }

    private void setLines() {
        this.currentLine = 0;
        this.curPage = 0;
        this.lines = Tool.formatText(this.text, this.vmData[5] - this.vmData[9] - this.vmData[11], this.font);
        this.totalLines = this.lines.length;
        this.showLines = (this.vmData[6] - this.vmData[10] - this.vmData[12] + this.lineSpace) / (this.font.getHeight() + this.lineSpace);
        if (this.showLines > 0) {
            this.totalPage = (this.totalLines + this.showLines - 1) / this.showLines;
            this.needScrollBar = true;
        } else {
            this.totalPage = 1;
        }
        if (this.showLines > this.totalLines) {
            this.showLines = this.totalLines;
        }
        this.lastPageLine = this.totalLines - this.showLines;
        if (this.gsb != null) {
            this.gsb.reset();
            this.gsb.maxScrollDis = this.lastPageLine * this.font.getHeight();
        }
    }

    public String getText() {
        return this.text;
    }

    public void moveUp() {
        ++this.currentLine;
        if (this.currentLine > this.lastPageLine) {
            this.currentLine = this.lastPageLine;
        }
        if (this.gsb != null) {
            this.gsb.scrollPos = this.currentLine * this.font.getHeight();
        }
    }

    public void moveDown() {
        --this.currentLine;
        if (this.currentLine < 0) {
            this.currentLine = 0;
        }
        if (this.gsb != null) {
            this.gsb.scrollPos = this.currentLine * this.font.getHeight();
        }
    }

    public void moveUpPage() {
        this.currentLine += this.showLines;
        ++this.curPage;
        if (this.currentLine >= this.totalLines) {
            this.currentLine = 0;
            this.curPage = 0;
        }
        if (this.gsb != null) {
            this.gsb.scrollPos = this.currentLine * this.font.getHeight();
        }
    }

    public void paint() {
        int _count;
        if (this.colors != null) {
            Tool.drawFrameBox(Utilities.graphics, this.vmData[31] + this.vmData[7], this.vmData[32] + this.vmData[8], this.vmData[5], this.vmData[6], this.colors);
        }
        if (this.cornerRes != null) {
            Tool.drawBoxCorner(Utilities.graphics, this.vmData[31] + this.vmData[7], this.vmData[32] + this.vmData[8], this.vmData[5], this.vmData[6], this.cornerRes, this.index);
        }
        if ((_count = this.currentLine + this.showLines) >= this.totalLines) {
            _count = this.totalLines;
        }
        Utilities.graphics.setColor(this.color);
        int _y = this.vmData[32] + this.vmData[8] + this.vmData[10] + 1;
        Utilities.graphics.setFont(this.font);
        for (int i = this.currentLine; i < _count; ++i) {
            Tool.drawMixedText(Utilities.graphics, this.lines[i], this.vmData[31] + this.vmData[7] + this.vmData[9], _y + (i - this.currentLine) * (this.font.getHeight() + this.lineSpace), this.color, 0, this.is3d, 20, this.font);
        }
        Utilities.graphics.setFont(Utilities.font);
    }

    public int testWidth() {
        String[] tmp = Tool.formatText(this.text, this.vmData[13] - this.vmData[9] - this.vmData[11], this.font);
        return Tool.getStringsMaxWidth(tmp, true) + this.vmData[9] + this.vmData[11];
    }

    public int testHeight(int _width) {
        String[] tmp = Tool.formatText(this.text, _width - this.vmData[9] - this.vmData[11], this.font);
        int _totalLines = tmp.length;
        int _realHeight = (this.font.getHeight() + this.lineSpace) * _totalLines - this.lineSpace + this.vmData[10] + this.vmData[12];
        if (_realHeight > this.vmData[15]) {
            return this.vmData[15];
        }
        return _realHeight;
    }
}

