/*
 * Decompiled with CFR 0.152.
 */
package com.pip.gui;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.gui.GWidget;
import com.pip.gui.IGPaint;
import com.pip.image.ImageSet;
import com.pip.sanguo.GameMain;
import com.pip.ui.VMGame;

public class GIcon
extends GWidget
implements IGPaint {
    int[] backColors;
    ImageSet iconRes;
    public int iconIndex;
    public int trans;
    public int anchor;
    ImageSet numberRes;
    public int numberIndex;
    public int numberSpace;
    public int numberX;
    public int numberY;
    public int number;
    int maskRgb;
    boolean hasMask;

    public GIcon(VMGame _vmGame, int self, int[] vmData, String name) {
        super(_vmGame, self, vmData, name);
    }

    public GWidget getClone(VMGame _vmGame) {
        GIcon gIcon = new GIcon(_vmGame, 0, this.getVMDataCopy(), this.name);
        this.setCloneData(gIcon);
        if (this.backColors != null) {
            gIcon.backColors = new int[this.backColors.length];
            System.arraycopy(this.backColors, 0, gIcon.backColors, 0, gIcon.backColors.length);
        }
        gIcon.iconRes = this.iconRes;
        gIcon.iconIndex = this.iconIndex;
        gIcon.trans = this.trans;
        gIcon.anchor = this.anchor;
        gIcon.numberRes = this.numberRes;
        gIcon.numberIndex = this.numberIndex;
        gIcon.numberSpace = this.numberSpace;
        gIcon.numberX = this.numberX;
        gIcon.numberY = this.numberY;
        gIcon.number = this.number;
        gIcon.maskRgb = this.maskRgb;
        gIcon.hasMask = this.hasMask;
        return gIcon;
    }

    public void setData(int[] backColors, String iconResName, int _iconIndex, int trans, int anchor) {
        this.backColors = backColors;
        if (iconResName != null) {
            this.iconRes = (ImageSet)Tool.getGlobalObject(iconResName);
            this.setIconIndex(_iconIndex);
            this.trans = trans;
            this.anchor = anchor;
        }
    }

    public void setNumberData(String numberResName, int numberIndex, int numberSpace, int numberX, int numberY) {
        this.numberRes = (ImageSet)Tool.getGlobalObject(numberResName);
        this.numberIndex = numberIndex;
        this.numberSpace = numberSpace;
        this.numberX = numberX;
        this.numberY = numberY;
    }

    public void setBackColors(int[] backColors) {
        this.backColors = backColors;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setIconIndex(int _iconIndex) {
        this.iconIndex = _iconIndex;
        if (this.iconIndex >= 0) {
            this.vmData[14] = this.iconRes.getFrameWidth(this.iconIndex);
            this.vmData[16] = this.iconRes.getFrameHeight(this.iconIndex);
            if (this.vmData[5] == 0) {
                this.vmData[5] = this.vmData[14];
                this.vmData[6] = this.vmData[16];
            }
        }
    }

    public void setMask(boolean hasMask, int maskRgb) {
        this.hasMask = hasMask;
        this.maskRgb = maskRgb;
    }

    public void paint() {
        if (this.parentNeedScroll()) {
            this.getIntersect(this.rect);
            Utilities.graphics.setClip(this.rect[0], this.rect[1], this.rect[2], this.rect[3]);
        }
        if (this.backColors != null) {
            Tool.drawFrameBox(Utilities.graphics, this.vmData[31] + this.vmData[7], this.vmData[32] + this.vmData[8], this.vmData[5], this.vmData[6], this.backColors);
        }
        if (this.iconRes != null && this.iconIndex >= 0) {
            this.iconRes.drawFrame(Utilities.graphics, this.iconIndex, this.vmData[31] + this.vmData[7] + this.vmData[5] / 2, this.vmData[32] + this.vmData[8] + this.vmData[6] / 2, this.trans, this.anchor);
        }
        if (this.numberRes != null && this.numberIndex >= 0 && this.number > 0) {
            Tool.drawImageNumber(Utilities.graphics, this.numberRes, this.numberIndex, new Integer(this.number).toString(), this.vmData[31] + this.vmData[7] + this.vmData[5] - this.numberX, this.vmData[32] + this.vmData[8] + this.vmData[6] - this.numberY, this.numberSpace, 40);
        }
        if (this.hasMask) {
            Tool.fillAlphaRect(Utilities.graphics, this.maskRgb, this.vmData[31] + this.vmData[7], this.vmData[32] + this.vmData[8], this.vmData[5], this.vmData[6]);
        }
        Utilities.graphics.setClip(0, 0, GameMain.viewWidth, GameMain.viewHeight);
    }
}

