/*
 * Decompiled with CFR 0.152.
 */
package com.pip.engine;

import com.pip.common.Tool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class PackageFile {
    public String name;
    public int version;
    public String[] fileNames;
    public byte[][] fileContents;
    protected Hashtable nameIndexMap;

    public PackageFile() {
        this.name = "";
        this.fileNames = new String[0];
        this.fileContents = new byte[0][];
        this.nameIndexMap = new Hashtable();
    }

    public PackageFile(byte[] data) throws IOException {
        int i;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        this.name = Tool.readUTF(in);
        this.version = in.readInt();
        int fileCount = in.readShort();
        this.fileNames = new String[fileCount];
        this.nameIndexMap = new Hashtable();
        for (i = 0; i < fileCount; ++i) {
            this.fileNames[i] = Tool.readUTF(in);
            this.nameIndexMap.put("/" + this.fileNames[i], new Integer(i));
        }
        this.fileContents = new byte[fileCount][];
        for (i = 0; i < fileCount; ++i) {
            int length = in.readInt();
            byte[] fileData = new byte[length];
            in.readFully(fileData);
            this.fileContents[i] = fileData;
        }
    }

    public byte[] getFile(String name) {
        Integer index = (Integer)this.nameIndexMap.get(name);
        if (index == null) {
            return null;
        }
        return this.fileContents[index];
    }

    public void releaseFile(String name) {
        Integer index = (Integer)this.nameIndexMap.get(name);
        if (index != null) {
            this.fileContents[index.intValue()] = null;
        }
    }

    public void addFile(String name, byte[] data) {
        int fileCount = this.fileNames.length;
        String[] newNames = new String[fileCount + 1];
        System.arraycopy(this.fileNames, 0, newNames, 0, fileCount);
        newNames[fileCount] = name;
        this.fileNames = newNames;
        this.nameIndexMap.put(name, new Integer(fileCount));
        byte[][] newContents = new byte[fileCount + 1][];
        System.arraycopy(this.fileContents, 0, newContents, 0, fileCount);
        newContents[fileCount] = data;
        this.fileContents = newContents;
    }
}

