/*
 * Decompiled with CFR 0.152.
 */
package com.pip.engine;

import com.pip.common.Tool;
import com.pip.engine.IAnimateCallback;
import com.pip.image.ImageSet;
import com.pip.image.PipAnimateSet;
import com.pip.sanguo.GameMain;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class AnimatePlayer {
    private static Tool keyMaker = new Tool();
    private PipAnimateSet animate;
    private int index;
    private int frame;
    private boolean isShown;
    private boolean playedOnce;
    private String name;
    private int callBackIndex;
    private IAnimateCallback callBackParams;
    private int key;
    private int playType;
    private int[][] drawOffset;
    private ImageSet[] replaceImages;
    private AnimatePlayer parent;
    private int anchor;
    private int order;
    private boolean notIcon;
    private int layer;
    private int[] animateBox = new int[4];

    public AnimatePlayer(String name) {
        this.name = name;
        this.parent = null;
        this.anchor = 192;
        this.order = 1;
        this.key = keyMaker.nextKey();
    }

    public AnimatePlayer getCopy() {
        AnimatePlayer result = new AnimatePlayer(this.name);
        result.frame = this.frame;
        result.index = this.index / 4 * 4;
        result.animate = this.animate;
        result.drawOffset = this.drawOffset;
        result.replaceImages = this.replaceImages;
        return result;
    }

    public AnimatePlayer getRelateCopy() {
        AnimatePlayer result = this.getCopy();
        result.parent = this;
        return result;
    }

    public String getAnimateName() {
        return this.name;
    }

    public int getKey() {
        return this.key;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        this.anchor = anchor;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isNotIcon() {
        return this.notIcon;
    }

    public void setNotIcon(boolean notIcon) {
        this.notIcon = notIcon;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void init(PipAnimateSet animate) {
        this.animate = animate;
        this.drawOffset = new int[animate.getImageCount()][];
    }

    public void setAnimateImageDrawOffset(int imageId, int index, int replaceImageId, int replaceOffset) {
        if (index < 0) {
            this.drawOffset[imageId] = null;
        } else {
            if (this.drawOffset[imageId] == null) {
                this.drawOffset[imageId] = new int[this.animate.getImageFrameCount(imageId)];
                int count = this.drawOffset[imageId].length;
                for (int i = 0; i < count; ++i) {
                    this.drawOffset[imageId][i] = -65536;
                }
            }
            this.drawOffset[imageId][index] = replaceImageId << 16 | replaceOffset & 0xFFFF;
        }
    }

    public void addReplaceAnimateImage(String imageName) {
        ImageSet imageSet = GameMain.resourceManager.findImageSet(imageName, true);
        Vector<ImageSet> tmp = new Vector<ImageSet>();
        if (this.replaceImages != null) {
            for (int i = 0; i < this.replaceImages.length; ++i) {
                tmp.addElement(this.replaceImages[i]);
            }
        }
        tmp.addElement(imageSet);
        this.replaceImages = new ImageSet[tmp.size()];
        tmp.copyInto(this.replaceImages);
    }

    public void draw(Graphics g, int x, int y) {
        if (this.isShown) {
            if (this.parent == null) {
                this.animate.drawAnimateFrameWithOffset(g, this.index, this.frame, x, y, this.drawOffset, this.replaceImages);
            } else {
                this.animate.drawAnimateFrameWithOffset(g, this.parent.index, this.parent.frame, x, y, this.drawOffset, this.replaceImages);
            }
        }
    }

    public void drawSingleFrame(Graphics g, int index, int x, int y) {
        if (this.isShown) {
            this.animate.drawFrameWithOffset(g, index, x, y, this.drawOffset, this.replaceImages);
        }
    }

    public void cycle() {
        if (this.parent == null && this.isShown) {
            ++this.frame;
            if (this.frame >= this.animate.getAnimateLength(this.index)) {
                switch (this.playType) {
                    case 0: {
                        this.frame = 0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        --this.frame;
                    }
                }
                if (this.callBackIndex > 0 && !this.playedOnce) {
                    this.callBack(this.callBackIndex, this.callBackParams);
                }
                this.playedOnce = true;
            }
        }
    }

    public int getPlayType() {
        return this.playType;
    }

    public boolean isHunmanAnimate() {
        return this.animate.getAnimateCount() >= GameMain.humanAnimateIndex;
    }

    public int getAnimateCount() {
        return this.animate.getAnimateCount();
    }

    public boolean playing() {
        return this.playType != 0 && this.callBackIndex > 0 && !this.playedOnce && this.isShown;
    }

    public void callBack(int callBackIndex, IAnimateCallback callBackParams) {
        callBackParams.callback(callBackIndex, this.key);
    }

    public void setAnimate(int index, int playType, int callBackIndex, IAnimateCallback callBackParams) {
        if (index != this.index || callBackIndex >= 0) {
            if (index < 0) {
                index = this.animate.getAnimateCount() - 1;
            } else if (index >= this.animate.getAnimateCount()) {
                index = 0;
            }
            this.index = index;
            this.frame = 0;
            this.playedOnce = false;
        }
        this.playType = playType;
        this.callBackIndex = callBackIndex;
        this.callBackParams = callBackParams;
    }

    public void setShown(boolean shown) {
        this.isShown = shown;
    }

    public boolean isShown() {
        return this.isShown;
    }

    public int[] getDrawArea() {
        return this.animate.getAnimateSize(this.index);
    }

    public int[] getAnimateBox(int index) {
        if (index < 0) {
            return this.animate.getAnimateBox(this.animateBox, this.index);
        }
        return this.animate.getAnimateBox(this.animateBox, index);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AnimatePlayer) {
            AnimatePlayer other = (AnimatePlayer)obj;
            return other.name.equals(this.name);
        }
        return super.equals(obj);
    }
}

