/*
 * Decompiled with CFR 0.152.
 */
package com.pip.common;

import com.pip.common.Utilities;
import com.pip.engine.IAnimateCallback;
import com.pip.image.ImageSet;
import com.pip.image.PipImage;
import com.pip.io.UASegment;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameNetPlayer;
import com.pip.sanguo.GameNpc;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameWorld;
import com.pip.sanguo.SanguoMIDlet;
import com.pip.ui.VM;
import com.pip.ui.VMGame;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class Tool {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int G_BOTTOM = 32;
    public static final int G_HCENTER = 1;
    public static final int G_LEFT = 4;
    public static final int G_RIGHT = 8;
    public static final int G_TOP = 16;
    public static final int G_VCENTER = 2;
    public static final int G_TOPLEFT = 20;
    public static final int G_CENTER = 3;
    public static final int G_TOPCENTER = 17;
    public static final int G_TOPRIGHT = 24;
    public static final int G_BOTTOMLEFT = 36;
    public static final int G_BOTTOMRIGHT = 40;
    public static final int G_BOTTOMCENTER = 33;
    public static final int G_LEFTCENTER = 6;
    public static final int G_RIGHTCENTER = 10;
    public static final byte H_CENTER = 0;
    public static final byte H_LEFT = 1;
    public static final byte H_RIGHT = 2;
    public static Random rnd = new Random(Tool.getSystemTime());
    private static int[] alphaColors;
    private static Image alphaImage;
    private static Hashtable alphaImageMap;
    public static final int RES_UI_TIP_ARROW = 13;
    public static final int RES_UI_TIP_TOPRIGHT = 14;
    public static final int DRAWBACK_TYPE_NORMAL = 0;
    public static final int DRAWBACK_TYPE_GARY = 1;
    public static final int DRAWBACK_TYPE_HIGHLIGHT = 2;
    public static final int DRAWBACK_TYPE_DARKLIGHT = 3;
    public static final int DRAWBACK_TYPE_GREEN = 4;
    public static final int[] DRAWBACK_TYPE_NORMAL_DATA;
    private static int textTick;
    private static final int FTEXT_MASK = 1;
    private static final int FHCRC_MASK = 2;
    private static final int FEXTRA_MASK = 4;
    private static final int FNAME_MASK = 8;
    private static final int FCOMMENT_MASK = 16;
    private static final int BTYPE_NONE = 0;
    private static final int BTYPE_FIXED = 1;
    private static final int BTYPE_DYNAMIC = 2;
    private static final int BTYPE_RESERVED = 3;
    private static final int MAX_BITS = 16;
    private static final int MAX_CODE_LITERALS = 287;
    private static final int MAX_CODE_DISTANCES = 31;
    private static final int MAX_CODE_LENGTHS = 18;
    private static final int EOB_CODE = 256;
    private static final int[] LENGTH_EXTRA_BITS;
    private static final int[] LENGTH_VALUES;
    private static final int[] DISTANCE_EXTRA_BITS;
    private static final int[] DISTANCE_VALUES;
    private static final int[] DYNAMIC_LENGTH_ORDER;
    private static int gzipIndex;
    private static int gzipByte;
    private static int gzipBit;
    private Hashtable maxKey = new Hashtable();
    private Integer key = new Integer(0);
    public static final int CL_BLACK = 0;
    public static final int CL_DARKGRAY = 0x808080;
    public static final int CL_GRAY = 0xC0C0C0;
    public static final int CL_WHITE = 0xFFFFFF;
    public static final int CL_RED = 0xFF0000;
    public static final int CL_YELLOW = 0xFFFF00;
    public static final int CL_GREEN = 65280;
    public static final int CL_LIGHTBLUE = 65535;
    public static final int CL_BLUE = 7322617;
    public static final int CL_PURPLE = 0xFF00FF;
    public static final int CL_LIGHTYELLOW = 0xFFFF80;
    public static final int CL_LIGHTGREEN = 65408;
    public static final int CL_WHITEBLUE = 0x80FFFF;
    public static final int CL_DARKBLUE = 0x8080FF;
    public static final int CL_DARKRED = 0xFF0080;
    public static final int CL_BROWN = 16744512;
    public static final int CL_PEPC = 4005888;
    public static final byte DRAW_ITEMS_ROLE = 1;
    public static final byte DRAW_ITEMS_GROUND_MAPNPC = 2;
    public static final byte DRAW_ITEMS_ROLE_MAPNPC = 3;
    public static final byte DRAW_ITEMS_SKY_MAPNPC = 4;
    public static final byte DRAW_ITEMS_NPC = 5;
    public static final byte DRAW_ITEMS_PLAYER = 6;
    public static final byte DRAW_ITEMS_CREATURE = 7;
    public static final byte DRAW_ITEMS_CORPSE = 8;
    public static final byte DRAW_ITEMS_EXIT = 9;
    public static final byte DRAW_ITEMS_LEAVING_SPRITE = 10;
    public static final byte DRAW_ITEMS_ATTENDANT = 11;
    public static final int DEFAULT_TILE_WIDTH = 16;
    public static final int DEFAULT_TILE_HEIGHT = 16;
    public static final int DRAW_ORDER_TOP = 0;
    public static final int DRAW_ORDER_FRONT = 1;
    public static final int DRAW_ORDER_BACK = 2;
    public static final int DRAW_ORDER_TOP_TOP = 3;
    public static final int CHECK_RESOURCE_SAVE_KEY = -2;
    public static final int SPRITE_ANCHOR_BOX_TOP = 1;
    public static final int SPRITE_ANCHOR_BOX_BOTTOM = 2;
    public static final int SPRITE_ANCHOR_BOX_LEFT = 4;
    public static final int SPRITE_ANCHOR_BOX_RIGHT = 8;
    public static final int SPRITE_ANCHOR_BOX_HCENTER = 16;
    public static final int SPRITE_ANCHOR_BOX_VCENTER = 32;
    public static final int SPRITE_ANCHOR_X_REF = 64;
    public static final int SPRITE_ANCHOR_Y_REF = 128;
    public static final int SPRITE_ANCHOR_HEAD = 256;
    public static final byte VM_PROCESSOR_PANEL = -2;
    public static final byte VM_PROCESSOR_WORLD = -1;
    public static final byte VM_PROCESSOR_GAMESPRITE = -100;
    public static final byte SPRITE_TYPE_ROLE = 0;
    public static final byte SPRITE_TYPE_PLAYER = 1;
    public static final byte SPRITE_TYPE_NPC = 3;
    public static final byte SPRITE_TYPE_CREATURE = 2;
    public static final byte SPRITE_TYPE_CORPSE = 4;
    public static final byte SPRITE_TYPE_GATHER_NPC = 5;
    public static final byte SPRITE_TYPE_ATTENDANT = 6;
    public static final byte SPRITE_TYPE_EXIT = 99;
    public static final byte SPRITE_TYPE_ICON = 100;
    public static final int DIR_NONE = -1;
    public static final int DIR_DOWN = 0;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_LEFT = 2;
    public static final int DIR_UP = 3;
    public static final int SUB_DIR_TOPRIGHT = 0;
    public static final int SUB_DIR_TOPLEFT = 1;
    public static final int SUB_DIR_BOTTOMRIGHT = 2;
    public static final int SUB_DIR_BOTTOMLEFT = 3;
    public static final byte WAY_POINT_STATUS_IDLE = 0;
    public static final byte WAY_POINT_STATUS_DOING = 1;
    public static final byte WAY_POINT_STATUS_DONE = 2;
    public static final byte X_AXIS = 0;
    public static final byte Y_AXIS = 1;
    public static final byte HEAD_STRING_TYPE_DRAWAREA = 0;
    public static final byte HEAD_STRING_TYPE_ABSOLUTE = 1;
    public static final byte HEAD_STRING_TYPE_XAREA = 2;
    public static final byte DRAW_STRING_3D = 0;
    public static final byte DRAW_STRING_NORMAL = 1;
    public static final byte NO_CALL_BACK = -1;
    public static final IAnimateCallback NO_CALL_BACK_SPRITE;
    public static final byte ANIMATE_IMAGE_NO_REPLACE = -1;
    public static final byte ANIMATE_PLAY_TYPE_ALWAYS = 0;
    public static final byte ANIMATE_PLAY_TYPE_ONCE = 1;
    public static final byte ANIMATE_PLAY_TYPE_HOLD = 2;
    public static final int FLYING_STRING_TYPE_NUMBER = 0;
    public static final int FLYING_STRING_TYPE_STRING = 1;
    public static final int FLYING_STRING_TYPE_3DSTRING = 2;
    public static final int ATTACK_TYPE_WEAPON = 0;
    public static final int ATTACK_TYPE_BOW = 1;
    public static final int ATTACK_TYPE_MAGIC = 2;
    public static final int ANIMATE_EFFECT_MAGIC = 0;
    public static final int ANIMATE_EFFECT_POSION = 1;
    public static final int ANIMATE_EFFECT_MAGIC_HIT = 2;
    public static final int ANIMATE_EFFECT_ATTACK_HIT = 3;
    public static final int ANIMATE_EFFECT_ARROW_HIT = 4;
    public static final String ANIMATE_SPRITE_ROLE_MALE = "male.ctn";
    public static final String ANIMATE_SPRITE_ROLE_HORSE = "horse.ctn";
    public static final String ANIMATE_SPRITE_ROLE_EFFECT = "effect.ctn";
    public static final String ANIMATE_SPRITE_ROLE_MAGIC = "magic.ctn";
    public static final int ANIMATE_IMAGE_ID_BODY1 = 0;
    public static final int ANIMATE_IMAGE_ID_BODY2 = 1;
    public static final int ANIMATE_IMAGE_ID_ATTACK = 2;
    public static final int ANIMATE_IMAGE_ID_LIMB1 = 3;
    public static final int ANIMATE_IMAGE_ID_LIMB2 = 4;
    public static final int ANIMATE_IMAGE_ID_HORSE = 5;
    public static final int ANIMATE_IMAGE_ID_WEAPON = 6;
    public static final int ANIMATE_IMAGE_FRAME_ID_HANDLE = 0;
    public static final int ANIMATE_IMAGE_FRAME_ID_WEAPON = 1;
    public static final int ANIMATE_IMAGE_FRAME_ID_HEAD_1 = 0;
    public static final int ANIMATE_IMAGE_FRAME_ID_HEAD_2 = 1;
    public static final int ANIMATE_IMAGE_FRAME_ID_HEAD_3 = 2;
    public static final int ANIMATE_IMAGE_FRAME_ID_BODY_1 = 3;
    public static final int ANIMATE_IMAGE_FRAME_ID_BODY_2 = 4;
    public static final int ANIMATE_IMAGE_FRAME_ID_BODY_3 = 5;
    public static final int ANIMATE_IMAGE_FRAME_ID_BODY_4 = 6;
    public static final int[] BACK_MATRIX;
    public static final int[] MOVE_MATRIX;
    public static final int[] ASSIS_LEFT_MATRIX;
    public static final int[] ASSIS_RIGHT_MATRIX;
    public static final int FOLLOW_DIS_X = 20;
    public static final int FOLLOW_DIS_Y = 20;
    public static final int[] FOLLOW_DIS_MATRIX;
    public static final int[] VIBRA_MATRIX;
    public static final int[] SIN_TABLE;
    private static Hashtable globalVars;
    private static final String punctation = ",.?:\"!;\uff0c\u3002\uff1f\uff1a\u201c\u201d\uff01\uff1b";
    public static final short CONN_SYNC_CLIENT = 101;
    public static final short CONN_SYNC_SERVER = 102;
    public static final short CONN_LOGIN_CLIENT = 103;
    public static final short CONN_LOGIN_SERVER = 104;
    public static final short CONN_MOVE_CLIENT = 105;
    public static final short CONN_MOVE_SERVER = 106;
    public static final short CONN_ON_HORSE_CLIENT = 107;
    public static final short CONN_OFF_HORSE_CLIENT = 108;
    public static final short CONN_ATTACK_CLIENT = 109;
    public static final short CONN_ATTACK_SERVER = 110;
    public static final short CONN_ATTACKED_SERVER = 111;
    public static final short CONN_LOGOUT_CLIENT = 113;
    public static final short CONN_LOGOUT_SERVER = 114;
    public static final short CONN_UNIT_INVISIBLE_SERVER = 115;
    public static final short CONN_TOUCHEXIT_CLIENT = 116;
    public static final short CONN_PKG_SERVER = 117;
    public static final short CONN_TOUCHNPC_CLIENT = 120;
    public static final short CONN_NPC_CHAT_SERVER = 121;
    public static final short CONN_MESSAGE_SERVER = 122;
    public static final short CONN_QUESTION_SERVER = 123;
    public static final short CONN_ABILITIES_SERVER = 124;
    public static final short CONN_QUEST_START_ADDED_SERVER = 125;
    public static final short CONN_QUEST_START_REMOVED_SERVER = 126;
    public static final short CONN_QUEST_FINISH_ADDED_SERVER = 127;
    public static final short CONN_QUEST_FINISH_REMOVED_SERVER = 128;
    public static final short CONN_QUEST_DESC_CLIENT = 129;
    public static final short CONN_QUEST_DESC_SERVER = 130;
    public static final short CONN_QUEST_ACCEPT_CLIENT = 131;
    public static final short CONN_QUEST_ACCEPTED_SERVER = 132;
    public static final short CONN_LOADING_FINISHED_CLIENT = 133;
    public static final short CONN_GOMAP_ALLOW = 134;
    public static final short CONN_QUEST_FINISHED_SERVER = 135;
    public static final short CONN_ATTACK_FAIL_SERVER = 136;
    public static final short CONN_QUEST_FINISH_CLIENT = 137;
    public static final short CONN_QUEST_FINISH_FAIL_SERVER = 138;
    public static final short CONN_BAG_CHANGED_SERVER = 139;
    public static final short CONN_ITEMINFO_CLIENT = 142;
    public static final short CONN_ITEMINFO_SERVER = 143;
    public static final short CONN_SYNC_PLAYER_SERVER = 144;
    public static final short CONN_USEITEM_CLIENT = 145;
    public static final short CONN_BAG_CLIENT = 146;
    public static final short CONN_BAG_SERVER = 147;
    public static final short CONN_REMOVEITEM_CLIENT = 148;
    public static final short CONN_QUEST_PREDESC_CLIENT = 149;
    public static final short CONN_QUEST_PREDESC_SERVER = 150;
    public static final short CONN_QUEST_POSTDESC_CLIENT = 151;
    public static final short CONN_QUEST_POSTDESC_SERVER = 152;
    public static final short CONN_SKILL_LIST_CLIENT = 153;
    public static final short CONN_SKILL_LIST_SERVER = 154;
    public static final short CONN_SKILL_ADDPOINT_CLIENT = 155;
    public static final short CONN_SKILL_REFRESH_CLIENT = 156;
    public static final short CONN_SKILL_NAMELIST_CLIENT = 157;
    public static final short CONN_SKILL_NAMELIST_SERVER = 158;
    public static final short CONN_QUEST_LIST_CLIENT = 159;
    public static final short CONN_QUEST_LIST_SERVER = 160;
    public static final short CONN_QUEST_INFO_SERVER = 161;
    public static final short CONN_VM_VARIABLE_SYNC_CLIENT = 162;
    public static final short CONN_VM_VARIABLE_SYNC_SERVER = 163;
    public static final short CONN_ITEM_DESC_CLIENT = 164;
    public static final short CONN_ITEM_DESC_SERVER = 165;
    public static final short CONN_QUEST_ABANDON_CLIENT = 172;
    public static final short CONN_QUEST_ABANDON_SERVER = 173;
    public static final short CONN_NOTIFY_CLIENT = 174;
    public static final short CONN_SKILL_ATTACK_SERVER = 186;
    public static final short CONN_SKILL_ATTACKED_SERVER = 187;
    public static final short CONN_VERSION_COMPARE_CLIENT = 188;
    public static final short CONN_VERSION_COMPARE_SERVER = 189;
    public static final short CONN_SYNC_VERSION_SERVER = 190;
    public static final short CONN_GETFILE_CLIENT = 191;
    public static final short CONN_GETFILE_SERVER = 192;
    public static final short CONN_UNIT_REFRESH_SERVER = 193;
    public static final short CONN_UNIT_MULTI_REFRESH_SERVER = 194;
    public static final short CONN_UNIT_MOVE_SERVER = 195;
    public static final short CONN_UNIT_INFO_CLIENT = 196;
    public static final short CONN_UNIT_INFO_SERVER = 197;
    public static final short CONN_GATHER_START_CLIENT = 198;
    public static final short CONN_GATHER_END_CLIENT = 199;
    public static final short CONN_RELOAD_CLIENT = 200;
    public static final short CONN_ACTIONBAR_OPTION_CLIENT = 236;
    public static final short CONN_ACTIONBAR_OPTION_SERVER = 237;
    public static final short SET_ACTIONBAR_OPTION_CLIENT = 238;
    public static final short SET_ACTIONBAR_OPTION_SERVER = 239;
    public static final short CONN_OPENUI_SERVER = 235;
    public static final short CONN_SKILL_PREPARE_ATTACK_SERVER = 297;
    public static final short CONN_CHASE_SERVER = 336;
    public static final short CONN_REQUEST_WHOLE_MOVE = 348;
    public static final short NEW_CONN_GETFILE_CLIENT = 2381;
    public static final short NEW_CONN_GETFILE_SERVER = 2382;
    public static Hashtable unitViewCache;

    public static long getSystemTime() {
        return System.currentTimeMillis();
    }

    public static Integer getSpriteKey(int instanceId) {
        return new Integer(instanceId);
    }

    public static Long getSpriteKey(int type, int id) {
        return new Long((long)type << 32 | (long)id);
    }

    public static int getSpriteKeyType(Long key) {
        return (int)(key >> 32);
    }

    public static int getSpriteKeyId(Long key) {
        return (int)(key & 0xFFFFFFFFFFFFFFFFL);
    }

    public static int calulateStepWithMoveMatrix(byte axis, int dir, int step) {
        return MOVE_MATRIX[(dir << 1) + axis] * step;
    }

    public static int calulateStepWithBackMatrix(byte axis, int dir, int step) {
        return BACK_MATRIX[(dir << 1) + axis] * step;
    }

    public static int calulateOffsetWithVibraMatrix(byte axis, int dir, int tick) {
        return VIBRA_MATRIX[(dir << 2) + ((tick & 1) << 1) + axis];
    }

    public static void calulateDirWithWayPointMatrix(int srcDir, int srcSubDir, int src_x, int src_y, int dest_x, int dest_y, int[] newDir) {
        int dx = dest_x - src_x;
        int dy = dest_y - src_y;
        newDir[0] = srcDir;
        newDir[1] = srcSubDir;
        if (dx == 0 && dy == 0) {
            return;
        }
        if (Math.abs(dx) - Math.abs(dy) >= 0) {
            if (dx >= 0) {
                newDir[0] = 1;
                newDir[1] = dy >= 0 ? 2 : 0;
            } else {
                newDir[0] = 2;
                newDir[1] = dy >= 0 ? 3 : 1;
            }
        } else if (dy >= 0) {
            newDir[0] = 0;
            newDir[1] = dx >= 0 ? 2 : 3;
        } else {
            newDir[0] = 3;
            newDir[1] = dx >= 0 ? 0 : 1;
        }
    }

    private static int correctWayPointMatrixParameter(int para) {
        return (para > 0 ? 1 : (para == 0 ? 0 : -1)) + 1;
    }

    public static int getNextRnd(int min, int max) {
        if (max <= min) {
            return min;
        }
        return min + Math.abs(rnd.nextInt()) % (max - min);
    }

    public static void mergeBox(int[] box, int[] box1) {
        if (box1[2] == 0) {
            return;
        }
        if (box[2] == 0) {
            box[0] = box1[0];
            box[1] = box1[1];
            box[2] = box1[2];
            box[3] = box1[3];
        } else {
            int bx = box[0];
            int by = box[1];
            box[0] = bx < box1[0] ? bx : box1[0];
            box[1] = by < box1[1] ? by : box1[1];
            box[2] = (bx + box[2] > box1[0] + box1[2] ? bx + box[2] : box1[0] + box1[2]) - box[0];
            box[3] = (by + box[3] > box1[1] + box1[3] ? by + box[3] : box1[1] + box1[3]) - box[1];
        }
    }

    public static String[] splitString(String s, char ch) {
        int startIndex = 0;
        int endIndex = 0;
        Vector<String> vS = new Vector<String>();
        while (true) {
            if ((endIndex = s.indexOf(ch, startIndex)) == -1) break;
            vS.addElement(s.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
        }
        vS.addElement(s.substring(startIndex));
        Object[] strs = new String[vS.size()];
        vS.copyInto(strs);
        return strs;
    }

    public static String[] splitString(String s) {
        return Tool.splitString(s, '\n');
    }

    public static int getStringsMaxWidth(String[] strs, boolean mixed) {
        int width = 0;
        if (strs != null) {
            int sw = 0;
            for (int i = 0; i < strs.length; ++i) {
                sw = mixed ? Tool.drawMixedText(null, strs[i], 0, 0, 0, 0, true, 0) : Utilities.font.stringWidth(strs[i]);
                if (width >= sw) continue;
                width = sw;
            }
        }
        return width;
    }

    public static void clearAlphaImageMap() {
        alphaImageMap.clear();
    }

    public static void fillAlphaRect(Graphics g, int rgb, int x, int y, int width, int height) {
        int alpha = rgb & 0xFF000000;
        if (alpha == 0) {
            return;
        }
        if (alpha == -16777216) {
            g.setColor(rgb & 0xFFFFFF);
            g.fillRect(x, y, width, height);
            return;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        alphaImage = (Image)alphaImageMap.get(new Integer(rgb));
        if (alphaImage == null) {
            int[] tmp = new int[GameMain.viewWidth];
            for (int i = 0; i < GameMain.viewWidth; ++i) {
                tmp[i] = rgb;
            }
            alphaImage = Image.createRGBImage((int[])tmp, (int)GameMain.viewWidth, (int)1, (boolean)true);
            alphaImageMap.put(new Integer(rgb), alphaImage);
        }
        g.clipRect(x, y, width, height);
        for (int j = 0; j < height; ++j) {
            g.drawImage(alphaImage, x, y + j, 20);
        }
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public static void draw3DString(Graphics g, String text, int x, int y, int color, int bgColor, int anchor) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (bgColor < 0) {
            g.setColor(color);
            Tool.drawString(g, text, x, y, anchor);
            return;
        }
        switch (GameMain.draw3DStringLevel) {
            case 0: {
                g.setColor(bgColor);
                Tool.drawString(g, text, x + 1, y - 1, anchor);
                Tool.drawString(g, text, x - 1, y + 1, anchor);
                Tool.drawString(g, text, x - 1, y - 1, anchor);
                Tool.drawString(g, text, x + 1, y + 1, anchor);
                Tool.drawString(g, text, x, y - 1, anchor);
                Tool.drawString(g, text, x, y + 1, anchor);
                Tool.drawString(g, text, x - 1, y, anchor);
                Tool.drawString(g, text, x + 1, y, anchor);
                break;
            }
            case 1: {
                g.setColor(bgColor);
                Tool.drawString(g, text, x, y - 1, anchor);
                Tool.drawString(g, text, x, y + 1, anchor);
                Tool.drawString(g, text, x - 1, y, anchor);
                Tool.drawString(g, text, x + 1, y, anchor);
                break;
            }
            case 2: {
                g.setColor(bgColor);
                Tool.drawString(g, text, x + 1, y + 1, anchor);
            }
        }
        g.setColor(color);
        Tool.drawString(g, text, x, y, anchor);
    }

    public static void draw3DString2(Graphics g, String text, int x, int y, int color, int bgColor, int anchor) {
        if (bgColor < 0) {
            g.setColor(color);
            Tool.drawString(g, text, x, y, anchor);
            return;
        }
        switch (GameMain.draw3DStringLevel) {
            case 0: {
                g.setColor(bgColor);
                Tool.drawString(g, text, x + 2, y, anchor);
                Tool.drawString(g, text, x, y + 2, anchor);
                Tool.drawString(g, text, x, y, anchor);
                Tool.drawString(g, text, x + 2, y + 2, anchor);
                Tool.drawString(g, text, x + 1, y, anchor);
                Tool.drawString(g, text, x + 1, y + 2, anchor);
                Tool.drawString(g, text, x, y + 1, anchor);
                Tool.drawString(g, text, x + 2, y + 1, anchor);
                break;
            }
            case 1: {
                g.setColor(bgColor);
                Tool.drawString(g, text, x + 1, y, anchor);
                Tool.drawString(g, text, x + 1, y + 2, anchor);
                Tool.drawString(g, text, x, y + 1, anchor);
                Tool.drawString(g, text, x + 2, y + 1, anchor);
                break;
            }
            case 2: {
                g.setColor(bgColor);
                Tool.drawString(g, text, x + 1, y + 1, anchor);
                g.setColor(color);
                Tool.drawString(g, text, x, y, anchor);
                return;
            }
        }
        g.setColor(color);
        Tool.drawString(g, text, x + 1, y + 1, anchor);
    }

    public static int get3DStringWidth(String str) {
        return Tool.get3DStringWidthEx(str, Utilities.font);
    }

    public static int get3DStringWidthEx(String str, Font font) {
        int _3dStringWidth = font.stringWidth(str);
        switch (GameMain.draw3DStringLevel) {
            case 0: 
            case 1: {
                _3dStringWidth += 2;
                break;
            }
            case 2: {
                ++_3dStringWidth;
            }
        }
        return _3dStringWidth;
    }

    public static int get3DStringHeight() {
        return Tool.get3DStringHeightEx(Utilities.font);
    }

    public static int get3DStringHeightEx(Font font) {
        int _3dStringHeight = font.getHeight();
        switch (GameMain.draw3DStringLevel) {
            case 0: 
            case 1: {
                _3dStringHeight += 2;
                break;
            }
            case 2: {
                ++_3dStringHeight;
            }
        }
        return _3dStringHeight;
    }

    public static void drawString(Graphics g, String text, int x, int y, int anchor) {
        g.drawString(text, x, y - Utilities.CHAR_OFFSET, anchor);
    }

    public static int drawImageNumber(Graphics g, ImageSet numberImg, String str, int x, int y, int anchor) {
        return Tool.drawImageNumber(g, numberImg, 0, str, x, y, 0, anchor);
    }

    public static int drawImageNumber(Graphics g, ImageSet numberImg, int startIndex, String str, int x, int y, int space, int anchor) {
        if (numberImg == null) {
            return 0;
        }
        int cw = numberImg.getFrameWidth(startIndex);
        int ch = numberImg.getFrameHeight(startIndex);
        int len = str.length();
        int tw = len * cw;
        if ((anchor & 1) > 0) {
            x -= tw / 2;
        } else if ((anchor & 8) > 0) {
            x -= tw;
        }
        if ((anchor & 2) > 0) {
            y -= ch / 2;
        } else if ((anchor & 0x20) > 0) {
            y -= ch;
        }
        int totalWidth = 0;
        for (int i = 0; i < len; ++i) {
            char chr = str.charAt(i);
            int ind = -1;
            if (chr >= '0' && chr <= '9') {
                ind = chr - 48;
            } else if (chr == '+') {
                ind = 10;
            } else if (chr == '-') {
                ind = 11;
            } else if (chr == '/') {
                ind = 12;
            } else if (chr == '(') {
                ind = 13;
            } else if (chr == ')') {
                ind = 14;
            }
            if (g != null) {
                numberImg.drawFrame(g, startIndex + ind, x, y);
            }
            x += cw + space;
            totalWidth += cw + space;
        }
        return totalWidth;
    }

    public static void drawFlyingString(Graphics g, int x, int y, String str, int color, int distance, int percent, int tick, boolean is3d) {
        int rx = x;
        int ry = y;
        ry -= distance * percent / 100;
        if (is3d) {
            Tool.draw3DString(g, str, rx, ry, color, 0, 33);
        } else {
            g.setColor(color);
            g.drawString(str, rx, ry, 33);
        }
    }

    public static void drawFlyingNumber(Graphics g, int x, int y, int[] frames, int paletteColor, int distance, int percent, int tick) {
        int rx = x;
        int ry = y;
        int offset = GameMain.flyNumberIndex;
        rx -= frames.length * GameMain.numberImage.getFrameWidth(offset += paletteColor * GameMain.flyNumberBlockCount) / 2;
        ry -= distance * percent / 100;
        for (int i = 0; i < frames.length; ++i) {
            int frame = frames[i] + offset;
            GameMain.numberImage.drawFrame(g, frame, rx, ry);
            rx += GameMain.numberImage.getFrameWidth(frame);
        }
    }

    public static int[] getNumberFrameArray(int number) {
        Vector<Integer> tmp = new Vector<Integer>();
        if (number < 0) {
            tmp.addElement(new Integer(11));
            number = -number;
        } else {
            tmp.addElement(new Integer(10));
        }
        String str = "" + number;
        for (int i = 0; i < str.length(); ++i) {
            tmp.addElement(new Integer(str.charAt(i) - 48));
        }
        int[] result = new int[tmp.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)tmp.elementAt(i);
        }
        return result;
    }

    public static int calculateDistance(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2, int direct) {
        int result = 0;
        switch (direct) {
            case 3: {
                result = y2 - (y1 + h1);
                break;
            }
            case 0: {
                result = y1 - (y2 + h2);
                break;
            }
            case 2: {
                result = x2 - (x1 + w1);
                break;
            }
            case 1: {
                result = x1 - (x2 + w2);
            }
        }
        if (result < 0) {
            result = 0;
        }
        return result;
    }

    public static boolean rectIntersect(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 + w1 > x2 && x1 < x2 + w2 && y1 + h1 > y2 && y1 < y2 + h2;
    }

    public static void rectGetIntersection(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2, int[] ret) {
        int tx1 = x1;
        int ty1 = y1;
        int rx1 = x2;
        int ry1 = y2;
        long tx2 = tx1;
        tx2 += (long)w1;
        long ty2 = ty1;
        ty2 += (long)h1;
        long rx2 = rx1;
        rx2 += (long)w2;
        long ry2 = ry1;
        ry2 += (long)h2;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        ret[0] = tx1;
        ret[1] = ty1;
        ret[2] = (int)tx2;
        ret[3] = (int)ty2;
    }

    public static boolean rectContain(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 <= x2 && x1 + w1 >= x2 + w2 && y1 <= y2 && y1 + h1 >= y2 + h2;
    }

    public static boolean rectIn(int x1, int y1, int w1, int h1, int x2, int y2) {
        return x1 <= x2 && x1 + w1 >= x2 && y1 <= y2 && y1 + h1 >= y2;
    }

    public static int distance(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        return (int)Tool.sqrt(dx * dx + dy * dy);
    }

    public static long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static void debug(String msg) {
        System.out.println(msg);
    }

    public static int sin(int angle) {
        if (angle < 0) {
            angle += (-angle / 360 + 1) * 360;
        }
        int reaAngle = angle % 360;
        int ret = 0;
        if (reaAngle >= 0 && reaAngle <= 90) {
            ret = SIN_TABLE[reaAngle];
        } else if (reaAngle > 90 && reaAngle <= 180) {
            ret = SIN_TABLE[180 - reaAngle];
        } else if (reaAngle > 180 && reaAngle <= 270) {
            ret = -SIN_TABLE[reaAngle - 180];
        } else if (reaAngle > 270 && reaAngle < 360) {
            ret = -SIN_TABLE[360 - reaAngle];
        }
        return ret;
    }

    public static int cos(int angle) {
        return Tool.sin(90 - angle);
    }

    public static int gcd(int m, int n) {
        int tmp;
        if (m == 0) {
            return n;
        }
        if (n == 0) {
            return m;
        }
        if (m < n) {
            tmp = m;
            m = n;
            n = tmp;
        }
        while (n != 0) {
            tmp = m % n;
            m = n;
            n = tmp;
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadLocalResource(String name) {
        byte[] result = null;
        InputStream is = null;
        try {
            is = ((Object)((Object)SanguoMIDlet.instance)).getClass().getResourceAsStream("/" + name);
            result = Utilities.getBytesFromInput(is);
        }
        catch (Exception e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    public static void drawFrameBox(Graphics g, int x, int y, int width, int height, int[] colors) {
        int count = colors.length;
        g.setColor(colors[0]);
        g.fillRect(x, y, width - 1, height - 1);
        int bx = x - 1;
        int by = y - 1;
        int bw = width + 1;
        int bh = height + 1;
        for (int i = 1; i < count; ++i) {
            g.setColor(colors[i]);
            g.drawRect(++bx, ++by, bw -= 2, bh -= 2);
        }
    }

    public static void drawBoxCorner(Graphics g, int x, int y, int width, int height, ImageSet image, int index) {
        int imageWidth = image.getFrameWidth(index);
        int imageHeight = image.getFrameHeight(index);
        image.drawFrame(g, index, x, y, 0);
        image.drawFrame(g, index, x + width - imageWidth, y, 2);
        image.drawFrame(g, index, x, y + height - imageHeight, 1);
        image.drawFrame(g, index, x + width - imageWidth, y + height - imageHeight, 3);
    }

    public static void drawTip(Graphics g, int arrowX, int arrowY, String[] tipStr, ImageSet res_Image) {
        if (tipStr == null) {
            return;
        }
        int tipCornerWidth = res_Image.getFrameWidth(14);
        int tipCornerHeight = res_Image.getFrameHeight(14);
        int tipArrowHeight = res_Image.getFrameWidth(13);
        int tipRows = tipStr.length;
        int maxWidth = 0;
        for (int i = 0; i < tipRows; ++i) {
            int width = Tool.drawMixedText(null, tipStr[i], 0, 0, 0, 0, true, 0);
            if (maxWidth >= width) continue;
            maxWidth = width;
        }
        int bagTipWidth = (tipCornerWidth << 1) + maxWidth + 2;
        int bagTipHeight = Utilities.font.getHeight() * tipRows;
        if (bagTipHeight < tipCornerHeight << 1) {
            bagTipHeight = tipCornerHeight << 1;
        }
        int bagTipX = arrowX - tipCornerWidth - (bagTipWidth >> 1);
        int bagTipY = arrowY - tipArrowHeight - bagTipHeight;
        int bagTipRx = bagTipX + bagTipWidth;
        Tool.fillAlphaRect(g, -1426391067, bagTipX, bagTipY + tipCornerHeight, bagTipWidth, bagTipHeight - (tipCornerHeight << 1));
        Tool.fillAlphaRect(g, -1426391067, bagTipX + tipCornerWidth, bagTipY, bagTipWidth - (tipCornerWidth << 1), tipCornerHeight);
        Tool.fillAlphaRect(g, -1426391067, bagTipX + tipCornerWidth, bagTipY + bagTipHeight - tipCornerHeight, bagTipWidth - (tipCornerWidth << 1), tipCornerHeight);
        g.setColor(5179648);
        g.drawLine(bagTipX + tipCornerWidth, bagTipY, bagTipX + bagTipWidth - tipCornerWidth, bagTipY);
        g.drawLine(bagTipX + tipCornerWidth, bagTipY + bagTipHeight, bagTipX + bagTipWidth - tipCornerWidth, bagTipY + bagTipHeight);
        g.drawLine(bagTipX, bagTipY + tipCornerHeight, bagTipX, bagTipY + bagTipHeight - tipCornerHeight);
        g.drawLine(bagTipRx, bagTipY + tipCornerHeight, bagTipRx, bagTipY + bagTipHeight - tipCornerHeight);
        res_Image.drawFrame(g, 13, arrowX, arrowY - tipArrowHeight, 3, 24);
        Tool.drawBoxCorner(g, bagTipX, bagTipY, bagTipWidth, bagTipHeight, res_Image, 14);
        g.setColor(0);
        for (int i = 0; i < tipRows; ++i) {
            if (tipStr[i] == null) continue;
            Tool.drawMixedText(g, tipStr[i], bagTipX + tipCornerWidth, bagTipY + Utilities.font.getHeight() * i, 0, 0, tipStr[i].indexOf("{x}") != -1, 20);
        }
    }

    public static void drawSpellRow(Graphics g, int x, int y, int width, ImageSet image, int index, int trans) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int imageWidth = image.getFrameWidth(index);
        int imageHeight = image.getFrameHeight(index);
        if (trans == 4 || trans == 7 || trans == 6 || trans == 5) {
            int tmp = imageHeight;
            imageHeight = imageWidth;
            imageWidth = tmp;
        }
        int imageCount = width / imageWidth;
        if (width % imageWidth > 0) {
            ++imageCount;
        }
        g.clipRect(x, y, width, imageHeight);
        int cx = x;
        for (int i = 0; i < imageCount; ++i) {
            image.drawFrame(g, index, cx, y, trans);
            cx += imageWidth;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public static void drawSpellCol(Graphics g, int x, int y, int height, ImageSet image, int index, int trans) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int imageWidth = image.getFrameWidth(index);
        int imageHeight = image.getFrameHeight(index);
        if (trans == 4 || trans == 7 || trans == 6 || trans == 5) {
            int tmp = imageHeight;
            imageHeight = imageWidth;
            imageWidth = tmp;
        }
        int imageCount = height / imageHeight;
        if (height % imageHeight > 0) {
            ++imageCount;
        }
        g.clipRect(x, y, imageWidth, height);
        int cy = y;
        for (int i = 0; i < imageCount; ++i) {
            image.drawFrame(g, index, x, cy, trans);
            cy += imageHeight;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public static void drawSpellArea(Graphics g, int x, int y, int width, int height, ImageSet image, int index, int trans) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int imageWidth = image.getFrameWidth(index);
        int imageHeight = image.getFrameHeight(index);
        int imageColCount = width / imageWidth;
        if (width % imageWidth > 0) {
            ++imageColCount;
        }
        int imageRowCount = height / imageHeight;
        if (height % imageHeight > 0) {
            ++imageRowCount;
        }
        g.clipRect(x, y, width, height);
        int cx = x;
        int cy = y;
        for (int i = 0; i < imageRowCount; ++i) {
            cx = x;
            for (int j = 0; j < imageColCount; ++j) {
                image.drawFrame(g, index, cx, cy, trans);
                cx += imageWidth;
            }
            cy += imageHeight;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public static void drawBack(Graphics g, int x, int y, int width, int height) {
        Tool.drawBack(g, x, y, width, height, 0, 0);
    }

    public static void drawBack(Graphics g, int x, int y, int width, int height, int type, int value) {
        int[] c = null;
        switch (type) {
            case 4: {
                c = new int[]{9959840, 2408244, 6153066, 6742899, 9496729};
                for (int i = 0; i < c.length; ++i) {
                    c[i] = PipImage.lighter(c[i], value);
                }
                break;
            }
            case 0: {
                c = DRAWBACK_TYPE_NORMAL_DATA;
                break;
            }
            case 1: {
                c = new int[]{0xCCCCCC, 0x737373, 0xA0A0A0, 0xA9A9A9, 0xBFBFBF};
                if (value == 0) break;
                for (int i = 0; i < c.length; ++i) {
                    c[i] = PipImage.lighter(c[i], value);
                }
                break;
            }
            case 2: {
                c = new int[DRAWBACK_TYPE_NORMAL_DATA.length];
                System.arraycopy(DRAWBACK_TYPE_NORMAL_DATA, 0, c, 0, DRAWBACK_TYPE_NORMAL_DATA.length);
                for (int i = 0; i < c.length; ++i) {
                    c[i] = PipImage.lighter(c[i], value);
                }
                break;
            }
            case 3: {
                c = new int[DRAWBACK_TYPE_NORMAL_DATA.length];
                System.arraycopy(DRAWBACK_TYPE_NORMAL_DATA, 0, c, 0, DRAWBACK_TYPE_NORMAL_DATA.length);
                for (int i = 0; i < c.length; ++i) {
                    c[i] = PipImage.darker(c[i], value);
                }
                break;
            }
        }
        g.setColor(c[0]);
        g.fillRect(x, y, width, height);
        g.setColor(c[1]);
        g.drawRect(x, y, width, height);
        g.setColor(c[2]);
        g.drawRect(x + 1, y + 1, width - 2, height - 2);
        g.setColor(c[3]);
        g.drawRect(x + 2, y + 2, width - 4, height - 4);
        g.setColor(c[4]);
        g.drawRect(x + 3, y + 3, width - 6, height - 6);
    }

    public static String isNumString(String s) {
        int l1 = s.indexOf("<i>");
        int l2 = s.indexOf("</i>");
        if (l1 != -1 && l2 != -1) {
            return s.substring(l1 + 3, l2);
        }
        return null;
    }

    public static int drawMixedText(Graphics g, String str, int x, int y, int color, int bkColor, boolean use3dString, int anchor) {
        Vector vec = Tool.formatString(str, 100000, Utilities.font, true);
        return Tool.drawMixedText(g, vec, x, y, color, bkColor, use3dString, anchor);
    }

    public static int drawMixedText(Graphics g, String str, int x, int y, int color, int bkColor, boolean use3dString, int anchor, Font font) {
        Vector vec = Tool.formatString(str, 100000, font, true);
        return Tool.drawMixedText(g, vec, x, y, color, bkColor, use3dString, anchor);
    }

    public static int drawMixedText(Graphics g, Vector vec, int x, int y, int color, int bkColor, boolean use3dString, int anchor) {
        return Tool.drawMixedText(g, vec, x, y, color, bkColor, use3dString, anchor, Utilities.font);
    }

    public static int drawMixedText(Graphics g, Vector vec, int x, int y, int color, int bkColor, boolean use3dString, int anchor, Font font) {
        int count = vec.size();
        boolean oldUse3dString = use3dString;
        for (int i = 0; i < count; ++i) {
            Object[] sec = (Object[])vec.elementAt(i);
            int secColor = color;
            int picFlag = 0;
            boolean isSec2String = true;
            if (sec[1] != null) {
                picFlag = (Integer)sec[1];
                if (picFlag != -1) {
                    secColor = picFlag;
                } else {
                    if (g != null) {
                        ((ImageSet)sec[2]).drawFrame(g, (Integer)sec[4], x, y + font.getHeight() / 2, 0, 6);
                        if (sec.length > 6) {
                            ((ImageSet)sec[5]).drawFrame(g, (Integer)sec[7], x + (Integer)sec[6], y + font.getHeight() / 2, 0, 6);
                        }
                    }
                    x += ((ImageSet)sec[2]).getFrameWidth((Integer)sec[4]);
                    continue;
                }
            }
            String text = (String)sec[2];
            use3dString = sec[5] != null && (Integer)sec[5] == 1 ? false : (sec[5] != null && (Integer)sec[5] == 2 ? true : oldUse3dString);
            x = Tool.drawMoneyString(g, text, x, y, anchor, secColor, bkColor, use3dString, true, font);
        }
        return x;
    }

    public static int drawMoneyString(Graphics g, String str, int x, int y, int anchor, int color, int bkColor, boolean use3dString, boolean isShort, Font font) {
        int ret = x;
        try {
            if (str == null || str.length() == 0) {
                return ret;
            }
            String ns = Tool.isNumString(str);
            if (ns == null) {
                if (g != null) {
                    if (use3dString) {
                        Tool.draw3DString(g, str, x, y, color, bkColor, anchor);
                    } else {
                        g.setColor(color);
                        g.drawString(str, x, y, anchor);
                    }
                }
                ret += font.stringWidth(str);
            } else {
                if (ns == null || ns.length() == 0) {
                    return ret;
                }
                ret += Tool.drawImageNumber(g, GameMain.numberImage, GameMain.numberImageIndex, ns, ret, y + Utilities.LINE_HEIGHT / 2, 0, 6) + 2;
            }
            return ret;
        }
        catch (Exception e) {
            return ret;
        }
    }

    public static String getName(String name, int width) {
        int w = Utilities.font.stringWidth(name);
        boolean changed = false;
        while (w > width) {
            name = name.substring(0, name.length() - 1);
            w = Utilities.font.stringWidth(name + "..");
            changed = true;
        }
        if (changed) {
            name = name + "..";
        }
        return name;
    }

    public static void drawShadowString(Graphics g, String s, int x, int y, int color) {
        g.setFont(Utilities.font);
        g.setColor(0);
        g.drawString(s, x + 1, y + 1, 20);
        g.setColor(color);
        g.drawString(s, x, y, 20);
    }

    public static void drawShadowString(Graphics g, String s, int x, int y, boolean selected) {
        Tool.drawShadowString(g, s, x, y, selected ? 0xFFFF00 : 0xFFFFFF);
    }

    public static void drawShadowString(Graphics g, String s, int x, int y, int anchor, int color) {
        g.setFont(Utilities.font);
        g.setColor(0);
        g.drawString(s, x + 1, y + 1, anchor);
        g.setColor(color);
        g.drawString(s, x, y, anchor);
    }

    public static void drawShadowString(Graphics g, String s, int x, int y, int anchor, boolean selected) {
        g.setFont(Utilities.font);
        g.setColor(0);
        g.drawString(s, x + 1, y + 1, anchor);
        g.setColor(selected ? 0xFFFF00 : 0xFFFFFF);
        g.drawString(s, x, y, anchor);
    }

    public static void drawString(Graphics g, String s, int x, int y, boolean selected) {
        Tool.drawShadowString(g, s, x, y, selected);
    }

    public static int getNextSelect(int preSelect, int arrLen) {
        int select;
        if ((select = ++preSelect) >= arrLen) {
            select = 0;
        }
        return select;
    }

    public static int getPreSelect(int preSelect, int arrLen) {
        int select;
        if ((select = --preSelect) < 0) {
            select = (byte)(arrLen - 1);
        }
        return select;
    }

    public static Image zoomImage(Image srcImg, int scalePercent) {
        return Tool.zoomImage(srcImg, srcImg.getWidth() * scalePercent / 100, srcImg.getHeight() * scalePercent / 100);
    }

    public static Image zoomImage(Image srcImg, int desW, int desH) {
        int i;
        int srcW = srcImg.getWidth();
        int srcH = srcImg.getHeight();
        int[] srcBuf = new int[srcW * srcH];
        srcImg.getRGB(srcBuf, 0, srcW, 0, 0, srcW, srcH);
        int[] tabY = new int[desH];
        int[] tabX = new int[desW];
        int sb = 0;
        int db = 0;
        int tems = 0;
        int temd = 0;
        int distance = srcH > desH ? srcH : desH;
        for (i = 0; i <= distance; ++i) {
            tabY[db] = (short)sb;
            temd += desH;
            if ((tems += srcH) > distance) {
                tems -= distance;
                ++sb;
            }
            if (temd <= distance) continue;
            temd -= distance;
            ++db;
        }
        sb = 0;
        db = 0;
        tems = 0;
        temd = 0;
        distance = srcW > desW ? srcW : desW;
        for (i = 0; i <= distance; ++i) {
            tabX[db] = (short)sb;
            temd += desW;
            if ((tems += srcW) > distance) {
                tems -= distance;
                ++sb;
            }
            if (temd <= distance) continue;
            temd -= distance;
            ++db;
        }
        int[] desBuf = new int[desW * desH];
        int dx = 0;
        int dy = 0;
        boolean sx = false;
        int sy = 0;
        int oldy = -1;
        for (int i2 = 0; i2 < desH; ++i2) {
            if (oldy == tabY[i2]) {
                System.arraycopy(desBuf, dy - desW, desBuf, dy, desW);
            } else {
                dx = 0;
                for (int j = 0; j < desW; ++j) {
                    desBuf[dy + dx] = srcBuf[sy + tabX[j]];
                    ++dx;
                }
                sy += (tabY[i2] - oldy) * srcW;
            }
            oldy = tabY[i2];
            dy += desW;
        }
        return Image.createRGBImage((int[])desBuf, (int)desW, (int)desH, (boolean)true);
    }

    public static synchronized byte[] inflate(byte[] gzip) throws IOException {
        gzipBit = 0;
        gzipByte = 0;
        gzipIndex = 0;
        if (Tool.readBits(gzip, 16) != 35615 || Tool.readBits(gzip, 8) != 8) {
            throw new IOException("Invalid GZIP format");
        }
        int flg = Tool.readBits(gzip, 8);
        gzipIndex += 6;
        if ((flg & 4) != 0) {
            gzipIndex += Tool.readBits(gzip, 16);
        }
        if ((flg & 8) != 0) {
            while (gzip[gzipIndex++] != 0) {
            }
        }
        if ((flg & 0x10) != 0) {
            while (gzip[gzipIndex++] != 0) {
            }
        }
        if ((flg & 2) != 0) {
            gzipIndex += 2;
        }
        int index = gzipIndex;
        gzipIndex = gzip.length - 4;
        byte[] uncompressed = new byte[Tool.readBits(gzip, 16) | Tool.readBits(gzip, 16) << 16];
        int uncompressedIndex = 0;
        gzipIndex = index;
        int bfinal = 0;
        int btype = 0;
        do {
            int[] distanceTree;
            int[] literalTree;
            bfinal = Tool.readBits(gzip, 1);
            btype = Tool.readBits(gzip, 2);
            if (btype == 0) {
                gzipBit = 0;
                int len = Tool.readBits(gzip, 16);
                int nlen = Tool.readBits(gzip, 16);
                System.arraycopy(gzip, gzipIndex, uncompressed, uncompressedIndex, len);
                gzipIndex += len;
                uncompressedIndex += len;
                continue;
            }
            if (btype == 2) {
                int hlit = Tool.readBits(gzip, 5) + 257;
                int hdist = Tool.readBits(gzip, 5) + 1;
                int hclen = Tool.readBits(gzip, 4) + 4;
                byte[] lengthBits = new byte[19];
                for (int i = 0; i < hclen; ++i) {
                    lengthBits[Tool.DYNAMIC_LENGTH_ORDER[i]] = (byte)Tool.readBits(gzip, 3);
                }
                int[] lengthTree = Tool.createHuffmanTree(lengthBits, 18);
                literalTree = Tool.createHuffmanTree(Tool.decodeCodeLengths(gzip, lengthTree, hlit), hlit - 1);
                distanceTree = Tool.createHuffmanTree(Tool.decodeCodeLengths(gzip, lengthTree, hdist), hdist - 1);
            } else {
                int i;
                byte[] literalBits = new byte[288];
                for (i = 0; i < 144; ++i) {
                    literalBits[i] = 8;
                }
                for (i = 144; i < 256; ++i) {
                    literalBits[i] = 9;
                }
                for (i = 256; i < 280; ++i) {
                    literalBits[i] = 7;
                }
                for (i = 280; i < 288; ++i) {
                    literalBits[i] = 8;
                }
                literalTree = Tool.createHuffmanTree(literalBits, 287);
                byte[] distanceBits = new byte[32];
                for (int i2 = 0; i2 < distanceBits.length; ++i2) {
                    distanceBits[i2] = 5;
                }
                distanceTree = Tool.createHuffmanTree(distanceBits, 31);
            }
            int code = 0;
            int leb = 0;
            int deb = 0;
            while ((code = Tool.readCode(gzip, literalTree)) != 256) {
                if (code > 256) {
                    int length = LENGTH_VALUES[code -= 257];
                    leb = LENGTH_EXTRA_BITS[code];
                    if (leb > 0) {
                        length += Tool.readBits(gzip, leb);
                    }
                    code = Tool.readCode(gzip, distanceTree);
                    int distance = DISTANCE_VALUES[code];
                    deb = DISTANCE_EXTRA_BITS[code];
                    if (deb > 0) {
                        distance += Tool.readBits(gzip, deb);
                    }
                    int offset = uncompressedIndex - distance;
                    while (distance < length) {
                        System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, distance);
                        uncompressedIndex += distance;
                        length -= distance;
                        distance <<= 1;
                    }
                    System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, length);
                    uncompressedIndex += length;
                    continue;
                }
                uncompressed[uncompressedIndex++] = (byte)code;
            }
        } while (bfinal == 0);
        return uncompressed;
    }

    private static int readBits(byte[] gzip, int n) {
        int data = gzipBit == 0 ? (gzipByte = gzip[gzipIndex++] & 0xFF) : gzipByte >> gzipBit;
        for (int i = 8 - gzipBit; i < n; i += 8) {
            gzipByte = gzip[gzipIndex++] & 0xFF;
            data |= gzipByte << i;
        }
        gzipBit = gzipBit + n & 7;
        return data & (1 << n) - 1;
    }

    private static int readCode(byte[] gzip, int[] tree) {
        int node = tree[0];
        while (node >= 0) {
            if (gzipBit == 0) {
                gzipByte = gzip[gzipIndex++] & 0xFF;
            }
            node = (gzipByte & 1 << gzipBit) == 0 ? tree[node >> 16] : tree[node & 0xFFFF];
            gzipBit = gzipBit + 1 & 7;
        }
        return node & 0xFFFF;
    }

    private static byte[] decodeCodeLengths(byte[] gzip, int[] lengthTree, int count) {
        byte[] bits = new byte[count];
        int i = 0;
        int code = 0;
        int last = 0;
        while (i < count) {
            code = Tool.readCode(gzip, lengthTree);
            if (code >= 16) {
                int repeat = 0;
                if (code == 16) {
                    repeat = 3 + Tool.readBits(gzip, 2);
                    code = last;
                } else {
                    repeat = code == 17 ? 3 + Tool.readBits(gzip, 3) : 11 + Tool.readBits(gzip, 7);
                    code = 0;
                }
                while (repeat-- > 0) {
                    bits[i++] = (byte)code;
                }
            } else {
                bits[i++] = (byte)code;
            }
            last = code;
        }
        return bits;
    }

    private static int[] createHuffmanTree(byte[] bits, int maxCode) {
        int[] bl_count = new int[17];
        for (int i = 0; i < bits.length; ++i) {
            byte by = bits[i];
            bl_count[by] = bl_count[by] + 1;
        }
        int code = 0;
        bl_count[0] = 0;
        int[] next_code = new int[17];
        for (int i = 1; i <= 16; ++i) {
            next_code[i] = code = code + bl_count[i - 1] << 1;
        }
        int[] tree = new int[(maxCode << 1) + 16];
        int treeInsert = 1;
        for (int i = 0; i <= maxCode; ++i) {
            byte len = bits[i];
            if (len == 0) continue;
            byte by = len;
            next_code[by] = next_code[by] + 1;
            int node = 0;
            for (int bit = len - 1; bit >= 0; --bit) {
                int value = code & 1 << bit;
                if (value == 0) {
                    int left = tree[node] >> 16;
                    if (left == 0) {
                        int n = node;
                        tree[n] = tree[n] | treeInsert << 16;
                        node = treeInsert++;
                        continue;
                    }
                    node = left;
                    continue;
                }
                int right = tree[node] & 0xFFFF;
                if (right == 0) {
                    int n = node;
                    tree[n] = tree[n] | treeInsert;
                    node = treeInsert++;
                    continue;
                }
                node = right;
            }
            tree[node] = Integer.MIN_VALUE | i;
        }
        return tree;
    }

    public Tool() {
        this.maxKey.put(this.key, this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextKey() {
        Hashtable hashtable = this.maxKey;
        synchronized (hashtable) {
            int k = (Integer)this.maxKey.get(this.key) + 1;
            this.maxKey.put(this.key, new Integer(k));
            return k;
        }
    }

    public static void setGlobalValue(String varName, int varValue) {
        globalVars.put(varName, new Integer(varValue));
    }

    public static void setGlobalValue(String varName, Object varValue) {
        globalVars.put(varName, varValue);
    }

    public static void deleteGlobalVar(String varName) {
        globalVars.remove(varName);
    }

    public static void clearGlobalVar() {
        globalVars.clear();
    }

    public static int getGlobalInt(String varName) {
        int intValue = 0;
        intValue = globalVars.containsKey(varName) ? (Integer)globalVars.get(varName) : 0;
        return intValue;
    }

    public static String getGlobalString(String varName) {
        String str = "";
        str = globalVars.containsKey(varName) ? (String)globalVars.get(varName) : "";
        return str;
    }

    public static Object getGlobalObject(String varName) {
        return globalVars.get(varName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addRecord(String rmsName, byte[] data) {
        RecordStore rs = null;
        int result = -1;
        try {
            rs = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            result = rs.addRecord(data, 0, data.length);
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveRecord(String rmsName, int recordId, byte[] data) {
        RecordStore rs = null;
        boolean result = false;
        try {
            rs = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            rs.setRecord(recordId, data, 0, data.length);
            result = true;
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadRecord(String rmsName, int recordId) {
        RecordStore rs = null;
        byte[] result = null;
        try {
            rs = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            result = rs.getRecord(recordId);
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteRecord(String rmsName, int recordId) {
        RecordStore rs = null;
        boolean result = false;
        try {
            rs = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            rs.deleteRecord(recordId);
            result = true;
        }
        catch (Exception e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveData(String rmsName, byte[] data, byte index) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            int recordId = -1;
            while (re.hasNextElement()) {
                int id = re.nextRecordId();
                byte[] record = rs.getRecord(id);
                if (record.length <= 0 || record[0] != index) continue;
                recordId = id;
                break;
            }
            re.destroy();
            byte[] newdata = new byte[data.length + 1];
            System.arraycopy(data, 0, newdata, 1, data.length);
            newdata[0] = index;
            if (recordId == -1) {
                rs.addRecord(newdata, 0, newdata.length);
            } else {
                rs.setRecord(recordId, newdata, 0, newdata.length);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getData(String rmsName, byte index) {
        RecordStore rs = null;
        byte[] ret = null;
        try {
            rs = RecordStore.openRecordStore((String)rmsName, (boolean)false);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                byte[] record = re.nextRecord();
                if (record.length <= 0 || record[0] != index) continue;
                ret = record;
                break;
            }
            re.destroy();
            if (ret != null) {
                byte[] ret1 = new byte[ret.length - 1];
                System.arraycopy(ret, 1, ret1, 0, ret.length - 1);
                ret = ret1;
            }
            byte[] byArray = ret;
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteData(String rmsName, byte index) {
        RecordStore rs = null;
        try {
            int id;
            rs = RecordStore.openRecordStore((String)rmsName, (boolean)true);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            int recordId = -1;
            while (re.hasNextElement()) {
                id = re.nextRecordId();
                byte[] record = rs.getRecord(id);
                if (record.length <= 0 || record[0] != index) continue;
                recordId = id;
                break;
            }
            re.destroy();
            if (recordId != -1) {
                rs.deleteRecord(recordId);
            }
            id = 1;
            return id != 0;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.closeRecordStore();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void deleteRMSFile(String dbName) {
        try {
            RecordStore.deleteRecordStore((String)dbName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Vector formatString(String s, int width, Font font, boolean isDraw) {
        Vector<Object[]> ret = new Vector<Object[]>();
        int length = s.length();
        Integer currColor = null;
        boolean isForceNo3d = false;
        boolean force3d = false;
        int line = 0;
        int xOffset = 0;
        String currStr = "";
        int currentStrWid = 0;
        Object[] strObj = null;
        boolean currLineSelected = false;
        boolean tagEnd = false;
        for (int pos = 0; pos < length; ++pos) {
            String picItem;
            String[] info;
            int endTagPos;
            char ch = s.charAt(pos);
            if (ch == '{' && s.charAt(pos + 1) == '#' && (endTagPos = s.indexOf(125, pos + 2)) != -1 && (info = Tool.splitString(picItem = s.substring(pos + 2, endTagPos), ',')).length >= 2) {
                if (currentStrWid > 0) {
                    strObj = new Object[6];
                    strObj[0] = new Integer(line);
                    strObj[1] = currColor;
                    strObj[2] = currStr;
                    strObj[3] = new Integer(xOffset);
                    if (currLineSelected) {
                        strObj[4] = new Integer(1);
                    }
                    xOffset += currentStrWid;
                    currStr = "";
                    ret.addElement(strObj);
                }
                if (info.length == 2) {
                    strObj = new Object[6];
                } else if (info.length == 4) {
                    strObj = new Object[8];
                }
                strObj[0] = new Integer(line);
                strObj[1] = new Integer(-1);
                boolean error = false;
                try {
                    strObj[2] = info[0];
                    strObj[3] = new Integer(xOffset);
                    strObj[4] = new Integer(Integer.parseInt(info[1]));
                    strObj[2] = Tool.getGlobalObject((String)strObj[2]);
                    if (info.length == 4 && Integer.parseInt(info[3]) >= 0) {
                        int fgw;
                        strObj[5] = info[2];
                        strObj[7] = new Integer(Integer.parseInt(info[3]));
                        strObj[5] = Tool.getGlobalObject((String)strObj[5]);
                        int bgw = ((ImageSet)strObj[2]).getFrameWidth((Integer)strObj[4]);
                        strObj[6] = bgw > (fgw = ((ImageSet)strObj[5]).getFrameWidth((Integer)strObj[7])) ? new Integer((bgw - fgw) / 2) : new Integer((fgw - bgw) / 2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error = true;
                }
                if (!error && strObj[2] != null) {
                    currentStrWid = ((ImageSet)strObj[2]).getFrameWidth((Integer)strObj[4]);
                    if (xOffset + currentStrWid > width) {
                        xOffset = 0;
                        ++line;
                    }
                    if (!isDraw) {
                        strObj[2] = s.substring(pos, endTagPos + 1);
                    }
                    strObj[0] = new Integer(line);
                    strObj[3] = new Integer(xOffset);
                    xOffset += currentStrWid;
                    ret.addElement(strObj);
                    pos = endTagPos;
                    currentStrWid = 0;
                    continue;
                }
            }
            if (ch == '<') {
                if (s.charAt(pos + 1) == 'i') {
                    if (s.charAt(pos + 2) == '>') {
                        int p2 = s.indexOf(60, pos + 3);
                        int p3 = s.indexOf("</i>", pos + 3);
                        if (p2 != -1 && p2 == p3) {
                            String numStr = "";
                            int offset = 0;
                            while (s.charAt(pos + 3 + offset) != '<') {
                                numStr = numStr + s.charAt(pos + 3 + offset);
                                ++offset;
                            }
                            boolean error = false;
                            try {
                                Integer.parseInt(numStr);
                            }
                            catch (Exception e) {
                                error = true;
                            }
                            if (!error) {
                                if (currentStrWid > 0) {
                                    strObj = new Object[6];
                                    strObj[0] = new Integer(line);
                                    strObj[1] = currColor;
                                    strObj[2] = currStr;
                                    strObj[3] = new Integer(xOffset);
                                    if (currLineSelected) {
                                        strObj[4] = new Integer(1);
                                    }
                                    xOffset += currentStrWid;
                                    currStr = "";
                                    ret.addElement(strObj);
                                }
                                currentStrWid = Tool.drawImageNumber(null, GameMain.numberImage, GameMain.numberImageIndex, numStr, 0, 0, 0, 20) + 2;
                                strObj = new Object[6];
                                strObj[1] = null;
                                strObj[2] = s.substring(pos, p3 + 4);
                                if (xOffset + currentStrWid > width) {
                                    xOffset = 0;
                                    ++line;
                                }
                                strObj[0] = new Integer(line);
                                strObj[3] = new Integer(xOffset);
                                xOffset += currentStrWid;
                                ret.addElement(strObj);
                                pos = p3 + 3;
                                currentStrWid = 0;
                                continue;
                            }
                        }
                    }
                } else {
                    if (s.charAt(pos + 1) == 'c') {
                        pos += 2;
                        String clrStr = "";
                        while (s.charAt(pos) != '>') {
                            clrStr = clrStr + s.charAt(pos);
                            ++pos;
                        }
                        if (currentStrWid > 0) {
                            strObj = new Object[6];
                            strObj[0] = new Integer(line);
                            strObj[1] = currColor;
                            strObj[2] = currStr;
                            strObj[3] = new Integer(xOffset);
                            if (currLineSelected) {
                                strObj[4] = new Integer(1);
                                currLineSelected = false;
                            }
                            xOffset += currentStrWid;
                            ret.addElement(strObj);
                        }
                        if ("{x}".equals(s.substring(pos + 1, pos + 4))) {
                            isForceNo3d = true;
                            pos += 3;
                        } else if ("{d}".equals(s.substring(pos + 1, pos + 4))) {
                            pos += 3;
                            force3d = true;
                        } else {
                            isForceNo3d = false;
                        }
                        currColor = new Integer(Integer.parseInt(clrStr, 16));
                        currStr = "";
                        currentStrWid = 0;
                        continue;
                    }
                    if (s.charAt(pos + 1) == '/') {
                        pos += 3;
                        if (currentStrWid > 0) {
                            strObj = new Object[6];
                            strObj[0] = new Integer(line);
                            strObj[1] = currColor;
                            strObj[2] = currStr;
                            strObj[3] = new Integer(xOffset);
                            if (currLineSelected) {
                                strObj[4] = new Integer(1);
                                currLineSelected = false;
                            }
                            if (isForceNo3d) {
                                strObj[5] = new Integer(1);
                            } else if (force3d) {
                                strObj[5] = new Integer(2);
                            }
                            xOffset += currentStrWid;
                            currStr = "";
                            currentStrWid = 0;
                            ret.addElement(strObj);
                            tagEnd = true;
                        }
                        currColor = null;
                        continue;
                    }
                }
            } else if (ch == '|') {
                currLineSelected = true;
            }
            if ((ch = s.charAt(pos)) == '\r') continue;
            if (ch == '\n') {
                ret.addElement(new Object[]{new Integer(line), currColor, currStr, new Integer(xOffset), null, null});
                xOffset = 0;
                currStr = "";
                currentStrWid = 0;
                ++line;
            } else {
                int cw = font.charWidth(ch);
                if (xOffset + currentStrWid + cw > width) {
                    strObj = new Object[6];
                    strObj[0] = new Integer(line);
                    strObj[1] = currColor;
                    strObj[2] = currStr;
                    strObj[3] = new Integer(xOffset);
                    if (currLineSelected) {
                        strObj[4] = new Integer(1);
                        currLineSelected = false;
                    }
                    xOffset = 0;
                    currStr = "" + ch;
                    currentStrWid = cw;
                    ret.addElement(strObj);
                    ++line;
                } else if (ch != '\n' && ch != '|') {
                    currStr = currStr + ch;
                    currentStrWid += cw;
                }
                if (ch == '\n' || pos == s.length() - 1) {
                    strObj = new Object[6];
                    strObj[0] = new Integer(line);
                    strObj[1] = currColor;
                    strObj[2] = currStr;
                    strObj[3] = new Integer(xOffset);
                    if (currLineSelected) {
                        strObj[4] = new Integer(1);
                        currLineSelected = false;
                    }
                    xOffset = 0;
                    currStr = "";
                    currentStrWid = 0;
                    ret.addElement(strObj);
                    ++line;
                }
            }
            tagEnd = false;
        }
        return ret;
    }

    public static String[] formatText(String text, int width, Font font) {
        return Tool.formatText(text, width, font, false);
    }

    public static String[] formatText(String text, int width, Font font, boolean markLineHeight) {
        Vector vec = new Vector();
        vec = Tool.formatString(text, width, font, false);
        Vector<String> newVec = new Vector<String>();
        int len = vec.size();
        int lineNum = 0;
        String currLine = "";
        for (int i = 0; i < len; ++i) {
            int clr;
            Object[] sec = (Object[])vec.elementAt(i);
            int line = (Integer)sec[0];
            String secText = "";
            secText = sec[1] == null ? (String)sec[2] : ((clr = ((Integer)sec[1]).intValue()) != -1 ? (sec[5] != null ? "<c" + Integer.toHexString(clr) + ">{x}" + sec[2] + "</c>" : "<c" + Integer.toHexString(clr) + ">" + sec[2] + "</c>") : (String)sec[2]);
            if (line != lineNum) {
                newVec.addElement(currLine);
                currLine = secText;
                lineNum = line;
                continue;
            }
            currLine = currLine + secText;
        }
        if (currLine.length() > 0 || newVec.size() == 0) {
            newVec.addElement(currLine);
        }
        Object[] ret = new String[newVec.size()];
        newVec.copyInto(ret);
        return ret;
    }

    public static String[] splitString(String text, int width, Font font) {
        Vector<String> vec = new Vector<String>();
        int lineStart = 0;
        int lineWid = 0;
        int charCount = text.length();
        for (int i = 0; i < charCount; ++i) {
            char ch = text.charAt(i);
            if (ch == '\n') {
                if (i > 0 && text.charAt(i - 1) == '\r') {
                    vec.addElement(text.substring(lineStart, i - 1));
                } else {
                    vec.addElement(text.substring(lineStart, i));
                }
                lineStart = i + 1;
                lineWid = 0;
                continue;
            }
            int charWid = font.charWidth(ch);
            if (lineWid == 0 || lineWid + charWid <= width) {
                lineWid += charWid;
                continue;
            }
            if (punctation.indexOf(ch) >= 0) {
                charWid += font.charWidth(text.charAt(--i));
            }
            vec.addElement(text.substring(lineStart, i));
            lineStart = i;
            lineWid = charWid;
        }
        if (lineWid > 0) {
            vec.addElement(text.substring(lineStart));
        }
        Object[] ret = new String[vec.size()];
        vec.copyInto(ret);
        return ret;
    }

    public static String mergeString(Vector v) {
        StringBuffer sb = new StringBuffer();
        int count = v.size();
        for (int i = 0; i < count; ++i) {
            sb.append((String)v.elementAt(i));
        }
        return sb.toString();
    }

    public static String mergeString2(Vector v) {
        StringBuffer sb = new StringBuffer();
        int count = v.size();
        for (int i = 0; i < count; ++i) {
            String tmp = (String)v.elementAt(i);
            if (tmp == null || tmp.equals("")) continue;
            sb.append(tmp);
            if (i >= count - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static short getShort(byte[] data, int off) {
        return (short)((data[off] & 0xFF) << 8 | data[off + 1] & 0xFF);
    }

    public static void setShort(byte[] data, int off, short value) {
        data[off] = (byte)(value >> 8 & 0xFF);
        data[off + 1] = (byte)(value & 0xFF);
    }

    public static int getInt(byte[] data, int off) {
        return (data[off] & 0xFF) << 24 | (data[off + 1] & 0xFF) << 16 | (data[off + 2] & 0xFF) << 8 | data[off + 3] & 0xFF;
    }

    public static void setInt(byte[] data, int off, int value) {
        data[off] = (byte)(value >> 24 & 0xFF);
        data[off + 1] = (byte)(value >> 16 & 0xFF);
        data[off + 2] = (byte)(value >> 8 & 0xFF);
        data[off + 3] = (byte)(value & 0xFF);
    }

    public static String readUTF16(DataInputStream is) throws IOException {
        int slen = is.readByte();
        if ((slen & 0x80) != 0) {
            byte slen2 = is.readByte();
            slen = ((slen & 0x7F) << 8) + (slen2 & 0xFF);
        }
        char[] buf = new char[slen];
        for (int i = 0; i < slen; ++i) {
            buf[i] = is.readChar();
        }
        return new String(buf);
    }

    public static final String readUTF(DataInputStream in) throws IOException {
        int c;
        int count;
        int utflen = in.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        byte char2 = 0;
        byte char3 = 0;
        int chararr_count = 0;
        in.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        while (count < utflen) {
            c = bytearr[count] & 0xFF;
            if (c < 128) {
                ++count;
                chararr[chararr_count++] = (char)c;
                continue;
            }
            if (c < 224) {
                if ((count += 2) > utflen) {
                    throw new UTFDataFormatException("malformed input: partial character at end");
                }
                char2 = bytearr[count - 1];
                if ((char2 & 0xC0) != 128) {
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
                chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                continue;
            }
            if (c >= 240) continue;
            if ((count += 3) > utflen) {
                throw new UTFDataFormatException("malformed input: partial character at end");
            }
            char2 = bytearr[count - 2];
            char3 = bytearr[count - 1];
            if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                throw new UTFDataFormatException("malformed input around byte " + (count - 1));
            }
            chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
        }
        return new String(chararr, 0, chararr_count);
    }

    public static void removeUnitViewCacheByType(int type) {
        Hashtable restTable = new Hashtable();
        Enumeration enu = unitViewCache.keys();
        while (enu.hasMoreElements()) {
            Long key = (Long)enu.nextElement();
            if (Tool.getSpriteKeyType(key) == type) continue;
            restTable.put(key, unitViewCache.get(key));
        }
        unitViewCache = restTable;
    }

    public static void requestWholeMove(int instanceId) {
        UASegment segment = new UASegment(348);
        try {
            segment.writeInt(instanceId);
            Utilities.sendRequest(segment);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendPosition(int dir, int x, int y, int state) {
        UASegment segment = new UASegment(105);
        try {
            segment.writeInt(Utilities.getServerTime());
            segment.writeShort((short)x);
            segment.writeShort((short)y);
            segment.writeByte((byte)dir);
            segment.writeShort((short)state);
            Utilities.sendRequest(segment);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void recvUnitView(UASegment segment) {
        int type = segment.readUnsignedByte();
        boolean isOutView = (type & 0x80) == 128;
        int id = segment.readInt();
        int instanceId = segment.readInt();
        switch (type &= 0x7F) {
            case 1: {
                Tool.processUnitView(type, id, instanceId, isOutView, -1);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                if (isOutView) {
                    Tool.processUnitView(type, id, instanceId, isOutView, -1);
                    break;
                }
                Tool.processUnitView(type, id, instanceId, isOutView, segment.readUnsignedShort());
            }
        }
        segment.handled = true;
    }

    public static void recvMultiUnitView(UASegment segment) {
        int count = segment.readUnsignedByte();
        block4: for (int i = 0; i < count; ++i) {
            int type = segment.readUnsignedByte();
            boolean isOutView = (type & 0x80) == 128;
            int id = segment.readInt();
            int instanceId = segment.readInt();
            switch (type &= 0x7F) {
                case 1: {
                    Tool.processUnitView(type, id, instanceId, isOutView, -1);
                    continue block4;
                }
                case 3: 
                case 5: 
                case 6: {
                    if (isOutView) {
                        Tool.processUnitView(type, id, instanceId, isOutView, -1);
                        continue block4;
                    }
                    Tool.processUnitView(type, id, instanceId, isOutView, segment.readUnsignedShort());
                }
            }
        }
        segment.handled = true;
    }

    private static void processUnitView(int type, int id, int instanceId, boolean isOutView, int imageId) {
        switch (type) {
            case 1: {
                GameNetPlayer player = GameWorld.findPlayerByInstanceId(instanceId);
                if (isOutView) {
                    if (player == null) break;
                    player.isOutView = true;
                    if (!player.noNeedRemove) {
                        if (GameWorld.teamInfo.get(new Integer(player.getInstanceId())) != null) break;
                        GameWorld.doDestorySprite(player, false, false);
                        break;
                    }
                    GameWorld.instance.sendCommand(14040, new Integer(player.getInstanceId()));
                    break;
                }
                if (player == null) {
                    player = GameNetPlayer.createGameNetPlayer(id, instanceId);
                    GameWorld.addSprite(player);
                    Tool.sendUnitInfo(instanceId);
                }
                if (player.noNeedRemove) {
                    GameWorld.instance.sendCommand(14041, new Integer(player.getInstanceId()));
                }
                player.sprite.setPosition(-1000, player.sprite.getY());
                player.isOutView = false;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                GameNpc npc = GameWorld.findNpcByInstanceId(instanceId);
                if (isOutView) {
                    GameWorld.doDestorySprite(npc, true, false);
                    break;
                }
                if (npc != null) break;
                npc = GameNpc.createGameNpc((byte)type, id, instanceId, imageId);
                GameWorld.addSprite(npc);
                Tool.sendUnitInfo(instanceId);
                if (type != 6) break;
                npc.sendCommand(10010, new Integer(npc.getInstanceId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recvUnitMove(UASegment segment) {
        segment.reset();
        int type = segment.readUnsignedByte();
        boolean firstSect = (type >> 7 & 1) == 1;
        boolean secondSect = (type >> 6 & 1) == 1;
        boolean thirdSect = (type >> 5 & 1) == 1;
        boolean forthSect = (type >> 4 & 1) == 1;
        boolean fifthSect = (type >> 3 & 1) == 1;
        int instanceId = segment.readInt();
        type &= 7;
        int mapId = 0;
        int x = 0;
        int y = 0;
        int angle = 0;
        int time = 0;
        int speed = 0;
        short state = 0;
        int targetPos = -1;
        int movePackage = 100000;
        GameSprite gameSprite = null;
        switch (type) {
            case 1: {
                gameSprite = GameWorld.findPlayerByInstanceId(instanceId);
                if (gameSprite != null) {
                    ((GameNetPlayer)gameSprite).lastSyncMoveTime = Tool.getSystemTime();
                    break;
                }
                gameSprite = GameNetPlayer.createGameNetPlayer(instanceId, instanceId);
                GameWorld.addSprite(gameSprite);
                Tool.sendUnitInfo(instanceId);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                gameSprite = GameWorld.findNpcByInstanceId(instanceId);
                movePackage = 200000;
            }
        }
        if (firstSect) {
            movePackage += 10000;
            mapId = segment.readUnsignedShort();
            int mapInstanceId = -1;
            if (mapId >> 15 == 1) {
                mapInstanceId = segment.readInt();
                mapId &= Short.MAX_VALUE;
            }
            boolean mapChanged = false;
            if (gameSprite != null) {
                if (gameSprite.sprite.getMapId() != mapId) {
                    mapChanged = true;
                }
                gameSprite.sprite.setMapId(mapId);
                if (type == 1) {
                    gameSprite.sprite.setMapInstanceId(mapInstanceId);
                } else {
                    gameSprite.sprite.setMapInstanceId(GameWorld.player.sprite.getMapInstanceId());
                }
            }
            x = segment.readUnsignedShort();
            y = segment.readUnsignedShort();
            if (gameSprite != null && (gameSprite.sprite.getX() < -500 || mapChanged)) {
                gameSprite.sprite.setPosition(x, y);
            }
        }
        if (secondSect) {
            movePackage += 1000;
            angle = segment.readUnsignedByte();
            time = segment.readInt();
            speed = segment.readUnsignedByte();
            switch (type) {
                case 3: 
                case 5: 
                case 6: {
                    targetPos = segment.readInt();
                }
            }
        }
        if (gameSprite != null && thirdSect) {
            movePackage += 100;
            gameSprite.hpMax = 200;
            gameSprite.hp = segment.readUnsignedByte();
            gameSprite.mpMax = 200;
            gameSprite.mp = segment.readUnsignedByte();
            if (type == 1 && GameWorld.player.isTeamState()) {
                VM vm;
                VM mapChanged = vm = VMGame.getVMGame("game_panel").getVM();
                synchronized (mapChanged) {
                    vm.callback("RefreshTeamPanel", new int[]{vm.makeTempObject(segment), vm.makeTempObject(gameSprite), instanceId, gameSprite.hpMax, gameSprite.hp, gameSprite.mpMax, gameSprite.mp});
                }
            }
            if (gameSprite == GameWorld.player.target) {
                GameWorld.instance.sendCommand(14020, null);
            }
        }
        if (gameSprite != null && forthSect) {
            movePackage += 10;
            state = segment.readShort();
            if ((gameSprite.state & 0xFFFE) != (state & 0xFFFE)) {
                VM vm;
                VM mapChanged = vm = VMGame.getVMGameByVMKey(VMGame.gameWorldVMGameKey).getVM();
                synchronized (mapChanged) {
                    vm.callback("UnitMoveForthChanged", new int[]{vm.makeTempObject(segment), vm.makeTempObject(gameSprite), type, instanceId, state, gameSprite.state});
                }
            }
            gameSprite.state = state;
        }
        if (gameSprite != null && fifthSect) {
            VM vm;
            ++movePackage;
            int mask = segment.readUnsignedByte();
            VM vM = vm = VMGame.getVMGame("game_world").getVM();
            synchronized (vM) {
                vm.callback("UnitMoveFifthChanged", new int[]{vm.makeTempObject(segment), vm.makeTempObject(gameSprite), type, instanceId, mask});
            }
        }
        if (gameSprite != null && !gameSprite.chaseMode && gameSprite.status.size() == 0 && firstSect && secondSect && forthSect && gameSprite.sprite.getMapId() == GameWorld.player.sprite.getMapId() && gameSprite.sprite.getMapInstanceId() == GameWorld.player.sprite.getMapInstanceId()) {
            if (gameSprite.sprite.getX() != x || gameSprite.sprite.getY() != y) {
                gameSprite.addWayPoint(x, y, gameSprite.moveAnimateIndex, gameSprite.stopAnimateIndex, (state & 1) == 1, angle << 1, time, speed, targetPos);
            } else {
                gameSprite.sprite.setPosition(x, y);
            }
        }
        if (type == 1 && gameSprite != null && !gameSprite.infoRecved && !gameSprite.infoForceRequested) {
            Tool.requestWholeMove(instanceId);
            gameSprite.infoForceRequested = true;
        }
        segment.handled = true;
    }

    public static void sendUnitInfo(int instanceId) {
        UASegment segment;
        GameSprite sprite = GameWorld.getSprite(instanceId);
        if (sprite != null && (segment = (UASegment)unitViewCache.get(Tool.getSpriteKey(sprite.getType(), sprite.getId()))) != null) {
            segment.reset();
            segment.setInt(instanceId);
            GameWorld.BroadcastPacket(segment);
            return;
        }
        segment = new UASegment(196);
        try {
            segment.writeInt(instanceId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Utilities.sendRequest(segment);
    }

    public static void sendLogout() {
        UASegment segment = new UASegment(113);
        Utilities.sendRequest(segment);
    }

    public static void recvLogout(UASegment segment) {
        int instanceId = segment.readInt();
        segment.handled = true;
        GameWorld.playerLogout(instanceId);
    }

    public static void recvInvisible(UASegment segment) {
        int instanceId = segment.readInt();
        GameSprite gameSprite = GameWorld.getSprite(instanceId);
        if (gameSprite != null) {
            switch (gameSprite.getType()) {
                case 1: {
                    GameWorld.playerLogout(instanceId);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }

    public static void sendHorseAction(int dir, int x, int y, boolean on) {
        UASegment segment = on ? new UASegment(107) : new UASegment(108);
        try {
            segment.writeInt(Utilities.getServerTime());
            segment.writeInt(x);
            segment.writeInt(y);
            segment.writeByte((byte)dir);
            Utilities.sendRequest(segment);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void recvAttack(UASegment segment, boolean isPreAttack) {
        int instanceId = segment.readInt();
        int targetInstanceId = segment.readInt();
        int startAnimateId = segment.readInt();
        GameSprite gameSprite = GameWorld.getSprite(instanceId);
        if (gameSprite != null) {
            if (isPreAttack) {
                gameSprite.sendCommand(10061, new int[]{1, instanceId, targetInstanceId, startAnimateId, 0});
            } else {
                gameSprite.sendCommand(10060, new int[]{1, instanceId, targetInstanceId, startAnimateId, 0});
            }
        }
    }

    public static void recvAttacked(UASegment segment) {
        int targetInstanceId = segment.readInt();
        int time = segment.readInt();
        int sourceInstanceId = segment.readInt();
        byte attackType = segment.readByte();
        byte damageType = segment.readByte();
        int damage = segment.readInt();
        int magicType = segment.readInt();
        GameSprite gameSprite = GameWorld.getSprite(targetInstanceId);
        if (gameSprite != null) {
            gameSprite.sendCommand(10070, new int[]{1, targetInstanceId, time, sourceInstanceId, attackType, damageType, damage, magicType});
        }
    }

    public static void recvAttackFail(UASegment segment) {
        int reason = segment.readUnsignedByte();
        int sourceInstanceId = segment.readInt();
        int targetInstanceId = segment.readInt();
        int attackId = segment.readInt();
        GameSprite gameSprite = GameWorld.getSprite(sourceInstanceId);
        if (gameSprite != null) {
            gameSprite.sendCommand(10130, new int[]{1, reason, sourceInstanceId, targetInstanceId, attackId});
        }
    }

    public static void sendTouchExit(int exitId) {
        UASegment segment = new UASegment(116);
        try {
            segment.writeInt(Utilities.getServerTime());
            segment.writeInt(exitId);
            Utilities.sendRequest(segment);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendLoadMapFinished() {
        block5: {
            UASegment segment = new UASegment(133);
            try {
                VM vm;
                Utilities.sendRequest(segment);
                VMGame vmg = VMGame.getVMGame("ui_gamemenu");
                if (vmg == null) break block5;
                VM vM = vm = vmg.getVM();
                synchronized (vM) {
                    vm.callback("LoadingFinish", new int[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void recvAllowGomap(UASegment segment) {
        segment.handled = true;
        GameWorld.goMap(segment.readInt(), segment.readInt(), segment.readInt(), segment.readInt());
    }

    public static void sendGetFile(String name) {
        UASegment segment = new UASegment(2381);
        try {
            segment.writeString(GameMain.getUIModel());
            segment.writeString(name);
            Utilities.sendRequest(segment);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void recvGetFile(UASegment segment) {
        String name = segment.readString();
        int version = segment.readInt();
        int fileLength = segment.readInt();
        int startIndex = segment.readInt();
        byte[] data = segment.readBytes();
        if (fileLength == 0 || fileLength <= data.length) {
            GameMain.resourceManager.recvResource(name, version, data);
        } else {
            GameMain.resourceManager.recvFileData(name, version, data, fileLength, startIndex);
        }
    }

    public static void sendSyncVMVarialbe(int questId, int addr, int value) {
        UASegment segment = new UASegment(162);
        try {
            segment.writeInt(questId);
            segment.writeInt(addr);
            segment.writeInt(value);
            Utilities.sendRequest(segment);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void sendNotifyServer(int questId, int notifyId, int notifyType, int questionAnswer) {
        UASegment segment = new UASegment(174);
        try {
            segment.writeInt(questId);
            segment.writeByte((byte)notifyId);
            segment.writeByte((byte)notifyType);
            segment.writeByte((byte)questionAnswer);
            Utilities.sendRequest(segment);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void recvChaseServer(UASegment segment) {
        int sourceId = segment.readInt();
        int targetId = segment.readInt();
        short startX = segment.readShort();
        short startY = segment.readShort();
        int speed = segment.readUnsignedByte();
        short distanceAllow = segment.readShort();
        segment.handled = true;
        GameSprite gameSprite = GameWorld.getSprite(sourceId);
        if (gameSprite != null) {
            gameSprite.sendCommand(10150, new int[]{1, sourceId, targetId, distanceAllow, startX, startY, speed});
        }
    }

    public static void drawWorldMap(ImageSet img, Vector frame, Vector transit, int mapTileWidth, int mapTileHeight, Graphics g, int x, int y) {
        int mapRows = frame.size();
        int mapCols = ((byte[])frame.elementAt(0)).length;
        for (int i = 0; i < mapRows; ++i) {
            for (int j = 0; j < mapCols; ++j) {
                img.drawFrame(g, ((byte[])frame.elementAt(i))[j], x + j * mapTileWidth, y + i * mapTileHeight, ((byte[])transit.elementAt(i))[j], 0);
            }
        }
    }

    public static void drawWorldMap(ImageSet img, Vector frame, Vector transit, int mapTileWidth, int mapTileHeight, Graphics g) {
        Tool.drawWorldMap(img, frame, transit, mapTileWidth, mapTileHeight, g, 0, 0);
    }

    public static void drawWorldMap(ImageSet img, Vector frame, Vector transit, int x, int y, int screenWidth, int screenHeight, int mapTileWidth, int mapTileHeight, Graphics g) {
        int mapRows = frame.size();
        int mapCols = ((byte[])frame.elementAt(0)).length;
        int mapWidth = mapCols * mapTileWidth;
        int mapHeight = mapRows * mapTileHeight;
        int screenX = x < screenWidth / 2 ? 0 : (mapWidth - x < screenWidth / 2 ? x - (screenWidth - (mapWidth - x)) : x - screenWidth / 2);
        int screenY = y < screenHeight / 2 ? 0 : (mapHeight - y < screenHeight / 2 ? y - (screenHeight - (mapHeight - y)) : y - screenHeight / 2);
        int _offX = screenX % mapTileWidth;
        int _offY = screenY % mapTileHeight;
        int _xx = 0 - _offX;
        int _yy = 0 - _offY;
        int _rows = (screenHeight + _offY) % mapTileHeight;
        _rows = _rows > 0 ? (screenHeight + _offY) / mapTileHeight + 1 : (screenHeight + _offY) / mapTileHeight;
        int _cols = (screenWidth + _offX) % mapTileWidth;
        _cols = _cols > 0 ? (screenWidth + _offX) / mapTileWidth + 1 : (screenWidth + _offX) / mapTileWidth;
        int _sRows = screenY / mapTileHeight;
        int _sCols = screenX / mapTileWidth;
        for (int i = 0; i < _rows; ++i) {
            for (int j = 0; j < _cols; ++j) {
                img.drawFrame(g, ((byte[])frame.elementAt(i + _sRows))[j + _sCols], _xx + j * mapTileWidth, _yy + i * mapTileHeight, ((byte[])transit.elementAt(i + _sRows))[j + _sCols], 0);
            }
        }
    }

    public static String getIMEI() {
        String imei = "";
        imei = System.getProperty("phone.imei");
        if (imei == null || "".equals(imei.trim())) {
            imei = System.getProperty("com.nokia.IMEI");
        }
        if (imei == null || "".equals(imei.trim())) {
            imei = System.getProperty("com.nokia.mid.imei");
        }
        if (imei == null || "".equals(imei.trim())) {
            imei = System.getProperty("com.sonyericsson.imei");
        }
        if (imei == null || "".equals(imei.trim())) {
            imei = System.getProperty("com.siemens.imei");
        }
        if (imei == null || "".equals(imei.trim())) {
            imei = System.getProperty("com.motorola.IMEI");
        }
        if (imei == null || "".equals(imei.trim())) {
            imei = System.getProperty("phone.IMEI");
        }
        if (imei == null || "".equals(imei.trim())) {
            imei = System.getProperty("com.samsung.imei");
        }
        if (imei == null || "".equals(imei.trim())) {
            imei = System.getProperty("IMEI");
        }
        if (imei == null) {
            imei = "";
        }
        return imei.trim();
    }

    public static Image processAlphaImage(Image src, int alpha) {
        Image ret = null;
        int w = src.getWidth();
        int h = src.getHeight();
        int[] argb = new int[w * h];
        src.getRGB(argb, 0, w, 0, 0, w, h);
        for (int i = 0; i < argb.length; ++i) {
            if (argb[i] == -1) {
                argb[i] = 0xFFFFFF;
                continue;
            }
            if (argb[i] == 0xFFFFFF) continue;
            argb[i] = argb[i] + alpha;
        }
        ret = Image.createRGBImage((int[])argb, (int)w, (int)h, (boolean)true);
        return ret;
    }

    public static void sendLog(String str) {
        UASegment segment = new UASegment(201);
        try {
            segment.writeByte((byte)8);
            segment.writeInt(-1);
            segment.writeString(str);
            segment.writeBytes(new byte[0]);
            Utilities.sendRequest(segment);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        alphaImage = null;
        alphaImageMap = new Hashtable();
        DRAWBACK_TYPE_NORMAL_DATA = new int[]{16373143, 12612645, 14853212, 14922598, 15254928};
        textTick = 0;
        LENGTH_EXTRA_BITS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0, 99, 99};
        LENGTH_VALUES = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0};
        DISTANCE_EXTRA_BITS = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
        DISTANCE_VALUES = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
        DYNAMIC_LENGTH_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
        NO_CALL_BACK_SPRITE = null;
        BACK_MATRIX = new int[]{0, -1, -1, 0, 1, 0, 0, 1};
        MOVE_MATRIX = new int[]{0, 1, 1, 0, -1, 0, 0, -1};
        ASSIS_LEFT_MATRIX = new int[]{1, -1, -1, -1, 1, 1, -1, 1};
        ASSIS_RIGHT_MATRIX = new int[]{-1, -1, -1, 1, 1, -1, 1, 1};
        FOLLOW_DIS_MATRIX = new int[]{0, 0, 20, 0, 40, 0, 0, 20, 20, 20, 40, 20, 0, 40, 20, 40, 40, 40, 60, 0, 60, 20, 60, 40, 0, 60, 20, 60, 40, 60, 60, 60, 80, 0, 80, 20, 80, 40, 80, 60, 0, 80, 20, 80, 40, 80, 60, 80, 80, 80};
        VIBRA_MATRIX = new int[]{0, 1, 0, -1, 1, 0, -1, 0, -1, 0, 1, 0, 0, -1, 0, 1};
        SIN_TABLE = new int[]{0, 1750, 3490, 5230, 6980, 8720, 1045, 1219, 1392, 1564, 1736, 1908, 2079, 2250, 2419, 2588, 2756, 2924, 3090, 3256, 3420, 3584, 3746, 3907, 4067, 4226, 4384, 4540, 4695, 4848, 5000, 5150, 5299, 5446, 5592, 5736, 5878, 6018, 6157, 6293, 6428, 6561, 6691, 6820, 6947, 7071, 7193, 7314, 7431, 7547, 7660, 7771, 7880, 7986, 8090, 8192, 8290, 8387, 8480, 8572, 8660, 8746, 8829, 8910, 8988, 9063, 9135, 9205, 9272, 9336, 9397, 9455, 9511, 9563, 9613, 9659, 9703, 9744, 9781, 9816, 9848, 9877, 9903, 9925, 9945, 9962, 9976, 9986, 9994, 9998, 10000};
        globalVars = new Hashtable();
        unitViewCache = new Hashtable();
    }
}

