/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ResourceStreamUtil {
    private ResourceStreamUtil() {
    }

    public static byte[] getResourceAsByteArray(String url) throws IOException {
        return ResourceStreamUtil.toByteArray(url.getClass().getResourceAsStream(url));
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        try {
            int read;
            int bufferSize = in.available();
            if (bufferSize <= 0) {
                bufferSize = 8192;
            }
            byte[] buffer = new byte[bufferSize];
            ByteArrayOutputStream out = new ByteArrayOutputStream(bufferSize);
            while ((read = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, read);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

