/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.BitMapFontViewer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public final class BitMapFont {
    private static Hashtable fontsByUrl = new Hashtable();
    private String fontUrl;
    private Image fontImage;
    private boolean hasMixedCase;
    private byte[] characterWidths;
    private short[] xPositions;
    private String characterMap;
    private int fontHeight;
    private int spaceIndex;

    private BitMapFont(String fontUrl) {
        this.fontUrl = fontUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFont() {
        InputStream in = null;
        try {
            String map;
            in = this.getClass().getResourceAsStream(this.fontUrl);
            if (in == null) {
                return;
            }
            DataInputStream dataIn = new DataInputStream(in);
            this.hasMixedCase = dataIn.readBoolean();
            this.characterMap = map = dataIn.readUTF();
            this.spaceIndex = map.indexOf(32);
            int length = map.length();
            this.characterWidths = new byte[length];
            this.xPositions = new short[length];
            short xPos = 0;
            for (int i = 0; i < length; ++i) {
                byte width;
                this.characterWidths[i] = width = dataIn.readByte();
                this.xPositions[i] = xPos;
                xPos = (short)(xPos + width);
            }
            this.fontImage = Image.createImage((InputStream)in);
            this.fontHeight = this.fontImage.getHeight();
            this.fontUrl = null;
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public BitMapFontViewer getViewer(String input) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return null;
            }
        }
        if (!this.hasMixedCase) {
            input = input.toLowerCase();
        }
        int length = input.length();
        int[] indeces = new int[length];
        for (int i = length - 1; i >= 0; --i) {
            char inputCharacter = input.charAt(i);
            indeces[i] = inputCharacter == '\n' ? -2 : this.characterMap.indexOf(inputCharacter);
        }
        return new BitMapFontViewer(this.fontImage, indeces, this.xPositions, this.characterWidths, this.fontHeight, this.spaceIndex, 1);
    }

    public static BitMapFont getInstance(String url) {
        BitMapFont font = (BitMapFont)fontsByUrl.get(url);
        if (font == null) {
            font = new BitMapFont(url);
            fontsByUrl.put(url, font);
        }
        return font;
    }

    public static void removeInstance(String url) {
        fontsByUrl.remove(url);
    }

    public int charWidth(char c) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        for (int i = 0; i < this.characterMap.length(); ++i) {
            char cm = this.characterMap.charAt(i);
            if (cm != c) continue;
            return this.characterWidths[i];
        }
        return -1;
    }

    public int stringWidth(String str) {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        int width = 0;
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            for (int j = 0; j < this.characterMap.length(); ++j) {
                char cm = this.characterMap.charAt(j);
                if (cm != c) continue;
                width += this.characterWidths[j];
                continue block0;
            }
        }
        return width;
    }

    public int getFontHeight() {
        if (this.fontImage == null) {
            this.initFont();
            if (this.fontImage == null) {
                return -1;
            }
        }
        return this.fontHeight;
    }
}

