/*
 * Decompiled with CFR 0.152.
 */
package com.pip.ui;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.gui.GContainer;
import com.pip.gui.GWidget;
import com.pip.gui.GWindow;
import com.pip.io.UASegment;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameWorld;
import com.pip.ui.Quest;
import com.pip.ui.VM;
import com.pip.util.SortHashtable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class VMGame {
    public static final short CONN_VM_DATA = -10000;
    public static final short CONN_VM_COMMAND = -10001;
    public static final int GAME_COMMAND_CREATE_SPRITE = 10005;
    public static final int GAME_COMMAND_SPRITE_LOAD_ANIMATE = 10010;
    public static final int GAME_COMMAND_SPRITE_ANIMATE_OK = 10020;
    public static final int GAME_COMMAND_SPRITE_CHANGED = 10030;
    public static final int GAME_COMMAND_SPRITE_SET_ANIMATE = 10040;
    public static final int GAME_COMMAND_SPRITE_ANIMATE_PLAY_END = 10050;
    public static final int GAME_COMMAND_SPRITE_PLAY_ATTACK = 10060;
    public static final int GAME_COMMAND_SPRITE_PLAY_PRE_ATTACK = 10061;
    public static final int GAME_COMMAND_SPRITE_PLAY_ATTACKED = 10070;
    public static final int GAME_COMMAND_SPRITE_PLAY_DIE = 10080;
    public static final int GAME_COMMAND_SPRITE_GET_UNIT_INFO = 10090;
    public static final int GAME_COMMAND_SPRITE_TARGETED = 10100;
    public static final int GAME_COMMAND_SPRITE_REFRESH_HEAD_STRING = 10110;
    public static final int GAME_COMMAND_SPRITE_CHASE_END = 10120;
    public static final int GAME_COMMAND_SPRITE_CHASE_STOP = 10121;
    public static final int GAME_COMMAND_SPRITE_PLAY_ATTACK_FAIL = 10130;
    public static final int GAME_COMMAND_SPRITE_FIRE = 10140;
    public static final int GAME_COMMAND_SPRITE_START_CHASE = 10150;
    public static final int GAME_COMMAND_SPRITE_CANCEL_ATTACK = 10160;
    public static final int GAME_COMMAND_SPRITE_PENDING_STOP = 10170;
    public static final int GAME_COMMAND_SPRITE_DESTROY = 10180;
    public static final int GAME_COMMAND_SPRITE_LOAD_HOSRE_ANIMATE = 10190;
    public static final int GAME_COMMAND_WORLD_SYNC_TARGET = 14020;
    public static final int GAME_COMMAND_WORLD_QUEST_ACTION = 14030;
    public static final int GAME_COMMAND_WORLD_PLAYER_OUT_VIEW = 14040;
    public static final int GAME_COMMAND_WORLD_PLAYER_IN_VIEW = 14041;
    public static final int GAME_COMMAND_WORLD_POINT_PRESSED = 14042;
    public static final int GAME_COMMAND_WORLD_POINT_RELEASED = 14043;
    public static final int GAME_COMMAND_WORLD_POINT_DRAGGED = 14044;
    public static final int GAME_COMMAND_PANEL_INIT = 15010;
    public static final int GAME_COMMAND_PANEL_CHANGE_TARGET = 15020;
    public static final int GAME_COMMAND_PANEL_SYNC_CD = 15030;
    public static final int GAME_COMMAND_ROLE_MOVE = 15040;
    public static final int GAME_COMMAND_PANEL_REFRESH_TARGET = 15050;
    public static final int GAME_COMMAND_PANEL_CLEAR_ROLL = 15060;
    public static final String VM_DATA_PREFIX_ANIMATE = "vmDataAnimate";
    public static final String CALLBACK_GAME_COMMAND = "GameCommand";
    public static final String CALLBACK_SCREEN_SIZE_CHANGED = "ScreenSizeChanged";
    public static final String CALLBACK_QUEST_TOUCH_NPC = "QuestTouchNpc";
    public static final String CALLBACK_PQE_CHAT = "QuestChat";
    public static final String CALLBACK_PQE_MESSAGE = "QuestMessage";
    public static final String CALLBACK_PQE_QUESTION = "QuestQuestion";
    public static final String CALLBACK_LOAD_ETF_START = "LoadEtfStart";
    public static final String CALLBACK_LOAD_ETF_END = "LoadEtfEnd";
    public static final String CALLBACK_LOAD_ETF_END1 = "LoadEtfEnd1";
    public static final String CALLBACK_DIS_CONNECTED = "DisConnected";
    public static final String CALLBACK_UNIT_MOVE_FORTH = "UnitMoveForthChanged";
    public static final String CALLBACK_UNIT_MOVE_FIFTH = "UnitMoveFifthChanged";
    public static final String CALLBACK_CHANGED_ON_HORSE = "ChangedOnHorse";
    public static final String CALLBACK_REFRESH_TEAM_PANEL = "RefreshTeamPanel";
    public static final String CALLBACK_LOADING_FINISH = "LoadingFinish";
    public static final String CALLBACK_VMGAME_DESTROY_NOTIFY = "VMGameDestroyNotify";
    public static final String CALLBACK_GAME_WORLD_ADD_GAME_EVENT = "GameWorldAddGameEvent";
    public static final String CALLBACK_GAME_WORLD_GET_VMGAME_KEY = "GameWorldGetVMGame";
    public static final String CALLBACK_QUEST_GET_ITEM_COUNT = "QuestGetItemCount";
    public static final int VM_UASEGMENT_TYPE_INT = 0;
    public static final int VM_UASEGMENT_TYPE_STRING = 1;
    private static SortHashtable sortHt = new SortHashtable();
    public static final byte VM_TYPE_GAME = 0;
    public static final byte VM_TYPE_UI = 1;
    public static final byte VM_TYPE_LIB = 2;
    public static final byte STATE_IDLE = -1;
    public static final byte STATE_REQUESTING_VMUI = 1;
    public static byte state = (byte)-1;
    private static Hashtable loadingVMID = new Hashtable();
    private static Hashtable vmparams = new Hashtable();
    private static Hashtable vmCache = new Hashtable();
    private byte vmType = 0;
    private String vmId;
    private Integer vmKey;
    private static Tool keyMaker = new Tool();
    private boolean isSingleton;
    public static int gameWorldVMGameKey;
    public VM gtvm;
    private SortHashtable vmContainers = new SortHashtable();
    private boolean transparent;
    private boolean closed;
    private boolean catchInput;
    private int oldVMsgPanelY = -1000;
    private static Hashtable gWidgets;
    private Hashtable vmGWidgets = new Hashtable();

    public static void clear() {
        Object[] vgs = sortHt.values();
        if (vgs != null) {
            for (int i = 0; i < vgs.length; ++i) {
                ((VMGame)vgs[i]).vmGWidgets.clear();
                ((VMGame)vgs[i]).gtvm.destroy();
            }
        }
        loadingVMID.clear();
        sortHt.clear();
        vmCache.clear();
        VM.globalVMData.clear();
        gWidgets.clear();
    }

    public static void clearExclude(String excludeVmId) {
        Object[] vgs = sortHt.values();
        if (vgs != null) {
            for (int i = 0; i < vgs.length; ++i) {
                VMGame vmGame = (VMGame)vgs[i];
                if (!excludeVmId.equals(vmGame.vmId)) {
                    vmGame.vmGWidgets.clear();
                    vmGame.gtvm.destroy();
                    sortHt.remove(vmGame.vmKey);
                    continue;
                }
                boolean ii = false;
                ii = false;
            }
        }
        loadingVMID.clear();
        vmCache.clear();
    }

    public void putGWidget(GWidget gWidget) {
        if (gWidget != null) {
            Integer _key = new Integer(gWidget.vmData[29]);
            gWidgets.put(_key, gWidget);
            this.vmGWidgets.put(_key, gWidget);
        }
    }

    public void removeGWidget(GWidget gWidget) {
        if (gWidget != null) {
            Integer _key = new Integer(gWidget.vmData[29]);
            gWidgets.remove(_key);
            this.vmGWidgets.remove(_key);
        }
    }

    public byte getVMType() {
        return this.vmType;
    }

    public String getVMId() {
        return this.vmId;
    }

    public GWindow createWindow(int vmObj, int[] vmData, boolean isTransparent, String name) {
        GWindow window = new GWindow(this, vmObj, vmData, isTransparent, name);
        this.vmContainers.put(window, window);
        window.isShow = false;
        return window;
    }

    public void vmDestroyWindow(GWindow gWindow) {
        this.vmContainers.remove(gWindow);
        gWindow.destroy();
    }

    public void vmCloseWindow(GWindow gWindow) {
        gWindow.isShow = false;
    }

    public void vmContainerAdd(GContainer parent, GWidget child) {
        parent.add(child);
    }

    public void vmContainerInsert(GContainer parent, GWidget child, int index) {
        parent.insert(child, index);
    }

    public void vmContainerDel(GContainer parent, GWidget child) {
        parent.remove(child);
    }

    public void vmShowWindow(GWindow gWindow) {
        this.vmContainers.remove(gWindow);
        this.vmContainers.put(gWindow, gWindow);
        gWindow.isShow = true;
    }

    public SortHashtable getGWindows() {
        return this.vmContainers;
    }

    public void addCommonCallback(int type, GWindow gWindow, String funcName) {
        switch (type) {
            case 1: {
                gWindow.funcCycle = funcName;
                break;
            }
            case 3: {
                gWindow.funcCycleUI = funcName;
                break;
            }
            case 4: {
                gWindow.funcPaint = funcName;
                break;
            }
            case 2: {
                gWindow.funcPacket = funcName;
            }
        }
    }

    public void removeCommonCallback(int type, GWindow gWindow) {
        switch (type) {
            case 1: {
                gWindow.funcCycle = null;
                break;
            }
            case 3: {
                gWindow.funcCycleUI = null;
                break;
            }
            case 4: {
                gWindow.funcPaint = null;
                break;
            }
            case 2: {
                gWindow.funcPacket = null;
            }
        }
    }

    public void processCommonCallback(int type) {
        block6: {
            GWindow container;
            int containerCount = this.vmContainers.size();
            if (containerCount <= 0) break block6;
            Object[] values = this.vmContainers.values();
            int firstIndex = 0;
            int count = this.vmContainers.size();
            for (firstIndex = count - 1; firstIndex >= 0 && (container = (GWindow)this.vmContainers.values()[firstIndex]) != null && (type == 2 || container.isTransparent() || container.vmData[20] == 0); --firstIndex) {
            }
            if (firstIndex < 0) {
                firstIndex = 0;
            }
            if (type == 3) {
                for (int i = containerCount - 1; i >= firstIndex; --i) {
                    GWindow gWindow = (GWindow)values[i];
                    this.handleCaller(gWindow, type);
                    if (!gWindow.isShow || !gWindow.catchInput) continue;
                    Utilities.keyFlag2 = 0L;
                }
            } else {
                for (int i = firstIndex; i < containerCount; ++i) {
                    this.handleCaller((GWindow)values[i], type);
                }
            }
        }
    }

    private void handleCaller(GWindow gWindow, int type) {
        if (gWindow == null || (type == 1 || type == 3 || type == 4) && !gWindow.isShow) {
            return;
        }
        try {
            gWindow.handleCaller(type, this.gtvm.blocked);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setToTop(String vmId) {
        VMGame vg = VMGame.getLastVMGame(vmId);
        if (vg == null) {
            return;
        }
        VMGame.deleteVMGame(vg.vmKey);
        VMGame.addVMGame(vg);
    }

    private static void addVMGame(VMGame vg) {
        sortHt.put(vg.vmKey, vg);
    }

    private static void deleteVMGame(Integer vmKey) {
        sortHt.remove(vmKey);
    }

    private void vmCycle() {
        if (this.closed) {
            return;
        }
        if (this.gtvm != null) {
            this.processCommonCallback(1);
            this.gtvm.execute(1);
        }
    }

    public static void cycle() {
        if (state == 1) {
            Enumeration enu = loadingVMID.keys();
            Hashtable<String, Long> rest = new Hashtable<String, Long>();
            while (enu.hasMoreElements()) {
                String id = (String)enu.nextElement();
                Long startTime = (Long)loadingVMID.get(id);
                if (Tool.getSystemTime() - startTime >= 60000L) continue;
                rest.put(id, startTime);
            }
            loadingVMID = rest;
            VMGame.checkLoading();
            return;
        }
        int vmcount = sortHt.size();
        if (state == -1 && vmcount > 0) {
            block9: for (int i = vmcount - 1; i >= 0; --i) {
                VMGame mn = (VMGame)sortHt.values()[i];
                switch (mn.vmType) {
                    case 0: {
                        mn.vmCycle();
                        continue block9;
                    }
                    case 1: {
                        try {
                            mn.vmCycle();
                        }
                        catch (Exception e) {
                            mn.close();
                        }
                        if (VMGame.isTopUI(mn.vmId)) {
                            try {
                                mn.cycleUI();
                            }
                            catch (Exception e) {
                                mn.close();
                            }
                            if (mn.isCatchInput()) {
                                Utilities.keyFlag2 = 0L;
                            }
                        }
                        if (!mn.isClosed()) continue block9;
                        mn.destroy();
                        continue block9;
                    }
                }
            }
        }
    }

    private static boolean isTopUI(String vmId) {
        VMGame vg = VMGame.getLastVMGame(vmId);
        int vmcount = sortHt.size();
        int startIndex = sortHt.index(vg.vmKey);
        if (startIndex >= 0) {
            for (int i = startIndex + 1; i < vmcount; ++i) {
                VMGame mn = (VMGame)sortHt.values()[i];
                if (mn.vmType != 1 || !mn.isCatchInput()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static int openUI(String vmId, Object param) {
        vmparams.put(vmId, param);
        return VMGame.loadVMGame(vmId, (byte)1, true);
    }

    public static Object getVMParam(String vmId) {
        return vmparams.remove(vmId);
    }

    public void cycleUI() {
        if (this.closed) {
            return;
        }
        if (this.gtvm != null) {
            this.processCommonCallback(3);
            this.gtvm.execute(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callback(String funcName, Object[] data) {
        VM vm = VMGame.getVMGame((String)this.vmId).gtvm;
        if (vm != null) {
            VM vM = vm;
            synchronized (vM) {
                int[] params = null;
                if (data != null) {
                    params = new int[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        params[i] = data[i] instanceof Integer ? ((Integer)data[i]).intValue() : vm.makeTempObject(data[i]);
                    }
                }
                return vm.callback(funcName, params);
            }
        }
        return -1;
    }

    public static VMGame getVMGameByVMKey(int vmKey) {
        return (VMGame)sortHt.get(new Integer(vmKey));
    }

    public static VMGame getVMGame(String vmId) {
        Object[] vgs = sortHt.values();
        for (int i = 0; i < vgs.length; ++i) {
            if (!((VMGame)vgs[i]).vmId.equals(vmId)) continue;
            return (VMGame)vgs[i];
        }
        return null;
    }

    public static VMGame getLastVMGame(String vmId) {
        Object[] vgs = sortHt.values();
        VMGame ret = null;
        for (int i = 0; i < vgs.length; ++i) {
            if (!((VMGame)vgs[i]).vmId.equals(vmId)) continue;
            ret = (VMGame)vgs[i];
        }
        return ret;
    }

    public VM getVM() {
        return this.gtvm;
    }

    private VMGame(String id, byte[] data, byte[] etdData, byte vmType) throws Exception {
        this.vmId = id;
        this.vmType = vmType;
        if (vmType == 1) {
            this.catchInput = true;
        }
        this.gtvm = new VM(this);
        this.gtvm.init(data);
        this.gtvm.link();
        this.vmKey = new Integer(keyMaker.nextKey());
        this.isSingleton = true;
        if ("game_world".equals(this.vmId)) {
            gameWorldVMGameKey = this.vmKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int loadVMGame(String vmId, byte vmType, boolean sync) {
        int ret;
        block24: {
            byte[] etfData;
            block23: {
                VMGame result = VMGame.getVMGame(vmId);
                if (result != null && result.isSingleton) {
                    result.close();
                    result.destroy();
                }
                etfData = (byte[])vmCache.get(vmId);
                ret = 0;
                if (etfData != null) break block23;
                etfData = GameMain.resourceManager.findResource(vmId + ".etf");
                switch (vmType) {
                    case 0: {
                        if (etfData != null) {
                            try {
                                ret = VMGame.addUI(vmId, Tool.inflate(etfData), (byte)0);
                            }
                            catch (Exception e) {}
                            break;
                        }
                        break block24;
                    }
                    case 1: {
                        if (etfData != null) {
                            try {
                                ret = VMGame.addUI(vmId, Tool.inflate(etfData), (byte)1);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            return ret;
                        }
                        GameMain.resourceManager.requestResource(vmId + ".etf");
                        loadingVMID.put(vmId, new Long(Tool.getSystemTime()));
                        if (state == -1) {
                            VM vm;
                            state = 1;
                            VM vM = vm = VMGame.getVMGame("game_world").getVM();
                            synchronized (vM) {
                                vm.callback(CALLBACK_LOAD_ETF_START, new int[]{vm.makeTempObject(vmId)});
                                break;
                            }
                        }
                        break block24;
                    }
                }
                break block24;
            }
            switch (vmType) {
                case 0: {
                    try {
                        ret = VMGame.addUI(vmId, etfData, (byte)0);
                    }
                    catch (Exception e) {}
                    break;
                }
                case 1: {
                    try {
                        ret = VMGame.addUI(vmId, etfData, (byte)1);
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recvEtfData(String vmId, byte[] etfData) {
        block5: {
            int etfVMKey = 0;
            try {
                VM vm;
                etfVMKey = VMGame.addUI(vmId, Tool.inflate(etfData), (byte)1);
                VMGame gameWorld = VMGame.getVMGame("game_world");
                if (gameWorld == null) break block5;
                VM vM = vm = gameWorld.getVM();
                synchronized (vM) {
                    vm.callback(CALLBACK_LOAD_ETF_END1, new int[]{vm.makeTempObject(vmId), etfVMKey});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        loadingVMID.remove(vmId);
        VMGame.checkLoading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkLoading() {
        if (loadingVMID.size() == 0) {
            VM vm;
            state = (byte)-1;
            VM vM = vm = VMGame.getVMGame("game_world").getVM();
            synchronized (vM) {
                vm.callback(CALLBACK_LOAD_ETF_END, null);
            }
        }
    }

    public static int addUI(String vmId, byte[] etfData, byte vmType) throws Exception {
        if (GameMain.needCacheVm.containsKey(vmId)) {
            vmCache.put(vmId, etfData);
        }
        VM tmpVM = new VM(null);
        tmpVM.loadETF(etfData);
        for (int i = 0; i < tmpVM.libNames.length; ++i) {
            String libName = tmpVM.libNames[i];
            if (VMGame.getVMGame(libName) != null) continue;
            byte[] tmpData = GameMain.resourceManager.findResource(libName + ".etf");
            VMGame.addUI(libName, Tool.inflate(tmpData), (byte)2);
        }
        VMGame mn = new VMGame(vmId, etfData, null, vmType);
        etfData = null;
        if (vmType != 2) {
            mn.gtvm.execute(0);
        }
        if (vmType == 1 && GameWorld.panel != null && !mn.transparent) {
            mn.oldVMsgPanelY = GameWorld.panel.getMsgPanelY();
            if (mn.oldVMsgPanelY > 0) {
                GameWorld.panel.setMsgPanelY(GameMain.viewHeight);
            }
        }
        VMGame.addVMGame(mn);
        if (vmType == 1) {
            Quest.setEventMask(32);
        }
        return mn.vmKey;
    }

    public static void removeVMGame(String vmId) {
        VMGame vg = VMGame.getLastVMGame(vmId);
        if (vg != null) {
            vg.gtvm.execute(5);
            vg.gtvm.destroy();
            sortHt.remove(vg.vmKey);
        }
    }

    public static void handleSegment(UASegment segment) {
        Object[] vgs = sortHt.values();
        if (vgs != null) {
            for (int i = vgs.length - 1; i >= 0; --i) {
                VMGame vg = (VMGame)vgs[i];
                if (vg.vmType == 2 || vg.closed) continue;
                segment.reset();
                vg.gtvm.execute(2);
                if (segment.handled) {
                    return;
                }
                vg.processCommonCallback(2);
                if (!segment.handled) continue;
                return;
            }
        }
    }

    public void draw(Graphics g) {
        if (this.closed) {
            return;
        }
        if (!this.transparent) {
            VMGame.drawDefaultBackground(g);
        }
        if (this.gtvm != null) {
            this.gtvm.execute(4);
            this.processCommonCallback(4);
        }
    }

    public static void drawAll(Graphics g, int low, int high) {
        VMGame mn;
        int firstIndex;
        int uiCount = sortHt.size();
        for (firstIndex = uiCount - 1; firstIndex >= 0 && (mn = (VMGame)sortHt.values()[firstIndex]) != null && (mn.isTransparent() || mn.vmType != 1); --firstIndex) {
        }
        if (firstIndex < 0) {
            firstIndex = 0;
        }
        while (firstIndex < uiCount) {
            mn = (VMGame)sortHt.values()[firstIndex];
            if (mn.vmType == 1) {
                mn.draw(g);
            } else if (mn.vmType == 0) {
                mn.gtvm.execute(4);
            }
            ++firstIndex;
        }
    }

    public static void drawDefaultBackground(Graphics g) {
        Tool.drawBack(g, 0, 0, GameMain.viewWidth, GameMain.viewHeight);
    }

    public static void closeAllUI(VMGame refUI, int type) {
        Object[] vgs = sortHt.values();
        if (vgs != null) {
            for (int i = vgs.length - 1; i >= 0; --i) {
                VMGame vg = (VMGame)vgs[i];
                if (vg.equals(refUI)) {
                    if (vg.getVMType() == 1 && type == 0) {
                        vg.close();
                    }
                    return;
                }
                if (vg.getVMType() != 1) continue;
                vg.close();
            }
        }
    }

    public static void closeVM(String vmId) {
        VMGame vg = VMGame.getVMGame(vmId);
        if (vg != null) {
            vg.close();
        }
    }

    public static void closeVM(int vmKey) {
        VMGame vg = (VMGame)sortHt.get(new Integer(vmKey));
        if (vg != null) {
            vg.close();
        }
    }

    public static boolean hasUI(String uiID) {
        VMGame vg = VMGame.getVMGame(uiID);
        if (vg.getVMId().equals(uiID) && !vg.isClosed()) {
            return true;
        }
        return loadingVMID.containsKey(uiID);
    }

    public void close() {
        this.closed = true;
        if (this.vmType == 1 && GameWorld.panel != null && !this.transparent && this.oldVMsgPanelY > 0) {
            GameWorld.panel.setMsgPanelY(this.oldVMsgPanelY);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public static boolean isAllTransparent(boolean chectCatchInput) {
        Object[] vgs = sortHt.values();
        if (vgs != null) {
            for (int i = 0; i < vgs.length; ++i) {
                VMGame vg = (VMGame)vgs[i];
                if (vg.vmType != 1 || vg.isTransparent() && (!chectCatchInput || !vg.isCatchInput())) continue;
                return false;
            }
        }
        return true;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    public boolean getSingleton() {
        return this.isSingleton;
    }

    public boolean isCatchInput() {
        return this.catchInput;
    }

    public void setCatchInput(boolean catchInput) {
        this.catchInput = catchInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.gtvm != null) {
            this.gtvm.execute(5);
            this.gtvm.destroy();
            this.gtvm = null;
            VMGame.deleteVMGame(this.vmKey);
            VMGame gvm = VMGame.getVMGameByVMKey(gameWorldVMGameKey);
            if (gvm != null) {
                VM vm;
                VM vM = vm = gvm.getVM();
                synchronized (vM) {
                    vm.callback(CALLBACK_VMGAME_DESTROY_NOTIFY, new int[]{this.vmKey, vm.makeTempObject(gvm), vm.makeTempObject(this.vmId), this.vmType});
                }
                Enumeration emu = this.vmGWidgets.keys();
                while (emu.hasMoreElements()) {
                    Integer _key = (Integer)emu.nextElement();
                    gWidgets.remove(_key);
                }
                this.vmGWidgets.clear();
            }
        }
    }

    public static SortHashtable getVMGames() {
        return sortHt;
    }

    public static int getCommonKey() {
        return keyMaker.nextKey();
    }

    public static String getTopUIVMId() {
        int vmcount = sortHt.size();
        for (int i = vmcount - 1; i >= 0; --i) {
            VMGame mn = (VMGame)sortHt.values()[i];
            if (mn.vmType != 1) continue;
            return mn.vmId;
        }
        return null;
    }

    public static GWindow getTopGWindow() {
        Object[] vgs = sortHt.values();
        for (int i = vgs.length - 1; i >= 0; --i) {
            VMGame vg = (VMGame)vgs[i];
            if (vg.vmContainers == null || vg.vmContainers.size() <= 0) continue;
            Object[] gWindows = vg.vmContainers.values();
            for (int j = gWindows.length - 1; j >= 0; --j) {
                GWindow gWindow = (GWindow)gWindows[j];
                if (!gWindow.isShow) continue;
                return gWindow;
            }
        }
        return null;
    }

    public static GWindow getMouseTopGWindow(int x, int y) {
        Object[] vgs = sortHt.values();
        for (int i = vgs.length - 1; i >= 0; --i) {
            VMGame vg = (VMGame)vgs[i];
            if (vg.vmContainers == null || vg.vmContainers.size() <= 0) continue;
            Object[] gWindows = vg.vmContainers.values();
            for (int j = gWindows.length - 1; j >= 0; --j) {
                GWindow gWindow = (GWindow)gWindows[j];
                if (!gWindow.isShow) continue;
                if (Tool.rectIn(gWindow.vmData[7], gWindow.vmData[8], gWindow.vmData[5], gWindow.vmData[6], x, y)) {
                    return gWindow;
                }
                if (!gWindow.catchInput) continue;
                return gWindow;
            }
        }
        return null;
    }

    public static GWidget getPointerWidget(int x, int y) {
        GWindow gTopWindow = VMGame.getTopGWindow();
        if (gTopWindow != null) {
            return gTopWindow.serchWdiget2(x, y);
        }
        return null;
    }

    public static GWidget getPointerWidget(GWindow gTopWindow, int x, int y) {
        if (gTopWindow != null) {
            return gTopWindow.serchWdiget(x, y);
        }
        return null;
    }

    public static GWidget getGWidget(int key) {
        return (GWidget)gWidgets.get(new Integer(key));
    }

    static {
        gWidgets = new Hashtable();
    }
}

