/*
 * Decompiled with CFR 0.152.
 */
package com.pip.sanguo;

import com.pip.common.Tool;
import com.pip.engine.AnimatePlayer;
import com.pip.engine.FlyingStringInfo;
import com.pip.engine.GameMap;
import com.pip.engine.LandformImage;
import com.pip.image.ImageSet;
import com.pip.image.PipAnimateSet;
import com.pip.io.UASegment;
import com.pip.sanguo.DrawItem;
import com.pip.sanguo.GameExit;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameNetPlayer;
import com.pip.sanguo.GameNpc;
import com.pip.sanguo.GameRole;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameWorld;
import com.pip.ui.Quest;
import com.pip.util.SortHashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameView {
    public GameMap map;
    private ImageSet tileImage = null;
    private byte[][] tinfo = null;
    private LandformImage[] landformImages = null;
    private byte[][] landformTileInfos = null;
    private int[][] mapDataBuffer = null;
    private boolean mapDataBufferReleased = true;
    private byte[][] mapCollisonData = null;
    private int[] miniMapData = null;
    private int miniMapWidth;
    private int miniMapHeight;
    private int[] miniMapProcData = null;
    public static boolean mapNpcAnimateNeedLoad = true;
    public static PipAnimateSet mapNpcAnimateSet = null;
    private int[][] mapNpcCollision = null;
    public int tileWidth;
    public int tileHeight;
    private int tileXCount;
    private int tileYCount;
    public int pathTileWidth;
    public int pathTileHeight;
    private int pathTileXCount;
    private int pathTileYCount;
    private boolean useImageBuffer = true;
    private Image bgImg = null;
    public boolean isFirstBgImage = true;
    private Graphics gg;
    private int oldStartX;
    private int oldStartY;
    private int bgCellW;
    private int bgCellH;
    private int bgWidth;
    private int bgHeight;
    private int oldEndX;
    private int oldEndY;
    public int vx;
    public int vy;
    private short[] yOrder = null;
    private int yOrderCount = 0;
    private short[] autoSelectOrder = null;
    private short[] forceSelectOrder = null;
    private int autoSelectOrderCount = 0;
    private int forceSelectOrderCount = 0;
    private Vector pendingItems = new Vector();
    private Vector pendingItemsTop = new Vector();
    private Vector mapNpcDirtyData = new Vector();
    private static int[] thumbColors;
    public static int[] miniMapConfig;
    public static boolean miniMapShow;
    public static final byte MINI_MAP_CONIFG_ALPHA = 0;
    private static final byte MINI_MAP_CONIFG_FLASH = 1;
    private static final byte MINI_MAP_CONIFG_FLASH_COLOR_COUNT = 2;
    private static final byte MINI_MAP_CONIFG_ICON_SIZE = 3;
    private static final byte MINI_MAP_CONFIG_BOX1_COLOR = 4;
    private static final byte MINI_MAP_CONFIG_BOX2_COLOR = 5;
    private static final byte MINI_MAP_CONIFG_SPHERE1 = 6;
    private static final byte MINI_MAP_CONIFG_SCALE1 = 7;
    private static final byte MINI_MAP_CONIFG_SPHERE2 = 8;
    private static final byte MINI_MAP_CONIFG_SCALE2 = 9;
    private static final byte MINI_MAP_CONIFG_SPHERE3 = 10;
    private static final byte MINI_MAP_CONIFG_SCALE3 = 11;
    private static final byte MINI_MAP_CONIFG_X = 12;
    private static final byte MINI_MAP_CONIFG_Y = 13;
    private static final byte MINI_MAP_CONIFG_NET_WIDTH = 14;
    private static final byte MINI_MAP_CONIFG_NET_HEIGHT = 15;
    public static final byte MINI_MAP_NET_COLOR_FAST = 0;
    public static final byte MINI_MAP_NET_COLOR_NORMAL = 1;
    public static final byte MINI_MAP_NET_COLOR_SLOW = 2;
    public static final byte MINI_MAP_NET_COLOR_BAD = 3;
    public static int currNetColor;
    private static final byte MAP_CAN_PASS = 0;
    private static final byte MAP_NOT_PASS = 1;
    private static final byte PATH_SHIFT = 1;
    public static int viewX;
    public static int viewY;
    public static int showHeight;
    public static int showWidth;
    public static boolean showMapNpcAnimate;
    public static int[] sortTable;
    public static final SortHashtable drawItemPanel;
    private Tool idKey = new Tool();
    private static Image miniMapImage;
    private int oldViewX = 0;
    private int oldViewY = 0;
    private static boolean needBuildEdgeMapNpc;
    private static final Vector edgeNpcsOfGround;
    private static final Vector edgeNpcsOfRole;
    private static final Vector edgeNpcsOfSky;
    public static ImageSet bubbleImg;
    private static final byte[][] PATH_FIND;

    public GameView(GameMap map) {
        this.map = map;
        this.rebuildViewData();
        showWidth = GameMain.viewWidth;
        showHeight = GameMain.viewHeight;
    }

    public int addDrawItem(PipAnimateSet pas, ImageSet image, int frame, int x, int y, int trans, int anchor) {
        int id = this.idKey.nextKey();
        DrawItem di = new DrawItem(pas, image, frame, x, y, trans, anchor);
        drawItemPanel.put(new Integer(id), di);
        return id;
    }

    public void removeDrawItem(int key) {
        drawItemPanel.remove(new Integer(key));
    }

    public void clearDrawItem() {
        drawItemPanel.clear();
    }

    public GameSprite findNearTarget(boolean autoList) {
        short[] orderList = this.forceSelectOrder;
        int orderCount = this.forceSelectOrderCount;
        if (autoList) {
            orderList = this.autoSelectOrder;
            orderCount = this.autoSelectOrderCount;
        }
        if (orderList == null) {
            return null;
        }
        GameSprite result = null;
        GameSprite current = null;
        boolean isSelectAll = GameRole.isSelectAllMode();
        for (int i = 0; i < orderCount; i += 4) {
            short type = orderList[i];
            short idx = orderList[i + 1];
            if (orderList[i + 2] > GameMain.autoSelectDistance) continue;
            current = this.transSelectTarget(type, idx);
            if ((current = this.checkTarget(current)) == null) continue;
            if (isSelectAll) {
                result = current;
                break;
            }
            if (GameRole.isCivilPlayer(current)) continue;
            result = current;
            break;
        }
        return result;
    }

    public GameSprite findNearNPC() {
        GameWorld.player.clearTarget();
        short[] orderList = this.forceSelectOrder;
        int orderCount = this.forceSelectOrderCount;
        if (orderList == null) {
            return null;
        }
        GameSprite result = null;
        GameSprite current = null;
        boolean isSelectAll = GameRole.isSelectAllMode();
        for (int i = 0; i < orderCount; i += 4) {
            short type = orderList[i];
            short idx = orderList[i + 1];
            if (type != 5 || orderList[i + 2] > GameMain.autoSelectDistance || (current = this.transSelectTarget(type, idx)) != null && current.canAttack || (current = this.checkTarget(current)) == null) continue;
            if (isSelectAll) {
                result = current;
                break;
            }
            if (GameRole.isCivilPlayer(current)) continue;
            result = current;
            break;
        }
        return result;
    }

    public GameSprite findNextTarget(GameSprite oldTarget) {
        short idx;
        short type;
        int i;
        if (this.forceSelectOrder == null) {
            return null;
        }
        GameSprite result = null;
        GameSprite current = null;
        int oldIndex = -4;
        boolean isSelectAll = GameRole.isSelectAllMode();
        if (oldTarget != null) {
            for (i = 0; i < this.forceSelectOrderCount; i += 4) {
                type = this.forceSelectOrder[i];
                idx = this.forceSelectOrder[i + 1];
                current = this.transSelectTarget(type, idx);
                if ((current = this.checkTarget(current)) != oldTarget) continue;
                oldIndex = i;
                break;
            }
        } else {
            oldIndex = -4;
        }
        for (i = oldIndex + 4; i < this.forceSelectOrderCount; i += 4) {
            type = this.forceSelectOrder[i];
            idx = this.forceSelectOrder[i + 1];
            current = this.transSelectTarget(type, idx);
            if ((current = this.checkTarget(current)) == null) continue;
            if (isSelectAll) {
                result = current;
                break;
            }
            if (GameRole.isCivilPlayer(current)) continue;
            result = current;
            break;
        }
        if (result == null) {
            for (i = 0; i < oldIndex; i += 4) {
                type = this.forceSelectOrder[i];
                idx = this.forceSelectOrder[i + 1];
                current = this.transSelectTarget(type, idx);
                if ((current = this.checkTarget(current)) == null) continue;
                if (isSelectAll) {
                    result = current;
                    break;
                }
                if (GameRole.isCivilPlayer(current)) continue;
                result = current;
                break;
            }
        }
        return result;
    }

    public GameSprite findNearCreature() {
        GameWorld.player.clearTarget();
        short[] orderList = this.forceSelectOrder;
        int orderCount = this.forceSelectOrderCount;
        if (orderList == null) {
            return null;
        }
        GameSprite current = null;
        for (int i = 0; i < orderCount; i += 4) {
            short type = orderList[i];
            short idx = orderList[i + 1];
            if (type != 5 || orderList[i + 2] > GameMain.autoSelectDistance || type != 5 || idx >= GameWorld.gameSprites.size() || (current = (GameSprite)GameWorld.gameSprites.elementAt(idx)) == null || current.die || !current.canAttack) continue;
            return current;
        }
        return current;
    }

    private GameSprite transSelectTarget(int type, int idx) {
        GameSprite result = null;
        try {
            switch (type) {
                case 5: 
                case 6: {
                    result = (GameSprite)GameWorld.gameSprites.elementAt(idx);
                    break;
                }
                case 9: {
                    result = (GameSprite)GameWorld.gameExits.elementAt(idx);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return result;
    }

    public GameSprite checkTarget(GameSprite target) {
        GameSprite result;
        block11: {
            block10: {
                result = target;
                if (result == null || !result.canSelect) break block10;
                block0 : switch (result.getType()) {
                    case 5: {
                        int questId = ((GameNpc)result).questId;
                        switch (questId) {
                            case -1: {
                                break block0;
                            }
                            case -2: {
                                result = null;
                                break block0;
                            }
                        }
                        Quest quest = Quest.findQuest(questId, false);
                        if (quest == null || quest.state == 2 || quest.state == 0) {
                            result = null;
                            break;
                        }
                        break block11;
                    }
                    case 1: 
                    case 3: {
                        if (!result.die || !result.canAttack) break;
                        result = null;
                        break;
                    }
                    case 6: {
                        result = null;
                    }
                }
                break block11;
            }
            result = null;
        }
        return result;
    }

    private void processNearSprite() {
        int[] roleBox = new int[4];
        int[] exitBox = new int[4];
        int[] spriteBox = new int[4];
        roleBox = GameWorld.player.sprite.getCollisionBox(roleBox, false);
        boolean spriteFound = false;
        block5: for (int i = 0; i < this.autoSelectOrderCount; i += 4) {
            short type = this.autoSelectOrder[i];
            short idx = this.autoSelectOrder[i + 1];
            switch (type) {
                case 9: {
                    GameExit gameExit = (GameExit)GameWorld.gameExits.elementAt(idx);
                    if (gameExit == null) continue block5;
                    exitBox = gameExit.sprite.getCollisionBox(exitBox, false);
                    exitBox[0] = exitBox[0] - 8;
                    exitBox[2] = exitBox[2] + 16;
                    exitBox[3] = exitBox[3] + 12;
                    if (this.autoSelectOrder[i + 2] <= GameMain.autoSelectDistance) {
                        gameExit.sprite.setHeadStringShow(true);
                    } else {
                        gameExit.sprite.setHeadStringShow(false);
                    }
                    if (Tool.rectIntersect(roleBox[0], roleBox[1], roleBox[2], roleBox[3], exitBox[0], exitBox[1], exitBox[2], exitBox[3])) {
                        if (gameExit.touching) continue block5;
                        gameExit.sendCommand(10140, null);
                        gameExit.touching = true;
                        continue block5;
                    }
                    gameExit.touching = false;
                    continue block5;
                }
                case 5: 
                case 6: {
                    GameSprite gameSprite = (GameSprite)GameWorld.gameSprites.elementAt(idx);
                    if (gameSprite == null || !GameWorld.netplayerNameNearShow || this.checkTarget(gameSprite) == null) continue block5;
                    spriteBox = gameSprite.sprite.getCollisionBox(spriteBox, false);
                    spriteBox[3] = spriteBox[3] * 2;
                    if (!spriteFound && this.autoSelectOrder[i + 2] <= GameMain.netplayerShowNameDistance) {
                        if (gameSprite != GameWorld.player.target) {
                            gameSprite.sprite.setHeadStringShow(true);
                        }
                        spriteFound = true;
                        continue block5;
                    }
                    if (gameSprite == GameWorld.player.target) continue block5;
                    gameSprite.sprite.setHeadStringShow(false);
                    continue block5;
                }
                case 11: {
                    GameSprite gameSprite = (GameSprite)GameWorld.gameSprites.elementAt(idx);
                    gameSprite.sprite.setHeadStringShow(true);
                }
            }
        }
    }

    public int collisionMap(int x, int y, int w, int h, int direct, int step, int oldX, int oldY, int currentResult) {
        int result = currentResult;
        int x1 = 0;
        int y1 = 0;
        int w1 = 0;
        int h1 = 0;
        int startX = 0;
        int startY = 0;
        int endX = 0;
        int endY = 0;
        switch (direct) {
            case 0: {
                startX = x;
                endX = x + w;
                startY = oldY + h;
                endY = y + h;
                break;
            }
            case 1: {
                startX = oldX + w;
                endX = x + w;
                startY = y;
                endY = y + h;
                break;
            }
            case 2: {
                startX = x;
                endX = oldX;
                startY = y;
                endY = y + h;
                break;
            }
            case 3: {
                startX = x;
                endX = x + w;
                startY = y;
                endY = oldY;
            }
        }
        startY /= this.pathTileHeight;
        endX /= this.pathTileWidth;
        endY /= this.pathTileHeight;
        if ((startX /= this.pathTileWidth) < 0) {
            startX = 0;
        }
        if (startY < 0) {
            startY = 0;
        }
        if (endX >= this.pathTileXCount) {
            endX = this.pathTileXCount - 1;
        }
        if (endY >= this.pathTileYCount) {
            endY = this.pathTileYCount - 1;
        }
        for (int i = startY; i <= endY; ++i) {
            for (int j = startX; j <= endX; ++j) {
                int ptx;
                int oldResult = result;
                x1 = j * this.pathTileWidth;
                y1 = i * this.pathTileHeight;
                w1 = this.pathTileWidth;
                h1 = this.pathTileHeight;
                int testx = j;
                int testy = i;
                if ((this.mapCollisonData[testy][testx >>= 3] >> (ptx = testx & 7) & 1) == 1) {
                    result = Tool.calculateDistance(x1, y1, w1, h1, oldX, oldY, w, h, direct);
                }
                result = Math.min(result, oldResult);
            }
        }
        return result;
    }

    public boolean canMove(int x, int y) {
        int testx = this.getTileX(x) << 1;
        int ptx = testx & 7;
        int testy = this.getTileY(y) << 1;
        if ((testx >>= 3) >= 0 && testx < this.mapCollisonData[0].length && testy >= 0 && testy < this.mapCollisonData.length) {
            return (this.mapCollisonData[testy][testx] >> ptx & 1) == 0;
        }
        return false;
    }

    public int collisionYOrder(int x, int y, int w, int h, int direct, int step, int oldX, int oldY, int currentResult) {
        int result = currentResult;
        int[] box = new int[4];
        block4: for (int i = 0; i < this.yOrderCount; i += 4) {
            int oldResult = result;
            short idx = this.yOrder[i + 1];
            switch (this.yOrder[i]) {
                case 2: 
                case 3: {
                    short[][] npcData = this.yOrder[i] == 2 ? this.map.groundNPCs : this.map.roleNPCs;
                    short animateId = npcData[0][idx];
                    int count = this.mapNpcCollision[animateId].length >> 1;
                    for (int j = 0; j < count; ++j) {
                        oldResult = result;
                        box[0] = (short)(this.mapNpcCollision[animateId][j << 1] >> 16) + npcData[1][idx];
                        box[1] = (short)(this.mapNpcCollision[animateId][j << 1] & 0xFFFF) + npcData[2][idx];
                        box[2] = this.mapNpcCollision[animateId][(j << 1) + 1] >> 16;
                        box[3] = this.mapNpcCollision[animateId][(j << 1) + 1] & 0xFFFF;
                        if (Tool.rectIntersect(box[0], box[1], box[2], box[3], x, y, w, h)) {
                            result = Tool.calculateDistance(box[0], box[1], box[2], box[3], oldX, oldY, w, h, direct);
                        }
                        result = Math.min(result, oldResult);
                    }
                    continue block4;
                }
                case 5: {
                    GameNpc npcSprite = (GameNpc)GameWorld.gameSprites.elementAt(idx);
                    if (!npcSprite.needCollision) continue block4;
                    if (Tool.rectIntersect((box = npcSprite.sprite.getCollisionBox(box, true))[0], box[1], box[2], box[3], x, y, w, h)) {
                        result = Tool.calculateDistance(box[0], box[1], box[2], box[3], oldX, oldY, w, h, direct);
                    }
                    result = Math.min(result, oldResult);
                }
            }
        }
        return result;
    }

    public static void initMiniMapConfig(UASegment segment) {
        thumbColors = segment.readInts();
        miniMapConfig = segment.readInts();
    }

    public void drawMiniMap(Graphics g, int x, int y) {
        int iconY;
        int iconX;
        GameSprite gameSprite;
        int i;
        if (this.mapDataBufferReleased) {
            return;
        }
        int iconSize = miniMapConfig[3];
        g.setColor(miniMapConfig[4]);
        g.drawRect(x, y, this.miniMapWidth - 1, this.miniMapHeight - 1);
        g.setColor(miniMapConfig[5]);
        g.drawRect(x + 1, y + 1, this.miniMapWidth - 3, this.miniMapHeight - 3);
        x += 2;
        y += 2;
        int drawWidth = this.miniMapWidth - 4;
        int drawHeight = this.miniMapHeight - 4;
        int iconXRevise = this.tileXCount * this.tileWidth;
        int iconYRevise = this.tileYCount * this.tileHeight;
        int iconSizeRevise = iconSize / 2;
        if (miniMapConfig[0] == -16777216) {
            g.drawRGB(this.miniMapData, 0, drawWidth, x, y, drawWidth, drawHeight, false);
        } else if (miniMapConfig[0] != 0) {
            if (miniMapImage == null) {
                miniMapImage = Image.createRGBImage((int[])this.miniMapData, (int)drawWidth, (int)drawHeight, (boolean)true);
            }
            g.drawImage(miniMapImage, x, y, 20);
        }
        g.setColor(miniMapConfig[currNetColor + 16]);
        g.fillRect(x - 1, y + drawHeight + 2, miniMapConfig[14] == 0 ? this.miniMapWidth - 2 : miniMapConfig[14], miniMapConfig[15]);
        int count = GameWorld.gameSprites.size();
        for (i = 0; i < count; ++i) {
            gameSprite = (GameSprite)GameWorld.gameSprites.elementAt(i);
            iconX = gameSprite.sprite.getX() * drawWidth / iconXRevise;
            iconY = gameSprite.sprite.getY() * drawHeight / iconYRevise;
            if (gameSprite.miniMapShow && gameSprite.sprite.getMapId() == this.map.id && gameSprite.miniMapImage == null) {
                g.setColor(gameSprite.miniMapColor[this.miniMapProcData[1]]);
                g.fillRect(iconX + x - iconSizeRevise, iconY + y - iconSizeRevise, iconSize, iconSize);
            }
            if (gameSprite.sprite.getMapId() != this.map.id || gameSprite.miniMapImage == null) continue;
            ImageSet is = (ImageSet)Tool.getGlobalObject((String)gameSprite.miniMapImage[0]);
            is.drawFrame(g, (Integer)gameSprite.miniMapImage[1], iconX + x - iconSizeRevise, iconY + y - iconSizeRevise, 0, 3);
        }
        count = GameWorld.gameExits.size();
        for (i = 0; i < count; ++i) {
            gameSprite = (GameSprite)GameWorld.gameExits.elementAt(i);
            if (!gameSprite.miniMapShow) continue;
            iconX = gameSprite.sprite.getX() * drawWidth / iconXRevise;
            iconY = gameSprite.sprite.getY() * drawHeight / iconYRevise;
            g.setColor(gameSprite.miniMapColor[this.miniMapProcData[1]]);
            g.fillRect(iconX + x - iconSizeRevise, iconY + y - iconSizeRevise, iconSize, iconSize);
        }
    }

    public void cycle(int viewX, int viewY) {
        this.createYOrder(viewX, viewY);
        this.processNearSprite();
        if (miniMapShow && !this.mapDataBufferReleased && GameMain.tick >= this.miniMapProcData[0]) {
            this.miniMapProcData[0] = GameMain.tick + miniMapConfig[1];
            this.miniMapProcData[1] = this.miniMapProcData[1] + 1;
            if (this.miniMapProcData[1] >= miniMapConfig[2]) {
                this.miniMapProcData[1] = 0;
            }
        }
    }

    public static void moveMap() {
        if (GameWorld.player == null) {
            return;
        }
        viewX = (short)(GameWorld.player.sprite.getX() - (showWidth >> 1));
        viewY = (short)(GameWorld.player.sprite.getY() - (showHeight >> 1));
        if (viewX < 0) {
            viewX = 0;
        }
        if (viewY < 0) {
            viewY = 0;
        }
        short viewMaxX = (short)(GameWorld.gameView.map.width - showWidth & 0xFFFF);
        short viewMaxY = (short)(GameWorld.gameView.map.height - showHeight & 0xFFFF);
        if (viewX > viewMaxX) {
            viewX = viewMaxX;
        }
        if (viewY > viewMaxY) {
            viewY = viewMaxY;
        }
        if (viewMaxX < 0) {
            viewX = (short)(viewMaxX / 2);
        }
        if (viewMaxY < 0) {
            viewY = (short)(viewMaxY / 2);
        }
    }

    public void draw(Graphics g, int viewX, int viewY) {
        int mx = 0;
        int my = 0;
        int mw = showWidth;
        int mh = showHeight;
        if (mw > this.map.width) {
            mx = -viewX;
            mw = this.map.width;
        }
        if (mh > this.map.height) {
            my = -viewY;
            mh = this.map.height;
        }
        g.setClip(mx, my, mw, mh);
        this.drawMap(g, viewX, viewY);
        this.drawItem(g, viewX, viewY);
        this.drawYOrder(g, viewX, viewY);
        this.drawPendingItems(g);
        if (miniMapShow) {
            this.drawMiniMap(g, miniMapConfig[12] - this.miniMapWidth, miniMapConfig[13]);
        }
        g.setClip(0, 0, GameMain.viewWidth, GameMain.viewHeight);
    }

    public void addPendingHeadString(String str, int x, int y, int color, int bgColor, int anchor, boolean is3D, boolean isTop) {
        PendingDrawItem item = new PendingDrawItem();
        item.type = 0;
        item.objData = str;
        item.x = x;
        item.y = y;
        item.color = color;
        item.bgColor = bgColor;
        item.anchor = anchor;
        item.is3D = is3D;
        if (isTop) {
            this.pendingItemsTop.addElement(item);
        } else {
            this.pendingItems.addElement(item);
        }
    }

    public void addPendingImage(ImageSet image, int frame, int x, int y, int anchor, boolean isTop) {
        PendingDrawItem item = new PendingDrawItem();
        item.type = 3;
        item.objData = image;
        item.x = x;
        item.y = y;
        item.color = frame;
        item.anchor = anchor;
        if (isTop) {
            this.pendingItemsTop.addElement(item);
        } else {
            this.pendingItems.addElement(item);
        }
    }

    public void addPendingFlyString(FlyingStringInfo flyInfo, int x, int y, boolean isTop) {
        PendingDrawItem item = new PendingDrawItem();
        item.type = 1;
        item.objData = flyInfo;
        item.x = x;
        item.y = y;
        this.pendingItems.addElement(item);
    }

    public void addPendingAnimate(AnimatePlayer animatePlayer, int x, int y, boolean isTop) {
        PendingDrawItem item = new PendingDrawItem();
        item.type = 2;
        item.objData = animatePlayer;
        item.x = x;
        item.y = y;
        if (isTop) {
            this.pendingItemsTop.addElement(item);
        } else {
            this.pendingItems.addElement(item);
        }
    }

    public void addPendingBubble(String[] text, int x, int y, boolean isTop) {
        Bubble item = new Bubble(text, x, y);
        if (isTop) {
            this.pendingItemsTop.addElement(item);
        } else {
            this.pendingItems.addElement(item);
        }
    }

    private void drawPendingItems(Graphics g) {
        PendingDrawItem item;
        int i;
        int count = this.pendingItems.size();
        for (i = 0; i < count; ++i) {
            item = (PendingDrawItem)this.pendingItems.elementAt(i);
            item.draw(g);
        }
        this.pendingItems.removeAllElements();
        count = this.pendingItemsTop.size();
        for (i = 0; i < count; ++i) {
            item = (PendingDrawItem)this.pendingItemsTop.elementAt(i);
            item.draw(g);
        }
        this.pendingItemsTop.removeAllElements();
    }

    private void drawItem(Graphics g, int viewX, int viewY) {
        try {
            int count = drawItemPanel.size();
            for (int i = 0; i < count; ++i) {
                DrawItem item = (DrawItem)drawItemPanel.getValue(i);
                item.draw(g, viewX, viewY);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void addMapNpcDirtyData(int[] box, int viewX, int viewY) {
        box[0] = box[0] - (viewX + 8);
        box[1] = box[1] - (viewY + 8);
        box[2] = box[2] + 16;
        box[3] = box[3] + 16;
        int size = this.mapNpcDirtyData.size();
        for (int i = 0; i < size; ++i) {
            int[] tmp = (int[])this.mapNpcDirtyData.elementAt(i);
            if (!Tool.rectIntersect(tmp[0], tmp[1], tmp[2], tmp[3], box[0], box[1], box[2], box[3])) continue;
            Tool.mergeBox(tmp, box);
        }
        int[] arr = new int[4];
        System.arraycopy(box, 0, arr, 0, 4);
        this.mapNpcDirtyData.addElement(arr);
    }

    private Vector getMapNpcDirtyList(int[] box, int viewX, int viewY) {
        Vector<int[]> dirtyList = new Vector<int[]>();
        box[0] = box[0] - viewX;
        box[1] = box[1] - viewY;
        int size = this.mapNpcDirtyData.size();
        for (int i = 0; i < size; ++i) {
            int[] dirty = (int[])this.mapNpcDirtyData.elementAt(i);
            if (!Tool.rectIntersect(box[0], box[1], box[2], box[3], dirty[0], dirty[1], dirty[2], dirty[3])) continue;
            dirtyList.addElement(dirty);
        }
        return dirtyList.size() == 0 ? null : dirtyList;
    }

    private void drawYOrder(Graphics g, int viewX, int viewY) {
        short[][] npcData = null;
        if (this.yOrder == null) {
            return;
        }
        this.mapNpcDirtyData.removeAllElements();
        int[] npcBox = new int[4];
        block12: for (int i = 0; i < this.yOrderCount; i += 4) {
            short type = this.yOrder[i];
            short idx = this.yOrder[i + 1];
            switch (type) {
                case 1: {
                    GameWorld.player.draw(g, viewX, viewY);
                    this.addMapNpcDirtyData(GameWorld.player.sprite.getAnimateBox(), viewX, viewY);
                    continue block12;
                }
                case 9: {
                    GameExit gameExit = (GameExit)GameWorld.gameExits.elementAt(idx);
                    gameExit.draw(g, viewX, viewY);
                    this.addMapNpcDirtyData(gameExit.sprite.getAnimateBox(), viewX, viewY);
                    continue block12;
                }
                case 2: 
                case 3: 
                case 4: {
                    switch (type) {
                        case 2: {
                            npcData = this.map.groundNPCs;
                            break;
                        }
                        case 3: {
                            npcData = this.map.roleNPCs;
                            break;
                        }
                        case 4: {
                            npcData = this.map.skyNPCs;
                        }
                    }
                    short animateId = npcData[0][idx];
                    npcBox = mapNpcAnimateSet.getAnimateBox(npcBox, animateId);
                    npcBox[0] = npcBox[0] + npcData[1][idx];
                    npcBox[1] = npcBox[1] + npcData[2][idx];
                    if (!showMapNpcAnimate || mapNpcAnimateSet.getAnimateLength(animateId) <= 1 && this.useImageBuffer) {
                        Vector drawData;
                        if (type == 2 || (drawData = this.getMapNpcDirtyList(npcBox, viewX, viewY)) == null) continue block12;
                        int size = drawData.size() - 1;
                        for (int j = 0; j <= size; ++j) {
                            int[] r = (int[])drawData.elementAt(j);
                            g.setClip(r[0], r[1], r[2], r[3]);
                            if (j == size) {
                                this.drawMapNpc(g, viewX, viewY, npcData, idx, false);
                                continue;
                            }
                            this.drawMapNpc(g, viewX, viewY, npcData, idx, !showMapNpcAnimate);
                        }
                        g.setClip(0, 0, GameMain.viewWidth, GameMain.viewHeight);
                        continue block12;
                    }
                    this.addMapNpcDirtyData(npcBox, viewX, viewY);
                    this.drawMapNpc(g, viewX, viewY, npcData, idx, true);
                    continue block12;
                }
                case 5: 
                case 6: 
                case 11: {
                    GameSprite drawSprite = (GameSprite)GameWorld.gameSprites.elementAt(idx);
                    drawSprite.draw(g, viewX, viewY);
                    this.addMapNpcDirtyData(drawSprite.sprite.getAnimateBox(), viewX, viewY);
                    continue block12;
                }
                case 10: {
                    if (idx >= GameWorld.leavingSprites.size()) continue block12;
                    GameSprite drawSprite = (GameSprite)GameWorld.leavingSprites.elementAt(idx);
                    drawSprite.draw(g, viewX, viewY);
                    this.addMapNpcDirtyData(drawSprite.sprite.getAnimateBox(), viewX, viewY);
                }
            }
        }
    }

    private void createYOrder(int viewX, int viewY) {
        int i;
        int distance;
        short dy;
        short dx;
        int yOrderPoint = 0;
        int autoSelectOrderPoint = 0;
        int forceSelectOrderPoint = 0;
        int count = 0;
        int playerX = GameWorld.player.sprite.getX();
        int playerY = GameWorld.player.sprite.getY();
        int viewWidth = GameMain.viewWidth;
        int viewHeight = GameMain.viewHeight;
        this.yOrder[yOrderPoint++] = 1;
        this.yOrder[yOrderPoint++] = 0;
        this.yOrder[yOrderPoint++] = (short)GameWorld.player.sprite.getY();
        this.yOrder[yOrderPoint++] = (short)GameWorld.player.sprite.getX();
        for (int i2 = 0; i2 < GameWorld.gameExits.size(); ++i2) {
            GameExit gameExit = (GameExit)GameWorld.gameExits.elementAt(i2);
            int[] box = gameExit.sprite.getAnimateBox();
            if (!Tool.rectIntersect(box[0], box[1], box[2], box[3], viewX, viewY, viewWidth, viewHeight)) continue;
            ++count;
            this.yOrder[yOrderPoint++] = 9;
            this.yOrder[yOrderPoint++] = (short)i2;
            this.yOrder[yOrderPoint++] = (short)gameExit.sprite.getY();
            this.yOrder[yOrderPoint++] = (short)gameExit.sprite.getX();
            dx = this.yOrder[yOrderPoint - 1];
            dy = this.yOrder[yOrderPoint - 2];
            distance = Tool.distance(dx, dy, playerX, playerY);
            if (distance > GameMain.forceSelectDistance) continue;
            this.autoSelectOrder[autoSelectOrderPoint++] = 9;
            this.autoSelectOrder[autoSelectOrderPoint++] = (short)i2;
            this.autoSelectOrder[autoSelectOrderPoint++] = (short)Tool.distance(dx, dy, playerX, playerY);
            this.autoSelectOrder[autoSelectOrderPoint++] = 0;
            this.forceSelectOrder[forceSelectOrderPoint++] = 9;
            this.forceSelectOrder[forceSelectOrderPoint++] = (short)i2;
            this.forceSelectOrder[forceSelectOrderPoint++] = (short)Tool.distance(dx, dy, playerX, playerY);
            this.forceSelectOrder[forceSelectOrderPoint++] = 0;
        }
        short[][] npcData = null;
        int drawNpcType = 3;
        int drawNpcOffset = 0;
        for (int j = 0; j < 3; ++j) {
            switch (j) {
                case 0: {
                    npcData = this.map.groundNPCs;
                    drawNpcType = 2;
                    drawNpcOffset = -this.map.height * 2;
                    break;
                }
                case 1: {
                    npcData = this.map.roleNPCs;
                    drawNpcType = 3;
                    drawNpcOffset = 0;
                    break;
                }
                case 2: {
                    npcData = this.map.skyNPCs;
                    drawNpcType = 4;
                    drawNpcOffset = this.map.height;
                }
            }
            int[] npcBox = new int[4];
            for (i = 0; i < npcData[0].length; ++i) {
                short animateId = npcData[0][i];
                npcBox = mapNpcAnimateSet.getAnimateBox(npcBox, animateId);
                npcBox[0] = npcBox[0] + npcData[1][i];
                npcBox[1] = npcBox[1] + npcData[2][i];
                if (!Tool.rectIntersect(npcBox[0], npcBox[1], npcBox[2], npcBox[3], viewX, viewY, viewWidth, viewHeight)) continue;
                ++count;
                this.yOrder[yOrderPoint++] = drawNpcType;
                this.yOrder[yOrderPoint++] = (short)i;
                this.yOrder[yOrderPoint++] = (short)(npcData[2][i] + drawNpcOffset);
                this.yOrder[yOrderPoint++] = npcData[1][i];
            }
        }
        int netplayerCount = 0;
        int[] collisionBox = new int[4];
        block11: for (i = 0; i < GameWorld.gameSprites.size(); ++i) {
            GameSprite gameSprite = (GameSprite)GameWorld.gameSprites.elementAt(i);
            byte spriteType = gameSprite.getType();
            switch (spriteType) {
                case 1: 
                case 3: 
                case 5: 
                case 6: {
                    collisionBox = gameSprite.sprite.getCollisionBox(collisionBox, false);
                    if (!Tool.rectIntersect(collisionBox[0], collisionBox[1], collisionBox[2], collisionBox[3], viewX, viewY, viewWidth, viewHeight) || gameSprite.sprite.getMapId() != this.map.id || gameSprite.sprite.getMapInstanceId() != GameWorld.player.sprite.getMapInstanceId()) continue block11;
                    if (spriteType == 1) {
                        if (netplayerCount >= GameMain.netplayerShowMaxCount) {
                            ((GameNetPlayer)gameSprite).beSkiped = true;
                            continue block11;
                        }
                        ((GameNetPlayer)gameSprite).beSkiped = false;
                        ++netplayerCount;
                        this.yOrder[yOrderPoint++] = 6;
                    } else {
                        this.yOrder[yOrderPoint++] = spriteType == 6 ? 11 : 5;
                    }
                    ++count;
                    this.yOrder[yOrderPoint++] = (short)i;
                    this.yOrder[yOrderPoint++] = (short)gameSprite.sprite.getY();
                    this.yOrder[yOrderPoint++] = (short)gameSprite.sprite.getX();
                    dx = this.yOrder[yOrderPoint - 1];
                    dy = this.yOrder[yOrderPoint - 2];
                    distance = Tool.distance(dx, dy, playerX, playerY);
                    if (distance > GameMain.forceSelectDistance) continue block11;
                    if (spriteType == 1) {
                        this.autoSelectOrder[autoSelectOrderPoint++] = 6;
                        this.forceSelectOrder[forceSelectOrderPoint++] = 6;
                    } else if (spriteType == 6) {
                        this.autoSelectOrder[autoSelectOrderPoint++] = 11;
                        this.forceSelectOrder[forceSelectOrderPoint++] = 11;
                    } else {
                        this.autoSelectOrder[autoSelectOrderPoint++] = 5;
                        this.forceSelectOrder[forceSelectOrderPoint++] = 5;
                    }
                    this.autoSelectOrder[autoSelectOrderPoint++] = (short)i;
                    this.forceSelectOrder[forceSelectOrderPoint++] = (short)i;
                    int dist = Tool.distance(dx, dy, playerX, playerY);
                    if (spriteType == 3 || spriteType == 5) {
                        if (gameSprite.canAttack) {
                            this.autoSelectOrder[autoSelectOrderPoint++] = (short)(dist - GameRole.enemyNpcAutoDist);
                            this.forceSelectOrder[forceSelectOrderPoint++] = (short)(dist - GameRole.enemyNpcForceDist);
                        } else {
                            this.autoSelectOrder[autoSelectOrderPoint++] = (short)(dist - GameRole.allyNpcAutoDist);
                            this.forceSelectOrder[forceSelectOrderPoint++] = (short)(dist - GameRole.allyNpcForceDist);
                        }
                    } else if (gameSprite.canAttack) {
                        this.autoSelectOrder[autoSelectOrderPoint++] = (short)(dist - GameRole.enemyPlayerAutoDist);
                        this.forceSelectOrder[forceSelectOrderPoint++] = (short)(dist - GameRole.enemyPlayerForceDist);
                    } else if (GameWorld.teamInfo.get(new Integer(gameSprite.getInstanceId())) == null) {
                        this.autoSelectOrder[autoSelectOrderPoint++] = (short)(dist - GameRole.allyPlayerAutoDist);
                        this.forceSelectOrder[forceSelectOrderPoint++] = (short)(dist - GameRole.allyPlayerForceDist);
                    } else {
                        this.autoSelectOrder[autoSelectOrderPoint++] = (short)(dist - GameRole.teamerAutoDist);
                        this.forceSelectOrder[forceSelectOrderPoint++] = (short)(dist - GameRole.teamerForceDist);
                    }
                    this.autoSelectOrder[autoSelectOrderPoint++] = 0;
                    this.forceSelectOrder[forceSelectOrderPoint++] = 0;
                }
            }
        }
        for (i = 0; i < GameWorld.leavingSprites.size(); ++i) {
            GameSprite gameSprite = (GameSprite)GameWorld.leavingSprites.elementAt(i);
            if (!Tool.rectIntersect((collisionBox = gameSprite.sprite.getCollisionBox(collisionBox, false))[0], collisionBox[1], collisionBox[2], collisionBox[3], viewX, viewY, viewWidth, viewHeight)) continue;
            this.yOrder[yOrderPoint++] = 10;
            this.yOrder[yOrderPoint++] = (short)i;
            this.yOrder[yOrderPoint++] = (short)gameSprite.sprite.getY();
            this.yOrder[yOrderPoint++] = (short)gameSprite.sprite.getX();
        }
        if (count == -1) {
            this.yOrderCount = 0;
            this.autoSelectOrderCount = 0;
        } else {
            this.yOrderCount = yOrderPoint;
            this.sort(this.yOrder, this.yOrderCount >> 2);
            this.autoSelectOrderCount = autoSelectOrderPoint;
            this.sort(this.autoSelectOrder, this.autoSelectOrderCount >> 2);
            this.forceSelectOrderCount = forceSelectOrderPoint;
            this.sort(this.forceSelectOrder, this.forceSelectOrderCount >> 2);
        }
    }

    private void sort(short[] items, int itemsCount) {
        int t;
        short[] temp = new short[4];
        int n = itemsCount;
        for (t = 7; t < 17 && sortTable[t] <= n / 9; ++t) {
        }
        while (t >= 0) {
            int h;
            for (int i = h = sortTable[t]; i < n; ++i) {
                int j;
                int id = i << 2;
                System.arraycopy(items, id, temp, 0, 4);
                for (j = i - h; j >= 0 && (items[(j << 2) + 2] - temp[2] == 0 ? items[(j << 2) + 3] - temp[3] : items[(j << 2) + 2] - temp[2]) > 0; j -= h) {
                    int id1 = j + h << 2;
                    int id2 = j << 2;
                    System.arraycopy(items, id2, items, id1, 4);
                }
                id = j + h << 2;
                System.arraycopy(temp, 0, items, id, 4);
            }
            --t;
        }
    }

    private void drawMapNpc(Graphics g, int viewX, int viewY, short[][] npcData, int idx, boolean changeFrame) {
        short animateId = npcData[0][idx];
        int x = npcData[1][idx] - viewX;
        int y = npcData[2][idx] - viewY;
        int frame = npcData[3][idx];
        mapNpcAnimateSet.drawAnimateFrame(g, animateId, frame, x, y);
        if (changeFrame) {
            if ((GameMain.tick & 1) == 0) {
                ++frame;
            }
            if (frame >= mapNpcAnimateSet.getAnimateLength(animateId)) {
                frame = 0;
            }
            npcData[3][idx] = (short)frame;
        }
    }

    public void releaseMapDataBuffer() {
        if (!this.mapDataBufferReleased) {
            this.mapDataBufferReleased = true;
            this.mapDataBuffer = null;
            this.miniMapData = null;
            this.miniMapProcData = null;
            System.gc();
        }
    }

    public void rebuildMapDataBuffer() {
        if (this.mapDataBufferReleased) {
            System.gc();
            switch (this.map.backgroundType) {
                case 1: {
                    this.makeMapDataBuffer();
                }
            }
            this.rebuildMiniMap();
            this.mapDataBufferReleased = false;
            this.isFirstBgImage = true;
        }
    }

    private void makeMapDataBuffer() {
        this.mapDataBuffer = this.map.createBlurMapBuffer(this.landformImages);
    }

    private void rebuildViewData() {
        try {
            switch (this.map.backgroundType) {
                case 0: {
                    this.tileWidth = this.map.owner.tileWidth;
                    this.tileHeight = this.map.owner.tileHeight;
                    this.tileImage = this.map.owner.loadTileImage();
                    this.tinfo = this.map.owner.getTileInfo();
                    break;
                }
                case 1: {
                    this.tileWidth = this.map.owner.blurTileWidth;
                    this.tileHeight = this.map.owner.blurTileHeight;
                    this.landformImages = this.map.owner.loadAllLandformImage();
                    this.landformTileInfos = this.map.owner.loadAllLandformTileInfof();
                    this.makeMapDataBuffer();
                }
            }
            this.mapDataBufferReleased = false;
            if (mapNpcAnimateNeedLoad) {
                mapNpcAnimateSet = null;
                System.gc();
                mapNpcAnimateSet = this.map.owner.loadNPCAnimates();
                mapNpcAnimateNeedLoad = false;
            }
            this.mapNpcCollision = this.map.owner.loadNPCCollision();
            this.tileXCount = this.map.mapData[0].length;
            this.tileYCount = this.map.mapData.length;
            this.rebuildMiniMap();
            this.yOrderCount = 4 * (this.map.exitIDs.length + this.map.groundNPCs[0].length + this.map.roleNPCs[0].length + this.map.skyNPCs[0].length + 100);
            this.yOrder = new short[this.yOrderCount];
            this.autoSelectOrderCount = 4 * (this.map.exitIDs.length + 100);
            this.autoSelectOrder = new short[this.autoSelectOrderCount];
            this.forceSelectOrderCount = this.autoSelectOrderCount;
            this.forceSelectOrder = new short[this.forceSelectOrderCount];
            GameWorld.gameExits.removeAllElements();
            for (int i = 0; i < this.map.exitIDs.length; ++i) {
                GameExit gameExit = GameExit.createGameExit(this.map.exitTargetMapNames[i], this.map.exitX[i], this.map.exitY[i], i);
                GameWorld.gameExits.addElement(gameExit);
            }
            this.pathTileWidth = this.tileWidth >> 1;
            this.pathTileHeight = this.tileHeight >> 1;
            this.pathTileXCount = this.tileXCount << 1;
            this.pathTileYCount = this.tileYCount << 1;
            this.rebuildMapCollisionData();
            this.rebuildImageBuffer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rebuildImageBuffer() {
        if (this.useImageBuffer) {
            this.bgCellW = GameMain.viewWidth / this.tileWidth + 1;
            this.bgCellH = GameMain.viewHeight / this.tileHeight + 1;
            if (GameMain.viewWidth % this.tileWidth != 0) {
                ++this.bgCellW;
            }
            if (GameMain.viewHeight % this.tileHeight != 0) {
                ++this.bgCellH;
            }
            this.bgWidth = this.bgCellW * this.tileWidth;
            this.bgHeight = this.bgCellH * this.tileHeight;
            this.bgImg = null;
            this.bgImg = Image.createImage((int)this.bgWidth, (int)this.bgHeight);
            this.gg = this.bgImg.getGraphics();
            this.isFirstBgImage = true;
        }
    }

    private void rebuildMapCollisionData() {
        this.mapCollisonData = new byte[this.pathTileYCount][(this.pathTileXCount >> 3) + 1];
        for (int i = 0; i < this.tileYCount; ++i) {
            int[] lineBuffer = null;
            if (this.map.backgroundType == 1) {
                lineBuffer = this.mapDataBuffer[i];
            }
            for (int j = 0; j < this.tileXCount; ++j) {
                int cx = j << 1;
                int cy = i << 1;
                boolean flag = false;
                if (this.map.backgroundType == 1) {
                    int fid;
                    int lfid;
                    int cc = lineBuffer[j];
                    if ((cc & 0x7FF) != 0) {
                        lfid = cc >> 7 & 0xF;
                        fid = (cc & 0x1F) - 1;
                    } else if ((cc & 0x3FF800) != 0) {
                        lfid = cc >> 18 & 0xF;
                        fid = (cc >> 11 & 0x1F) - 1;
                    } else {
                        lfid = cc >> 29 & 7;
                        fid = (cc >> 22 & 0x1F) - 1;
                    }
                    flag = (this.landformTileInfos[lfid][fid] & 1) == 1;
                } else {
                    boolean bl = flag = (this.tinfo[1][this.map.mapData[i][j] & 0xFF] & 1) == 1;
                }
                if (!flag) continue;
                int dd = 2;
                for (int dy = 0; dy < dd; ++dy) {
                    for (int dx = 0; dx < dd; ++dx) {
                        int testx = cx + dx;
                        int ptx = testx & 7;
                        int testy = cy + dy;
                        byte[] byArray = this.mapCollisonData[testy];
                        int n = testx >>= 3;
                        byArray[n] = (byte)(byArray[n] & ~(1 << ptx));
                        byte[] byArray2 = this.mapCollisonData[testy];
                        int n2 = testx;
                        byArray2[n2] = (byte)(byArray2[n2] | 1 << ptx);
                    }
                }
            }
        }
        int[] box = new int[4];
        for (int k = 0; k < 2; ++k) {
            short[][] npcData = null;
            npcData = k == 0 ? this.map.groundNPCs : this.map.roleNPCs;
            for (int i = 0; i < npcData[0].length; ++i) {
                short animateId = npcData[0][i];
                int count = this.mapNpcCollision[animateId].length >> 1;
                int maxX = this.pathTileXCount - 1;
                int maxY = this.pathTileYCount - 1;
                for (int j = 0; j < count; ++j) {
                    box[0] = (short)(this.mapNpcCollision[animateId][j << 1] >> 16) + npcData[1][i];
                    box[1] = (short)(this.mapNpcCollision[animateId][j << 1] & 0xFFFF) + npcData[2][i];
                    box[2] = this.mapNpcCollision[animateId][(j << 1) + 1] >> 16;
                    box[3] = this.mapNpcCollision[animateId][(j << 1) + 1] & 0xFFFF;
                    int startX = box[0] / this.pathTileWidth;
                    int startY = box[1] / this.pathTileHeight;
                    int endX = (box[0] + box[2]) / this.pathTileWidth;
                    int endY = (box[1] + box[3]) / this.pathTileHeight;
                    startX = Math.max(0, startX);
                    startY = Math.max(0, startY);
                    endX = Math.max(0, endX);
                    endY = Math.max(0, endY);
                    startX = Math.min(maxX, startX);
                    startY = Math.min(maxY, startY);
                    endX = Math.min(maxX, endX);
                    endY = Math.min(maxY, endY);
                    for (int cy = startY; cy <= endY; ++cy) {
                        for (int cx = startX; cx <= endX; ++cx) {
                            int testy = cy;
                            int testx = cx >> 3;
                            int ptx = cx & 7;
                            if ((this.mapCollisonData[testy][testx] >> ptx & 1) == 1) continue;
                            byte[] byArray = this.mapCollisonData[testy];
                            int n = testx;
                            byArray[n] = (byte)(byArray[n] & ~(1 << ptx));
                            byte[] byArray3 = this.mapCollisonData[testy];
                            int n3 = testx;
                            byArray3[n3] = (byte)(byArray3[n3] | 1 << ptx);
                        }
                    }
                }
            }
        }
    }

    private int getProperScale() {
        int maxLength;
        int scale = miniMapConfig[7];
        int n = maxLength = this.map.width > this.map.height ? this.map.width : this.map.height;
        if (maxLength >= miniMapConfig[6] >> 16 && maxLength < (miniMapConfig[6] & 0xFFFF)) {
            scale = miniMapConfig[7];
        }
        if (maxLength >= miniMapConfig[8] >> 16 && maxLength < (miniMapConfig[8] & 0xFFFF)) {
            scale = miniMapConfig[9];
        }
        if (maxLength >= miniMapConfig[10] >> 16 && maxLength < (miniMapConfig[10] & 0xFFFF)) {
            scale = miniMapConfig[11];
        }
        return scale;
    }

    public int[] getMiniMapSize() {
        int[] size = new int[]{this.miniMapWidth, this.miniMapHeight};
        return size;
    }

    public void rebuildMiniMap() {
        int scale = this.getProperScale();
        int alpha = miniMapConfig[0];
        this.miniMapWidth = this.tileXCount * scale / 100;
        this.miniMapHeight = this.tileYCount * scale / 100;
        this.miniMapProcData = new int[2];
        if (alpha != 0) {
            this.miniMapData = new int[this.miniMapWidth * this.miniMapHeight];
            miniMapImage = null;
            for (int i = 0; i < this.miniMapHeight; ++i) {
                int tileY = Math.min(i * 100 / scale, this.tileYCount - 1);
                Object sbuffer = null;
                Object bbuffer = null;
                int[] lineBuffer = null;
                if (this.map.backgroundType == 1 && this.mapDataBuffer[tileY] instanceof int[]) {
                    lineBuffer = this.mapDataBuffer[tileY];
                }
                for (int j = 0; j < this.miniMapWidth; ++j) {
                    byte tileInfo = 0;
                    int tileX = Math.min(j * 100 / scale, this.tileXCount - 1);
                    if (this.map.backgroundType == 1) {
                        int fid;
                        int lfid;
                        int cc = lineBuffer[tileX];
                        if ((cc & 0x7FF) != 0) {
                            lfid = cc >> 7 & 0xF;
                            fid = (cc & 0x1F) - 1;
                        } else if ((cc & 0x3FF800) != 0) {
                            lfid = cc >> 18 & 0xF;
                            fid = (cc >> 11 & 0x1F) - 1;
                        } else {
                            lfid = cc >> 29 & 7;
                            fid = (cc >> 22 & 0x1F) - 1;
                        }
                        tileInfo = this.landformTileInfos[lfid][fid];
                    } else {
                        tileInfo = this.tinfo[1][this.map.mapData[tileY][tileX] & 0xFF];
                    }
                    this.miniMapData[i * this.miniMapWidth + j] = alpha | thumbColors[tileInfo >> 1 & 0x1F];
                }
            }
        }
        this.miniMapWidth += 4;
        this.miniMapHeight += 4;
        this.miniMapProcData = new int[4];
    }

    private void drawMap(Graphics g, int viewX, int viewY) {
        if (this.useImageBuffer && this.bgImg != null) {
            int startX = viewX / this.tileWidth;
            int endX = startX + this.bgCellW - 1;
            int startY = viewY / this.tileHeight;
            int endY = startY + this.bgCellH - 1;
            if (this.isFirstBgImage) {
                this.isFirstBgImage = false;
                this.gg.setColor(0);
                this.gg.fillRect(0, 0, this.bgWidth, this.bgHeight);
                this.drawCellMap(startX, startY, endX, endY);
                this.oldStartX = startX;
                this.oldEndX = endX;
                this.oldStartY = startY;
                this.oldEndY = endY;
            }
            if (this.oldStartX != startX) {
                int ex;
                int sx;
                if (startX < this.oldStartX) {
                    sx = startX;
                    ex = this.oldStartX - 1;
                    if (ex > endX) {
                        ex = endX;
                    }
                } else {
                    sx = this.oldEndX + 1;
                    ex = endX;
                    if (sx < startX) {
                        sx = startX;
                    }
                }
                this.drawCellMap(sx, this.oldStartY, ex, this.oldEndY);
                this.oldStartX = startX;
                this.oldEndX = endX;
            }
            if (this.oldStartY != startY) {
                int ey;
                int sy;
                if (startY < this.oldStartY) {
                    sy = startY;
                    ey = this.oldStartY - 1;
                    if (ey > endY) {
                        ey = endY;
                    }
                } else {
                    sy = this.oldEndY + 1;
                    ey = endY;
                    if (sy < startY) {
                        sy = startY;
                    }
                }
                this.drawCellMap(this.oldStartX, sy, this.oldEndX, ey);
                this.oldStartY = startY;
                this.oldEndY = endY;
            }
            int sMapX = viewX % this.bgWidth;
            int eMapX = (viewX + GameMain.viewWidth) % this.bgWidth;
            int sMapY = viewY % this.bgHeight;
            int eMapY = (viewY + GameMain.viewHeight) % this.bgHeight;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipW = g.getClipWidth();
            int clipH = g.getClipHeight();
            if (eMapX > sMapX) {
                if (eMapY > sMapY) {
                    g.drawImage(this.bgImg, -sMapX + this.vx, -sMapY + this.vy, 0);
                } else {
                    g.clipRect(this.vx, this.vy, GameMain.viewWidth, this.bgHeight - sMapY);
                    g.drawImage(this.bgImg, -sMapX + this.vx, -sMapY + this.vy, 0);
                    g.setClip(clipX, clipY, clipW, clipH);
                    g.clipRect(this.vx, this.bgHeight - sMapY + this.vy, GameMain.viewWidth, eMapY);
                    g.drawImage(this.bgImg, -sMapX + this.vx, this.bgHeight - sMapY + this.vy, 0);
                }
            } else if (eMapY > sMapY) {
                g.clipRect(this.vx, this.vy, this.bgWidth - sMapX, GameMain.viewHeight);
                g.drawImage(this.bgImg, -sMapX + this.vx, -sMapY + this.vy, 0);
                g.setClip(clipX, clipY, clipW, clipH);
                g.clipRect(this.bgWidth - sMapX + this.vx, this.vy, eMapX, GameMain.viewHeight);
                g.drawImage(this.bgImg, this.bgWidth - sMapX + this.vx, -sMapY + this.vy, 0);
            } else {
                g.clipRect(this.vx, this.vy, this.bgWidth - sMapX, this.bgHeight - sMapY);
                g.drawImage(this.bgImg, -sMapX + this.vx, -sMapY + this.vy, 0);
                g.setClip(clipX, clipY, clipW, clipH);
                g.clipRect(this.bgWidth - sMapX + this.vx, this.vy, eMapX, this.bgHeight - sMapY);
                g.drawImage(this.bgImg, this.bgWidth - sMapX + this.vx, -sMapY + this.vy, 0);
                g.setClip(clipX, clipY, clipW, clipH);
                g.clipRect(this.vx, this.bgHeight - sMapY + this.vy, this.bgWidth - sMapX, eMapY);
                g.drawImage(this.bgImg, -sMapX + this.vx, this.bgHeight - sMapY + this.vy, 0);
                g.setClip(clipX, clipY, clipW, clipH);
                g.clipRect(this.bgWidth - sMapX + this.vx, this.bgHeight - sMapY + this.vy, eMapX, eMapY);
                g.drawImage(this.bgImg, this.bgWidth - sMapX + this.vx, this.bgHeight - sMapY + this.vy, 0);
            }
            if (GameMain.viewWidth > this.map.width || GameMain.viewHeight > this.map.height) {
                g.setClip(0, 0, GameMain.viewWidth, GameMain.viewHeight);
                this.drawEdgeMapNpc(g, viewX, viewY);
            }
            g.setClip(clipX, clipY, clipW, clipH);
        } else {
            this.drawMapNoBuffer(g, viewX, viewY);
        }
    }

    private void buildEdgeNpcs(short[][] npcData, Vector edgeNpcs, int viewX, int viewY) {
        edgeNpcs.removeAllElements();
        int mapBoxX = 0;
        int mapBoxY = 0;
        int mapBoxWidth = this.map.width;
        int mapBoxHeight = this.map.height;
        int offsetX = -viewX;
        int offsetY = -viewY;
        int[] box = new int[4];
        for (int i = 0; i < npcData[0].length; ++i) {
            int animateId = npcData[0][i];
            box = mapNpcAnimateSet.getAnimateBox(box, animateId);
            box[0] = box[0] + npcData[1][i];
            box[1] = box[1] + npcData[2][i];
            if (box[0] > mapBoxX && box[0] + box[2] < mapBoxX + mapBoxWidth && box[1] > mapBoxY && box[1] + box[3] < mapBoxY + mapBoxHeight) continue;
            edgeNpcs.addElement(new int[]{animateId, 0, npcData[1][i] + offsetX + mapBoxX, npcData[2][i] + offsetY + mapBoxY});
        }
    }

    private void drawEdgeMapNpc(Graphics g, int viewX, int viewY) {
        int[] npcData;
        int i;
        if (needBuildEdgeMapNpc) {
            needBuildEdgeMapNpc = false;
            this.buildEdgeNpcs(this.map.groundNPCs, edgeNpcsOfGround, viewX, viewY);
            this.buildEdgeNpcs(this.map.roleNPCs, edgeNpcsOfRole, viewX, viewY);
            this.buildEdgeNpcs(this.map.skyNPCs, edgeNpcsOfSky, viewX, viewY);
        } else if (this.oldViewX != viewX || this.oldViewY != viewY) {
            this.oldViewX = viewX;
            this.oldViewY = viewY;
            this.buildEdgeNpcs(this.map.groundNPCs, edgeNpcsOfGround, viewX, viewY);
            this.buildEdgeNpcs(this.map.roleNPCs, edgeNpcsOfRole, viewX, viewY);
            this.buildEdgeNpcs(this.map.skyNPCs, edgeNpcsOfSky, viewX, viewY);
        }
        for (i = 0; i < edgeNpcsOfGround.size(); ++i) {
            npcData = (int[])edgeNpcsOfGround.elementAt(i);
            mapNpcAnimateSet.drawAnimateFrame(g, npcData[0], npcData[1], npcData[2], npcData[3]);
        }
        for (i = 0; i < edgeNpcsOfRole.size(); ++i) {
            npcData = (int[])edgeNpcsOfRole.elementAt(i);
            mapNpcAnimateSet.drawAnimateFrame(g, npcData[0], npcData[1], npcData[2], npcData[3]);
        }
        for (i = 0; i < edgeNpcsOfSky.size(); ++i) {
            npcData = (int[])edgeNpcsOfSky.elementAt(i);
            mapNpcAnimateSet.drawAnimateFrame(g, npcData[0], npcData[1], npcData[2], npcData[3]);
        }
    }

    private void mergeMapNpcDrawBox(Vector drawData, int x, int y, int tileX, int tileY) {
        int count = drawData.size();
        boolean includeFound = false;
        for (int i = 0; i < count; ++i) {
            int[] data = (int[])drawData.elementAt(i);
            if (!Tool.rectIntersect(data[0], data[1], data[2], data[3], x, y, this.tileWidth, this.tileHeight)) continue;
            includeFound = true;
            break;
        }
        if (includeFound) {
            return;
        }
        boolean mergeFound = false;
        for (int i = 0; i < count; ++i) {
            int[] data = (int[])drawData.elementAt(i);
            if (data[0] + data[2] == x && data[1] <= y) {
                data[2] = data[2] + this.tileWidth;
                data[6] = data[6] + this.tileWidth;
                mergeFound = true;
            } else if (data[1] + data[3] == y && data[0] <= x) {
                data[3] = data[3] + this.tileHeight;
                data[7] = data[7] + this.tileHeight;
                mergeFound = true;
            }
            if (mergeFound) break;
        }
        if (!mergeFound) {
            drawData.addElement(new int[]{x, y, this.tileWidth, this.tileHeight, tileX * this.tileWidth, tileY * this.tileHeight, this.tileWidth, this.tileHeight});
        }
    }

    private void drawCellMap(int startX, int startY, int endX, int endY) {
        int sx = 0;
        int sy = 0;
        Vector mapNpcDrawData = new Vector();
        for (int j = startY; j <= endY; ++j) {
            Object[] lineData;
            if (j < 0 || j >= this.tileYCount) continue;
            if (this.map.backgroundType == 0) {
                lineData = this.map.mapData[j];
            } else {
                if (this.mapDataBufferReleased) continue;
                lineData = this.mapDataBuffer[j];
            }
            sy = j % this.bgCellH * this.tileHeight;
            for (int i = startX; i <= endX; ++i) {
                if (i < 0 || i >= this.tileXCount) continue;
                sx = i % this.bgCellW * this.tileWidth;
                this.drawMapTile(this.gg, sx, sy, i, j, lineData);
                this.mergeMapNpcDrawBox(mapNpcDrawData, sx, sy, i, j);
            }
        }
        int[] box = new int[4];
        for (int i = 0; i < mapNpcDrawData.size(); ++i) {
            int[] data = (int[])mapNpcDrawData.elementAt(i);
            this.drawStillMapNpc(this.gg, this.map.groundNPCs, data[4], data[5], data[6], data[7], data[0] - data[4], data[1] - data[5], box);
            this.drawStillMapNpc(this.gg, this.map.roleNPCs, data[4], data[5], data[6], data[7], data[0] - data[4], data[1] - data[5], box);
            this.drawStillMapNpc(this.gg, this.map.skyNPCs, data[4], data[5], data[6], data[7], data[0] - data[4], data[1] - data[5], box);
        }
    }

    private void drawStillMapNpc(Graphics g, short[][] npcData, int mapBoxX, int mapBoxY, int mapBoxWidth, int mapBoxHeight, int offsetX, int offsetY, int[] box) {
        g.setClip(mapBoxX + offsetX, mapBoxY + offsetY, mapBoxWidth, mapBoxHeight);
        for (int i = 0; i < npcData[0].length; ++i) {
            short animateId = npcData[0][i];
            if (mapNpcAnimateSet.getAnimateLength(animateId) > 1 && showMapNpcAnimate) continue;
            box = mapNpcAnimateSet.getAnimateBox(box, animateId);
            box[0] = box[0] + npcData[1][i];
            box[1] = box[1] + npcData[2][i];
            if (!Tool.rectIntersect(box[0], box[1], box[2], box[3], mapBoxX, mapBoxY, mapBoxWidth, mapBoxHeight)) continue;
            mapNpcAnimateSet.drawAnimateFrame(g, animateId, 0, npcData[1][i] + offsetX, npcData[2][i] + offsetY);
        }
        if (this.useImageBuffer) {
            g.setClip(0, 0, this.bgWidth, this.bgHeight);
        } else {
            g.setClip(0, 0, GameMain.viewWidth, GameMain.viewHeight);
        }
    }

    private void drawMapTile(Graphics g, int x, int y, int tileX, int tileY, Object lineData) {
        switch (this.map.backgroundType) {
            case 0: {
                byte[] ld = (byte[])lineData;
                int tile = this.tinfo[0][ld[tileX] & 0xFF] & 0xFF;
                int trans = this.tinfo[1][ld[tileX] & 0xFF] >> 6 & 3;
                this.tileImage.drawFrame(g, tile, x, y, trans);
                break;
            }
            case 1: {
                if (this.mapDataBufferReleased) {
                    return;
                }
                int cc = ((int[])lineData)[tileX];
                if ((cc & 0xFFC00000) == 0) break;
                int lfid = cc >> 29 & 7;
                int trans = cc >> 27 & 3;
                int fid = (cc >> 22 & 0x1F) - 1;
                this.landformImages[lfid].drawFrame(g, fid, x, y, trans);
                if ((cc & 0x3FF800) == 0) break;
                lfid = cc >> 18 & 0xF;
                trans = cc >> 16 & 3;
                fid = (cc >> 11 & 0x1F) - 1;
                this.landformImages[lfid].drawFrame(g, fid, x, y, trans);
                if ((cc & 0x7FF) == 0) break;
                lfid = cc >> 7 & 0xF;
                trans = cc >> 5 & 3;
                fid = (cc & 0x1F) - 1;
                this.landformImages[lfid].drawFrame(g, fid, x, y, trans);
            }
        }
    }

    private void drawMapNoBuffer(Graphics g, int viewX, int viewY) {
        int startX = this.getTileX(viewX);
        int startY = this.getTileY(viewY);
        if (startX < 0) {
            startX = 0;
        }
        if (startY < 0) {
            startY = 0;
        }
        int endX = Math.min(this.tileXCount, this.getTileX(viewX + GameMain.viewWidth) + 1);
        int endY = Math.min(this.tileYCount, this.getTileY(viewY + GameMain.viewHeight) + 1);
        for (int i = startY; i < endY; ++i) {
            Object[] lineData;
            if (i < 0 || i >= this.tileYCount) continue;
            if (this.map.backgroundType == 0) {
                lineData = this.map.mapData[i];
            } else {
                if (this.mapDataBufferReleased) continue;
                lineData = this.mapDataBuffer[i];
            }
            for (int j = startX; j < endX; ++j) {
                if (j < 0 || j >= this.tileXCount) continue;
                int x = j * this.tileWidth - viewX;
                int y = i * this.tileHeight - viewY;
                this.drawMapTile(g, x, y, j, i, lineData);
            }
        }
    }

    private int getTileX(int x) {
        return x / this.tileWidth;
    }

    private int getTileY(int y) {
        return y / this.tileHeight;
    }

    public short[][] searchPath_AStar(int startX, int startY, int endX, int endY, int spriteType) {
        byte step;
        int checkY;
        int checkX;
        byte[] p;
        int i;
        if (startX < 0 || startX >= this.pathTileXCount || startY < 0 || startY >= this.pathTileYCount || endX < 0 || endX >= this.pathTileXCount || endY < 0 || endY >= this.pathTileYCount) {
            return null;
        }
        if (startX == endX && startY == endY) {
            return null;
        }
        if ((this.mapCollisonData[endY][endX >> 3] >> (endX & 7) & 1) != 0) {
            return null;
        }
        short[][] pathLen = new short[this.pathTileYCount][this.pathTileXCount];
        int maxEdge = this.pathTileYCount + this.pathTileXCount << 4;
        short[] openNodes = new short[maxEdge];
        int openNodeStart = 0;
        int openNodeEnd = 1;
        pathLen[startY][startX] = 1;
        openNodes[0] = (short)(startX << 8 | startY);
        boolean found = false;
        while (openNodeStart != openNodeEnd) {
            int thisX = openNodes[openNodeStart] >> 8 & 0xFF;
            int thisY = openNodes[openNodeStart] & 0xFF;
            short thisLen = pathLen[thisY][thisX];
            if (++openNodeStart >= maxEdge) {
                openNodeStart = 0;
            }
            if (thisX == endX && thisY == endY) {
                found = true;
                break;
            }
            for (i = 0; i < 8; ++i) {
                short t;
                p = PATH_FIND[i];
                checkX = thisX + p[0];
                checkY = thisY + p[1];
                step = p[2];
                if (checkX < 0 || checkX >= this.pathTileXCount || checkY < 0 || checkY >= this.pathTileYCount || (t = pathLen[checkY][checkX]) != 0 && t <= thisLen + step) continue;
                if (t == 0 && (this.mapCollisonData[checkY][checkX >> 3] >> (checkX & 7) & 1) != 0) {
                    pathLen[checkY][checkX] = -1;
                    continue;
                }
                pathLen[checkY][checkX] = (short)(thisLen + step);
                if ((checkY - thisY) * (endY - thisY) >= 0 && (checkX - thisX) * (endX - thisX) >= 0) {
                    if (--openNodeStart < 0) {
                        openNodeStart = maxEdge - 1;
                    }
                    openNodes[openNodeStart] = (short)(checkX << 8 | checkY);
                    continue;
                }
                openNodes[openNodeEnd] = (short)(checkX << 8 | checkY);
                if (++openNodeEnd < maxEdge) continue;
                openNodeEnd = 0;
            }
        }
        if (found) {
            int stepLen = pathLen[endY][endX];
            short[][] ret = new short[stepLen][2];
            int retp = stepLen - 1;
            block2: while (endX != startX || endY != startY) {
                ret[retp][0] = (short)endX;
                ret[retp][1] = (short)endY;
                --retp;
                for (i = 0; i < 8; ++i) {
                    p = PATH_FIND[i];
                    checkX = endX + p[0];
                    checkY = endY + p[1];
                    step = p[2];
                    if (checkX < 0 || checkX >= this.pathTileXCount || checkY < 0 || checkY >= this.pathTileYCount || pathLen[checkY][checkX] != stepLen - step) continue;
                    endX = checkX;
                    endY = checkY;
                    stepLen -= step;
                    continue block2;
                }
            }
            short[][] ret2 = new short[ret.length - retp - 1][2];
            System.arraycopy(ret, retp + 1, ret2, 0, ret2.length);
            return this.optimizePath(ret2, spriteType);
        }
        return null;
    }

    private short[][] optimizePath(short[][] path, int spriteType) {
        int i;
        if (path == null) {
            return null;
        }
        Vector<short[]> optPath = new Vector<short[]>();
        int oldDx = 0;
        int oldDy = 0;
        for (i = 0; i < path.length - 1; ++i) {
            int dx = path[i][0] - path[i + 1][0];
            int dy = path[i][1] - path[i + 1][1];
            if (dx == oldDx && dy == oldDy) continue;
            oldDx = dx;
            oldDy = dy;
            optPath.addElement(path[i]);
        }
        optPath.addElement(path[path.length - 1]);
        for (i = 0; i < optPath.size() - 2; ++i) {
            short[] p2;
            short[] p1;
            for (int j = i + 2; j < optPath.size() && this.testPath((p1 = (short[])optPath.elementAt(i))[0], p1[1], (p2 = (short[])optPath.elementAt(j))[0], p2[1], spriteType); ++j) {
                optPath.removeElementAt(i + 1);
                --j;
            }
        }
        short[][] newPath = new short[optPath.size()][];
        optPath.copyInto((Object[])newPath);
        return newPath;
    }

    private boolean testPath(int x1, int y1, int x2, int y2, int spriteType) {
        if (spriteType == 0) {
            x1 *= this.pathTileWidth;
            y1 *= this.pathTileHeight;
            x2 *= this.pathTileWidth;
            y2 *= this.pathTileHeight;
            int dy = (y2 += this.pathTileHeight / 2) - (y1 += this.pathTileHeight / 2);
            int dx = (x2 += this.pathTileWidth / 2) - (x1 += this.pathTileWidth / 2);
            if (Math.abs(dx) > Math.abs(dy)) {
                int minX = Math.min(x1, x2);
                int maxX = Math.max(x1, x2);
                for (int x = minX; x < maxX; x += 2) {
                    int y = dy * (x - x1) / dx + y1;
                    if ((this.mapCollisonData[y / this.pathTileHeight][x / this.pathTileWidth >> 3] >> (x / this.pathTileWidth & 7) & 1) == 0) continue;
                    return false;
                }
            } else {
                int minY = Math.min(y1, y2);
                int maxY = Math.max(y1, y2);
                for (int y = minY; y < maxY; y += 2) {
                    int x = dx * (y - y1) / dy + x1;
                    if ((this.mapCollisonData[y / this.pathTileHeight][x / this.pathTileWidth >> 3] >> (x / this.pathTileWidth & 7) & 1) == 0) continue;
                    return false;
                }
            }
            return true;
        }
        int dy = y2 - y1;
        int dx = x2 - x1;
        if (Math.abs(dx) > Math.abs(dy)) {
            int minX = Math.min(x1, x2);
            int maxX = Math.max(x1, x2);
            for (int x = minX; x < maxX; ++x) {
                int y = dy * (x - x1) / dx + y1;
                if ((this.mapCollisonData[y][x >> 3] >> (x & 7) & 1) == 0) continue;
                return false;
            }
        } else {
            int minY = Math.min(y1, y2);
            int maxY = Math.max(y1, y2);
            for (int y = minY; y < maxY; ++y) {
                int x = dx * (y - y1) / dy + x1;
                if ((this.mapCollisonData[y][x >> 3] >> (x & 7) & 1) == 0) continue;
                return false;
            }
        }
        return true;
    }

    static {
        miniMapShow = false;
        currNetColor = 1;
        showMapNpcAnimate = true;
        sortTable = new int[]{1, 4, 10, 23, 57, 132, 301, 701, 1577, 3548, 7983, 17961, 40412, 90927, 204585, 460316, 1035711, 2330349};
        drawItemPanel = new SortHashtable();
        miniMapImage = null;
        needBuildEdgeMapNpc = false;
        edgeNpcsOfGround = new Vector();
        edgeNpcsOfRole = new Vector();
        edgeNpcsOfSky = new Vector();
        bubbleImg = null;
        PATH_FIND = new byte[][]{{-1, 0, 2}, {1, 0, 2}, {0, -1, 2}, {0, 1, 2}, {-1, -1, 3}, {1, -1, 3}, {-1, 1, 3}, {1, 1, 3}};
    }

    private class Bubble
    extends PendingDrawItem {
        public int width;
        public int counterKey = -1;
        public String[] lines;

        public Bubble(String[] text, int x, int y) {
            this.x = x;
            this.y = y;
            this.type = 4;
            this.lines = text;
            if (bubbleImg == null) {
                bubbleImg = (ImageSet)Tool.getGlobalObject("VarUIRes");
            }
        }
    }

    private class PendingDrawItem {
        public int type;
        public Object objData;
        public int x;
        public int y;
        public int color;
        public int bgColor;
        public boolean is3D;
        public int anchor;
        public static final int ITEM_TYPE_HEAD_STRING = 0;
        public static final int ITEM_TYPE_FLY_STRING = 1;
        public static final int ITEM_TYPE_ANIMATE = 2;
        public static final int ITEM_TYPE_IMAGE = 3;
        public static final int ITEM_TYPE_BUBBLE = 4;

        private PendingDrawItem() {
        }

        public void draw(Graphics g) {
            switch (this.type) {
                case 0: {
                    if (this.is3D) {
                        Tool.draw3DString(g, (String)this.objData, this.x, this.y, this.color, this.bgColor, this.anchor);
                        break;
                    }
                    g.setColor(this.color);
                    Tool.drawString(g, (String)this.objData, this.x, this.y, this.anchor);
                    break;
                }
                case 1: {
                    FlyingStringInfo fly = (FlyingStringInfo)this.objData;
                    if (fly.isAcross) {
                        if (fly.calculate <= fly.hCycleCount) {
                            this.x += fly.hSpeed * fly.calculate * fly.dir;
                            this.y -= fly.hSpeed * fly.calculate;
                            fly.drawFlying(g, this.x, this.y, fly.number, fly.color, 0, 0, 0);
                            break;
                        }
                        if (fly.calculate - fly.hCycleCount < fly.stopCycleCount) {
                            this.x += fly.hSpeed * fly.hCycleCount * fly.dir;
                            this.y -= fly.hSpeed * fly.hCycleCount;
                            fly.drawFlying(g, this.x, this.y, fly.number, fly.color, 0, 0, 0);
                            break;
                        }
                        int vCycleCount = fly.calculate - fly.hCycleCount - fly.stopCycleCount;
                        this.x += fly.hSpeed * fly.hCycleCount * fly.dir;
                        this.y = this.y - fly.hSpeed * fly.hCycleCount - fly.vSpeed * vCycleCount;
                        fly.drawFlying(g, this.x, this.y, fly.number, fly.color, 0, 0, 0);
                        break;
                    }
                    fly.drawFlying(g, this.x, this.y, fly.number, fly.color, fly.distance, fly.calculate * 100 / fly.time, fly.calculate - 1);
                    break;
                }
                case 2: {
                    AnimatePlayer animatePlayer = (AnimatePlayer)this.objData;
                    animatePlayer.draw(g, this.x, this.y);
                    break;
                }
                case 3: {
                    ImageSet image = (ImageSet)this.objData;
                    image.drawFrame(g, this.color, this.x, this.y, 0, this.anchor);
                    break;
                }
                case 4: {
                    Bubble bl = (Bubble)this;
                    Tool.drawTip(g, bl.x, bl.y, bl.lines, bubbleImg);
                }
            }
        }
    }
}

