/*
 * Decompiled with CFR 0.152.
 */
package com.pip.sanguo;

import com.pip.common.Tool;
import com.pip.engine.AnimateCache;
import com.pip.engine.AnimatePlayer;
import com.pip.engine.IAnimateCallback;
import com.pip.engine.IAnimateOwner;
import com.pip.engine.IVMGameProcessor;
import com.pip.engine.Sprite;
import com.pip.image.ImageSet;
import com.pip.image.PipAnimateSet;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameWorld;
import com.pip.ui.VM;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class GameSprite
implements IAnimateCallback,
IAnimateOwner,
IVMGameProcessor {
    private byte type;
    private int id;
    private int instanceId;
    private String name;
    private String[] extraName;
    private Hashtable gameData = new Hashtable();
    public Sprite sprite;
    protected VM vm;
    protected boolean onHorse;
    protected boolean canAttack;
    protected boolean canSelect = true;
    protected boolean hold;
    protected int weaponType;
    public boolean die;
    protected boolean attacking;
    public int hpMax;
    public int mpMax;
    public int hp;
    public int mp;
    public int state;
    public byte faction;
    public int level;
    public boolean isFollowing;
    private boolean isTeamState;
    public boolean infoRecved = false;
    public boolean infoForceRequested = false;
    public Hashtable status = new Hashtable();
    public int horsepara;
    public int horsePoint;
    private Vector forceWayPointList = new Vector();
    public boolean forceWayPointMode;
    private int[] forceWayPoint;
    private int forceWayPointSpeed;
    public boolean chaseMode;
    protected boolean chaseAlways;
    protected int chaseDistanceAllow;
    protected int chaseSpeed;
    protected int chaseTargetInstanceId;
    protected Vector chaseList = new Vector();
    protected short[] chasePoint;
    protected int[] chaseCallbackPara;
    public int moveAnimateIndex;
    public int stopAnimateIndex;
    public int chaseMoveAnimateIndex;
    public int chaseStopAnimateIndex;
    public int pendingStopAnimateIndex;
    public int chasePendingStopAnimateIndex;
    private int pendingTick;
    public boolean miniMapShow = false;
    public boolean forceMiniMapShow = false;
    public int[] miniMapColor = null;
    public Object[] miniMapImage = null;
    public int[] leavingPosition = null;
    public GameSprite followOwner;
    public static final short DEFAULT_SPEED = 45;
    public static final byte DEFAULT_DIR = 0;
    public static final int SPECIAL_STATUS_FEAR = 6;
    public static final int SPECIAL_STATUS_PALSY = 7;
    public static final int SPECIAL_STATUS_STOP = 8;
    protected Vector followers = new Vector();
    private Hashtable animates = new Hashtable();
    public boolean isOutView;
    private boolean startForceFollow;

    protected GameSprite(int type, int id, int instanceId) {
        this.type = (byte)type;
        this.id = id;
        this.instanceId = instanceId;
        this.name = "\u672a\u77e5";
        this.sprite = new Sprite(this);
        this.sprite.setSpeed(45);
        this.onHorse = false;
        this.sprite.setDir(0);
        this.sprite.setAnimateDir(0);
        this.sprite.setWork(true);
        this.sprite.setCollision(false);
    }

    public byte getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.infoRecved = true;
        int extraIdx = name.indexOf(124);
        if (extraIdx >= 0) {
            this.name = name.substring(0, extraIdx);
            this.extraName = Tool.splitString(name.substring(extraIdx + 1), '|');
        } else {
            this.extraName = null;
        }
    }

    public boolean isTeamState() {
        return this.isTeamState;
    }

    public boolean addFollower(GameSprite follower) {
        if (follower == null || this.followers.size() >= Tool.FOLLOW_DIS_MATRIX.length >> 1 || follower == this.followOwner || this.followers.contains(follower)) {
            return false;
        }
        if (follower.followOwner != null) {
            follower.followOwner.removeFollower(follower);
        }
        this.followers.addElement(follower);
        follower.followOwner = this;
        this.setFollowersPosition();
        return true;
    }

    public void removeFollower(GameSprite follower) {
        follower.followOwner = null;
        this.followers.removeElement(follower);
    }

    public void removeAllFollowers() {
        int count = this.followers.size();
        for (int i = 0; i < count; ++i) {
            ((GameSprite)this.followers.elementAt((int)i)).followOwner = null;
        }
        this.followers.removeAllElements();
    }

    void setFollowersPosition() {
        int count = this.followers.size();
        if (count > 0) {
            int disx = 20;
            int disy = 20;
            if (this.sprite.getDir() == 0 || this.sprite.getDir() == 3) {
                if (count == 2) {
                    disx >>= 1;
                }
            } else {
                disx = 20;
                disy = 20;
                if (count == 2) {
                    disy >>= 1;
                }
            }
            int firstX = this.sprite.getX() + disx * Tool.ASSIS_RIGHT_MATRIX[(this.sprite.getDir() << 1) + 0];
            int firstY = this.sprite.getY() + disy * Tool.ASSIS_RIGHT_MATRIX[(this.sprite.getDir() << 1) + 1];
            int followX = 0;
            int followY = 0;
            for (int i = 0; i < count; ++i) {
                GameSprite gs = (GameSprite)this.followers.elementAt(i);
                if (gs.sprite.getMapId() != this.sprite.getMapId()) continue;
                if (gs.sprite.getX() == gs.followOwner.sprite.getX() && gs.sprite.getY() == gs.followOwner.sprite.getY()) {
                    this.startForceFollow = false;
                    break;
                }
                followX = firstX + Tool.FOLLOW_DIS_MATRIX[(i << 1) + (this.sprite.getDir() == 0 || this.sprite.getDir() == 3 ? 0 : 1)] * Tool.ASSIS_LEFT_MATRIX[(this.sprite.getDir() << 1) + 0];
                followY = firstY + Tool.FOLLOW_DIS_MATRIX[(i << 1) + (this.sprite.getDir() == 0 || this.sprite.getDir() == 3 ? 1 : 0)] * Tool.ASSIS_LEFT_MATRIX[(this.sprite.getDir() << 1) + 1];
                if (gs.sprite.getX() == followX && gs.sprite.getY() == followY) continue;
                if (GameWorld.gameView.canMove(gs.sprite.getX(), gs.sprite.getY()) && !this.startForceFollow) {
                    gs.sprite.addWayPoint(followX, followY, gs.moveAnimateIndex, gs.stopAnimateIndex, gs.sprite.getSpeed(), this);
                    continue;
                }
                gs.sprite.addWayPoint(gs.followOwner.sprite.getX(), gs.followOwner.sprite.getY(), gs.moveAnimateIndex, gs.stopAnimateIndex, gs.sprite.getSpeed(), this);
                this.startForceFollow = true;
            }
        }
    }

    public void addWayPoint(int dest_x, int dest_y, int moveAnimateIndex, int stopAnimateIndex, boolean needGuess, int angle, int time, int speed, int targetPos) {
        if (GameWorld.player.sprite.getMapId() == this.sprite.getMapId()) {
            this.sprite.addWayPoint(dest_x, dest_y, moveAnimateIndex, stopAnimateIndex, needGuess, angle, time, speed, this, true, targetPos);
        } else {
            this.sprite.setPosition(-1000, dest_y);
        }
    }

    public void setHeadStringConfig(int type, int space, int drawMode, int offsetx, int offsety, int order) {
        int[] config = new int[]{type, space, drawMode, offsetx, offsety, order};
        this.sprite.setHeadStringConfig(config);
    }

    public void destroy() {
        Vector animateNames = this.sprite.getAllAnimateNames();
        for (int i = 0; i < animateNames.size(); ++i) {
            String animateName = (String)animateNames.elementAt(i);
            AnimateCache.releaseAnimate(this, animateName, false);
        }
        this.sendCommand(10180, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendCommand(int command, Object commandData) {
        VM vM = this.vm;
        synchronized (vM) {
            int[] params = new int[]{this.vm.makeTempObject(this), command, this.vm.makeTempObject(commandData)};
            this.vm.callback("GameCommand", params);
        }
    }

    public void vm_sprite_set_mini_map_color(int[] miniMapColor) {
        this.miniMapColor = new int[miniMapColor.length];
        System.arraycopy(miniMapColor, 0, this.miniMapColor, 0, miniMapColor.length);
    }

    public void vm_sprite_set_mini_map_image(String resName, int frame) {
        if (frame == -1) {
            this.miniMapImage = null;
        } else {
            this.miniMapImage = new Object[2];
            this.miniMapImage[0] = resName;
            this.miniMapImage[1] = new Integer(frame);
        }
    }

    public void vm_sprite_set_mini_map_show(boolean show) {
        if (!this.forceMiniMapShow) {
            this.miniMapShow = show;
        }
    }

    public void forceMiniMapShow(int b) {
        this.forceMiniMapShow = b == 1;
    }

    public int getForceMiniMapShow() {
        return this.forceMiniMapShow ? 1 : 0;
    }

    public int vm_sprite_get_mini_map_show() {
        return this.miniMapShow ? 1 : 0;
    }

    public void vm_request_animates(String[] animateNames) {
        for (int i = 0; i < animateNames.length; ++i) {
            AnimateCache.requestAnimate(this, animateNames[i]);
        }
    }

    public void vm_set_sprite_show(boolean show) {
        this.sprite.setShow(show);
    }

    public void vm_add_animate(String animateName) {
        String tmpName = "vmDataAnimate" + animateName;
        AnimatePlayer animate = (AnimatePlayer)this.gameData.get(tmpName);
        this.sprite.addAnimate(animate);
        this.gameData.remove(tmpName);
    }

    public void vm_remove_animate(String animateName) {
        this.sprite.removeAnimate(animateName);
        AnimateCache.releaseAnimate(this, animateName, false);
    }

    public void vm_set_animate_show(String animateName, boolean show) {
        if (show) {
            this.sprite.showAnimate(animateName);
        } else {
            this.sprite.hideAnimate(animateName);
        }
    }

    public void vm_add_animate_replace_images(String animateName, String[] imageNames) {
        int count = imageNames.length;
        for (int i = 0; i < count; ++i) {
            this.sprite.addReplaceAnimateImage(animateName, imageNames[i]);
        }
    }

    public boolean vm_test_animate_ok(String[] names) {
        boolean allOk = true;
        for (int i = 0; i < names.length; ++i) {
            if (this.sprite.hasAnimate(names[i])) continue;
            allOk = false;
            break;
        }
        return allOk;
    }

    public boolean vm_sprite_has_animate(String name) {
        return this.sprite.hasAnimate(name);
    }

    public int[] vm_sprite_get_animate_box() {
        return this.sprite.getAnimateBox();
    }

    public String vm_sprite_get_name() {
        return this.getName();
    }

    public void vm_sprite_set_name(String _name) {
        this.setName(_name);
    }

    public int vm_sprite_get_faction() {
        return this.faction;
    }

    public void vm_sprite_set_faction(int _faction) {
        this.faction = (byte)_faction;
    }

    public int vm_sprite_get_level() {
        return this.level;
    }

    public void vm_sprite_set_level(int _level) {
        this.level = _level;
    }

    public int vm_sprite_get_hp() {
        return this.hp;
    }

    public int vm_sprite_get_hp_max() {
        return this.hpMax;
    }

    public int vm_sprite_get_mp() {
        return this.mp;
    }

    public int vm_sprite_get_mp_max() {
        return this.mpMax;
    }

    public int[] vm_sprite_get_pos() {
        return new int[]{this.sprite.getX(), this.sprite.getY()};
    }

    public void vm_sprite_set_pos(int x, int y) {
        this.sprite.setPosition(x, y);
    }

    public int vm_sprite_get_map_id() {
        return this.sprite.getMapId();
    }

    public int vm_sprite_get_map_instance_id() {
        return this.sprite.getMapInstanceId();
    }

    public void vm_game_set_animate_index(String _animateName, int _index, int _playType, int _callBackIndex) {
        this.sprite.setAnimateIndex(_animateName, _index, _playType, _callBackIndex, this, false);
    }

    public int vm_game_sprite_play_animate(AnimatePlayer _animatePlayer, int _anchor, int _order) {
        _animatePlayer.setAnchor(_anchor);
        _animatePlayer.setOrder(_order);
        _animatePlayer.setShown(true);
        this.animates.put(new Integer(_animatePlayer.getKey()), _animatePlayer);
        return _animatePlayer.getKey();
    }

    public void vm_sprite_set_can_attack(boolean _canAttact) {
        this.canAttack = _canAttact;
    }

    public boolean vm_sprite_get_can_attack() {
        return this.canAttack;
    }

    public void vm_sprite_set_can_select(boolean _canSelect) {
        this.canSelect = _canSelect;
    }

    public boolean vm_sprite_get_can_select() {
        return this.canSelect;
    }

    public int[] vm_sprite_get_animate_para() {
        byte dir = this.sprite.getDir();
        int animateDir = this.sprite.getAnimateDir();
        int animateSubDir = this.sprite.getAnimateSubDir();
        int moving = this.sprite.getMove() ? 1 : 0;
        int onHorse = this.onHorse ? 1 : 0;
        int holding = this.hold ? 1 : 0;
        int attacking = this.attacking ? 1 : 0;
        int die = this.die ? 1 : 0;
        int isHuman = this.isHumanAnimate() ? 1 : 0;
        int chasing = this.chaseMode ? 1 : 0;
        return new int[]{dir, animateDir, animateSubDir, moving, onHorse, holding, attacking, die, isHuman, this.weaponType, chasing, this.horsepara, this.horsePoint};
    }

    public void vm_game_sprite_stop_animate(int _animatePlayerKey) {
        this.animates.remove(new Integer(_animatePlayerKey));
    }

    public void vm_game_sprite_add_fly_string(int _type, String _str, int _number, int _paletteColor, int _distance, int _time, int _order, int _delayTick) {
        this.sprite.addFlyingString((byte)_type, _str, _number, _paletteColor, _distance, _time, _order, _delayTick);
    }

    public void vm_game_sprite_add_across_fly_string(int _type, String _str, int _number, int _paletteColor, int _dir, int _hCycleCount, int _hSpeed, int _stopCycleCount, int _vCycleCount, int _vSpeed, int _order, int _delayTick) {
        this.sprite.addFlyingString((byte)_type, _str, _number, _paletteColor, _dir, _hCycleCount, _hSpeed, _stopCycleCount, _vCycleCount, _vSpeed, _order, _delayTick);
    }

    public void vm_game_sprite_add_vibar(int _time, int _distance) {
        this.sprite.addVibar(this.sprite.getDir(), _time, _distance);
    }

    public void vm_game_sprite_set_die(boolean _die) {
        this.die = _die;
        this.sprite.setWork(!this.die);
    }

    public void vm_game_sprite_set_waypoint_animate(int _moveAnimate, int _stopAnimate, int _chaseMoveAnimate, int _chaseStopAnimate, int _pendingStopAnimate, int _chasePendingStopAnimate) {
        this.moveAnimateIndex = _moveAnimate;
        this.stopAnimateIndex = _stopAnimate;
        this.chaseMoveAnimateIndex = _chaseMoveAnimate;
        this.chaseStopAnimateIndex = _chaseStopAnimate;
        this.pendingStopAnimateIndex = _pendingStopAnimate;
        this.chasePendingStopAnimateIndex = _chasePendingStopAnimate;
        this.sprite.wayPointInfo.moveAnimateIndex = this.moveAnimateIndex;
        this.sprite.wayPointInfo.stopAnimateIndex = this.stopAnimateIndex;
    }

    public void vm_sprite_set_head_string_config(int type, int space, int drawMode, int offsetX, int offsetY, int order) {
        this.setHeadStringConfig(type, space, drawMode, offsetX, offsetY, order);
    }

    public void vm_sprite_add_head_string(String _str, int _color, Object _image, int[] _imageIndex) {
        if (_image == null) {
            this.sprite.addHeadString(_str, _color, null, null);
        } else {
            this.sprite.addHeadString(_str, _color, (ImageSet)Tool.getGlobalObject((String)_image), _imageIndex);
        }
    }

    public void vm_sprite_clear_head_string() {
        this.sprite.clearHeadString();
    }

    public void vm_sprite_set_head_string_show(boolean _show) {
        this.sprite.setHeadStringShow(_show);
    }

    public void vm_sprite_set_collision(boolean _collision) {
        this.sprite.setCollision(_collision);
    }

    public int vm_sprite_get_type() {
        return this.getType();
    }

    public int vm_sprite_get_id() {
        return this.getId();
    }

    public int vm_sprite_get_instanceid() {
        return this.getInstanceId();
    }

    public int vm_sprite_get_dir() {
        return this.sprite.getDir();
    }

    public AnimatePlayer vm_sprite_get_animate_player(String _animateName) {
        return this.sprite.getAnimatePlayer(_animateName);
    }

    public void vm_sprite_send_command(int _command, Object _data) {
        this.sendCommand(_command, _data);
    }

    public boolean vm_sprite_start_chase_position(int _distanceAllow, int _targetX, int _targetY, int _speed, int[] _callbackPara, boolean _always) {
        boolean find = false;
        this.clearChase();
        if (GameWorld.gameView != null) {
            if (_speed < 0) {
                _speed = this.sprite.getSpeed();
            }
            find = this.startChase(this.sprite.getX(), this.sprite.getY(), _targetX, _targetY, _distanceAllow, _speed, -1, _callbackPara, _always);
        }
        return find;
    }

    public boolean vm_sprite_start_chase_sprite(int _distanceAllow, int _speed, GameSprite _targetSprite, int[] _callbackPara, boolean _always) {
        boolean find = false;
        this.clearChase();
        if (GameWorld.gameView != null) {
            if (_speed < 0) {
                _speed = this.sprite.getSpeed();
            }
            find = this.startChase(this.sprite.getX(), this.sprite.getY(), _targetSprite.sprite.getX(), _targetSprite.sprite.getY(), _distanceAllow, _speed, _targetSprite.getInstanceId(), _callbackPara, _always);
        }
        return find;
    }

    public void vm_sprite_clear_chase() {
        this.clearChase();
    }

    public void vm_sprite_set_dir(int _dir) {
        this.sprite.setDir(_dir);
        this.sprite.setAnimateDir(_dir);
    }

    public void vm_sprite_adjust_animate_dir(int _targetInstanceId, boolean _setAnimate) {
        GameSprite targetSprite = GameWorld.getSprite(_targetInstanceId);
        if (targetSprite != null) {
            int[] newDir = targetSprite.sprite.wayPointInfo.dirArray;
            Tool.calulateDirWithWayPointMatrix(this.sprite.getDir(), this.sprite.getAnimateSubDir(), this.sprite.getX(), this.sprite.getY(), targetSprite.sprite.getX(), targetSprite.sprite.getY(), newDir);
            if (!this.sprite.getMove()) {
                this.sprite.setDir(newDir[0]);
            }
            this.sprite.setAnimateDir(newDir[0]);
            this.sprite.setAnimateSubDir(newDir[1]);
            if (_setAnimate) {
                this.sendCommand(10040, null);
            }
        }
    }

    public String[] vm_sprite_get_extra_name() {
        return this.extraName;
    }

    public int vm_sprite_get_speed() {
        return this.sprite.getSpeed();
    }

    public void vm_sprite_set_speed(int _speed) {
        this.sprite.setSpeed(_speed);
    }

    public int vm_sprite_get_animate_sub_dir() {
        return this.sprite.getAnimateSubDir();
    }

    public void vm_sprite_set_animate_sub_dir(int _subDir) {
        this.sprite.setAnimateSubDir(_subDir);
    }

    public void vm_sprite_set_attacking(boolean _attacking) {
        this.attacking = _attacking;
    }

    public int vm_sprite_get_weapon_type() {
        return this.weaponType;
    }

    public void vm_sprite_set_weapon_type(int _weaponType) {
        this.weaponType = _weaponType;
    }

    public int vm_sprite_get_animate_dir() {
        return this.sprite.getAnimateDir();
    }

    public void vm_sprite_set_animate_dir(int _animateDir) {
        if (_animateDir < 0) {
            this.sprite.setAnimateDir(this.sprite.getDir());
        } else {
            this.sprite.setAnimateDir(_animateDir);
        }
    }

    public boolean vm_sprite_get_move() {
        return this.sprite.getMove();
    }

    public void vm_sprite_set_following(boolean isFollowing) {
        this.isFollowing = isFollowing;
    }

    public boolean vm_sprite_get_following() {
        return this.isFollowing;
    }

    public GameSprite vm_sprite_get_follow_owner() {
        return this.followOwner;
    }

    public void vm_sprite_set_leaving_pos() {
        if (this.leavingPosition == null) {
            this.leavingPosition = new int[2];
            this.leavingPosition[0] = this.sprite.getX();
            this.leavingPosition[1] = this.sprite.getY();
        }
    }

    public boolean vm_sprite_test_status(int _status) {
        return this.status.get(new Integer(_status)) != null;
    }

    public void vm_sprite_add_status(int _status) {
        Integer tmp = new Integer(_status);
        this.status.put(tmp, tmp);
    }

    public void vm_sprite_remove_status(int _status) {
        this.status.remove(new Integer(_status));
    }

    public void vm_sprite_clear_status() {
        this.status.clear();
    }

    public void vm_sprite_set_force_way_point(boolean _hasReturnPoint, int _forceSpeed, int _returnX, int _returnY, int[] _wayPointList) {
        this.clearForceWayPoint();
        for (int i = 0; i < _wayPointList.length >> 1; ++i) {
            this.forceWayPointList.addElement(new int[]{_wayPointList[i << 1], _wayPointList[(i << 1) + 1]});
        }
        if (_hasReturnPoint) {
            this.forceWayPointList.addElement(new int[]{_returnX, _returnY});
        }
        this.forceWayPointSpeed = _forceSpeed;
        this.forceWayPointMode = true;
    }

    public void vm_sprite_clear_force_way_point() {
        if (this.forceWayPointList.size() > 0) {
            int[] returnPoint = (int[])this.forceWayPointList.lastElement();
            this.sprite.setPosition(returnPoint[0], returnPoint[1]);
        }
        this.clearForceWayPoint();
    }

    public int vm_sprite_get_speed_addon() {
        return this.sprite.getSpeedAddon();
    }

    public void vm_sprite_set_speed_addon(int _speedAddon) {
        this.sprite.setSpeedAddon(_speedAddon);
    }

    public void vm_set_animate_not_icon(String animateName) {
        this.sprite.setAnimateNotIcon(animateName);
    }

    public void vm_game_sprite_set_animate_layer(String _animateName, int _layer) {
        this.sprite.setAnimateLayer(_animateName, _layer);
    }

    public void vm_game_sprite_regroup_animate() {
        this.sprite.regroupAnimate();
    }

    public boolean vm_sprite_is_out_view() {
        return this.isOutView;
    }

    public void vm_set_game_sprite_horse(boolean riding) {
        this.processAction(this.sprite.getDir(), false, riding, this.hold);
    }

    public void vm_set_game_sprite_hold(boolean _hold) {
        this.hold = _hold;
    }

    public boolean vm_sprite_is_team_state() {
        return this.isTeamState;
    }

    public void vm_sprite_set_team_state(boolean _isTeamState) {
        this.isTeamState = _isTeamState;
    }

    public void vm_sprite_set_animate_draw_replace_data(String _animateName, int _sourceImageId, int[] _sourceFrameId, int _destImageId, int[] _destFrameId) {
        int count = _sourceFrameId.length;
        for (int i = 0; i < count; ++i) {
            this.sprite.setAnimateImageDrawOffset(_animateName, _sourceImageId, _sourceFrameId[i], _destImageId, _destFrameId[i]);
        }
    }

    public Object processCommand(int command, Object data) {
        Object result = null;
        return result;
    }

    public void processAction(int newDir, boolean newMoving, boolean newOnHorse, boolean newHolding) {
        boolean animateIndexChanged = false;
        if (this.sprite.getDir() != newDir) {
            this.sprite.setDir(newDir);
            this.sprite.setAnimateDir(newDir);
            animateIndexChanged = true;
        }
        if (this.sprite.getMove() != newMoving || this.hold != newHolding) {
            this.hold = newHolding;
            this.sprite.setMove(newMoving);
            animateIndexChanged = true;
        }
        if (this.onHorse != newOnHorse) {
            this.onHorse = newOnHorse;
            animateIndexChanged = true;
        }
        if (animateIndexChanged) {
            this.sendCommand(10040, null);
            this.sendCommand(15050, null);
        }
    }

    public Object readGameData(String dataName) {
        return this.gameData.get(dataName);
    }

    public void saveGameData(String dataName, Object data) {
        this.gameData.put(dataName, data);
    }

    public void removeGameData(String dataName) {
        this.gameData.remove(dataName);
    }

    public void animateReady(String animateName, PipAnimateSet animate) {
        AnimatePlayer animateData = new AnimatePlayer(animateName);
        animateData.init(animate);
        this.saveGameData("vmDataAnimate" + animateName, animateData);
        this.sendCommand(10020, animateName);
    }

    public boolean canRemoved() {
        if (!this.sprite.isPlayingAnimate() && this.animates.size() == 0) {
            return true;
        }
        if (!this.sprite.isPlayingAnimate()) {
            Enumeration enu = this.animates.elements();
            while (enu.hasMoreElements()) {
                AnimatePlayer ap = (AnimatePlayer)enu.nextElement();
                if (!ap.playing()) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void cycle() {
        Enumeration enu = this.animates.elements();
        while (enu.hasMoreElements()) {
            AnimatePlayer ap = (AnimatePlayer)enu.nextElement();
            ap.cycle();
        }
        if (this.forceWayPointMode) {
            this.processForceWayPoint();
        } else if (this.chaseMode) {
            this.processChase();
        }
        if (this.sprite.getMove() || this.sprite.wayPointInfo.needHandle || this.attacking) {
            this.pendingTick = 0;
        }
        if (this.pendingTick > GameMain.animatePendingTick) {
            if (this.chaseMode) {
                if (this.chaseStopAnimateIndex != this.chasePendingStopAnimateIndex) {
                    this.sendCommand(10170, new Integer(this.chasePendingStopAnimateIndex));
                }
            } else if (this.stopAnimateIndex != this.pendingStopAnimateIndex) {
                this.sendCommand(10170, new Integer(this.pendingStopAnimateIndex));
            }
            this.pendingTick = 0;
        } else {
            ++this.pendingTick;
        }
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public void drawAnimate(Graphics g, int viewX, int viewY, boolean isBack) {
        int[] animateBox = this.sprite.getAnimateBox();
        Enumeration enu = this.animates.elements();
        while (enu.hasMoreElements()) {
            int ay;
            int ax;
            AnimatePlayer ap = (AnimatePlayer)enu.nextElement();
            if (isBack) {
                if (ap.getOrder() != 2) continue;
                ax = this.getAnimateAnchorX(ap.getAnchor(), animateBox);
                ay = this.getAnimateAnchorY(ap.getAnchor(), animateBox);
                ap.draw(g, ax - viewX, ay - viewY);
                continue;
            }
            ax = this.getAnimateAnchorX(ap.getAnchor(), animateBox);
            ay = this.getAnimateAnchorY(ap.getAnchor(), animateBox);
            if (ap.getOrder() == 0) {
                GameWorld.gameView.addPendingAnimate(ap, ax - viewX, ay - viewY, false);
                continue;
            }
            if (ap.getOrder() == 3) {
                GameWorld.gameView.addPendingAnimate(ap, ax - viewX, ay - viewY, true);
                continue;
            }
            if (ap.getOrder() == 2) continue;
            ap.draw(g, ax - viewX, ay - viewY);
        }
    }

    private int getAnimateAnchorX(int anchor, int[] animateBox) {
        int ax = animateBox[0];
        if ((anchor & 8) != 0) {
            ax += animateBox[2];
        } else if ((anchor & 0x10) != 0) {
            ax += animateBox[2] >> 1;
        } else if ((anchor & 0x40) != 0) {
            ax = this.sprite.getX();
        }
        return ax;
    }

    private int getAnimateAnchorY(int anchor, int[] animateBox) {
        int ay = animateBox[1];
        if ((anchor & 2) != 0) {
            ay += animateBox[3];
        } else if ((anchor & 0x20) != 0) {
            ay += animateBox[3] >> 1;
        } else if ((anchor & 0x80) != 0) {
            ay = this.sprite.getY();
        } else if ((anchor & 0x100) != 0) {
            ay -= this.sprite.getHeadStringHeight();
        }
        return ay;
    }

    private void processChase() {
        GameSprite gameSprite;
        short[] targetPoint;
        if (this.chaseList.size() > 0) {
            targetPoint = (short[])this.chaseList.lastElement();
            targetPoint = new short[]{targetPoint[0], targetPoint[1]};
            if (this.chaseTargetInstanceId >= 0 && (gameSprite = GameWorld.getSprite(this.chaseTargetInstanceId)) != null) {
                targetPoint[0] = (short)gameSprite.sprite.getX();
                targetPoint[1] = (short)gameSprite.sprite.getY();
            }
            if (this.chaseDistanceAllow > 0 && Tool.distance(this.sprite.getX(), this.sprite.getY(), targetPoint[0], targetPoint[1]) <= this.chaseDistanceAllow) {
                this.sprite.wayPointInfo.finishWayPoint(true);
                this.chaseList.removeAllElements();
            } else {
                short[] path = (short[])this.chaseList.firstElement();
                if (this.sprite.getX() != path[0] || this.sprite.getY() != path[1]) {
                    if (this.chasePoint == null || this.chasePoint[0] != path[0] || this.chasePoint[1] != path[1]) {
                        this.sprite.addWayPoint(path[0], path[1], this.chaseMoveAnimateIndex, this.chaseStopAnimateIndex, this.chaseSpeed, this);
                        this.chasePoint = path;
                    }
                } else {
                    this.chaseList.removeElementAt(0);
                    this.processChase();
                    return;
                }
            }
        }
        if (this.chaseList.size() == 0) {
            if (!this.chaseAlways) {
                int[] callBackPara = this.chaseCallbackPara;
                this.clearChase();
                if (callBackPara != null) {
                    this.sendCommand(10120, callBackPara);
                }
            } else if (this.chaseTargetInstanceId >= 0) {
                targetPoint = new short[]{(short)this.sprite.getX(), (short)this.sprite.getY()};
                if (this.chaseList.size() > 0) {
                    targetPoint = (short[])this.chaseList.lastElement();
                }
                if ((gameSprite = GameWorld.getSprite(this.chaseTargetInstanceId)) != null && Tool.distance(targetPoint[0], targetPoint[1], gameSprite.sprite.getX(), gameSprite.sprite.getY()) > this.chaseDistanceAllow) {
                    this.startChase(this.sprite.getX(), this.sprite.getY(), gameSprite.sprite.getX(), gameSprite.sprite.getY(), this.chaseDistanceAllow, this.chaseSpeed, this.chaseTargetInstanceId, this.chaseCallbackPara, this.chaseAlways);
                } else if (gameSprite == null) {
                    this.clearChase();
                }
            } else {
                this.clearChase();
            }
        }
    }

    public boolean startChase(int startX, int startY, int endX, int endY, int distanceAllow, int speed, int targetInstanceId, int[] callbackPara, boolean always) {
        int[] callBackPara;
        if (this.status.size() > 0) {
            return false;
        }
        if (this == GameWorld.player && (callBackPara = this.chaseCallbackPara) != null) {
            this.sendCommand(10121, callBackPara);
        }
        this.clearChase();
        int sx = startX / GameWorld.gameView.pathTileWidth;
        int sy = startY / GameWorld.gameView.pathTileHeight;
        int tx = endX / GameWorld.gameView.pathTileWidth;
        int ty = endY / GameWorld.gameView.pathTileHeight;
        short[][] path = null;
        path = GameWorld.gameView.searchPath_AStar(sx, sy, tx, ty, this.type);
        if (always) {
            this.chaseMode = true;
            this.chaseAlways = true;
        }
        if (path != null) {
            this.chaseMode = true;
            this.chaseDistanceAllow = distanceAllow;
            this.chaseSpeed = speed;
            this.chaseTargetInstanceId = targetInstanceId;
            this.chasePoint = null;
            this.chaseCallbackPara = callbackPara;
            this.chaseList.addElement(new short[]{(short)startX, (short)startY});
            for (int i = 1; i < path.length - 1; ++i) {
                this.chaseList.addElement(new short[]{(short)(path[i][0] * GameWorld.gameView.pathTileWidth + GameWorld.gameView.pathTileWidth / 2), (short)(path[i][1] * GameWorld.gameView.pathTileHeight + GameWorld.gameView.pathTileHeight / 2)});
            }
            this.chaseList.addElement(new short[]{(short)endX, (short)endY});
            GameMain.path = path;
            return true;
        }
        return false;
    }

    public void clearChase() {
        this.chaseMode = false;
        this.chaseAlways = false;
        this.chaseDistanceAllow = 0;
        this.chaseTargetInstanceId = -1;
        this.chaseSpeed = this.sprite.getSpeed();
        this.chaseList.removeAllElements();
        this.chasePoint = null;
        this.chaseCallbackPara = null;
        this.sprite.wayPointInfo.finishWayPoint(!this.die);
        this.attacking = false;
        GameMain.path = null;
    }

    public void processForceWayPoint() {
        if (this.forceWayPointList.size() > 0) {
            int[] path = (int[])this.forceWayPointList.firstElement();
            if (this.sprite.getX() != path[0] || this.sprite.getY() != path[1]) {
                if (this.forceWayPoint == null || this.forceWayPoint[0] != path[0] || this.forceWayPoint[1] != path[1]) {
                    this.sprite.addWayPoint(path[0], path[1], this.chaseMoveAnimateIndex, this.chaseStopAnimateIndex, this.forceWayPointSpeed, this);
                    this.forceWayPoint = path;
                }
            } else {
                this.forceWayPointList.removeElementAt(0);
                this.processChase();
                return;
            }
        }
        if (this.forceWayPointList.size() == 0) {
            this.clearForceWayPoint();
        }
    }

    public void clearForceWayPoint() {
        this.forceWayPointList.removeAllElements();
        this.forceWayPoint = null;
        this.forceWayPointMode = false;
        this.forceWayPointSpeed = this.sprite.getSpeed();
    }

    public void callback(int callbackFunction, int animateKey) {
        this.sendCommand(10050, new int[]{callbackFunction, animateKey});
    }

    public abstract void draw(Graphics var1, int var2, int var3);

    public abstract boolean isHumanAnimate();
}

