/*
 * Decompiled with CFR 0.152.
 */
package com.pip.sanguo;

import com.nokia.mid.ui.FullCanvas;
import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.engine.AnimateCache;
import com.pip.engine.AnimatePlayer;
import com.pip.engine.Weather;
import com.pip.image.ImageSet;
import com.pip.io.UASegment;
import com.pip.resource.ResourceAsynLoader;
import com.pip.resource.ResourceManager;
import com.pip.sanguo.GameView;
import com.pip.sanguo.GameWorld;
import com.pip.sanguo.SanguoMIDlet;
import com.pip.ui.Quest;
import com.pip.ui.VMGame;
import com.pip.util.VMCounter;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;

public class GameMain
extends FullCanvas
implements Runnable {
    public static int viewWidth;
    public static int viewHeight;
    public static GameMain instance;
    public static Display display;
    public static int tick;
    public static int semiTick;
    public static boolean sdkOneKeyEnter;
    public static final int MILLIS_PRE_UPDATE = 80;
    public static final int AVERAGE_PARA = 1000;
    public static final int AVERAGE_LIMIT = 3;
    public static int averageMillis;
    public static int totalMillis;
    public static int[] cycleMills;
    public static int millsPointer;
    public static boolean clientMoving;
    private static boolean needRepaint;
    public long reportAliveTime;
    public static final long REPORT_ALIVE_INTERVAL = 15000L;
    public UASegment nextPacket;
    public static boolean forceUpdating;
    private static boolean needReset;
    public static int resetType;
    public static int animateCacheType;
    public static long lastCycleTime;
    public static long lastPaintTime;
    public static String systemError;
    public static AnimatePlayer[] clientAnimates;
    public static AnimatePlayer[] specialAnimates;
    public static ImageSet numberImage;
    public static Hashtable needCacheVm;
    public static int[] battleRemind;
    public static Hashtable javaWorldPacket;
    public static int numberImageIndex;
    public static int flyNumberIndex;
    public static int flyNumberBlockCount;
    public static int humanAnimateIndex;
    public static int autoSelectDistance;
    public static int forceSelectDistance;
    public static int lostSelectDistance;
    public static int positionDistance;
    public static int positionTime;
    public static int positionLimit;
    public static int dropNetplayerTime;
    public static int dropflyingStringTime;
    public static int spriteFlyingStringDelay;
    public static int spritePlayAnimateDelay;
    public static int followingNotifyServerTime;
    public static int battleModePositionTime;
    public static int keepGoingDistance;
    public static int followMaxDis;
    public static int animatePendingTick;
    public static int spriteLeavingSpeed;
    public static int netplayerShowNameDistance;
    public static int imageScalePercent;
    public static int netplayerShowMaxCount;
    public static int draw3DStringLevel;
    public static int drawStringMoveDir;
    public static int iconOffset;
    public static boolean fadeEffect;
    public static int[] fadeData;
    public static int fadeColor;
    public static int fadeStartAlpha;
    public static int fadeEndAlpha;
    public static int fadeAlphaStep;
    public static int fadeMaxCount;
    public static int fadeCurrentAlpha;
    public static int fadeCurrentCount;
    public static boolean vibraEffect;
    public static int[] vibraData;
    public static int vibraTick;
    public static int vibraMaxCount;
    public static int vibraCurrentIndex;
    public static int vibraCurrentCount;
    public static Weather weather;
    public static GameWorld world;
    public static ResourceManager resourceManager;
    public static ResourceAsynLoader resourceAsynLoader;
    public static boolean initializing;
    public static int COLLISION_MAX_STEP;
    public static int COLLISION_STEP_ADD;
    public static boolean MAP_DATA_BUFFER_OPTIMIZE;
    public static long lastSyncTime;
    public static boolean inCycle;
    public static int npcDownloadMode;
    public static boolean underDev;
    public static int drawTimes;
    public static int makeTimes;
    public static short[][] path;
    public static boolean hadOpenCut;
    public static final int[] debugKeyOrder;
    public static int debugTestIndex;
    public static boolean debugMode;
    public static boolean starPressing;
    public static int longPressedTick;
    public static boolean needSelectNearestNPC;
    private static int oldPointerX;
    private static int oldPointerY;

    public GameMain(Display dp) {
        resourceAsynLoader = new ResourceAsynLoader();
        display = dp;
        instance = this;
        viewWidth = this.getWidth();
        viewHeight = this.getHeight();
        if (viewWidth == 320) {
            if (viewHeight < 200) {
                viewHeight = 240;
            }
        } else if (viewWidth == 240) {
            if (viewHeight < 280) {
                viewHeight = 320;
            }
        } else if (viewWidth == 176 && viewHeight < 192) {
            viewHeight = 208;
        }
        Tool.setGlobalValue("varDebugModel", 0);
    }

    public static void clear() {
        resourceAsynLoader.clear();
        resourceManager.clear();
        if (resetType != 3) {
            AnimateCache.clear();
            VMGame.clear();
        } else {
            AnimateCache.clear();
            VMGame.clearExclude("ui_update");
        }
        GameWorld.clear();
        Quest.clear();
        Utilities.clearKeyStates();
        if (resetType != 3) {
            Utilities.closeConnection();
        }
    }

    public static void resetClient(int type) {
        needReset = true;
        resetType = type;
    }

    public static void reset() {
        needReset = false;
        GameMain.clear();
        GameMain.init();
        System.out.println("Log reset client type:" + resetType);
    }

    public static void setUpdating(boolean updating) {
        forceUpdating = updating;
    }

    public static void init() {
        try {
            initializing = true;
            String fileName = "";
            Tool.setGlobalValue("varModel", GameMain.getModel());
            Tool.setGlobalValue("varVersion", GameMain.getClientVersion());
            Tool.setGlobalValue("varUIModel", GameMain.getUIModel());
            Tool.setGlobalValue("varJVMCode", GameMain.getJVMCode());
            Tool.setGlobalValue("varChannelCode", GameMain.getChannelCode());
            Tool.setGlobalValue("varOpenGL", 0);
            Tool.setGlobalValue("varMenuConfig", "");
            Tool.setGlobalValue("varRevision", "PiP");
            Tool.setGlobalValue("varRestrictIP", 0);
            totalMillis = 0;
            tick = 0;
            semiTick = 0;
            for (int i = 0; i < cycleMills.length; ++i) {
                GameMain.cycleMills[i] = 80;
                totalMillis += 80;
            }
            resourceManager.loadResourceInfo();
            VMGame.loadVMGame("game_init", (byte)1, true);
            VMGame.setToTop("ui_update");
            sdkOneKeyEnter = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getChannelCode() {
        return "CCCCCPiP";
    }

    public static String getUIModel() {
        return "Midp2Big";
    }

    public static String getModel() {
        return "NokiaN73";
    }

    public static String getJVMCode() {
        String jvmCode = System.getProperty("microedition.platform");
        if (jvmCode == null) {
            jvmCode = GameMain.getModel();
        }
        return jvmCode;
    }

    public static String getClientVersion() {
        String ver = SanguoMIDlet.instance.getAppProperty("MIDlet-Version");
        if (ver == null) {
            return "4.8";
        }
        return ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Utilities.graphics = g;
        g.setFont(Utilities.font);
        try {
            g.setColor(0x606060);
            g.fillRect(0, 0, viewWidth, viewHeight);
            boolean forcePaintWorld = false;
            forcePaintWorld = VMGame.isAllTransparent(false);
            if (forcePaintWorld && !initializing) {
                if (MAP_DATA_BUFFER_OPTIMIZE && GameWorld.gameView != null) {
                    GameWorld.gameView.rebuildMapDataBuffer();
                }
                world.draw(g, 0, 99);
            } else if (MAP_DATA_BUFFER_OPTIMIZE && GameWorld.gameView != null) {
                GameWorld.gameView.releaseMapDataBuffer();
            }
            g.setClip(0, 0, viewWidth, viewHeight);
            if (weather != null) {
                weather.draw(g);
            }
            VMGame.drawAll(g, 0, 99);
            if (GameWorld.panel != null) {
                GameWorld.panel.draw(g, 100, 999);
            }
            g.setClip(0, 0, viewWidth, viewHeight);
            if (battleRemind != null) {
                if (!forcePaintWorld && battleRemind[5] != 0) {
                    g.setColor(battleRemind[battleRemind[6] % 2]);
                    for (int i = 0; i < battleRemind[2]; ++i) {
                        g.drawRect(i, i, viewWidth - i * 2 - 1, viewHeight - i * 2 - 1);
                    }
                    if (tick % battleRemind[3] == 0) {
                        battleRemind[6] = battleRemind[6] + 1;
                        if (battleRemind[6] > battleRemind[4]) {
                            GameMain.battleRemind[5] = 0;
                        }
                    }
                } else {
                    GameMain.battleRemind[5] = 0;
                    GameMain.battleRemind[6] = 0;
                }
            }
        }
        catch (Throwable e) {
            systemError = e.toString();
        }
        finally {
            try {
                if (debugMode) {
                    g.setClip(0, 0, viewWidth, viewHeight);
                } else {
                    systemError = null;
                }
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        GameMain.init();
        long startTime = Tool.getSystemTime();
        while (SanguoMIDlet.isRun) {
            long st;
            long t;
            long cycleStart;
            block33: {
                cycleStart = Utilities.getSafeTime();
                if (npcDownloadMode == 1) {
                    inCycle = true;
                }
                SanguoMIDlet.isRun = !Utilities.isExitGame;
                clientMoving = false;
                Utilities.keyFlag2 = Utilities.keyFlag;
                Utilities.keyFlag &= 0xAAAAAAAAAAAAAAAAL;
                startTime = Tool.getSystemTime();
                needRepaint = true;
                if ((++tick & 1) == 1) {
                    ++semiTick;
                }
                if (!needReset) break block33;
                GameMain.reset();
                inCycle = false;
                t = Utilities.getSafeTime() - cycleStart;
                if (t < 0L) {
                    t = 0L;
                    cycleStart = Utilities.getSafeTime();
                }
                st = t < 80L ? 80L - t : 1L;
                do {
                    try {
                        Thread.sleep(st);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                } while ((st = 80L - (t = Utilities.getSafeTime() - cycleStart)) > 0L);
                if (!clientMoving) continue;
                GameMain.calculateAverageMills((int)(Tool.getSystemTime() - startTime));
                continue;
            }
            try {
                int remainTick;
                this.cycle();
                lastCycleTime = Tool.getSystemTime() - startTime;
                long paintTime = Tool.getSystemTime();
                if (this.isShown() && needRepaint) {
                    this.repaint();
                    this.serviceRepaints();
                }
                if ((remainTick = (int)(80L - (lastPaintTime = Tool.getSystemTime() - paintTime) - lastCycleTime) / 10) < 1) {
                    remainTick = 1;
                }
                block20: for (int i = 0; i < remainTick && GameWorld.moveSegments.size() > 0; ++i) {
                    UASegment segment = (UASegment)GameWorld.moveSegments.elementAt(0);
                    GameWorld.moveSegments.removeElementAt(0);
                    switch (segment.type) {
                        case 193: {
                            Tool.recvUnitView(segment);
                            continue block20;
                        }
                        case 194: {
                            Tool.recvMultiUnitView(segment);
                            continue block20;
                        }
                        case 195: {
                            Tool.recvUnitMove(segment);
                        }
                    }
                }
                inCycle = false;
            }
            catch (Throwable ex) {
                try {
                    systemError = ex.toString();
                    inCycle = false;
                }
                catch (Throwable throwable) {
                    inCycle = false;
                    t = Utilities.getSafeTime() - cycleStart;
                    if (t < 0L) {
                        t = 0L;
                        cycleStart = Utilities.getSafeTime();
                    }
                    st = t < 80L ? 80L - t : 1L;
                    do {
                        try {
                            Thread.sleep(st);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    } while ((st = 80L - (t = Utilities.getSafeTime() - cycleStart)) > 0L);
                    if (clientMoving) {
                        GameMain.calculateAverageMills((int)(Tool.getSystemTime() - startTime));
                    }
                    throw throwable;
                }
                t = Utilities.getSafeTime() - cycleStart;
                if (t < 0L) {
                    t = 0L;
                    cycleStart = Utilities.getSafeTime();
                }
                st = t < 80L ? 80L - t : 1L;
                do {
                    try {
                        Thread.sleep(st);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                } while ((st = 80L - (t = Utilities.getSafeTime() - cycleStart)) > 0L);
                if (!clientMoving) continue;
                GameMain.calculateAverageMills((int)(Tool.getSystemTime() - startTime));
                continue;
            }
            t = Utilities.getSafeTime() - cycleStart;
            if (t < 0L) {
                t = 0L;
                cycleStart = Utilities.getSafeTime();
            }
            st = t < 80L ? 80L - t : 1L;
            do {
                try {
                    Thread.sleep(st);
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while ((st = 80L - (t = Utilities.getSafeTime() - cycleStart)) > 0L);
            if (!clientMoving) continue;
            GameMain.calculateAverageMills((int)(Tool.getSystemTime() - startTime));
        }
        SanguoMIDlet.exit();
    }

    private static void calculateAverageMills(int mills) {
        if (mills > 240 || mills < 80) {
            return;
        }
        GameMain.cycleMills[GameMain.millsPointer] = mills;
        totalMillis += cycleMills[millsPointer];
        if (++millsPointer >= 1000) {
            millsPointer = 0;
        }
        if ((averageMillis = (totalMillis -= cycleMills[millsPointer]) / 1000) > 160) {
            averageMillis = 160;
        }
    }

    public void cycle() {
        try {
            long now = Tool.getSystemTime();
            if (Utilities.connection != null && now > this.reportAliveTime + 15000L) {
                UASegment seg = new UASegment(101);
                seg.writeInt(Utilities.getServerTime());
                Utilities.sendRequest(seg);
                this.reportAliveTime = now;
            }
            resourceManager.cycle();
            this.cycleSegments();
            VMGame.cycle();
            VMCounter.cycle();
            if (!forceUpdating && !initializing) {
                world.cycle();
                GameWorld.moveMap();
                AnimateCache.processAnimateReadyQueue();
            }
            if (clientAnimates != null) {
                for (int i = 0; i < clientAnimates.length; ++i) {
                    clientAnimates[i].cycle();
                }
            }
            if (fadeEffect) {
                GameMain.cycleFadeEffect();
            }
            if (vibraEffect) {
                GameMain.cycleVibraEffect();
            }
            if (weather != null) {
                weather.cycle();
            }
            if (starPressing && ++longPressedTick > 6 && !needSelectNearestNPC) {
                needSelectNearestNPC = true;
                if (GameWorld.panel != null && GameWorld.panel.state == 3 && GameWorld.player != null) {
                    GameWorld.player.searchNearestNpc();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cycleSegments() {
        Object[] segs;
        Vector vector = Utilities.segments;
        synchronized (vector) {
            segs = new UASegment[Utilities.segments.size()];
            Utilities.segments.copyInto(segs);
            Utilities.segments.removeAllElements();
        }
        int len = segs.length;
        for (int i = 0; i < len; ++i) {
            Object segment = segs[i];
            segs[i] = null;
            try {
                this.handleSegment((UASegment)segment);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleSegment(UASegment segment) {
        if (segment.type == 102) {
            int ctime = segment.readInt();
            int stime = segment.readInt();
            Utilities.setServerTime(stime);
            long feedbackTime = Tool.getSystemTime() - this.reportAliveTime;
            if (feedbackTime < 1000L) {
                GameView.currNetColor = 0;
                return;
            }
            if (feedbackTime < 2000L) {
                GameView.currNetColor = 1;
                return;
            }
            if (feedbackTime < 4000L) {
                GameView.currNetColor = 2;
                return;
            }
            GameView.currNetColor = 3;
            return;
        }
        this.nextPacket = segment;
        try {
            if (javaWorldPacket.containsKey(new Integer(segment.type))) {
                world.processPacket();
                return;
            }
            VMGame.handleSegment(segment);
            if (segment.handled) return;
            segment.reset();
            if (world != null) {
                world.processPacket();
                return;
            }
            switch (segment.type) {
                case 189: {
                    resourceManager.recvSyncVersion(segment);
                    return;
                }
                case 2382: {
                    Tool.recvGetFile(segment);
                    return;
                }
                case 134: {
                    Tool.recvAllowGomap(segment);
                    return;
                }
            }
            return;
        }
        finally {
            this.nextPacket = null;
        }
    }

    protected void keyPressed(int keyCode) {
        if (keyCode == 42) {
            if (!starPressing) {
                longPressedTick = 0;
                starPressing = true;
            }
            return;
        }
        Utilities.keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        if (keyCode == 42) {
            starPressing = false;
            if (needSelectNearestNPC) {
                needSelectNearestNPC = false;
            } else {
                Utilities.keyPressed(keyCode);
                Utilities.keyReleased(keyCode);
            }
        }
        Utilities.keyReleased(keyCode);
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    public static void drawFadeEffect(Graphics g) {
        g.drawRGB(fadeData, 0, viewWidth, 0, 0, viewWidth, viewHeight, true);
    }

    public static void cycleFadeEffect() {
        int count = fadeData.length;
        int curColor = fadeColor | fadeCurrentAlpha << 24;
        for (int i = 0; i < count; ++i) {
            GameMain.fadeData[i] = curColor;
        }
        boolean inc = true;
        if (fadeStartAlpha > fadeEndAlpha) {
            inc = false;
        }
        fadeCurrentAlpha = inc ? (fadeCurrentAlpha += fadeAlphaStep) : (fadeCurrentAlpha -= fadeAlphaStep);
        if (inc && fadeCurrentAlpha > fadeEndAlpha || !inc && fadeCurrentAlpha < fadeEndAlpha) {
            if (++fadeCurrentCount >= fadeMaxCount) {
                fadeEffect = false;
                fadeData = null;
            } else {
                fadeCurrentAlpha = fadeStartAlpha;
            }
        }
    }

    public static void cycleVibraEffect() {
        if (tick % vibraTick == 0) {
            int dataCount = vibraData.length >> 1;
            if (GameWorld.gameView != null) {
                GameWorld.gameView.vx = vibraData[vibraCurrentIndex << 1];
                GameWorld.gameView.vy = vibraData[(vibraCurrentIndex << 1) + 1];
            }
            if (++vibraCurrentIndex >= dataCount) {
                if (++vibraCurrentCount >= vibraMaxCount) {
                    vibraEffect = false;
                    vibraData = null;
                } else {
                    vibraCurrentIndex = 0;
                }
            }
        }
    }

    static {
        sdkOneKeyEnter = false;
        averageMillis = 80;
        totalMillis = 0;
        cycleMills = new int[1000];
        millsPointer = 0;
        clientMoving = false;
        forceUpdating = false;
        needReset = false;
        resetType = 0;
        animateCacheType = 0;
        needCacheVm = new Hashtable();
        battleRemind = null;
        javaWorldPacket = new Hashtable();
        imageScalePercent = 100;
        netplayerShowMaxCount = 20;
        draw3DStringLevel = 0;
        fadeEffect = false;
        fadeData = null;
        vibraEffect = false;
        vibraData = null;
        weather = null;
        resourceManager = new ResourceManager();
        initializing = false;
        COLLISION_MAX_STEP = 10;
        COLLISION_STEP_ADD = 1;
        MAP_DATA_BUFFER_OPTIMIZE = false;
        lastSyncTime = 0L;
        inCycle = false;
        npcDownloadMode = 0;
        underDev = false;
        drawTimes = 0;
        makeTimes = 0;
        path = null;
        hadOpenCut = false;
        debugKeyOrder = new int[]{4, 3, 2, 1, 49, 50, 51};
        debugTestIndex = 0;
        debugMode = false;
        starPressing = false;
        longPressedTick = 0;
        needSelectNearestNPC = false;
        oldPointerX = -1;
        oldPointerY = -1;
    }
}

