/*
 * Decompiled with CFR 0.152.
 */
package com.pip.resource;

import com.pip.common.Tool;
import com.pip.io.UASegment;
import com.pip.resource.DatabaseFile;
import com.pip.sanguo.GameMain;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ResourceDatabase {
    private byte dbCount;
    private int dbLimit;
    private Hashtable fileTable;
    protected String[] dbNames;
    private String dbInfoName;
    private int[] dbSavedSizes;
    private int[] dbRealSize;
    private boolean supportDeleteFile;
    private boolean dirty;

    public ResourceDatabase(byte dbCount, int dbLimit, String preFix, boolean supportDeleteFile) {
        this.dbCount = dbCount;
        this.dbLimit = dbLimit;
        this.supportDeleteFile = supportDeleteFile;
        this.dirty = false;
        this.fileTable = new Hashtable();
        this.dbNames = new String[dbCount];
        this.dbInfoName = preFix + "info";
        this.dbSavedSizes = new int[dbCount];
        this.dbRealSize = new int[dbCount];
        int len = String.valueOf(dbCount).length();
        int i = 0;
        while (i < dbCount) {
            this.dbNames[i] = preFix;
            this.dbSavedSizes[i] = 0;
            this.dbRealSize[i] = 0;
            String tmp = "0000" + (i + 1);
            int n = i++;
            this.dbNames[n] = this.dbNames[n] + tmp.substring(tmp.length() - len);
        }
    }

    public synchronized void clearDatabase() {
        Tool.deleteRMSFile(this.dbInfoName);
        for (int i = 0; i < this.dbCount; ++i) {
            Tool.deleteRMSFile(this.dbNames[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean loadInformation() {
        boolean ret = false;
        this.fileTable.clear();
        for (int i = 0; i < this.dbCount; ++i) {
            this.dbSavedSizes[i] = 0;
            this.dbRealSize[i] = 0;
        }
        this.loadWholeDatabase();
        byte[] infoData = this.readInfoData(this.dbInfoName);
        if (infoData != null) {
            int infoLen = (int)UASegment.getNumber(infoData, 0, 4);
            if (infoLen != infoData.length) {
                this.clearDatabase();
            } else {
                ByteArrayInputStream bis = new ByteArrayInputStream(infoData, 4, infoData.length - 4);
                DataInputStream dis = new DataInputStream(bis);
                try {
                    String savedClientVersion = Tool.readUTF(dis);
                    if (!GameMain.getClientVersion().equals(savedClientVersion)) {
                        Tool.deleteRMSFile(this.dbInfoName);
                        for (int i = 0; i < this.dbCount; ++i) {
                            Tool.deleteRMSFile(this.dbNames[i]);
                        }
                        ret = true;
                    } else {
                        for (int i = 0; i < this.dbCount; ++i) {
                            this.dbSavedSizes[i] = dis.readInt();
                            this.dbRealSize[i] = dis.readInt();
                        }
                        int fileCount = dis.readInt();
                        for (int i = 0; i < fileCount; ++i) {
                            DatabaseFile dbFile = new DatabaseFile();
                            dbFile.name = Tool.readUTF(dis);
                            dbFile.dbId = dis.readByte();
                            dbFile.recordId = dis.readInt();
                            dbFile.version = dis.readInt();
                            this.fileTable.put(dbFile.name, dbFile);
                        }
                    }
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        if (dis != null) {
                            dis.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
        }
        this.dirty = false;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveInformation(boolean saveData) {
        if (!this.dirty) {
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeUTF(GameMain.getClientVersion());
            for (int i = 0; i < this.dbCount; ++i) {
                dos.writeInt(this.dbSavedSizes[i]);
                dos.writeInt(this.dbRealSize[i]);
            }
            dos.writeInt(this.fileTable.size());
            Enumeration emu = this.fileTable.elements();
            while (emu.hasMoreElements()) {
                DatabaseFile dbFile = (DatabaseFile)emu.nextElement();
                dos.writeUTF(dbFile.name);
                dos.writeByte(dbFile.dbId);
                dos.writeInt(dbFile.recordId);
                dos.writeInt(dbFile.version);
            }
            byte[] infoData = bos.toByteArray();
            byte[] infoData1 = new byte[infoData.length + 4];
            System.arraycopy(infoData, 0, infoData1, 4, infoData.length);
            infoData = null;
            UASegment.setNumber(infoData1.length, infoData1, 0, 4);
            this.saveInfoData(this.dbInfoName, infoData1);
            if (saveData) {
                this.saveWholeDatabase();
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (Exception e) {}
        }
        this.dirty = false;
    }

    public synchronized void saveFile(String name, byte[] data, int version) {
        if (data.length > this.dbLimit) {
            return;
        }
        DatabaseFile dbFile = (DatabaseFile)this.fileTable.get(name);
        if (dbFile != null) {
            byte by = dbFile.dbId;
            this.dbRealSize[by] = this.dbRealSize[by] - data.length;
            if (this.supportDeleteFile) {
                byte by2 = dbFile.dbId;
                this.dbSavedSizes[by2] = this.dbSavedSizes[by2] - data.length;
                this.deleteFileData(this.dbNames[dbFile.dbId], dbFile.recordId);
            }
        } else {
            dbFile = new DatabaseFile();
            dbFile.name = name;
        }
        dbFile.dbId = this.findNextDb(data.length);
        dbFile.version = version;
        dbFile.needUpdate = false;
        if (dbFile.dbId < 0) {
            dbFile.dbId = this.findWasteDb();
            this.deleteWholeFileData(this.dbNames[dbFile.dbId]);
            this.clearDbFile(dbFile.dbId);
        }
        byte by = dbFile.dbId;
        this.dbSavedSizes[by] = this.dbSavedSizes[by] + data.length;
        byte by3 = dbFile.dbId;
        this.dbRealSize[by3] = this.dbRealSize[by3] + data.length;
        dbFile.recordId = this.saveFileData(this.dbNames[dbFile.dbId], data);
        if (dbFile.recordId >= 0) {
            this.fileTable.put(name, dbFile);
        } else {
            this.fileTable.remove(name);
        }
        this.dirty = true;
    }

    public synchronized byte[] loadFile(String name) {
        byte[] result = null;
        DatabaseFile dbFile = (DatabaseFile)this.fileTable.get(name);
        if (dbFile != null && !dbFile.needUpdate) {
            result = this.readFileData(this.dbNames[dbFile.dbId], dbFile.recordId);
        }
        if (result == null) {
            result = GameMain.resourceAsynLoader.getResource(name);
        }
        return result;
    }

    public Vector getFileNameList() {
        Vector<String> result = new Vector<String>();
        Enumeration emu = this.fileTable.keys();
        while (emu.hasMoreElements()) {
            String name = (String)emu.nextElement();
            result.addElement(name);
        }
        return result;
    }

    public int getFileVersion(String name) {
        DatabaseFile dbFile = (DatabaseFile)this.fileTable.get(name);
        if (dbFile != null) {
            return dbFile.version;
        }
        return 0;
    }

    public void updateFile(String name) {
        DatabaseFile dbFile = (DatabaseFile)this.fileTable.get(name);
        if (dbFile != null) {
            dbFile.needUpdate = true;
        }
    }

    public boolean hasFile(String name) {
        DatabaseFile dbFile = (DatabaseFile)this.fileTable.get(name);
        return dbFile != null;
    }

    private byte findNextDb(int size) {
        byte result = -1;
        for (int i = 0; i < this.dbCount; ++i) {
            if (this.dbSavedSizes[i] + size > this.dbLimit) continue;
            result = (byte)i;
            break;
        }
        return result;
    }

    private byte findWasteDb() {
        byte dbId = 0;
        int maxWasteSize = 0;
        for (int i = 0; i < this.dbCount; ++i) {
            if (this.dbSavedSizes[i] - this.dbRealSize[i] <= maxWasteSize) continue;
            maxWasteSize = this.dbSavedSizes[i] - this.dbRealSize[i];
            dbId = (byte)i;
        }
        return dbId;
    }

    private void clearDbFile(int dbId) {
        Hashtable<String, DatabaseFile> restTable = new Hashtable<String, DatabaseFile>();
        Enumeration emu = this.fileTable.elements();
        while (emu.hasMoreElements()) {
            DatabaseFile dbFile = (DatabaseFile)emu.nextElement();
            if (dbFile.dbId == dbId) continue;
            restTable.put(dbFile.name, dbFile);
        }
        this.fileTable = restTable;
        this.dbSavedSizes[dbId] = 0;
        this.dbRealSize[dbId] = 0;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void truncateDatabase() {
        Tool.deleteRMSFile(this.dbInfoName);
        for (int i = 0; i < this.dbCount; ++i) {
            Tool.deleteRMSFile(this.dbNames[i]);
        }
        this.loadInformation();
    }

    protected abstract byte[] readInfoData(String var1);

    protected abstract void saveInfoData(String var1, byte[] var2);

    protected abstract byte[] readFileData(String var1, int var2);

    protected abstract int saveFileData(String var1, byte[] var2);

    protected abstract void deleteFileData(String var1, int var2);

    protected abstract void deleteWholeFileData(String var1);

    protected abstract void loadWholeDatabase();

    protected abstract void saveWholeDatabase();
}

