/*
 * Decompiled with CFR 0.152.
 */
package com.pip.image;

import com.pip.common.Tool;
import com.pip.sanguo.GameMain;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PipImage {
    private static final byte[] HEAD = new byte[]{80, 73, 80};
    private static final byte[] HEAD_E = new byte[]{80, 73, 69};
    private static final byte[] HEAD_M = new byte[]{80, 73, 77};
    private static final byte[] HEAD_C = new byte[]{80, 74, 80};
    private static final byte[] HEAD_CE = new byte[]{80, 74, 69};
    private static final byte[] PALETTE_HEAD = new byte[]{80, 76, 84, 69};
    private static final byte[] DATA_HEAD = new byte[]{68, 65, 84, 65};
    private static final byte[] DUNZ_HEAD = new byte[]{68, 85, 78, 90};
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int[] TRANS_MAP = new int[]{0, 16384, 8192, 24576, 8462, 90, 270, 8282};
    private boolean canChangeColor;
    private int[][] palette;
    private int[] frameInfo;
    private byte[][] frameData;
    private boolean mergeMode;
    private int bytesPerPixel = 1;
    private Image[] mergeImage;
    private int[] frameCollision;
    public String fileName = "";
    private Object[] buffer;
    private static final byte COLOR_OP_NONE = 0;
    private static final byte COLOR_OP_LIGHTER = 1;
    private static final byte COLOR_OP_DARKER = 2;
    private static final byte COLOR_OP_MASK = 3;
    private static final byte COLOR_OP_CHANGE = 4;
    private static final byte COLOR_OP_GRAY = 5;
    private byte nextColorOp;
    private int colorParam1;
    private int colorParam2;
    public boolean hadBind = false;
    public boolean hadUnbind = false;

    public PipImage(InputStream is) throws IOException {
        this.load(new DataInputStream(is));
        if (this.mergeMode) {
            return;
        }
        this.buffer = new Object[this.palette.length * this.frameData.length];
        for (int i = 0; i < this.palette.length; ++i) {
            for (int j = 0; j < this.frameData.length; ++j) {
                this.buffer[i * this.frameData.length + j] = this.make(i, j);
            }
        }
        this.frameData = null;
        this.palette = new int[this.palette.length][];
    }

    public boolean isMergeImage() {
        return this.mergeMode;
    }

    public Image[] getMergeImage() {
        return this.mergeImage;
    }

    public int[] getMergeFrameInfo() {
        return this.frameInfo;
    }

    public void draw(Graphics g, int frame, int x, int y, int trans) {
        this.draw(g, frame, x, y, trans, 20);
    }

    public void draw(Graphics g, int frame, int x, int y, int trans, int anchor) {
        Object drawData = this.getFrameData(frame);
        int fid = frame % this.frameInfo.length;
        int w = this.frameInfo[fid] >> 10 & 0x3FF;
        int h = this.frameInfo[fid] & 0x3FF;
        if (trans < 4) {
            if ((anchor & 1) > 0) {
                x -= w / 2;
            } else if ((anchor & 8) > 0) {
                x -= w;
            }
            if ((anchor & 2) > 0) {
                y -= h / 2;
            } else if ((anchor & 0x20) > 0) {
                y -= h;
            }
        } else {
            if ((anchor & 1) > 0) {
                x -= h / 2;
            } else if ((anchor & 8) > 0) {
                x -= h;
            }
            if ((anchor & 2) > 0) {
                y -= w / 2;
            } else if ((anchor & 0x20) > 0) {
                y -= w;
            }
        }
        if (trans == 0) {
            g.drawImage((Image)drawData, x, y, 20);
        } else {
            g.drawRegion((Image)drawData, 0, 0, w, h, trans, x, y, 20);
        }
    }

    private Object getFrameData(int frame) {
        return this.buffer[frame];
    }

    private int getArea(Object data) {
        if (data instanceof int[]) {
            return ((int[])data).length;
        }
        if (data instanceof Image[]) {
            Image[] arr = (Image[])data;
            int ret = 0;
            for (int i = 0; i < arr.length; ++i) {
                ret += arr[i].getWidth() * arr[i].getHeight();
            }
            return ret;
        }
        Image img = (Image)data;
        return img.getWidth() * img.getHeight();
    }

    private Object make(int p, int f) {
        ++GameMain.makeTimes;
        int w = this.frameInfo[f] >> 10 & 0x3FF;
        int h = this.frameInfo[f] & 0x3FF;
        int[] rgb = new int[w * h];
        int[] usePal = this.palette[p];
        byte[] useData = this.frameData[f];
        if (this.nextColorOp != 0) {
            usePal = this.performColorOp(usePal);
        }
        int id = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (this.bytesPerPixel == 1) {
                    rgb[id] = usePal[useData[id] & 0xFF];
                    ++id;
                    continue;
                }
                int clr = (useData[id * 2] & 0xFF) << 8 | useData[id * 2 + 1] & 0xFF;
                rgb[id] = usePal[clr];
                ++id;
            }
        }
        return Image.createRGBImage((int[])rgb, (int)w, (int)h, (boolean)true);
    }

    private void load(DataInputStream dis) throws IOException {
        byte[] head = new byte[3];
        dis.read(head);
        if (head[2] == HEAD_M[2]) {
            this.mergeMode = true;
            int frameDataLength = dis.readUnsignedShort();
            byte[] frameGzipData = new byte[frameDataLength];
            dis.read(frameGzipData);
            ByteArrayInputStream fbis = new ByteArrayInputStream(Tool.inflate(frameGzipData));
            DataInputStream fdis = new DataInputStream(fbis);
            int frameCount = fdis.readUnsignedByte();
            this.frameInfo = new int[frameCount * 2];
            for (int i = 0; i < frameCount; ++i) {
                int frameX = fdis.readUnsignedShort();
                int frameY = fdis.readUnsignedShort();
                int frameWidth = fdis.readUnsignedByte();
                int frameHeight = fdis.readUnsignedByte();
                this.frameInfo[i << 1] = frameX << 16 | frameY;
                this.frameInfo[(i << 1) + 1] = frameWidth << 16 | frameHeight;
            }
            fdis.close();
            int imgCount = dis.readByte() & 0xFF;
            byte[] palette = new byte[dis.readShort() & 0xFFFF];
            dis.readFully(palette);
            this.mergeImage = new Image[imgCount];
            for (int i = 0; i < imgCount; ++i) {
                int dataLen = dis.readShort() & 0xFFFF;
                byte[] pngData = new byte[palette.length + dataLen];
                dis.read(pngData, 0, 33);
                System.arraycopy(palette, 0, pngData, 33, palette.length);
                dis.read(pngData, 33 + palette.length, dataLen - 33);
                this.mergeImage[i] = Image.createImage((byte[])pngData, (int)0, (int)pngData.length);
            }
        } else {
            this.mergeMode = false;
            this.canChangeColor = head[2] == HEAD_E[2];
            this.bytesPerPixel = head[1] == HEAD_C[1] ? 2 : 1;
            int c = dis.readByte() & 0xFF;
            this.palette = new int[c][];
            for (int i = 0; i < c; ++i) {
                this.palette[i] = this.readPalette(dis);
            }
            int size = dis.readByte() & 0xFF;
            this.frameInfo = new int[size];
            this.frameData = new byte[size][];
            this.frameCollision = new int[size];
            for (int i = 0; i < size; ++i) {
                this.readFrame(dis, i);
            }
        }
    }

    public void save(DataOutputStream dos) throws IOException {
        int i;
        if (this.canChangeColor) {
            dos.write(HEAD_E);
        } else {
            dos.write(HEAD);
        }
        dos.writeByte(this.palette.length);
        for (i = 0; i < this.palette.length; ++i) {
            this.writePalette(dos, this.palette[i]);
        }
        dos.writeByte(this.frameInfo.length);
        for (i = 0; i < this.frameInfo.length; ++i) {
            this.writeFrame(dos, i);
        }
    }

    public int getWidth(int frame) {
        int ff = frame % this.frameInfo.length;
        return this.frameInfo[ff] >> 10 & 0x3FF;
    }

    public int getHeight(int frame) {
        int ff = frame % this.frameInfo.length;
        return this.frameInfo[ff] & 0x3FF;
    }

    public int getFrameCount() {
        return this.frameInfo.length * this.palette.length;
    }

    public int getBlockCount() {
        return this.frameInfo.length;
    }

    public int getPaletteCount() {
        return this.palette.length;
    }

    public void replacePalette(int index, int[] data) {
        this.palette[index] = data;
    }

    private int[] readPalette(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        int[] ret = new int[len];
        dis.skip(4L);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = dis.readInt();
        }
        return ret;
    }

    private void writePalette(DataOutputStream dos, int[] pdata) throws IOException {
        dos.writeInt(pdata.length);
        dos.write(PALETTE_HEAD);
        for (int i = 0; i < pdata.length; ++i) {
            dos.writeInt(pdata[i]);
        }
    }

    private void readFrame(DataInputStream dis, int index) throws IOException {
        int len = dis.readInt() - 6;
        byte[] head = new byte[4];
        dis.readFully(head);
        byte flip = dis.readByte();
        byte frame = dis.readByte();
        short width = dis.readShort();
        short height = dis.readShort();
        int collision = 0;
        byte c = dis.readByte();
        if (c == 1) {
            collision = dis.readInt();
        }
        byte[] data = new byte[len];
        dis.readFully(data);
        if (head[1] == 65) {
            data = Tool.inflate(data);
        }
        this.frameData[index] = data;
        this.frameInfo[index] = (flip & 7) << 28 | (frame & 0xFF) << 20 | (width & 0x3FF) << 10 | height & 0x3FF;
        this.frameCollision[index] = collision;
    }

    private void writeFrame(DataOutputStream dos, int index) throws IOException {
        dos.writeInt(this.frameData[index].length + 6);
        dos.write(DUNZ_HEAD);
        int info = this.frameInfo[index];
        dos.writeByte(info >> 28);
        dos.writeByte(info >> 20);
        dos.writeShort(info >> 10 & 0x3FF);
        dos.writeShort(info & 0x3FF);
        if (this.frameCollision[index] == 0) {
            dos.writeByte(0);
        } else {
            dos.writeByte(0);
            dos.writeInt(this.frameCollision[index]);
        }
        dos.write(this.frameData[index]);
    }

    private static final int toRGB(int a, int r, int g, int b) {
        if (a > 255) {
            a = 255;
        }
        if (a < 0) {
            a = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        if (r < 0) {
            r = 0;
        }
        if (g < 0) {
            g = 0;
        }
        if (b < 0) {
            b = 0;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static final int[] parseRGB(int rgb) {
        int aa = rgb >> 24 & 0xFF;
        int rr = rgb >> 16 & 0xFF;
        int gg = rgb >> 8 & 0xFF;
        int bb = rgb & 0xFF;
        return new int[]{aa, rr, gg, bb};
    }

    public static final int lighter(int rgb, int v) {
        int[] c = PipImage.parseRGB(rgb);
        c[1] = c[1] + v * 3;
        c[2] = c[2] + v * 3;
        c[3] = c[3] + v * 3;
        return PipImage.toRGB(c[0], c[1], c[2], c[3]);
    }

    public static final int darker(int rgb, int v) {
        int[] c = PipImage.parseRGB(rgb);
        c[1] = c[1] - v * 3;
        c[2] = c[2] - v * 3;
        c[3] = c[3] - v * 3;
        return PipImage.toRGB(c[0], c[1], c[2], c[3]);
    }

    private static final int gray(int rgb) {
        int y;
        int[] c = PipImage.parseRGB(rgb);
        c[1] = y = c[1] * 299 / 1000 + c[2] * 587 / 1000 + c[3] * 114 / 1000;
        c[2] = y;
        c[3] = y;
        return PipImage.toRGB(c[0], c[1], c[2], c[3]);
    }

    public void lighter(int value) {
        this.nextColorOp = 1;
        this.colorParam1 = value;
    }

    public void darker(int value) {
        this.nextColorOp = (byte)2;
        this.colorParam1 = value;
    }

    public void mask(int value) {
        this.nextColorOp = (byte)3;
        this.colorParam1 = value;
    }

    public void changeColor(int src, int dest) {
        this.nextColorOp = (byte)4;
        this.colorParam1 = src;
        this.colorParam2 = dest;
    }

    public void gray() {
        this.nextColorOp = (byte)5;
    }

    private int[] performColorOp(int[] pal) {
        int[] ret = new int[pal.length];
        block7: for (int i = 0; i < ret.length; ++i) {
            switch (this.nextColorOp) {
                case 1: {
                    ret[i] = PipImage.lighter(pal[i], this.colorParam1);
                    continue block7;
                }
                case 2: {
                    ret[i] = PipImage.darker(pal[i], this.colorParam1);
                    continue block7;
                }
                case 3: {
                    ret[i] = pal[i] | this.colorParam1;
                    continue block7;
                }
                case 4: {
                    if (pal[i] == this.colorParam1) {
                        ret[i] = this.colorParam2;
                        continue block7;
                    }
                    ret[i] = pal[i];
                    continue block7;
                }
                case 5: {
                    ret[i] = PipImage.gray(pal[i]);
                }
            }
        }
        this.nextColorOp = 0;
        return ret;
    }

    public static int[] transit(int[] rgb, int w, int h, int trans) {
        if (trans == 0) {
            return rgb;
        }
        int[][] ret = trans < 4 ? new int[h][w] : new int[w][h];
        int srcpos = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                switch (trans) {
                    case 1: {
                        ret[h - 1 - y][x] = rgb[srcpos];
                        break;
                    }
                    case 2: {
                        ret[y][w - 1 - x] = rgb[srcpos];
                        break;
                    }
                    case 3: {
                        ret[h - 1 - y][w - 1 - x] = rgb[srcpos];
                        break;
                    }
                    case 4: {
                        ret[x][y] = rgb[srcpos];
                        break;
                    }
                    case 5: {
                        ret[x][h - 1 - y] = rgb[srcpos];
                        break;
                    }
                    case 6: {
                        ret[w - 1 - x][y] = rgb[srcpos];
                        break;
                    }
                    case 7: {
                        ret[w - 1 - x][h - 1 - y] = rgb[srcpos];
                    }
                }
                ++srcpos;
            }
        }
        int[] ret2 = new int[w * h];
        int tarpos = 0;
        for (int i = 0; i < ret.length; ++i) {
            System.arraycopy(ret[i], 0, ret2, tarpos, ret[i].length);
            tarpos += ret[i].length;
        }
        return ret2;
    }
}

