/*
 * Decompiled with CFR 0.152.
 */
package com.pip.image;

import com.pip.common.Tool;
import com.pip.image.ImageSet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class PipAnimateSet {
    private byte version;
    private ImageSet[] sourceImages;
    private int[] frameData;
    private short[] framePos;
    private byte[] frameLen;
    private int[] animateData;
    private short[] animatePos;
    private byte[] animateLen;
    private String[] sourceImageNames;
    private boolean ready;
    private int[][] animateBox = null;
    public String fileName = "";

    public PipAnimateSet(ImageSet[] images, byte[] def) {
        this.sourceImages = images;
        try {
            this.version = (byte)(def[0] >> 6 & 3);
            this.load(new DataInputStream(new ByteArrayInputStream(def)));
            if (this.ready) {
                this.storeAnimatebox();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getMissingImage() {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.sourceImageNames.length; ++i) {
            if (this.sourceImages[i] != null) continue;
            result.addElement(this.sourceImageNames[i]);
        }
        Object[] tmp = new String[result.size()];
        result.copyInto(tmp);
        return tmp;
    }

    public ImageSet getSourceImage(int index) {
        return this.sourceImages[index];
    }

    public String[] getAllImageName() {
        return this.sourceImageNames;
    }

    public void setImage(String name, ImageSet image) {
        int i;
        for (i = 0; i < this.sourceImageNames.length; ++i) {
            if (!this.sourceImageNames[i].equals(name) || this.sourceImages[i] != null) continue;
            this.sourceImages[i] = image;
            break;
        }
        for (i = 0; i < this.sourceImages.length; ++i) {
            if (this.sourceImages[i] != null) continue;
            return;
        }
        this.ready = true;
        this.storeAnimatebox();
    }

    public boolean ready() {
        return this.ready;
    }

    private void storeAnimatebox() {
        int animateCount = this.getAnimateCount();
        this.animateBox = new int[animateCount][];
    }

    private void load(DataInputStream dis) throws IOException {
        this.framePos = new short[dis.readShort() & 0x3FFF];
        this.frameLen = new byte[this.framePos.length];
        this.frameData = this.readIntArray(dis, this.framePos, this.frameLen);
        this.animatePos = new short[dis.readByte() & 0xFF];
        this.animateLen = new byte[this.animatePos.length];
        this.animateData = this.readIntArray(dis, this.animatePos, this.animateLen);
        this.sourceImageNames = this.readStringArray(dis, true);
        if (this.sourceImages == null) {
            this.sourceImages = new ImageSet[this.sourceImageNames.length];
        } else {
            this.ready = true;
        }
    }

    private String[] readStringArray(DataInputStream dis, boolean byteLength) throws IOException {
        int count = byteLength ? dis.readByte() & 0xFF : dis.readShort() & 0xFFFF;
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = Tool.readUTF(dis);
        }
        return ret;
    }

    private int[] readIntArray(DataInputStream dis, short[] start, byte[] len) throws IOException {
        int count = start.length;
        int[][] ret = new int[count][];
        int pos = 0;
        for (int i = 0; i < count; ++i) {
            int count2 = dis.readByte() & 0xFF;
            start[i] = (short)pos;
            len[i] = (byte)count2;
            ret[i] = new int[count2];
            for (int j = 0; j < count2; ++j) {
                ret[i][j] = dis.readInt();
            }
            pos += count2;
        }
        int[] ret2 = new int[pos];
        pos = 0;
        for (int i = 0; i < count; ++i) {
            System.arraycopy(ret[i], 0, ret2, pos, ret[i].length);
            pos += ret[i].length;
        }
        return ret2;
    }

    public void drawFrame(Graphics g, int frame, int x, int y) {
        int start = this.framePos[frame];
        int len = this.frameLen[frame] & 0xFF;
        for (int i = start; i < start + len; ++i) {
            int dy;
            int dx;
            int transition;
            int iframe;
            int imageID;
            int pd = this.frameData[i];
            if (this.version == 0) {
                imageID = pd >> 29 & 7;
                iframe = pd >> 21 & 0xFF;
                transition = pd >> 18 & 7;
                dx = pd >> 9 & 0x1FF;
                if (dx > 255) {
                    dx -= 512;
                }
                if ((dy = pd & 0x1FF) > 255) {
                    dy -= 512;
                }
            } else {
                if (this.version != 1) continue;
                imageID = pd >> 27 & 0x1F;
                iframe = pd >> 19 & 0xFF;
                transition = pd >> 16 & 7;
                dx = pd >> 8 & 0xFF;
                if (dx > 127) {
                    dx -= 256;
                }
                if ((dy = pd & 0xFF) > 127) {
                    dy -= 256;
                }
            }
            this.sourceImages[imageID].drawFrame(g, iframe, x + dx, y + dy, transition);
        }
    }

    public void drawAnimateFrame(Graphics g, int index, int time, int x, int y) {
        int start = this.animatePos[index];
        int len = this.animateLen[index] & 0xFF;
        int tick = 0;
        for (int i = start; i < start + len; ++i) {
            int aniData = this.animateData[i];
            int delay = aniData & 0xF;
            if (time >= tick && time < tick + delay) {
                int dy;
                int fr = aniData >> 24 & 0xFF;
                int dx = aniData >> 14 & 0x3FF;
                if (dx > 511) {
                    dx -= 1024;
                }
                if ((dy = aniData >> 4 & 0x3FF) > 511) {
                    dy -= 1024;
                }
                this.drawFrame(g, fr, x + dx, y + dy);
                break;
            }
            tick += delay;
        }
    }

    public void drawFrameWithOffset(Graphics g, int frame, int x, int y, int[][] drawOffset, ImageSet[] replaceImages) {
        int start = this.framePos[frame];
        int len = this.frameLen[frame] & 0xFF;
        for (int i = start; i < start + len; ++i) {
            int dy;
            int dx;
            int transition;
            int iframe;
            int imageID;
            int pd = this.frameData[i];
            if (this.version == 0) {
                imageID = pd >> 29 & 7;
                iframe = pd >> 21 & 0xFF;
                transition = pd >> 18 & 7;
                dx = pd >> 9 & 0x1FF;
                if (dx > 255) {
                    dx -= 512;
                }
                if ((dy = pd & 0x1FF) > 255) {
                    dy -= 512;
                }
            } else {
                if (this.version != 1) continue;
                imageID = pd >> 27 & 0x1F;
                iframe = pd >> 19 & 0xFF;
                transition = pd >> 16 & 7;
                dx = pd >> 8 & 0xFF;
                if (dx > 127) {
                    dx -= 256;
                }
                if ((dy = pd & 0xFF) > 127) {
                    dy -= 256;
                }
            }
            if (drawOffset[imageID] == null) {
                this.sourceImages[imageID].drawFrame(g, iframe, x + dx, y + dy, transition);
                continue;
            }
            ImageSet targetImage = this.sourceImages[imageID];
            short targetImageId = (short)(drawOffset[imageID][iframe] >> 16);
            short targetFrameOffset = (short)(drawOffset[imageID][iframe] & 0xFFFF);
            if (targetFrameOffset < 0) continue;
            iframe += targetFrameOffset;
            if (targetImageId >= 0) {
                targetImage = replaceImages[targetImageId];
            }
            targetImage.drawFrame(g, iframe, x + dx, y + dy, transition);
        }
    }

    public void drawAnimateFrameWithOffset(Graphics g, int index, int time, int x, int y, int[][] drawOffset, ImageSet[] replaceImages) {
        int start = this.animatePos[index];
        int len = this.animateLen[index] & 0xFF;
        int tick = 0;
        for (int i = start; i < start + len; ++i) {
            int aniData = this.animateData[i];
            int delay = aniData & 0xF;
            if (time >= tick && time < tick + delay) {
                int dy;
                int fr = aniData >> 24 & 0xFF;
                int dx = aniData >> 14 & 0x3FF;
                if (dx > 511) {
                    dx -= 1024;
                }
                if ((dy = aniData >> 4 & 0x3FF) > 511) {
                    dy -= 1024;
                }
                this.drawFrameWithOffset(g, fr, x + dx, y + dy, drawOffset, replaceImages);
                break;
            }
            tick += delay;
        }
    }

    public int getAnimateLength(int index) {
        int start = this.animatePos[index];
        int len = this.animateLen[index] & 0xFF;
        int ret = 0;
        for (int i = start; i < start + len; ++i) {
            ret += this.animateData[i] & 0xF;
        }
        return ret;
    }

    public int getAnimateCount() {
        return this.animatePos.length;
    }

    public int[] getAnimateBox(int[] box, int index) {
        System.arraycopy(this.getAnimateSize(index), 0, box, 0, 4);
        return box;
    }

    public int[] getAnimateSize(int index) {
        if (this.animateBox[index] != null) {
            return this.animateBox[index];
        }
        this.animateBox[index] = new int[4];
        int start = this.animatePos[index];
        int len = this.animateLen[index] & 0xFF;
        for (int i = start; i < start + len; ++i) {
            int dy;
            int aniData = this.animateData[i];
            int fr = aniData >> 24 & 0xFF;
            int[] frameBox = this.getFrameSize(fr);
            int dx = aniData >> 14 & 0x3FF;
            if (dx > 511) {
                dx -= 1024;
            }
            if ((dy = aniData >> 4 & 0x3FF) > 511) {
                dy -= 1024;
            }
            frameBox[0] = frameBox[0] + dx;
            frameBox[1] = frameBox[1] + dy;
            Tool.mergeBox(this.animateBox[index], frameBox);
        }
        return this.animateBox[index];
    }

    private int[] getFrameSize(int frame) {
        int start = this.framePos[frame];
        int len = this.frameLen[frame] & 0xFF;
        int[] box = new int[4];
        for (int i = start; i < start + len; ++i) {
            int dy;
            int dx;
            int transition;
            int iframe;
            int imageID;
            int pd = this.frameData[i];
            if (this.version == 0) {
                imageID = pd >> 29 & 7;
                iframe = pd >> 21 & 0xFF;
                transition = pd >> 18 & 7;
                dx = pd >> 9 & 0x1FF;
                if (dx > 255) {
                    dx -= 512;
                }
                if ((dy = pd & 0x1FF) > 255) {
                    dy -= 512;
                }
            } else {
                if (this.version != 1) continue;
                imageID = pd >> 27 & 0x1F;
                iframe = pd >> 19 & 0xFF;
                transition = pd >> 16 & 7;
                dx = pd >> 8 & 0xFF;
                if (dx > 127) {
                    dx -= 256;
                }
                if ((dy = pd & 0xFF) > 127) {
                    dy -= 256;
                }
            }
            int anchor = 20;
            int w = this.sourceImages[imageID].getFrameWidth(iframe);
            int h = this.sourceImages[imageID].getFrameHeight(iframe);
            if (transition < 4) {
                if ((anchor & 1) > 0) {
                    dx -= w / 2;
                } else if ((anchor & 8) > 0) {
                    dx -= w;
                }
                if ((anchor & 2) > 0) {
                    dy -= h / 2;
                } else if ((anchor & 0x20) > 0) {
                    dy -= h;
                }
            } else {
                if ((anchor & 1) > 0) {
                    dx -= h / 2;
                } else if ((anchor & 8) > 0) {
                    dx -= h;
                }
                if ((anchor & 2) > 0) {
                    dy -= w / 2;
                } else if ((anchor & 0x20) > 0) {
                    dy -= w;
                }
            }
            if (box[2] == 0) {
                box[0] = dx;
                box[1] = dy;
                box[2] = w;
                box[3] = h;
                continue;
            }
            int ox = box[0];
            int oy = box[1];
            box[0] = box[0] < dx ? box[0] : dx;
            box[1] = box[1] < dy ? box[1] : dy;
            box[2] = (ox + box[2] > dx + w ? ox + box[2] : dx + w) - box[0];
            box[3] = (oy + box[3] > dy + h ? oy + box[3] : dy + h) - box[1];
        }
        return box;
    }

    public int getImageFrameCount(int imageId) {
        return this.sourceImages[imageId].getFrameCount();
    }

    public void changeImageSet(int imageId, ImageSet imageSet) {
        this.sourceImages[imageId] = imageSet;
    }

    public int getImageCount() {
        return this.sourceImages.length;
    }
}

