/*
 * Decompiled with CFR 0.152.
 */
package com.pip.gui;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.gui.GWidget;
import com.pip.gui.IGCycle;
import com.pip.gui.IGPaint;
import com.pip.image.ImageSet;
import com.pip.sanguo.GameMain;
import com.pip.ui.VMGame;
import javax.microedition.lcdui.Font;

public class GLabel
extends GWidget
implements IGPaint,
IGCycle {
    String label;
    public boolean is3d;
    public int color;
    public int bgColor;
    public int anchor;
    public int[] colors;
    ImageSet cornerRes;
    public int index;
    boolean needExecuteCycle;
    boolean needScroll;
    int strWidth;
    int speed = 3;
    boolean isMixStr;
    boolean isChangeShow;
    int scrollOffset;
    boolean isRightScroll;
    boolean singleDirScroll = true;

    public GLabel(VMGame _vmGame, int self, int[] vmData, String name) {
        super(_vmGame, self, vmData, name);
    }

    public GWidget getClone(VMGame _vmGame) {
        GLabel gLabel = new GLabel(_vmGame, 0, this.getVMDataCopy(), this.name);
        this.setCloneData(gLabel);
        gLabel.label = this.label;
        gLabel.is3d = this.is3d;
        gLabel.color = this.color;
        gLabel.bgColor = this.bgColor;
        gLabel.anchor = this.anchor;
        gLabel.cornerRes = this.cornerRes;
        gLabel.index = this.index;
        gLabel.needExecuteCycle = gLabel.needExecuteCycle;
        gLabel.needScroll = this.needScroll;
        gLabel.strWidth = this.strWidth;
        gLabel.speed = this.speed;
        gLabel.isMixStr = this.isMixStr;
        gLabel.isChangeShow = this.isChangeShow;
        gLabel.scrollOffset = this.scrollOffset;
        gLabel.isRightScroll = this.isRightScroll;
        gLabel.singleDirScroll = this.singleDirScroll;
        if (this.colors != null) {
            gLabel.colors = new int[this.colors.length];
            System.arraycopy(this.colors, 0, gLabel.colors, 0, gLabel.colors.length);
        }
        return gLabel;
    }

    public void setData(String label, boolean is3d, int color, int bgColor, int anchor) {
        this.label = label;
        this.is3d = is3d;
        this.color = color;
        this.bgColor = bgColor;
        this.anchor = anchor;
        this.resetSize();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.resetSize();
    }

    public void setBounds(int _x, int _y, int _w, int _h) {
        super.setBounds(_x, _y, _w, _h);
        this.setScroll();
    }

    private void setScroll() {
        this.needScroll = this.vmData[5] - this.vmData[9] - this.vmData[11] < this.strWidth;
    }

    public void setBack(int[] colors, String cornerResName, int index) {
        this.colors = colors;
        if (cornerResName != null) {
            this.cornerRes = (ImageSet)Tool.getGlobalObject(cornerResName);
            this.index = index;
        }
    }

    public String getText() {
        return this.label;
    }

    public void setText(String text) {
        this.label = text;
        if (this.isMixStr) {
            this.setIsMixStr(this.isMixStr);
        } else {
            this.resetSize();
        }
        if (this.isChangeShow && this.strWidth > this.vmData[5]) {
            int defStrWidth = this.font.stringWidth("...");
            String[] showStrs = Tool.formatText(this.label, this.vmData[5] - defStrWidth, Utilities.font);
            this.label = showStrs[0] + "...";
        }
        this.setScroll();
    }

    private void resetSize() {
        if (this.is3d) {
            this.vmData[16] = Tool.get3DStringHeightEx(this.font);
            this.vmData[14] = Tool.get3DStringWidthEx(this.label, this.font);
        } else {
            this.vmData[16] = this.font.getHeight();
            this.vmData[14] = this.font.stringWidth(this.label);
        }
        this.strWidth = this.vmData[14];
    }

    public void setIsMixStr(boolean isMixStr) {
        this.isMixStr = isMixStr;
        if (this.label != null) {
            this.vmData[14] = Tool.drawMixedText(null, this.label, 0, 0, 0, 0, true, 0);
            this.strWidth = this.vmData[14];
        }
    }

    public void setIsChangeShow(boolean isChangeShow, int maxWidth) {
        this.isChangeShow = isChangeShow;
        this.vmData[5] = maxWidth;
        if (this.label != null) {
            if (this.strWidth < 0) {
                if (this.isMixStr) {
                    this.vmData[14] = Tool.drawMixedText(null, this.label, 0, 0, 0, 0, true, 0);
                    this.strWidth = this.vmData[14];
                } else {
                    this.resetSize();
                }
            }
            if (this.strWidth > this.vmData[5]) {
                int defStrWidth = this.font.stringWidth("...");
                String[] showStrs = Tool.formatText(this.label, this.vmData[5] - defStrWidth, Utilities.font);
                this.label = showStrs[0] + "...";
            }
        }
    }

    public void paint() {
        if (this.parentNeedScroll()) {
            this.getIntersect(this.rect);
            Utilities.graphics.setClip(this.rect[0], this.rect[1], this.rect[2], this.rect[3]);
        } else {
            this.rect[0] = 0;
            this.rect[1] = 0;
            this.rect[2] = GameMain.viewWidth;
            this.rect[3] = GameMain.viewHeight;
        }
        if (this.colors != null) {
            Tool.drawFrameBox(Utilities.graphics, this.vmData[7], this.vmData[8], this.vmData[5], this.vmData[6], this.colors);
        }
        if (this.cornerRes != null) {
            Tool.drawBoxCorner(Utilities.graphics, this.vmData[7], this.vmData[8], this.vmData[5], this.vmData[6], this.cornerRes, this.index);
        }
        if (this.label != null) {
            int _x = this.vmData[31];
            int _y = this.vmData[32];
            int _w = this.vmData[5] - this.vmData[9] - this.vmData[11];
            int _h = this.vmData[6] - this.vmData[10] - this.vmData[12];
            int realAnchor = this.anchor;
            switch (this.anchor) {
                case 17: {
                    _x += this.scrollOffset + this.vmData[7] + this.vmData[9] + _w / 2;
                    _y += this.vmData[8] + this.vmData[10];
                    break;
                }
                case 3: {
                    _x += this.scrollOffset + this.vmData[7] + this.vmData[9] + _w / 2;
                    _y += this.vmData[8] + this.vmData[10] + (_h - this.font.getHeight()) / 2;
                    realAnchor = 17;
                    break;
                }
                case 6: {
                    _x += this.scrollOffset + this.vmData[7] + this.vmData[9];
                    _y += this.vmData[8] + this.vmData[10];
                    break;
                }
                default: {
                    _x += this.scrollOffset + this.vmData[7] + this.vmData[9];
                    _y += this.vmData[8] + this.vmData[10];
                }
            }
            Tool.rectGetIntersection(this.rect[0], this.rect[1], this.rect[2], this.rect[3], this.vmData[31] + this.vmData[7] + this.vmData[9], this.vmData[32] + this.vmData[8] + this.vmData[10], _w, _h, this.rect);
            if (this.needExecuteCycle && this.needScroll) {
                Utilities.graphics.setClip(this.rect[0], this.rect[1], this.rect[2], this.rect[3]);
            }
            Utilities.graphics.setFont(this.font);
            if (this.isMixStr) {
                Tool.drawMixedText(Utilities.graphics, this.label, _x, _y, this.color, this.bgColor, this.is3d, realAnchor, this.font);
            } else if (this.is3d) {
                Tool.draw3DString2(Utilities.graphics, this.label, _x, _y, this.color, this.bgColor, realAnchor);
            } else {
                Utilities.graphics.setColor(this.color);
                Utilities.graphics.drawString(this.label, _x, _y, realAnchor);
            }
            Utilities.graphics.setClip(0, 0, GameMain.viewWidth, GameMain.viewHeight);
            Utilities.graphics.setFont(Utilities.font);
        }
    }

    public void cycle() {
        if (this.needExecuteCycle && this.needScroll) {
            this.computeScroll();
        }
    }

    private void computeScroll() {
        if (this.isRightScroll) {
            if (this.scrollOffset > 5) {
                this.isRightScroll = false;
            } else {
                this.scrollOffset += this.speed;
            }
        } else if (!this.singleDirScroll && this.scrollOffset < this.vmData[5] - this.strWidth - this.vmData[9] - this.vmData[11] - 5) {
            this.isRightScroll = true;
        } else {
            this.scrollOffset -= this.speed;
            if (this.scrollOffset + this.strWidth < 0 && this.singleDirScroll) {
                this.scrollOffset = this.vmData[5] - this.vmData[9] - this.vmData[11];
            }
        }
    }

    public boolean needExecuteCycle() {
        return this.needExecuteCycle && this.needScroll;
    }

    public void setNeedExecuteCycle(boolean needExecuteCycle) {
        this.needExecuteCycle = needExecuteCycle;
        if (!needExecuteCycle) {
            this.resetOffSet();
        }
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void resetOffSet() {
        this.scrollOffset = 0;
    }

    public boolean isSingleDirScroll() {
        return this.singleDirScroll;
    }

    public void setSingleDirScroll(boolean singleDirScroll) {
        this.singleDirScroll = singleDirScroll;
    }

    public void setOffsetScale(int scale) {
        this.scrollOffset = (this.vmData[5] - this.vmData[9] - this.vmData[11]) * scale / 100;
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }
}

