/*
 * Decompiled with CFR 0.152.
 */
package com.pip.engine;

import com.pip.common.Tool;
import com.pip.common.Utilities;
import com.pip.engine.AnimatePlayer;
import com.pip.engine.FlyingStringInfo;
import com.pip.engine.IAnimateCallback;
import com.pip.image.ImageSet;
import com.pip.sanguo.GameMain;
import com.pip.sanguo.GameRole;
import com.pip.sanguo.GameSprite;
import com.pip.sanguo.GameWorld;
import com.pip.util.SortHashtable;
import com.pip.util.VMCounter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Sprite {
    private Vector animateList = new Vector();
    private Hashtable animateTable = new Hashtable();
    private int x = -1000;
    private int y;
    private byte dir;
    private byte animateSubDir;
    private byte animateDir;
    private short speed;
    private short speedAddon;
    private boolean moving;
    private boolean showing;
    private boolean working;
    private boolean collision;
    private int[] animateBox = new int[4];
    private Vector headStrings = new Vector();
    private int[] headStringConfig = new int[6];
    private boolean headStringShow;
    private int headStringHeight;
    private Vector flyingStrings = new Vector();
    private Vector flyingStringQueue = new Vector();
    private Vector vibras = new Vector();
    private int mapId = -1;
    private int mapInstanceId = -1;
    private int currentStep;
    private int currentStep100;
    private boolean playingAnimate;
    public int movedStep;
    protected boolean needMakeAnimateBox = false;
    protected int[] realAnimateBox = new int[4];
    private int bubbleCounterKey = -1;
    public String[] bubbleBuffer = null;
    public static final int RES_UI_TIP_ARROW = 13;
    public static final int RES_UI_TIP_TOPRIGHT = 14;
    public static int HP_BAR_WIDTH = 20;
    public static int HP_BAR_HEIGHT = 3;
    private static int needNotDrawHpMp = -1;
    private int isMyAttendant = -1;
    public WayPointInfo wayPointInfo = new WayPointInfo();

    public int getMapInstanceId() {
        return this.mapInstanceId;
    }

    public void setMapInstanceId(int mapInstanceId) {
        this.mapInstanceId = mapInstanceId;
    }

    public Sprite(GameSprite ownerSprite) {
        this.wayPointInfo.ownerSprite = ownerSprite;
    }

    public byte getDir() {
        return this.dir;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = (short)speed;
    }

    public int getSpeedAddon() {
        return this.speedAddon;
    }

    public void setSpeedAddon(int speedAddon) {
        this.speedAddon = (short)speedAddon;
        if (speedAddon <= -100) {
            speedAddon = -99;
        }
    }

    public void setHeadStringShow(boolean show) {
        this.headStringShow = show;
    }

    public AnimatePlayer getAnimatePlayer(String animateName) {
        return (AnimatePlayer)this.animateTable.get(animateName);
    }

    public void addAnimate(AnimatePlayer animateData) {
        if (!this.animateTable.containsKey(animateData.getAnimateName())) {
            this.animateList.addElement(animateData);
            this.animateTable.put(animateData.getAnimateName(), animateData);
        }
    }

    public void removeAnimate(String animateName) {
        this.animateTable.remove(animateName);
        int count = this.animateList.size();
        int idx = -1;
        for (int i = 0; i < count; ++i) {
            AnimatePlayer animatePlayer = (AnimatePlayer)this.animateList.elementAt(i);
            if (!animatePlayer.getAnimateName().equals(animateName)) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            this.animateList.removeElementAt(idx);
        }
    }

    public Vector getAllAnimateNames() {
        Vector result = new Vector();
        Enumeration emu = this.animateTable.keys();
        while (emu.hasMoreElements()) {
            result.addElement(emu.nextElement());
        }
        return result;
    }

    public boolean isHumanAnimate(String animateName) {
        AnimatePlayer tmp = (AnimatePlayer)this.animateTable.get(animateName);
        if (tmp != null) {
            return tmp.isHunmanAnimate();
        }
        return false;
    }

    public AnimatePlayer getIconAnimate() {
        AnimatePlayer result = null;
        for (int i = 0; i < this.animateList.size(); ++i) {
            AnimatePlayer animate = (AnimatePlayer)this.animateList.elementAt(i);
            if (!animate.isShown() || animate.isNotIcon()) continue;
            result = animate;
            break;
        }
        return result;
    }

    public void showAnimate(String animateName) {
        AnimatePlayer tmp = (AnimatePlayer)this.animateTable.get(animateName);
        if (tmp != null) {
            tmp.setShown(true);
        }
    }

    public void hideAnimate(String animateName) {
        AnimatePlayer tmp = (AnimatePlayer)this.animateTable.get(animateName);
        if (tmp != null) {
            tmp.setShown(false);
        }
    }

    public void setAnimateNotIcon(String animateName) {
        AnimatePlayer tmp = (AnimatePlayer)this.animateTable.get(animateName);
        if (tmp != null) {
            tmp.setNotIcon(true);
        }
    }

    public void setAnimateLayer(String animateName, int layer) {
        AnimatePlayer tmp = (AnimatePlayer)this.animateTable.get(animateName);
        if (tmp != null) {
            tmp.setLayer(layer);
        }
    }

    public void regroupAnimate() {
        int size = this.animateList.size();
        for (int i = 0; i < size - 1; ++i) {
            AnimatePlayer p1 = (AnimatePlayer)this.animateList.elementAt(i);
            for (int j = i + 1; j < size; ++j) {
                AnimatePlayer p2 = (AnimatePlayer)this.animateList.elementAt(j);
                if (p1.getLayer() <= p2.getLayer()) continue;
                this.animateList.setElementAt(p1, j);
                this.animateList.setElementAt(p2, i);
                p1 = p2;
            }
        }
    }

    public boolean hasAnimate(String animateName) {
        return this.animateTable.get(animateName) != null;
    }

    public void setAnimateIndex(String animateName, int index, int playType, int callBackIndex, Object callBackParams, boolean whole) {
        if (whole) {
            int size = this.animateList.size();
            for (int i = 0; i < size; ++i) {
                AnimatePlayer tmp = (AnimatePlayer)this.animateList.elementAt(i);
                tmp.setAnimate(index, playType, callBackIndex, (IAnimateCallback)callBackParams);
            }
        } else {
            AnimatePlayer tmp = (AnimatePlayer)this.animateTable.get(animateName);
            if (tmp != null) {
                tmp.setAnimate(index, playType, callBackIndex, (IAnimateCallback)callBackParams);
            }
        }
        this.needMakeAnimateBox = true;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int[] getPosition(int boxCount) {
        if (this.needMakeAnimateBox) {
            this.makeAnimateBox();
        }
        int px = this.x + Tool.calulateStepWithBackMatrix((byte)0, this.dir, this.animateBox[2]) * boxCount;
        int py = this.y + Tool.calulateStepWithBackMatrix((byte)1, this.dir, this.animateBox[3]) * boxCount;
        return new int[]{this.dir, px, py};
    }

    public void setDir(int dir) {
        this.dir = (byte)dir;
    }

    public int getAnimateDir() {
        return this.animateDir;
    }

    public void setAnimateDir(int animateDir) {
        this.animateDir = (byte)animateDir;
    }

    public int getAnimateSubDir() {
        return this.animateSubDir;
    }

    public void setAnimateSubDir(int subDir) {
        this.animateSubDir = (byte)subDir;
    }

    public void setMove(boolean moving) {
        this.moving = moving;
    }

    public boolean getMove() {
        return this.moving;
    }

    public void setShow(boolean showing) {
        this.showing = showing;
    }

    public void setWork(boolean working) {
        this.working = working;
    }

    public void setCollision(boolean collision) {
        this.collision = collision;
    }

    public void setHeadStringConfig(int[] config) {
        this.headStringConfig = config;
    }

    public void addHeadString(String str, int color, ImageSet image, int[] imageIndex) {
        this.headStrings.addElement(new Object[]{str, new Integer(color), image, imageIndex});
    }

    public void clearHeadString() {
        this.headStrings.removeAllElements();
    }

    public int getHeadStringHeight() {
        return this.headStringHeight;
    }

    public void setAnimateImageDrawOffset(String animateName, int imageId, int index, int replaceImageId, int replaceOffset) {
        AnimatePlayer tmp = new AnimatePlayer(animateName);
        tmp = (AnimatePlayer)this.animateTable.get(animateName);
        if (tmp != null) {
            tmp.setAnimateImageDrawOffset(imageId, index, replaceImageId, replaceOffset);
        }
    }

    public void addReplaceAnimateImage(String animateName, String imageName) {
        AnimatePlayer tmp = (AnimatePlayer)this.animateTable.get(animateName);
        if (tmp != null) {
            tmp.addReplaceAnimateImage(imageName);
        }
    }

    public void addFlyingString(byte type, String str, int number, int paletteColor, int distance, int time, int order, int delayTick) {
        FlyingStringInfo fly = new FlyingStringInfo();
        fly.type = type;
        if (fly.type == 0) {
            fly.number = number;
        } else {
            fly.str = str;
        }
        fly.color = paletteColor;
        fly.distance = distance;
        fly.time = time;
        fly.order = order;
        fly.delayTick = delayTick;
        this.addFlyingData(fly);
    }

    public void addFlyingString(byte type, String str, int number, int paletteColor, int dir, int hCycleCount, int hSpeed, int stopCycleCount, int vCycleCount, int vSpeed, int order, int delayTick) {
        FlyingStringInfo fly = new FlyingStringInfo();
        fly.type = type;
        if (fly.type == 0) {
            fly.number = number;
        } else {
            fly.str = str;
        }
        fly.dir = dir;
        fly.color = paletteColor;
        fly.hCycleCount = hCycleCount;
        fly.hSpeed = hSpeed;
        fly.stopCycleCount = stopCycleCount;
        fly.vCycleCount = vCycleCount;
        fly.vSpeed = vSpeed;
        fly.order = order;
        fly.isAcross = true;
        fly.time = hCycleCount + vCycleCount + stopCycleCount;
        fly.delayTick = delayTick;
        this.addFlyingData(fly);
    }

    private void addFlyingData(FlyingStringInfo fly) {
        FlyingStringInfo tmp;
        int i;
        boolean found = false;
        int count = this.flyingStrings.size();
        for (i = 0; i < count; ++i) {
            tmp = (FlyingStringInfo)this.flyingStrings.elementAt(i);
            if (!tmp.equals(fly)) continue;
            found = true;
            break;
        }
        count = this.flyingStringQueue.size();
        for (i = 0; i < count; ++i) {
            tmp = (FlyingStringInfo)((Object[])this.flyingStringQueue.elementAt(i))[0];
            if (!tmp.equals(fly)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.flyingStringQueue.addElement(new Object[]{fly, new Integer(GameMain.spriteFlyingStringDelay)});
        }
    }

    public void addBubble(String text, int time) {
        this.bubbleBuffer = null;
        this.bubbleBuffer = Tool.splitString(text, '\n');
        if (this.bubbleCounterKey != -1) {
            VMCounter.removeVMCounter(this.bubbleCounterKey);
        }
        this.bubbleCounterKey = VMCounter.createVMCounter(time);
    }

    public void drawBubble(Graphics g, int screenX, int screenY, boolean isTop) {
        if (this.needMakeAnimateBox) {
            this.makeAnimateBox();
        }
        GameWorld.gameView.addPendingBubble(this.bubbleBuffer, screenX, screenY - this.animateBox[3] - this.headStrings.size() * Utilities.CHAR_HEIGHT, isTop);
    }

    public void addVibar(int dir, int time, int distance) {
        int[] tmp = new int[]{dir, time, distance, 0};
        this.vibras.addElement(tmp);
    }

    private void drawHeadString(Graphics g, int screenX, int screenY, boolean pending, boolean isTop) {
        if (this.headStringShow) {
            if (this.needMakeAnimateBox) {
                this.makeAnimateBox();
            }
            int size = this.headStrings.size();
            int headx = screenX;
            int heady = screenY;
            switch (this.headStringConfig[0]) {
                case 0: {
                    headx = this.animateBox[2] / 2 + screenX + this.animateBox[0] + this.headStringConfig[3];
                    heady = this.animateBox[1] + screenY + this.headStringConfig[4];
                    break;
                }
                case 1: {
                    headx = screenX + this.headStringConfig[3];
                    heady = screenY + this.headStringConfig[4];
                    break;
                }
                case 2: {
                    headx = screenX + this.headStringConfig[3];
                    heady = this.animateBox[1] + screenY + this.headStringConfig[4];
                }
            }
            for (int i = 0; i < size; ++i) {
                Object[] tmp = (Object[])this.headStrings.elementAt(i);
                String str = (String)tmp[0];
                int color = (Integer)tmp[1];
                ImageSet strImage = (ImageSet)tmp[2];
                int[] imgIndexs = (int[])tmp[3];
                int subx = headx - Utilities.font.stringWidth(str) / 2;
                int line = Utilities.CHAR_HEIGHT;
                if (strImage != null) {
                    for (int j = 0; j < imgIndexs.length; ++j) {
                        int index1 = imgIndexs[j] >> 16;
                        int index2 = imgIndexs[j] & 0xFFFF;
                        subx -= strImage.getFrameWidth(index2);
                        line = Math.max(Utilities.CHAR_HEIGHT, strImage.getFrameHeight(index2));
                        if (pending) {
                            if (index1 >= 0) {
                                GameWorld.gameView.addPendingImage(strImage, index1, subx, heady - line / 2, 6, isTop);
                            }
                            GameWorld.gameView.addPendingImage(strImage, index2, subx, heady - line / 2, 6, isTop);
                            continue;
                        }
                        if (index1 >= 0) {
                            strImage.drawFrame(g, index1, subx, heady - line / 2, 0, 6);
                        }
                        strImage.drawFrame(g, index2, subx, heady - line / 2, 0, 6);
                    }
                    subx = headx - Utilities.font.stringWidth(str) / 2;
                }
                switch (this.headStringConfig[2]) {
                    case 0: {
                        if (pending) {
                            GameWorld.gameView.addPendingHeadString(str, subx, heady, color, 0, 36, true, isTop);
                            break;
                        }
                        Tool.draw3DString(g, str, subx, heady, color, 0, 36);
                        break;
                    }
                    case 1: {
                        if (pending) {
                            GameWorld.gameView.addPendingHeadString(str, subx, heady, color, 0, 36, false, isTop);
                            break;
                        }
                        g.setColor(color);
                        Tool.drawString(g, str, subx, heady, 36);
                    }
                }
                heady -= line + this.headStringConfig[1];
            }
            this.headStringHeight = screenY + this.animateBox[1] - heady;
        } else {
            this.headStringHeight = 0;
        }
    }

    private void drawFlyString(Graphics g, int screenX, int screenY, boolean isBack) {
        int size = this.flyingStrings.size();
        Vector<FlyingStringInfo> remainFlyingNumbers = new Vector<FlyingStringInfo>();
        for (int i = 0; i < size; ++i) {
            FlyingStringInfo fly = (FlyingStringInfo)this.flyingStrings.elementAt(i);
            int flyX = screenX;
            int flyY = screenY;
            if (fly.delayTick > 0) {
                remainFlyingNumbers.addElement(fly);
                continue;
            }
            if (isBack && fly.order != 2) {
                remainFlyingNumbers.addElement(fly);
                continue;
            }
            if (fly.order == 0) {
                GameWorld.gameView.addPendingFlyString(fly, flyX, flyY, false);
            } else if (fly.order == 3) {
                GameWorld.gameView.addPendingFlyString(fly, flyX, flyY, true);
            } else if (fly.isAcross) {
                if (fly.calculate <= fly.hCycleCount) {
                    fly.drawFlying(g, flyX += fly.hSpeed * fly.calculate * fly.dir, flyY -= fly.hSpeed * fly.calculate, fly.number, fly.color, 0, 0, 0);
                } else if (fly.calculate - fly.hCycleCount < fly.stopCycleCount) {
                    fly.drawFlying(g, flyX += fly.hSpeed * fly.hCycleCount * fly.dir, flyY -= fly.hSpeed * fly.hCycleCount, fly.number, fly.color, 0, 0, 0);
                } else {
                    int vCycleCount = fly.calculate - fly.hCycleCount - fly.stopCycleCount;
                    flyY = flyY - fly.hSpeed * fly.hCycleCount - fly.vSpeed * vCycleCount;
                    fly.drawFlying(g, flyX += fly.hSpeed * fly.hCycleCount * fly.dir, flyY, fly.number, fly.color, 0, 0, 0);
                }
            } else {
                fly.drawFlying(g, flyX, flyY, fly.number, fly.color, fly.distance, fly.calculate * 100 / fly.time, fly.calculate);
            }
            if (fly.calculate >= fly.time) continue;
            remainFlyingNumbers.addElement(fly);
        }
        this.flyingStrings = remainFlyingNumbers;
    }

    public void draw(Graphics g, int viewX, int viewY) {
        if (this.showing) {
            int screenX = this.x - viewX;
            int screenY = this.y - viewY;
            int vx = screenX;
            int vy = screenY;
            int size = this.vibras.size();
            if (size > 0) {
                int[] vibra = (int[])this.vibras.firstElement();
                vx += Tool.calulateOffsetWithVibraMatrix((byte)0, vibra[0], vibra[3]) * vibra[2];
                vy += Tool.calulateOffsetWithVibraMatrix((byte)1, vibra[0], vibra[3]) * vibra[2];
                vibra[3] = vibra[3] + 1;
                if (vibra[3] >= vibra[1]) {
                    this.vibras.removeElementAt(0);
                }
            }
            if (this.headStringConfig[5] == 2) {
                this.drawHeadString(g, screenX, screenY, false, false);
            }
            this.drawFlyString(g, screenX, screenY, true);
            size = this.animateList.size();
            for (int i = 0; i < size; ++i) {
                AnimatePlayer tmp = (AnimatePlayer)this.animateList.elementAt(i);
                tmp.draw(g, vx, vy);
            }
            if (this.headStringConfig[5] == 1) {
                this.drawHeadString(g, screenX, screenY, false, false);
            } else if (this.headStringConfig[5] == 0) {
                this.drawHeadString(g, screenX, screenY, true, false);
            } else {
                this.drawHeadString(g, screenX, screenY, true, true);
            }
            this.drawFlyString(g, screenX, screenY, false);
            if (this.bubbleBuffer != null) {
                this.drawBubble(g, screenX, screenY, true);
            }
            this.drawAttendantHpMp(g, screenX, screenY);
        }
    }

    private void drawAttendantHpMp(Graphics g, int screenX, int screenY) {
        GameSprite gs = this.wayPointInfo.ownerSprite;
        if (gs.getType() != 6) {
            return;
        }
        if (needNotDrawHpMp == -1) {
            needNotDrawHpMp = Tool.getGlobalInt("NEED_DRAW_HP_MP_2011");
        }
        if (needNotDrawHpMp == 1) {
            return;
        }
        if (this.isMyAttendant == -1) {
            SortHashtable sht = (SortHashtable)GameWorld.instance.readGameData("vmDataAttendantBag");
            if (sht == null) {
                return;
            }
            this.isMyAttendant = sht.get(new Integer(gs.getInstanceId())) == null ? 0 : 1;
        }
        if (this.isMyAttendant == 0) {
            return;
        }
        if (GameMain.viewWidth >= 480) {
            HP_BAR_WIDTH = 40;
            HP_BAR_HEIGHT = 5;
        }
        if (this.needMakeAnimateBox) {
            this.makeAnimateBox();
        }
        int hpX = screenX - (HP_BAR_WIDTH >> 1);
        int hpY = this.animateBox[1] + screenY + this.headStringConfig[4] - Utilities.CHAR_HEIGHT * 2;
        int BAR_WIDTH = HP_BAR_WIDTH;
        g.setColor(0xFFFFFF);
        g.fillRect(hpX, hpY, HP_BAR_WIDTH, HP_BAR_HEIGHT);
        g.setColor(0x222222);
        g.drawRect(hpX, hpY, HP_BAR_WIDTH, HP_BAR_HEIGHT);
        if (gs.hpMax != 0) {
            if (GameMain.viewWidth >= 480) {
                g.setColor(16726297);
                g.fillRect(hpX, hpY, gs.hp * BAR_WIDTH / gs.hpMax, HP_BAR_HEIGHT);
            } else {
                g.setColor(16726297);
                g.fillRect(hpX, hpY, gs.hp * BAR_WIDTH / gs.hpMax, HP_BAR_HEIGHT);
            }
        }
        g.setColor(0x222222);
        g.drawRect(hpX, hpY, HP_BAR_WIDTH, HP_BAR_HEIGHT);
        g.setColor(0xFFFFFF);
        g.fillRect(hpX, hpY + HP_BAR_HEIGHT + 2, HP_BAR_WIDTH, HP_BAR_HEIGHT);
        g.setColor(0);
        g.drawRect(hpX, hpY + HP_BAR_HEIGHT + 2, HP_BAR_WIDTH, HP_BAR_HEIGHT);
        if (gs.mpMax != 0) {
            if (GameMain.viewWidth >= 480) {
                g.setColor(1875199);
                g.fillRect(hpX, hpY + HP_BAR_HEIGHT + 2, gs.mp * BAR_WIDTH / gs.mpMax, HP_BAR_HEIGHT);
            } else {
                g.setColor(1875199);
                g.fillRect(hpX, hpY + HP_BAR_HEIGHT + 2, gs.mp * BAR_WIDTH / gs.mpMax, HP_BAR_HEIGHT);
            }
        }
        g.setColor(0);
        g.drawRect(hpX, hpY + HP_BAR_HEIGHT + 2, HP_BAR_WIDTH, HP_BAR_HEIGHT);
    }

    public void cycle() {
        int restTime;
        if (this.working && (this.moving || this.wayPointInfo.needHandle)) {
            if (this.wayPointInfo.needHandle) {
                if (this.wayPointInfo.ownerSprite.getType() == 0) {
                    this.calculateStep();
                }
                this.wayPointInfo.processWayPoint();
            } else {
                this.calculateStep();
                this.handleMove();
            }
        }
        this.playingAnimate = false;
        int size = this.animateList.size();
        for (int i = 0; i < size; ++i) {
            AnimatePlayer tmp = (AnimatePlayer)this.animateList.elementAt(i);
            tmp.cycle();
            if (!tmp.playing()) continue;
            this.playingAnimate = true;
        }
        size = this.flyingStrings.size();
        if (size > 0) {
            Vector<FlyingStringInfo> remainFlyingString = new Vector<FlyingStringInfo>();
            long now = Tool.getSystemTime();
            for (int i = 0; i < size; ++i) {
                FlyingStringInfo fly = (FlyingStringInfo)this.flyingStrings.elementAt(i);
                if (fly.delayTick > 0) {
                    --fly.delayTick;
                    remainFlyingString.addElement(fly);
                    continue;
                }
                ++fly.calculate;
                if (now - fly.lastProcessTime >= (long)GameMain.dropflyingStringTime) continue;
                remainFlyingString.addElement(fly);
            }
            this.flyingStrings = remainFlyingString;
        }
        if ((size = this.flyingStringQueue.size()) > 0) {
            Object[] tmpData = (Object[])this.flyingStringQueue.firstElement();
            int delayTick = (Integer)tmpData[1];
            if (--delayTick <= 0) {
                this.flyingStringQueue.removeElementAt(0);
                FlyingStringInfo fly = (FlyingStringInfo)tmpData[0];
                fly.lastProcessTime = Tool.getSystemTime();
                this.flyingStrings.addElement(fly);
            } else {
                tmpData[1] = new Integer(delayTick);
            }
        }
        if (this.bubbleCounterKey != -1 && (restTime = VMCounter.getSaveTimeMillis(this.bubbleCounterKey)) <= 0) {
            this.bubbleCounterKey = -1;
            this.bubbleBuffer = null;
        }
    }

    public boolean isPlayingAnimate() {
        return this.playingAnimate || this.flyingStrings.size() != 0;
    }

    public int[] getCollisionBox(int[] box, boolean useAnimateWidth) {
        if (this.needMakeAnimateBox) {
            this.makeAnimateBox();
        }
        int useWidth = 8;
        int useHeight = 8;
        if (useAnimateWidth) {
            useWidth = this.animateBox[2];
        }
        box[0] = this.x - useWidth / 2;
        box[1] = this.y - useHeight / 4;
        box[2] = useWidth;
        box[3] = useHeight / 2;
        return box;
    }

    public int[] getAnimateBox() {
        if (this.needMakeAnimateBox) {
            this.makeAnimateBox();
        }
        this.realAnimateBox[0] = this.animateBox[0] + this.x;
        this.realAnimateBox[1] = this.animateBox[1] + this.y;
        this.realAnimateBox[2] = this.animateBox[2];
        this.realAnimateBox[3] = this.animateBox[3];
        return this.realAnimateBox;
    }

    private void calculateStep() {
        this.currentStep100 += this.speed * (100 + this.speedAddon) * GameMain.averageMillis / 1000;
        this.currentStep = this.currentStep100 / 100;
        this.currentStep100 -= this.currentStep * 100;
        GameMain.clientMoving = true;
    }

    private void makeAnimateBox() {
        this.animateBox[0] = 0;
        this.animateBox[1] = 0;
        this.animateBox[2] = 0;
        this.animateBox[3] = 0;
        int size = this.animateList.size();
        for (int i = 0; i < size; ++i) {
            AnimatePlayer tmp = (AnimatePlayer)this.animateList.elementAt(i);
            if (!tmp.isShown()) continue;
            Tool.mergeBox(this.animateBox, tmp.getDrawArea());
        }
        this.needMakeAnimateBox = false;
    }

    private void handleMove() {
        int spritex = this.x;
        int spritey = this.y;
        int[] collisionBox = new int[4];
        if (this.collision) {
            int yy;
            collisionBox = this.getCollisionBox(collisionBox, false);
            spritex = collisionBox[0];
            spritey = collisionBox[1];
            int spritew = collisionBox[2];
            int spriteh = collisionBox[3];
            int xx = Tool.calulateStepWithMoveMatrix((byte)0, this.dir, this.currentStep) + spritex;
            int realStep = GameWorld.collisionWorld(xx, yy = Tool.calulateStepWithMoveMatrix((byte)1, this.dir, this.currentStep) + spritey, spritew, spriteh, this.dir, this.currentStep, spritex, spritey);
            if (realStep == 0) {
                for (int i = 1; i <= GameMain.COLLISION_MAX_STEP; i += GameMain.COLLISION_STEP_ADD) {
                    int newdir2 = this.dir;
                    byte newdir3 = this.dir;
                    int newStep = this.currentStep * i;
                    switch (this.dir) {
                        case 0: 
                        case 3: {
                            newdir2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            newdir2 = 3;
                        }
                    }
                    xx = Tool.calulateStepWithMoveMatrix((byte)0, newdir2, newStep) + spritex;
                    yy = Tool.calulateStepWithMoveMatrix((byte)1, newdir2, newStep) + spritey;
                    int newRealStep2 = GameWorld.collisionWorld(xx, yy, spritew, spriteh, newdir2, newStep, spritex, spritey);
                    switch (this.dir) {
                        case 0: 
                        case 3: {
                            newdir3 = 1;
                            break;
                        }
                        case 1: 
                        case 2: {
                            newdir3 = 0;
                        }
                    }
                    xx = Tool.calulateStepWithMoveMatrix((byte)0, newdir3, newStep) + spritex;
                    yy = Tool.calulateStepWithMoveMatrix((byte)1, newdir3, newStep) + spritey;
                    int newRealStep3 = GameWorld.collisionWorld(xx, yy, spritew, spriteh, newdir3, newStep, spritex, spritey);
                    if (newRealStep2 != newRealStep3) {
                        if (newRealStep2 > newRealStep3) {
                            newRealStep2 = Math.min(newRealStep2, this.currentStep >> 1);
                            this.doMove(newdir2, newRealStep2);
                        } else {
                            newRealStep3 = Math.min(newRealStep3, this.currentStep >> 1);
                            this.doMove(newdir3, newRealStep3);
                        }
                    } else if (newRealStep2 != 0) {
                        continue;
                    }
                    break;
                }
            } else {
                this.doMove(this.dir, realStep);
            }
        } else {
            this.doMove(this.dir, this.currentStep);
        }
    }

    private void doMove(int doDir, int doStep) {
        this.x += Tool.calulateStepWithMoveMatrix((byte)0, doDir, doStep);
        this.y += Tool.calulateStepWithMoveMatrix((byte)1, doDir, doStep);
    }

    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    public int getMapId() {
        return this.mapId;
    }

    private void setWayPointAnimate(int index) {
        if (this.animateList.size() == 0 || this.wayPointInfo.ownerSprite.die) {
            return;
        }
        AnimatePlayer animate = (AnimatePlayer)this.animateList.firstElement();
        if (animate != null) {
            this.setAnimateIndex(animate.getAnimateName(), index, 0, -1, null, true);
            this.wayPointInfo.animateOK = true;
        }
    }

    public void addWayPoint(int dest_x, int dest_y, int moveAnimateIndex, int stopAnimateIndex, int speed, GameSprite gameSprite) {
        this.addWayPoint(dest_x, dest_y, moveAnimateIndex, stopAnimateIndex, false, 0, 0, speed, gameSprite, false, -1);
    }

    public void addWayPoint(int dest_x, int dest_y, int moveAnimateIndex, int stopAnimateIndex, boolean keepGoing, int angle, int time, int speed, GameSprite gameSprite, boolean needCorrectDir, int targetPos) {
        if (this.wayPointInfo.ownerSprite.die) {
            return;
        }
        if (keepGoing && targetPos < 0 && GameMain.keepGoingDistance > 0) {
            int dd;
            int dest_t_server = Utilities.getServerTime() - time;
            int dest_x_server = dest_x;
            int dest_y_server = dest_y;
            int goingDistance = GameMain.keepGoingDistance;
            if (dest_t_server > 0) {
                int dest_d_server = dest_t_server * speed / 1000;
                dest_x_server = dest_x + (int)((long)dest_d_server * (long)Tool.cos(angle) / 10000L);
                dest_y_server = dest_y + (int)((long)dest_d_server * (long)Tool.sin(angle) / 10000L);
            }
            if ((dd = Tool.distance(this.x, this.y, dest_x_server, dest_y_server)) == 0) {
                this.wayPointInfo.startPosX = this.x;
                this.wayPointInfo.startPosY = this.y;
                this.wayPointInfo.endPosX = dest_x_server + (int)((long)goingDistance * (long)Tool.cos(angle) / 10000L);
                this.wayPointInfo.endPosY = dest_y_server + (int)((long)goingDistance * (long)Tool.sin(angle) / 10000L);
                this.wayPointInfo.currentSpeed = speed;
                this.wayPointInfo.modifyMode = false;
            } else {
                int ds = Math.max(this.wayPointInfo.currentSpeed, speed);
                int dt = dd * 1000 / ds;
                int td = speed * dt / 1000;
                int tx = dest_x_server + (int)((long)td * (long)Tool.cos(angle) / 10000L);
                int ty = dest_y_server + (int)((long)td * (long)Tool.sin(angle) / 10000L);
                int md = Tool.distance(this.x, this.y, tx, ty);
                int ms = md * 1000 / dt;
                this.wayPointInfo.startPosX = this.x;
                this.wayPointInfo.startPosY = this.y;
                this.wayPointInfo.endPosX = tx;
                this.wayPointInfo.endPosY = ty;
                this.wayPointInfo.currentSpeed = ms;
                this.wayPointInfo.modifyNextPosX = dest_x_server + (int)((long)goingDistance * (long)Tool.cos(angle) / 10000L);
                this.wayPointInfo.modifyNextPosY = dest_y_server + (int)((long)goingDistance * (long)Tool.sin(angle) / 10000L);
                this.wayPointInfo.modifyNextSpeed = speed;
                this.wayPointInfo.modifyMode = true;
            }
        } else {
            this.wayPointInfo.startPosX = this.x;
            this.wayPointInfo.startPosY = this.y;
            if (targetPos > 0) {
                this.wayPointInfo.endPosX = targetPos >> 16 & 0xFFFF;
                this.wayPointInfo.endPosY = targetPos & 0xFFFF;
            } else {
                this.wayPointInfo.endPosX = dest_x;
                this.wayPointInfo.endPosY = dest_y;
            }
            this.wayPointInfo.currentSpeed = speed;
            this.wayPointInfo.modifyMode = false;
        }
        if (needCorrectDir) {
            this.wayPointInfo.needCorrectDir = true;
            if (angle < 0) {
                angle += (-angle / 360 + 1) * 360;
            }
            this.wayPointInfo.correctAngle = angle % 360;
        } else {
            this.wayPointInfo.needCorrectDir = false;
        }
        this.wayPointInfo.gameSprite = gameSprite;
        this.wayPointInfo.moveAnimateIndex = moveAnimateIndex;
        this.wayPointInfo.stopAnimateIndex = keepGoing && targetPos < 0 ? moveAnimateIndex : stopAnimateIndex;
        this.wayPointInfo.animateOK = false;
        this.wayPointInfo.needHandle = true;
        int[] dest_dir = this.wayPointInfo.startWayPoint();
        this.setDir(dest_dir[0]);
        this.setAnimateDir(dest_dir[0]);
        this.setAnimateSubDir(dest_dir[1]);
        if (this.wayPointInfo.gameSprite.isHumanAnimate()) {
            this.setWayPointAnimate(moveAnimateIndex + this.dir);
        } else {
            this.setWayPointAnimate(moveAnimateIndex + this.animateSubDir);
        }
    }

    public class WayPointInfo {
        public GameSprite ownerSprite;
        public int startPosX;
        public int startPosY;
        public int endPosX;
        public int endPosY;
        public int startTime;
        public int endTime;
        public int currentSpeed;
        public int distance;
        public boolean modifyMode = false;
        public int modifyNextPosX;
        public int modifyNextPosY;
        public int modifyNextSpeed;
        public boolean needCorrectDir = false;
        public int correctAngle;
        public boolean needHandle;
        public GameSprite gameSprite;
        public int moveAnimateIndex;
        public int stopAnimateIndex;
        public boolean animateOK;
        public int[] dirArray = new int[2];

        public int[] startWayPoint() {
            this.dirArray[0] = Sprite.this.dir;
            this.dirArray[1] = Sprite.this.animateSubDir;
            this.distance = Tool.distance(this.startPosX, this.startPosY, this.endPosX, this.endPosY);
            if (this.distance > 0) {
                this.endTime = this.startTime = Utilities.getServerTime();
                Sprite.this.movedStep = 0;
                if (this.currentSpeed != 0 && Sprite.this.speedAddon > -100) {
                    this.endTime += this.distance * 1000 / (this.currentSpeed * (100 + Sprite.this.speedAddon) / 100);
                }
                Tool.calulateDirWithWayPointMatrix(Sprite.this.dir, Sprite.this.animateSubDir, this.startPosX, this.startPosY, this.endPosX, this.endPosY, this.dirArray);
            }
            return this.dirArray;
        }

        public void processWayPoint() {
            if (this.ownerSprite.getType() == 0) {
                if (this.ownerSprite.die) {
                    Sprite.this.x = this.endPosX;
                    Sprite.this.y = this.endPosY;
                    this.finishWayPoint(true);
                } else {
                    int dest_y;
                    int dest_x;
                    int dx = this.endPosX - this.startPosX;
                    int dy = this.endPosY - this.startPosY;
                    Sprite.this.movedStep += ((GameRole)this.ownerSprite).sprite.currentStep;
                    int D = Sprite.this.movedStep;
                    if (D > this.distance) {
                        D = this.distance;
                    }
                    if (this.distance == 0) {
                        dest_x = this.endPosX;
                        dest_y = this.endPosY;
                    } else {
                        dest_x = this.startPosX + D * dx / this.distance;
                        dest_y = this.startPosY + D * dy / this.distance;
                    }
                    Sprite.this.x = dest_x;
                    Sprite.this.y = dest_y;
                    if (!this.ownerSprite.sprite.wayPointInfo.animateOK) {
                        Tool.calulateDirWithWayPointMatrix(this.ownerSprite.sprite.dir, this.ownerSprite.sprite.animateSubDir, Sprite.this.x, Sprite.this.y, this.endPosX, this.endPosY, this.dirArray);
                        this.ownerSprite.sprite.setDir(this.dirArray[0]);
                        this.ownerSprite.sprite.setAnimateDir(this.dirArray[0]);
                        this.ownerSprite.sprite.setAnimateSubDir(this.dirArray[1]);
                        this.ownerSprite.sprite.setWayPointAnimate(this.moveAnimateIndex + Sprite.this.dir);
                    }
                }
            } else if (Utilities.getServerTime() > this.endTime || this.ownerSprite.die) {
                Sprite.this.x = this.endPosX;
                Sprite.this.y = this.endPosY;
                this.finishWayPoint(true);
            } else if (Sprite.this.x != this.endPosX || Sprite.this.y != this.endPosY) {
                int dest_y;
                int dest_x;
                int elapse = Utilities.getServerTime() - this.startTime;
                int dx = this.endPosX - this.startPosX;
                int dy = this.endPosY - this.startPosY;
                int D = elapse * this.currentSpeed / 1000;
                if (this.distance == 0) {
                    dest_x = this.endPosX;
                    dest_y = this.endPosY;
                } else {
                    dest_x = this.startPosX + D * dx / this.distance;
                    dest_y = this.startPosY + D * dy / this.distance;
                }
                Sprite.this.x = dest_x;
                Sprite.this.y = dest_y;
                if (!Sprite.this.wayPointInfo.animateOK) {
                    Tool.calulateDirWithWayPointMatrix(Sprite.this.dir, Sprite.this.animateSubDir, Sprite.this.x, Sprite.this.y, this.endPosX, this.endPosY, this.dirArray);
                    Sprite.this.setDir(this.dirArray[0]);
                    Sprite.this.setAnimateDir(this.dirArray[0]);
                    Sprite.this.setAnimateSubDir(this.dirArray[1]);
                    if (this.gameSprite.isHumanAnimate()) {
                        Sprite.this.setWayPointAnimate(this.moveAnimateIndex + Sprite.this.dir);
                    } else {
                        Sprite.this.setWayPointAnimate(this.moveAnimateIndex + Sprite.this.animateSubDir);
                    }
                }
            }
        }

        public void finishWayPoint(boolean setAnimate) {
            if (this.modifyMode) {
                this.startPosX = Sprite.this.x;
                this.startPosY = Sprite.this.y;
                this.endPosX = this.modifyNextPosX;
                this.endPosY = this.modifyNextPosY;
                this.currentSpeed = this.modifyNextSpeed;
                this.modifyMode = false;
                this.needHandle = true;
                int[] dest_dir = this.startWayPoint();
                Sprite.this.setDir(dest_dir[0]);
                Sprite.this.setAnimateDir(dest_dir[0]);
                Sprite.this.setAnimateSubDir(dest_dir[1]);
                if (this.gameSprite.isHumanAnimate()) {
                    Sprite.this.setWayPointAnimate(this.moveAnimateIndex + Sprite.this.dir);
                } else {
                    Sprite.this.setWayPointAnimate(this.moveAnimateIndex + Sprite.this.animateSubDir);
                }
            } else {
                this.needHandle = false;
                if (this.needCorrectDir) {
                    int tx = Sprite.this.x + (int)((long)GameMain.keepGoingDistance * (long)Tool.cos(this.correctAngle) / 10000L);
                    int ty = Sprite.this.y + (int)((long)GameMain.keepGoingDistance * (long)Tool.sin(this.correctAngle) / 10000L);
                    Tool.calulateDirWithWayPointMatrix(Sprite.this.dir, Sprite.this.animateSubDir, Sprite.this.x, Sprite.this.y, tx, ty, this.dirArray);
                    Sprite.this.setDir(this.dirArray[0]);
                    Sprite.this.setAnimateDir(this.dirArray[0]);
                    Sprite.this.setAnimateSubDir(this.dirArray[1]);
                }
                if (setAnimate && this.gameSprite != null) {
                    if (this.gameSprite.isHumanAnimate()) {
                        Sprite.this.setWayPointAnimate(this.stopAnimateIndex + Sprite.this.dir);
                    } else {
                        Sprite.this.setWayPointAnimate(this.stopAnimateIndex + Sprite.this.animateSubDir);
                    }
                }
            }
        }
    }
}

