/*
 * Decompiled with CFR 0.152.
 */
package com.pip.engine;

import com.pip.engine.Random;
import com.pip.image.ImageSet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class LandformImage
extends ImageSet {
    public static final int TILE_100 = 0;
    public static final int TILE_75 = 1;
    public static final int TILE_50H = 2;
    public static final int TILE_50V = 3;
    public static final int TILE_50S = 4;
    public static final int TILE_25 = 5;
    protected short[] tileTypes;
    protected short[] tilePrior;
    public int[][] frameSearchTable;
    protected static final int[][] TYPE_MAP = new int[][]{{-1, 0}, {5, 0}, {5, 2}, {2, 0}, {5, 1}, {3, 0}, {4, 2}, {1, 0}, {5, 3}, {4, 0}, {3, 2}, {1, 2}, {2, 1}, {1, 1}, {1, 3}, {0, 0}};

    public LandformImage(byte[] data) throws Exception {
        super(data);
        int fcount = this.getFrameCount();
        ByteArrayInputStream bis = new ByteArrayInputStream(data, data.length - 4 * fcount, 4 * fcount);
        DataInputStream dis = new DataInputStream(bis);
        this.tileTypes = new short[fcount];
        this.tilePrior = new short[fcount];
        for (int i = 0; i < fcount; ++i) {
            this.tileTypes[i] = dis.readShort();
            this.tilePrior[i] = dis.readShort();
        }
    }

    public void generateSearchTable() {
        this.frameSearchTable = new int[6][];
        int count = this.tileTypes.length;
        for (int t = 0; t < 6; ++t) {
            int[] candidates = new int[count];
            int canCount = 0;
            for (int i = 0; i < count; ++i) {
                if (this.tileTypes[i] != t) continue;
                candidates[canCount++] = i;
            }
            this.frameSearchTable[t] = new int[canCount];
            System.arraycopy(candidates, 0, this.frameSearchTable[t], 0, canCount);
        }
    }

    private int randomChooseTile(Random rand, int tileType) {
        if (tileType == -1) {
            return -1;
        }
        int[] candidates = this.frameSearchTable[tileType];
        if (candidates.length == 0) {
            candidates = this.frameSearchTable[0];
        }
        int totalPrior = 0;
        for (int i = 0; i < candidates.length; ++i) {
            totalPrior += this.tilePrior[candidates[i]] & 0xFFFF;
        }
        if (totalPrior == 0) {
            return -1;
        }
        int point = rand.nextInt(totalPrior);
        for (int i = 0; i < candidates.length; ++i) {
            if ((point -= this.tilePrior[candidates[i]] & 0xFFFF) > 0) continue;
            return candidates[i];
        }
        return -1;
    }

    public int[] getTile(Random rand, int gridType) {
        int tileIndex = this.randomChooseTile(rand, TYPE_MAP[gridType][0]);
        return new int[]{tileIndex, TYPE_MAP[gridType][1]};
    }
}

