/*
 * Decompiled with CFR 0.152.
 */
package com.pip.engine;

import com.pip.common.Tool;
import com.pip.engine.GameMap;
import com.pip.engine.LandformImage;
import com.pip.engine.PackageFile;
import com.pip.image.ImageSet;
import com.pip.image.PipAnimateSet;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Enumeration;

public class GamePackage
extends PackageFile {
    public int tileWidth;
    public int tileHeight;
    public int blurTileWidth;
    public int blurTileHeight;
    public int areaID;
    public String title;
    public int landFromCount;

    public GamePackage(byte[] data) throws Exception {
        super(data);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.getFile("/0.stg"));
        DataInputStream dis = new DataInputStream(bis);
        this.tileWidth = dis.readShort();
        this.tileHeight = dis.readShort();
        this.blurTileWidth = dis.readShort();
        this.blurTileHeight = dis.readShort();
        this.areaID = dis.readShort() & 0xFFFF;
        this.title = Tool.readUTF(dis);
        this.landFromCount = 0;
        Enumeration emu = this.nameIndexMap.keys();
        while (emu.hasMoreElements()) {
            String fileName = (String)emu.nextElement();
            if (!fileName.endsWith(".ldf")) continue;
            ++this.landFromCount;
        }
    }

    public ImageSet loadTileImage() throws Exception {
        ImageSet ret = new ImageSet(this.getFile("/tile.pip"));
        ret.fileName = "tile.pip";
        return ret;
    }

    public byte[][] getTileInfo() throws Exception {
        return this.parseTileInfo(this.getFile("/tile.ts"));
    }

    private byte[][] parseTileInfo(byte[] data) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        int tcount = dis.readShort();
        byte[][] ret = new byte[2][tcount];
        for (int i = 0; i < tcount; ++i) {
            ret[0][i] = dis.readByte();
            ret[1][i] = dis.readByte();
        }
        return ret;
    }

    public LandformImage[] loadAllLandformImage() throws Exception {
        LandformImage[] result = new LandformImage[this.landFromCount];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.loadLandformImage(i);
        }
        return result;
    }

    public byte[][] loadAllLandformTileInfof() throws Exception {
        byte[][] result = new byte[this.landFromCount][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.loadLandformTileInfo(i);
        }
        return result;
    }

    public LandformImage loadLandformImage(int lid) throws Exception {
        return new LandformImage(this.getFile("/l" + lid + ".ldf"));
    }

    public byte[] loadLandformTileInfo(int lid) throws Exception {
        return this.parseTileInfo(this.getFile("/l" + lid + ".ts"))[1];
    }

    public PipAnimateSet loadNPCAnimates() throws Exception {
        return this.parseAnimatesPackage(this.getFile("/npc.anp"));
    }

    public PipAnimateSet parseAnimatesPackage(byte[] fileData) throws Exception {
        PackageFile pkg = new PackageFile(fileData);
        int fcount = pkg.fileContents.length;
        ImageSet[] imgs = new ImageSet[fcount - 1];
        for (int i = 1; i < fcount; ++i) {
            imgs[i - 1] = new ImageSet(pkg.fileContents[i]);
            imgs[i - 1].fileName = pkg.fileNames[i];
        }
        PipAnimateSet ret = new PipAnimateSet(imgs, pkg.fileContents[0]);
        ret.fileName = "mapNpc.pip";
        return ret;
    }

    public int[][] loadNPCCollision() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(this.getFile("/npc.col"));
        DataInputStream dis = new DataInputStream(bis);
        int count = dis.readShort();
        int[][] ret = new int[count][];
        for (int i = 0; i < count; ++i) {
            int subCount = dis.readUnsignedByte();
            ret[i] = new int[subCount << 1];
            for (int j = 0; j < subCount; ++j) {
                ret[i][j << 1] = dis.readUnsignedShort() << 16 | dis.readUnsignedShort();
                ret[i][(j << 1) + 1] = dis.readUnsignedByte() << 16 | dis.readUnsignedByte();
            }
        }
        return ret;
    }

    public GameMap loadMap(int mapID) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(Tool.inflate(this.getFile("/" + mapID + ".m")));
        DataInputStream dis = new DataInputStream(bis);
        GameMap ret = new GameMap(this);
        ret.load(dis);
        ret.id |= this.areaID << 4;
        return ret;
    }
}

