/*
 * Decompiled with CFR 0.152.
 */
package com.pip.engine;

import com.pip.engine.IAnimateOwner;
import com.pip.image.ImageSet;
import com.pip.image.PipAnimateSet;
import com.pip.sanguo.GameMain;
import java.util.Hashtable;
import java.util.Vector;

public class AnimateCache {
    private static final Hashtable animateCache = new Hashtable();
    private static final Hashtable imageCache = new Hashtable();
    private static final Hashtable requestAnimate2Owner = new Hashtable();
    private static final Hashtable requestImage2Animate = new Hashtable();
    private static final Hashtable animate2Owner = new Hashtable();
    private static final Hashtable image2Animate = new Hashtable();
    private static final Vector aysnAnimateReady = new Vector();
    private static final Vector pendingReleaseAnimate = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPendingReleaseAnimate() {
        Vector vector = pendingReleaseAnimate;
        synchronized (vector) {
            int count = pendingReleaseAnimate.size();
            for (int i = 0; i < count; ++i) {
                AnimateCache.releaseAnimate(null, (String)pendingReleaseAnimate.elementAt(i), true);
            }
            pendingReleaseAnimate.removeAllElements();
        }
    }

    public static void clear() {
        animateCache.clear();
        imageCache.clear();
        requestAnimate2Owner.clear();
        requestImage2Animate.clear();
        animate2Owner.clear();
        image2Animate.clear();
        aysnAnimateReady.removeAllElements();
        pendingReleaseAnimate.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processAnimateReadyQueue() {
        Object[][] items;
        Vector vector = aysnAnimateReady;
        synchronized (vector) {
            items = new Object[aysnAnimateReady.size()][];
            aysnAnimateReady.copyInto((Object[])items);
            aysnAnimateReady.removeAllElements();
        }
        for (int i = 0; i < items.length; ++i) {
            Object[] tmp = items[i];
            IAnimateOwner owner = (IAnimateOwner)tmp[0];
            String animateName = (String)tmp[1];
            PipAnimateSet animate = (PipAnimateSet)tmp[2];
            owner.animateReady(animateName, animate);
        }
    }

    public static void requestAnimate(IAnimateOwner owner, String animateName) {
        Object cacheAnimate = animateCache.get(animateName);
        if (cacheAnimate == null) {
            AnimateCache.addAnimateRequest(owner, animateName);
            animateCache.put(animateName, animateName);
            GameMain.resourceManager.requestResource(animateName);
        } else if (cacheAnimate instanceof String) {
            AnimateCache.addAnimateRequest(owner, animateName);
        } else if (cacheAnimate instanceof PipAnimateSet) {
            PipAnimateSet animate = (PipAnimateSet)cacheAnimate;
            if (animate.ready()) {
                AnimateCache.addAnimateOwner(owner, animateName);
                AnimateCache.addAnimateReadyQueue(owner, animateName, animate);
            } else {
                AnimateCache.addAnimateRequest(owner, animateName);
            }
        }
    }

    public static void recvAnimate(String animateName, byte[] ctnData) {
        PipAnimateSet animate = new PipAnimateSet(null, ctnData);
        animate.fileName = animateName;
        animateCache.put(animateName, animate);
        String[] missingImage = animate.getMissingImage();
        for (int i = 0; i < missingImage.length; ++i) {
            Object image = imageCache.get(missingImage[i]);
            if (image == null) {
                AnimateCache.addImageReuest(missingImage[i], animateName);
                imageCache.put(missingImage[i], missingImage[i]);
                GameMain.resourceManager.requestResource(missingImage[i]);
                continue;
            }
            if (image instanceof String) {
                AnimateCache.addImageReuest(missingImage[i], animateName);
                continue;
            }
            if (!(image instanceof ImageSet)) continue;
            AnimateCache.addImageOwner(missingImage[i], animateName);
            animate.setImage(missingImage[i], (ImageSet)image);
            if (!animate.ready()) continue;
            AnimateCache.animateReady(animateName, animate);
        }
    }

    public static void recvImage(String imageName, ImageSet image) {
        AnimateCache.imageReady(imageName, image);
        Vector animates = (Vector)image2Animate.get(imageName);
        if (animates == null) {
            return;
        }
        for (int i = 0; i < animates.size(); ++i) {
            String animateName = (String)animates.elementAt(i);
            PipAnimateSet animate = (PipAnimateSet)animateCache.get(animateName);
            animate.setImage(imageName, image);
            if (!animate.ready()) continue;
            AnimateCache.animateReady(animateName, animate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAnimate(IAnimateOwner owner, String animateName, boolean force) {
        int i;
        Object obj = animateCache.get(animateName);
        if (obj == null) {
            return;
        }
        if (obj instanceof String) {
            Vector owners = (Vector)requestAnimate2Owner.get(animateName);
            if (owners != null) {
                owners.removeElement(owner);
            }
            return;
        }
        PipAnimateSet animate = (PipAnimateSet)obj;
        if (animate == null) {
            return;
        }
        String[] imageNames = animate.getAllImageName();
        Vector owners = (Vector)animate2Owner.get(animateName);
        if (owners == null) {
            owners = new Vector();
        }
        Vector<IAnimateOwner> restOwners = new Vector<IAnimateOwner>();
        for (i = 0; i < owners.size(); ++i) {
            IAnimateOwner tmpOwner = (IAnimateOwner)owners.elementAt(i);
            if (owner != null && tmpOwner.getType() == owner.getType() && tmpOwner.getId() == owner.getId()) continue;
            restOwners.addElement(tmpOwner);
        }
        owners.removeAllElements();
        for (i = 0; i < restOwners.size(); ++i) {
            owners.addElement(restOwners.elementAt(i));
        }
        if (owners.size() == 0) {
            animate2Owner.remove(animateName);
            if (!force && GameMain.animateCacheType != 2) {
                Vector i2 = pendingReleaseAnimate;
                synchronized (i2) {
                    pendingReleaseAnimate.addElement(animateName);
                }
                return;
            }
            animateCache.remove(animateName);
            for (i = 0; i < imageNames.length; ++i) {
                int j;
                Vector animates = (Vector)image2Animate.get(imageNames[i]);
                if (animates == null) continue;
                Vector<String> restAnimates = new Vector<String>();
                for (j = 0; j < animates.size(); ++j) {
                    String tmpAnimateName = (String)animates.elementAt(j);
                    if (tmpAnimateName.equals(animateName)) continue;
                    restAnimates.addElement(tmpAnimateName);
                }
                animates.removeAllElements();
                for (j = 0; j < restAnimates.size(); ++j) {
                    animates.addElement(restAnimates.elementAt(j));
                }
                if (animates.size() != 0) continue;
                Object set = imageCache.get(imageNames[i]);
                imageCache.remove(imageNames[i]);
                image2Animate.remove(imageNames[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAnimateReadyQueue(IAnimateOwner owner, String animateName, PipAnimateSet animate) {
        Vector vector = aysnAnimateReady;
        synchronized (vector) {
            Object[] tmp = new Object[]{owner, animateName, animate};
            aysnAnimateReady.addElement(tmp);
        }
    }

    private static void animateReady(String animateName, PipAnimateSet animate) {
        int i;
        Vector requestOwners = (Vector)requestAnimate2Owner.get(animateName);
        if (requestOwners == null) {
            return;
        }
        Vector owners = (Vector)animate2Owner.get(animateName);
        requestAnimate2Owner.remove(animateName);
        if (owners == null) {
            owners = new Vector();
        }
        for (i = 0; i < requestOwners.size(); ++i) {
            owners.addElement(requestOwners.elementAt(i));
        }
        animate2Owner.put(animateName, owners);
        for (i = 0; i < owners.size(); ++i) {
            IAnimateOwner owner = (IAnimateOwner)owners.elementAt(i);
            AnimateCache.addAnimateReadyQueue(owner, animateName, animate);
        }
    }

    private static void imageReady(String imageName, ImageSet image) {
        Vector requestAnimates = (Vector)requestImage2Animate.get(imageName);
        if (requestAnimates == null) {
            return;
        }
        imageCache.put(imageName, image);
        Vector animates = (Vector)image2Animate.get(imageName);
        requestImage2Animate.remove(imageName);
        if (animates == null) {
            animates = new Vector();
        }
        for (int i = 0; i < requestAnimates.size(); ++i) {
            animates.addElement(requestAnimates.elementAt(i));
        }
        image2Animate.put(imageName, animates);
    }

    private static void addAnimateOwner(IAnimateOwner owner, String animateName) {
        Vector owners = (Vector)animate2Owner.get(animateName);
        if (owners == null) {
            return;
        }
        owners.addElement(owner);
    }

    private static void addImageOwner(String imageName, String animateName) {
        Vector animates = (Vector)image2Animate.get(imageName);
        animates.addElement(animateName);
    }

    private static void addAnimateRequest(IAnimateOwner owner, String animateName) {
        Vector<IAnimateOwner> owners = (Vector<IAnimateOwner>)requestAnimate2Owner.get(animateName);
        if (owners == null) {
            owners = new Vector<IAnimateOwner>();
        }
        owners.addElement(owner);
        requestAnimate2Owner.put(animateName, owners);
    }

    private static void addImageReuest(String imageName, String animateName) {
        Vector<String> animates = (Vector<String>)requestImage2Animate.get(imageName);
        if (animates == null) {
            animates = new Vector<String>();
        }
        animates.addElement(animateName);
        requestImage2Animate.put(imageName, animates);
    }
}

