/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEGroup;
import AbyssEngine.AEScene;
import AbyssEngine.AEVector3D;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;
import ScrollerGame.SCWeaponSystem;
import contentHeliStrike.SCEnemyFactory;
import java.util.Random;

public class SCTankBossEnemy
implements SCEnemy {
    private static AEGraphNode silo;
    private AEGraphNode base1;
    private AEGraphNode destroyed;
    private AEGroup base_root = new AEGroup();
    private AEGroup shoot_node;
    private int hitpoints;
    private int silo_hitpoints;
    private int initial_hitpoints;
    private int hitradius;
    private int corrected_hitradius_x1;
    private int corrected_hitradius_z1;
    private int corrected_hitradius_x2;
    private int corrected_hitradius_z2;
    private byte last_hit;
    private static final byte LAST_HIT_TANK = 1;
    private static final byte LAST_HIT_SILO = 2;
    private SCEnemySet enemy_set;
    private AEExplosionInterface explosion;
    private AEExplosionInterface silo_explosion;
    private SCWeaponSystem[] weapon;
    private int[] target_count_array;
    private int target_count_id;
    private long tile;
    private int time;
    private static final int MAX_DX = 2048;
    private static final int MAX_DZ = 1024;
    private static final int SPEED = 2048;
    private int initial_x;
    private int initial_z;
    private int target_x;
    private int target_z;
    private AEVector3D dir;
    private AEVector3D up;
    private AEVector3D left;
    private static Random rndm;
    public static boolean canShoot;
    public static boolean nukeCountdown;
    public static boolean nukeStart;
    private long sporn_enemy_delay;
    private static final long SPORN_ENEMY_DELAY = 7000L;
    private long initial_shoot_delay;
    private static final long INITIAL_SHOOT_DELAY = 3000L;

    public SCTankBossEnemy(AEGraphNode silo, AEExplosionInterface silo_explosion, AEGraphNode base1, AEGraphNode base2, AEGraphNode cannon, AEGraphNode destroyed, AEScene modul_root, int tx, int ty, int tz, int rx, int ry, int rz, int hitpoints, int hitradius, AEExplosionInterface explosion, SCWeaponSystem[] weapon, int[] target_count_array, int target_count_id, long tile) {
        if (silo != null && silo_explosion != null) {
            this.base_root.addChild(silo);
            silo.stopAnim(0);
            silo.setAnimRange(0, 200);
            silo.setTranslation(-tx, -ty, -tz - 4096);
            this.silo_hitpoints = hitpoints;
            SCTankBossEnemy.silo = silo;
            this.silo_explosion = silo_explosion;
        }
        this.shoot_node = new AEGroup();
        this.shoot_node.setRotation(0, 2048, 0);
        this.shoot_node.addChild(base2);
        cannon.setTranslation(0, 219, -220);
        this.shoot_node.addChild(cannon);
        this.base_root.setTranslation(tx, ty, tz);
        this.base_root.setRotation(rx, ry, rz);
        this.base1 = base1;
        this.base1.stopAnim(0);
        this.base1.setRotation(0, 2048, 0);
        this.base_root.addChild(base1);
        this.base_root.addChild(this.shoot_node);
        this.destroyed = destroyed;
        destroyed.stopAnim(0);
        this.initial_hitpoints = this.hitpoints = hitpoints;
        this.hitradius = hitradius;
        this.explosion = explosion;
        if (explosion != null) {
            explosion.getParticleSystem().setTranslation(tx, ty, tz);
        }
        this.weapon = weapon;
        this.target_count_array = target_count_array;
        this.target_count_id = target_count_id;
        this.tile = tile;
        if (rndm == null) {
            rndm = new Random();
        }
        this.initial_x = tx;
        this.initial_z = tz;
        this.target_x = 2048;
        this.target_z = 1024;
        this.time = 0;
        this.dir = new AEVector3D(0, 0, 4096);
        this.up = new AEVector3D(0, 4096, 0);
        this.left = new AEVector3D();
        canShoot = false;
        nukeCountdown = false;
        nukeStart = false;
        this.sporn_enemy_delay = 21000L;
        this.initial_shoot_delay = 3000L;
    }

    public void applyHitpoints(int hitpoints) {
        if (this.hitpoints <= 0 && this.silo_hitpoints <= 0) {
            return;
        }
        if (this.last_hit == 1) {
            this.hitpoints += hitpoints;
            if (this.hitpoints <= 0) {
                this.killTank();
            }
        } else if (silo != null) {
            this.silo_hitpoints += hitpoints;
            if (this.silo_hitpoints <= 0) {
                this.silo_explosion.getParticleSystem().setTranslation(silo.getPositionX(), silo.getPositionY() - 1024, silo.getPositionZ());
                this.silo_explosion.start();
                this.base_root.addChild(this.silo_explosion.getParticleSystem());
                if (this.hitpoints > 0) {
                    this.hitpoints = -1;
                    this.killTank();
                }
                nukeCountdown = false;
            }
        }
    }

    private void killTank() {
        AEGroup modul_root = this.base_root.getParent();
        if (modul_root != null) {
            this.base_root.removeChild(this.base1);
            this.base_root.removeChild(this.shoot_node);
            this.destroyed.setTranslation(this.base1.getPositionX() + this.base_root.getPositionX(), this.base1.getPositionY() + this.base_root.getPositionY(), this.base1.getPositionZ() + this.base_root.getPositionZ());
            this.destroyed.setRotation(0, this.base1.getRotationY() + this.base_root.getRotationY(), 0);
            modul_root.addChild(this.destroyed);
            this.destroyed.playAnim((byte)1);
        }
        if (this.explosion != null) {
            this.explosion.getParticleSystem().setTranslation(this.base1.getPositionX() + this.base_root.getPositionX(), this.base1.getPositionY() + this.base_root.getPositionY(), this.base1.getPositionZ() + this.base_root.getPositionZ());
            this.explosion.start();
        }
        if (this.target_count_array != null) {
            int n = this.target_count_id;
            this.target_count_array[n] = this.target_count_array[n] + 1;
        }
    }

    public int getCurrentX() {
        return this.base1.getWorldPositionX();
    }

    public int getCurrentY() {
        return this.base1.getWorldPositionY();
    }

    public int getCurrentZ() {
        return this.base1.getWorldPositionZ();
    }

    public AEGraphNode getGeometry() {
        return this.base_root;
    }

    public int getHitRadius() {
        return this.hitradius;
    }

    public int getHitpoints() {
        return this.hitpoints;
    }

    public boolean isDead() {
        return this.hitpoints <= 0 && this.silo_hitpoints <= 0;
    }

    public void setEnemySet(SCEnemySet enemy_set) {
        this.enemy_set = enemy_set;
    }

    public void setHitpoints(int hitpoints) {
        this.hitpoints = hitpoints;
    }

    public void update(int elapsed_time) {
        int distz;
        int distx;
        if (this.explosion != null && this.explosion.isActive()) {
            this.explosion.update(elapsed_time);
        }
        if (this.weapon != null && canShoot) {
            int i;
            if (this.initial_shoot_delay > 0L) {
                this.initial_shoot_delay -= (long)elapsed_time;
            } else if (this.hitpoints > 0) {
                for (i = 0; i < this.weapon.length; ++i) {
                    this.weapon[i].shoot(this.shoot_node);
                }
            }
            for (i = 0; i < this.weapon.length; ++i) {
                this.weapon[i].update(elapsed_time);
                this.weapon[i].render();
            }
        }
        if (this.hitpoints > 0) {
            this.base1.translate(-(elapsed_time * this.dir.x >> 12), 0, -(elapsed_time * this.dir.z >> 12));
            this.shoot_node.setTranslation(this.base1.getPositionX(), this.base1.getPositionY(), this.base1.getPositionZ());
            int dx = this.base1.getPositionX() - this.target_x;
            int dz = this.base1.getPositionZ() - this.target_z;
            this.up.set(dx, 0, dz);
            this.up.normalize();
            int blend2 = elapsed_time << 3 > 4096 ? 4096 : elapsed_time << 3;
            int blend1 = 4096 - blend2;
            this.dir.x = (this.dir.x * blend1 >> 12) + (this.up.x * blend2 >> 12);
            this.dir.y = (this.dir.y * blend1 >> 12) + (this.up.y * blend2 >> 12);
            this.dir.z = (this.dir.z * blend1 >> 12) + (this.up.z * blend2 >> 12);
            this.dir.normalize();
            this.up.set(0, 4096, 0);
            this.left = this.up.cross(this.dir, this.left);
            this.base1.setRotationMatrix(this.left, this.up, this.dir);
            if (dx * dx + dz * dz < 90000) {
                this.target_x = rndm.nextInt(4096) - 2048;
                this.target_z = rndm.nextInt(2048) - 1024;
            }
        }
        this.time += elapsed_time >> 1;
        if (this.hitpoints >= 0) {
            distx = this.base1.getWorldPositionX() - SCLevel.getCurrentX();
            distz = this.base1.getWorldPositionZ() - SCLevel.getCurrentZ();
            distx = distx < 0 ? -distx : distx;
            int n = distz = distz < 0 ? -distz : distz;
            if (distz > distx) {
                this.corrected_hitradius_z1 = this.hitradius - ((distz * (this.base1.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
                this.corrected_hitradius_x1 = this.hitradius;
            } else {
                this.corrected_hitradius_x1 = this.hitradius - ((distx * (this.base1.getWorldPositionY() - 700) >> 12) * 4096 >> 12);
                this.corrected_hitradius_z1 = this.hitradius;
            }
        }
        if (silo != null && this.silo_hitpoints >= 0) {
            distx = silo.getWorldPositionX() - SCLevel.getCurrentX();
            distz = silo.getWorldPositionZ() - SCLevel.getCurrentZ();
            distx = distx < 0 ? -distx : distx;
            int n = distz = distz < 0 ? -distz : distz;
            if (distz > distx) {
                this.corrected_hitradius_z2 = this.hitradius - ((distz * (silo.getWorldPositionY() - 1024 - 700) >> 12) * 4096 >> 12);
                this.corrected_hitradius_x2 = this.hitradius;
            } else {
                this.corrected_hitradius_x2 = this.hitradius - ((distx * (silo.getWorldPositionY() - 1024 - 700) >> 12) * 4096 >> 12);
                this.corrected_hitradius_z2 = this.hitradius;
            }
            if (this.sporn_enemy_delay < 0L) {
                SCEnemy pointEnemy;
                if (SCLevel.getEnemies().getEnemies().length < 4 && (pointEnemy = SCEnemyFactory.getPointEnemy(-1, 0, 1024, -512, 0, 0, 0, (AEScene)this.base_root.getParent(), SCLevel.getCurrentTile())) != null) {
                    SCLevel.getEnemies().addEnemy(pointEnemy);
                    this.base_root.getParent().addChild(pointEnemy.getGeometry());
                    this.base_root.getParent().addChild(pointEnemy.getExplosion());
                }
                this.sporn_enemy_delay = 7000L;
            } else if (canShoot) {
                this.sporn_enemy_delay -= (long)elapsed_time;
            }
            if (nukeStart) {
                silo.setAnimRange(200, Short.MAX_VALUE);
                silo.playAnim((byte)1);
                nukeStart = false;
            }
        }
    }

    public AEGraphNode getExplosion() {
        return this.explosion != null ? this.explosion.getParticleSystem() : null;
    }

    public SCWeaponSystem getWeapon() {
        return null;
    }

    public void reinit(int tx, int ty, int tz, int rx, int ry, int rz, AEScene modul_root, long tile) {
    }

    public boolean isUsed() {
        return this.tile >= SCLevel.getCurrentTile() && this.tile < SCLevel.getCurrentTile() + (long)SCLevel.modul.length;
    }

    public boolean isHit(long x, long y, long z) {
        int dz;
        int dx;
        if (this.hitpoints <= 0 && this.silo_hitpoints <= 0) {
            return false;
        }
        if (this.hitpoints > 0) {
            dx = (int)(x + SCLevel.global_tx - (long)this.base1.getWorldPositionX());
            dz = (int)(z + SCLevel.global_tz - (long)this.base1.getWorldPositionZ());
            if (dx <= this.corrected_hitradius_x1 && dx >= -this.corrected_hitradius_x1 && dz <= this.corrected_hitradius_z1 && dz >= -this.corrected_hitradius_z1) {
                this.last_hit = 1;
                return true;
            }
        }
        if (silo != null && this.silo_hitpoints > 0) {
            dx = (int)(x + SCLevel.global_tx - (long)silo.getWorldPositionX());
            dz = (int)(z + SCLevel.global_tz - (long)silo.getWorldPositionZ());
            if (dx > this.corrected_hitradius_x2 || dx < -this.corrected_hitradius_x2 || dz > this.corrected_hitradius_z2 || dz < -this.corrected_hitradius_z2) {
                return false;
            }
            this.last_hit = (byte)2;
            return true;
        }
        return false;
    }

    public int getEnemyClassId() {
        return this.target_count_id;
    }

    public void release() {
        if (this.base1 != null) {
            this.base1.release();
        }
        this.base1 = null;
        if (this.destroyed != null) {
            this.destroyed.release();
        }
        this.destroyed = null;
        if (this.base_root != null) {
            this.base_root.release();
        }
        this.base_root = null;
        if (this.shoot_node != null) {
            this.shoot_node.release();
        }
        this.shoot_node = null;
        if (silo != null) {
            silo.release();
        }
        silo = null;
        if (this.enemy_set != null) {
            this.enemy_set.removeAllEnemies();
        }
        this.enemy_set = null;
        if (this.explosion != null) {
            this.explosion.release();
        }
        this.explosion = null;
        if (this.weapon != null) {
            for (int i = 0; i < this.weapon.length; ++i) {
                this.weapon[i].release();
                this.weapon[i] = null;
            }
        }
        this.weapon = null;
        this.target_count_array = null;
        this.dir = null;
        this.up = null;
        this.left = null;
        rndm = null;
        canShoot = false;
        nukeCountdown = false;
        nukeStart = false;
    }

    public int getInitialHitpoints() {
        return this.initial_hitpoints;
    }

    public static void enableBoss() {
        canShoot = true;
        if (silo != null) {
            nukeCountdown = true;
            silo.playAnim((byte)1);
        }
    }
}

