/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike;

import AbyssEngine.AECamera;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGroup;
import AbyssEngine.AELookAtConstraint;
import AbyssEngine.AEMath;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AEScene;
import AbyssEngine.AEVector3D;
import AppKit.AEModule;
import contentHeliStrike.GameText;
import contentHeliStrike.MainMenu;
import contentHeliStrike.grh;
import contentHeliStrike.menu.SimpleTextBox;
import contentHeliStrike.menu.StaticImages;
import contentHeliStrike.menu.TextBox;
import javax.microedition.lcdui.Image;

public class MissionMenu
extends AEModule {
    private AECamera cam;
    private AEGroup cam_target;
    private AEScene root;
    private Image commander;
    private Image medal_accuracy_g;
    private Image medal_agility_g;
    private Image medal_mission_g;
    private Image medal_accuracy_s;
    private Image medal_agility_s;
    private Image medal_mission_s;
    private Image medal_accuracy_b;
    private Image medal_agility_b;
    private Image medal_mission_b;
    private Image lock_y;
    private Image lock_g;
    private int medal_id;
    private boolean medal_out_in;
    private int medal_y_offset;
    private static final int MEDAL_Y_OFFSET = 50;
    private static final long S_SELECT_MISSION = 4L;
    private static final long S_SHOW_MISSION = 8L;
    private static final int BORDER_EDGE = 5;
    private static final int[] cam_position = new int[]{0, 1024, 0, -550, 384, 190, -319, 384, 316, -110, 384, 514, 160, 384, 78, 104, 384, -60, -90, 384, -240, 7, 459, -574, 273, 459, -466, 389, 412, -312};
    private int cam_tx;
    private int cam_ty;
    private int cam_tz;
    private int current_cam;
    private TextBox mission_briefing;
    private AEVector3D tmp_pos1;
    private AEVector3D tmp_pos2;
    private AEVector3D tmp_pos3;
    private AEVector3D tmp_pos4;
    private long press_delay;
    private static final long PRESS_DELAY = 500L;
    private int missionLength;
    private int title_offset1;
    private int title_offset2;
    private static final int TITLE_OFFSET1 = -50;
    private static final int TITLE_OFFSET2 = -120;
    private long lock_blink;
    private static final long LOCK_BLINK = 250L;

    public int onInitialize() {
        StaticImages.load();
        this.mission_briefing = new TextBox(10, 30, grh.r_w - 20, grh.r_h - StaticImages.getStatusBarHeight() - 60, " ");
        this.mission_briefing.init();
        this.root = new AEScene();
        this.cam_target = new AEGroup();
        this.cam_target.setTranslation(0, 100, 0);
        this.root.addChild(this.cam_target);
        AEGeometry map = AEResourceManager.getGeometryResource(6000);
        this.root.addChild(map);
        this.cam = AECamera.create(grh.r_w, grh.r_h, 1024, 10, 4096);
        this.cam.setTranslation(0, 512, 0);
        this.root.addChild(this.cam);
        this.root.addConstraint(new AELookAtConstraint(this.cam_target, this.cam));
        grh.r_renderer.setCamera(this.cam);
        this.setCurrentCam(0);
        this.tmp_pos1 = new AEVector3D();
        this.tmp_pos2 = new AEVector3D();
        this.tmp_pos3 = new AEVector3D();
        this.tmp_pos4 = new AEVector3D();
        this.missionLength = 2;
        this.current_cam = grh.r_level + 1;
        this.changeStatus(4L, 0L);
        try {
            this.commander = Image.createImage((String)"/contentHeliStrike/interface/display_commander.png");
            this.medal_accuracy_g = Image.createImage((String)"/contentHeliStrike/interface/medal_accuracy_gold.png");
            this.medal_agility_g = Image.createImage((String)"/contentHeliStrike/interface/medal_agility_gold.png");
            this.medal_mission_g = Image.createImage((String)"/contentHeliStrike/interface/medal_mission_gold.png");
            this.medal_accuracy_s = Image.createImage((String)"/contentHeliStrike/interface/medal_accuracy_silver.png");
            this.medal_agility_s = Image.createImage((String)"/contentHeliStrike/interface/medal_agility_silver.png");
            this.medal_mission_s = Image.createImage((String)"/contentHeliStrike/interface/medal_mission_silver.png");
            this.medal_accuracy_b = Image.createImage((String)"/contentHeliStrike/interface/medal_accuracy_bronze.png");
            this.medal_agility_b = Image.createImage((String)"/contentHeliStrike/interface/medal_agility_bronze.png");
            this.medal_mission_b = Image.createImage((String)"/contentHeliStrike/interface/medal_mission_bronze.png");
            this.lock_y = Image.createImage((String)"/contentHeliStrike/interface/lock_y.png");
            this.lock_g = Image.createImage((String)"/contentHeliStrike/interface/lock_g.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.title_offset1 = -50;
        this.title_offset2 = -120;
        this.medal_y_offset = 50;
        this.medal_out_in = false;
        this.medal_id = this.current_cam;
        return 0;
    }

    private void setCurrentCam(int cam) {
        if (this.press_delay < 0L && (this.getStatus() & 4L) != 0L) {
            this.current_cam = cam > 9 ? 0 : (cam < 0 ? 9 : cam);
            this.medal_out_in = true;
            this.medal_y_offset = 1;
            this.press_delay = 500L;
        }
    }

    private void selectMission() {
        if (this.press_delay < 0L && this.current_cam != 0) {
            if ((this.getStatus() & 4L) != 0L) {
                this.changeStatus(8L, 4L);
                switch (this.current_cam) {
                    case 1: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(18));
                        break;
                    }
                    case 2: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(19));
                        break;
                    }
                    case 3: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(20));
                        break;
                    }
                    case 4: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(21));
                        break;
                    }
                    case 5: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(22));
                        break;
                    }
                    case 6: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(23));
                        break;
                    }
                    case 7: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(24));
                        break;
                    }
                    case 8: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(25));
                        break;
                    }
                    case 9: {
                        this.mission_briefing.setText(grh.MISSION_NAMES[this.current_cam - 1] + "\n" + GameText.getText(26));
                    }
                }
                this.mission_briefing.init();
            } else {
                this.changeStatus(4L, 8L);
            }
            this.press_delay = 500L;
        }
    }

    public void onKeyPress(int key) {
        switch (key) {
            case 32: 
            case 4096: 
            case 131072: {
                if ((this.getStatus() & 8L) != 0L && this.mission_briefing.fadeIn()) {
                    grh.r_level = this.current_cam - 1;
                    grh.r_handle.setModule(grh.r_modul[2]);
                    break;
                }
                if ((this.getStatus() & 4L) == 0L || grh.m_AchievedLevel < this.current_cam - 1) break;
                this.selectMission();
                break;
            }
            case 256: 
            case 65536: {
                if ((this.getStatus() & 8L) == 0L) break;
                this.mission_briefing.scrollDown();
                break;
            }
            case 64: 
            case 16384: {
                this.setCurrentCam(this.current_cam + 1);
                break;
            }
            case 4: 
            case 32768: {
                if ((this.getStatus() & 8L) == 0L) break;
                this.mission_briefing.scrollUp();
                break;
            }
            case 16: 
            case 8192: {
                this.setCurrentCam(this.current_cam - 1);
                break;
            }
            case 262144: {
                if ((this.getStatus() & 8L) != 0L && grh.m_AchievedLevel >= this.current_cam - 1) {
                    this.selectMission();
                    break;
                }
                if ((this.getStatus() & 4L) == 0L) break;
                grh.r_handle.setModule(grh.r_modul[3]);
            }
        }
    }

    public void onKeyRelease(int key) {
    }

    public void onRelease() {
        StaticImages.release();
        AEResourceManager.releaseAllResources();
        this.tmp_pos4 = null;
        this.tmp_pos3 = null;
        this.tmp_pos2 = null;
        this.tmp_pos1 = null;
        this.medal_mission_g = null;
        this.medal_agility_g = null;
        this.medal_accuracy_g = null;
        this.commander = null;
        this.medal_mission_s = null;
        this.medal_agility_s = null;
        this.medal_accuracy_s = null;
        this.medal_mission_b = null;
        this.medal_agility_b = null;
        this.medal_accuracy_b = null;
        this.lock_g = null;
        this.lock_y = null;
        if (this.cam != null) {
            this.cam.release();
        }
        this.cam = null;
        if (this.cam_target != null) {
            this.cam_target.release();
        }
        this.cam_target = null;
        if (this.root != null) {
            this.root.release();
        }
        this.root = null;
        this.mission_briefing = null;
    }

    public void onRender2D() {
        if ((this.getStatus() & 8L) != 0L) {
            this.tmp_pos1.x = cam_position[3 * this.current_cam] - 40;
            this.tmp_pos1.y = 0;
            this.tmp_pos1.z = cam_position[3 * this.current_cam + 2] - 40;
            this.tmp_pos2.x = cam_position[3 * this.current_cam] + 40;
            this.tmp_pos2.y = 0;
            this.tmp_pos2.z = cam_position[3 * this.current_cam + 2] - 40;
            this.tmp_pos3.x = cam_position[3 * this.current_cam] + 40;
            this.tmp_pos3.y = 0;
            this.tmp_pos3.z = cam_position[3 * this.current_cam + 2] + 40;
            this.tmp_pos4.x = cam_position[3 * this.current_cam] - 40;
            this.tmp_pos4.y = 0;
            this.tmp_pos4.z = cam_position[3 * this.current_cam + 2] + 40;
            if (grh.r_renderer.getScreenPosition(this.tmp_pos1) && grh.r_renderer.getScreenPosition(this.tmp_pos2) && grh.r_renderer.getScreenPosition(this.tmp_pos3) && grh.r_renderer.getScreenPosition(this.tmp_pos4)) {
                grh.r_g.setColor(-12287);
                grh.r_g.drawLine(this.tmp_pos1.x, this.tmp_pos1.y, this.tmp_pos2.x, this.tmp_pos2.y);
                grh.r_g.drawLine(this.tmp_pos2.x, this.tmp_pos2.y, this.tmp_pos3.x, this.tmp_pos3.y);
                grh.r_g.drawLine(this.tmp_pos3.x, this.tmp_pos3.y, this.tmp_pos4.x, this.tmp_pos4.y);
                grh.r_g.drawLine(this.tmp_pos1.x, this.tmp_pos1.y, this.tmp_pos4.x, this.tmp_pos4.y);
            }
            this.mission_briefing.draw();
        } else {
            for (int i = 1; i < 10; ++i) {
                this.tmp_pos1.x = cam_position[3 * i];
                this.tmp_pos1.y = 0;
                this.tmp_pos1.z = cam_position[3 * i + 2];
                this.tmp_pos2.x = cam_position[3 * i];
                this.tmp_pos2.y = 100;
                this.tmp_pos2.z = cam_position[3 * i + 2];
                if (!grh.r_renderer.getScreenPosition(this.tmp_pos1) || !grh.r_renderer.getScreenPosition(this.tmp_pos2)) continue;
                String score = GameText.getText(85) + " " + grh.m_Score[i - 1];
                String mission_name = grh.MISSION_NAMES[i - 1].substring(0, this.missionLength < grh.MISSION_NAMES[i - 1].length() ? this.missionLength : grh.MISSION_NAMES[i - 1].length());
                this.tmp_pos2.x -= grh.r_font.stringWidth(mission_name) >> 1;
                if (this.current_cam == i) {
                    grh.r_g.setColor(-12287);
                    grh.r_g.drawLine(this.tmp_pos2.x, this.tmp_pos2.y, this.tmp_pos1.x, this.tmp_pos1.y);
                    SimpleTextBox.draw(mission_name, true, this.tmp_pos2.x, this.tmp_pos2.y - (grh.r_font.getHeight() << 1) - 1, (byte)3);
                    SimpleTextBox.draw(score.substring(0, this.missionLength < score.length() ? this.missionLength : score.length()), true, this.tmp_pos2.x, this.tmp_pos2.y - grh.r_font.getHeight(), (byte)3);
                    if (grh.m_AchievedLevel >= i - 1) continue;
                    grh.r_g.drawImage(this.lock_y, this.tmp_pos2.x - this.lock_y.getWidth() - 3, this.tmp_pos2.y - (grh.r_font.getHeight() << 1) - 1 + (this.lock_y.getHeight() >> 1), 0);
                    continue;
                }
                grh.r_g.setColor(-7631989);
                grh.r_g.drawLine(this.tmp_pos2.x, this.tmp_pos2.y, this.tmp_pos1.x, this.tmp_pos1.y);
                SimpleTextBox.draw(mission_name, false, this.tmp_pos2.x, this.tmp_pos2.y - grh.r_font.getHeight(), (byte)3);
                if (grh.m_AchievedLevel >= i - 1) continue;
                grh.r_g.drawImage(this.lock_g, this.tmp_pos2.x - this.lock_g.getWidth() - 3, this.tmp_pos2.y - grh.r_font.getHeight() + (this.lock_g.getHeight() >> 1), 0);
            }
        }
        if (this.medal_id != 0) {
            int cx = 5;
            if ((grh.m_Medal[this.medal_id - 1] & 0x100) != 0) {
                grh.r_g.drawImage(this.medal_accuracy_g, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_accuracy_g.getHeight() + this.medal_y_offset, 0);
                cx += this.medal_accuracy_g.getWidth();
            } else if ((grh.m_Medal[this.medal_id - 1] & 0x10) != 0) {
                grh.r_g.drawImage(this.medal_accuracy_s, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_accuracy_s.getHeight() + this.medal_y_offset, 0);
                cx += this.medal_accuracy_s.getWidth();
            } else if ((grh.m_Medal[this.medal_id - 1] & 1) != 0) {
                grh.r_g.drawImage(this.medal_accuracy_b, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_accuracy_b.getHeight() + this.medal_y_offset, 0);
                cx += this.medal_accuracy_b.getWidth();
            }
            if ((grh.m_Medal[this.medal_id - 1] & 0x200) != 0) {
                grh.r_g.drawImage(this.medal_agility_g, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_agility_g.getHeight() + (this.medal_y_offset << 1), 0);
                cx += this.medal_agility_g.getWidth();
            } else if ((grh.m_Medal[this.medal_id - 1] & 0x20) != 0) {
                grh.r_g.drawImage(this.medal_agility_s, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_agility_s.getHeight() + (this.medal_y_offset << 1), 0);
                cx += this.medal_agility_s.getWidth();
            } else if ((grh.m_Medal[this.medal_id - 1] & 2) != 0) {
                grh.r_g.drawImage(this.medal_agility_b, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_agility_b.getHeight() + (this.medal_y_offset << 1), 0);
                cx += this.medal_agility_b.getWidth();
            }
            if ((grh.m_Medal[this.medal_id - 1] & 0x400) != 0) {
                grh.r_g.drawImage(this.medal_mission_g, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_mission_g.getHeight() + (this.medal_y_offset << 2), 0);
            } else if ((grh.m_Medal[this.medal_id - 1] & 0x40) != 0) {
                grh.r_g.drawImage(this.medal_mission_s, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_mission_s.getHeight() + (this.medal_y_offset << 2), 0);
            } else if ((grh.m_Medal[this.medal_id - 1] & 4) != 0) {
                grh.r_g.drawImage(this.medal_mission_b, cx, grh.r_h - StaticImages.getStatusBarHeight() - this.medal_mission_b.getHeight() + (this.medal_y_offset << 2), 0);
            }
        }
        if (this.medal_out_in) {
            this.medal_y_offset <<= 1;
            if (this.medal_y_offset > 50) {
                this.medal_out_in = false;
                this.medal_id = this.current_cam;
            }
        } else {
            this.medal_y_offset >>= 1;
        }
        StaticImages.drawStatusBar();
        grh.r_g.setColor(0x8B8B8B);
        grh.r_g.drawImage(StaticImages.buttonBack, grh.r_w - 4 - StaticImages.buttonBack.getWidth(), grh.r_h - 4 - StaticImages.buttonBack.getHeight(), 0);
        if (this.current_cam != 0 && (this.getStatus() & 4L) != 0L) {
            if (grh.m_AchievedLevel < this.current_cam - 1) {
                if (this.lock_blink < 0L) {
                    grh.r_g.setColor(-65536);
                }
                this.lock_blink -= this.elapsed_time;
                if (this.lock_blink < -250L) {
                    this.lock_blink = 250L;
                }
                grh.r_g.drawImage(StaticImages.buttonLocked, 4, grh.r_h - 4 - StaticImages.buttonLocked.getHeight(), 0);
            } else {
                grh.r_g.drawImage(StaticImages.buttonSelect, 4, grh.r_h - 4 - StaticImages.buttonSelect.getHeight(), 0);
            }
        } else if ((this.getStatus() & 4L) == 0L) {
            grh.r_g.drawImage(StaticImages.buttonSelect, 4, grh.r_h - 4 - StaticImages.buttonSelect.getHeight(), 0);
        }
        if ((this.getStatus() & 4L) != 0L) {
            this.title_offset1 -= this.title_offset1 * 512 >> 12;
            this.title_offset2 += -15;
        } else {
            this.title_offset1 += -7;
            this.title_offset2 -= this.title_offset2 * 512 >> 12;
        }
        SimpleTextBox.draw(GameText.getText(28), true, 0, this.title_offset1 + 4, (byte)18);
        SimpleTextBox.draw(GameText.getText(27), true, this.title_offset2 + 10, 4, (byte)3);
        grh.r_g.drawImage(this.commander, grh.r_w - this.commander.getWidth() - 4 - this.title_offset2, 3, 0);
        if ((this.getStatus() & 4L) != 0L) {
            MainMenu.iGeoffState = 0;
            grh.r_g.drawImage(StaticImages.buttonLeft, 4, grh.r_h >> 1, 2 | 4);
            grh.r_g.drawImage(StaticImages.buttonRight, grh.r_w - 4, grh.r_h >> 1, 2 | 8);
        }
    }

    public void onRender3D() {
        grh.r_g.setColor(0);
        grh.r_g.fillRect(0, 0, grh.r_w, grh.r_h);
        grh.r_device.bind(grh.r_g);
        grh.r_renderer.render(this.root);
        grh.r_renderer.drawLayers(this.ingame_time);
        grh.r_device.unbind(grh.r_g);
    }

    public void onStatusChange(long status_on, long status_off) {
    }

    public void onUpdate() {
        StaticImages.elapsed_time = (int)this.elapsed_time;
        if (this.press_delay >= 0L) {
            this.press_delay -= this.elapsed_time;
        }
        if ((this.getStatus() & 4L) != 0L) {
            if (this.current_cam == 0) {
                this.cam.translate(cam_position[3 * this.current_cam] - this.cam.getPositionX() >> 4, cam_position[3 * this.current_cam + 1] - this.cam.getPositionY() >> 4, cam_position[3 * this.current_cam + 2] + 512 - this.cam.getPositionZ() >> 4);
            } else {
                this.cam.translate(cam_position[3 * this.current_cam] - this.cam.getPositionX() >> 4, cam_position[3 * this.current_cam + 1] - this.cam.getPositionY() >> 4, cam_position[3 * this.current_cam + 2] + 100 - this.cam.getPositionZ() >> 4);
            }
            this.cam_target.translate(cam_position[3 * this.current_cam] - this.cam_target.getPositionX() >> 3, 0, cam_position[3 * this.current_cam + 2] - this.cam_target.getPositionZ() >> 3);
            if (this.current_cam == 0) {
                if (this.missionLength > 2) {
                    --this.missionLength;
                }
            } else if (this.missionLength < 15) {
                ++this.missionLength;
            }
        } else {
            this.cam.translate(cam_position[3 * this.current_cam] + (AEMath.sin((int)this.ingame_time >> 2) >> 5) - this.cam.getPositionX() >> 4, (cam_position[3 * this.current_cam + 1] >> 1) - this.cam.getPositionY() >> 4, cam_position[3 * this.current_cam + 2] + (AEMath.cos((int)this.ingame_time >> 2) >> 5) - this.cam.getPositionZ() >> 4);
            this.cam_target.translate(cam_position[3 * this.current_cam] - this.cam_target.getPositionX() >> 3, 0, cam_position[3 * this.current_cam + 2] - this.cam_target.getPositionZ() >> 3);
        }
    }
}

