/*
 * Decompiled with CFR 0.152.
 */
package ScrollerGame;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEParticleAccess;
import AbyssEngine.AERenderer;
import ScrollerGame.SCEnemy;
import ScrollerGame.SCEnemySet;
import ScrollerGame.SCLevel;

public class SCWeaponSystem {
    protected static final byte MODE_PARTICLE = 0;
    protected static final byte MODE_GEOMETRY = 1;
    public static final byte SHOOT_ONE = 0;
    public static final byte SHOOT_TWO = 1;
    public static final byte SHOOT_THREE = 2;
    public static final byte SHOOT_THREE_SPREAD = 3;
    public static final byte SHOOT_FOUR_SPREAD = 4;
    protected byte shoot_mode;
    protected SCEnemySet enemy_set;
    protected AERenderer renderer;
    protected AEGeometry geometry;
    protected AEGeometry[] geometry_copy;
    protected byte mode;
    protected int hitpoints;
    protected int count;
    protected int speed;
    protected int lifetime;
    protected int clifetime;
    protected boolean isActive;
    protected int next_indx;
    protected long[] ppos;
    protected int[] pdir;
    protected int[] pactive;
    protected long statsTotalShots;
    protected long statsHitShots;
    protected int shoot_delay;
    protected int fire_rate;
    protected AEExplosionInterface hit_explosion;
    protected long hit_x;
    protected long hit_y;
    protected long hit_z;

    public SCWeaponSystem(int count, int speed, int lifetime, int hitpoints, int fire_rate, AEGeometry geometry, AERenderer renderer) {
        this(count, speed, lifetime, hitpoints, fire_rate, geometry, renderer, null);
    }

    public SCWeaponSystem(int count, int speed, int lifetime, int hitpoints, int fire_rate, AEGeometry geometry, AERenderer renderer, AEExplosionInterface hit_explosion) {
        int i;
        this.count = count;
        this.lifetime = lifetime;
        this.hitpoints = hitpoints;
        this.fire_rate = fire_rate;
        this.ppos = new long[3 * count];
        for (i = 0; i < this.ppos.length; ++i) {
            this.ppos[i] = 32767L;
        }
        this.pdir = new int[3 * count];
        this.pactive = new int[count];
        this.statsHitShots = 0L;
        this.statsTotalShots = 0L;
        this.speed = speed;
        this.clifetime = 0;
        this.next_indx = 0;
        this.isActive = false;
        this.geometry = geometry;
        if (geometry instanceof AEParticleAccess) {
            this.mode = 0;
        } else {
            this.mode = 1;
            this.geometry_copy = new AEGeometry[count];
            this.geometry_copy[0] = geometry;
            for (i = 1; i < count; ++i) {
                this.geometry_copy[i] = (AEGeometry)geometry.copy();
            }
        }
        this.renderer = renderer;
        this.hit_explosion = hit_explosion;
        this.shoot_mode = 0;
    }

    public void reinit() {
        int i;
        for (i = 0; i < this.ppos.length; ++i) {
            this.ppos[i] = 32767L;
        }
        for (i = 0; i < this.pactive.length; ++i) {
            this.pactive[i] = -1;
        }
        this.isActive = false;
        this.clifetime = 0;
        this.next_indx = 0;
    }

    public void setShootMode(byte mode) {
        this.shoot_mode = mode;
    }

    public byte getShootMode() {
        return this.shoot_mode;
    }

    public int getAccuracyStats() {
        int result = (int)((this.statsHitShots << 12) / this.statsTotalShots);
        switch (this.shoot_mode) {
            case 0: {
                break;
            }
            case 1: {
                result = result * 3 / 2;
                break;
            }
            case 2: {
                result *= 2;
                break;
            }
            case 3: {
                result = result * 5 / 2;
                break;
            }
            case 4: {
                result *= 3;
            }
        }
        result = result < 4096 ? result : 4096;
        return result;
    }

    public void setEnemySet(SCEnemySet enemy_set) {
        this.enemy_set = enemy_set;
    }

    public void update(int elapsed_time) {
        if (this.isActive) {
            int tspeed = elapsed_time * this.speed >> 12;
            int s = 0;
            int i = 0;
            while (i < this.ppos.length) {
                if (this.pactive[s] > 0) {
                    int n = s;
                    this.pactive[n] = this.pactive[n] - elapsed_time;
                    int n2 = i;
                    this.ppos[n2] = this.ppos[n2] + (long)(this.pdir[i] * tspeed >> 12);
                    int n3 = i + 1;
                    this.ppos[n3] = this.ppos[n3] + (long)(this.pdir[i + 1] * tspeed >> 12);
                    int n4 = i + 2;
                    this.ppos[n4] = this.ppos[n4] + (long)(this.pdir[i + 2] * tspeed >> 12);
                } else {
                    this.ppos[i + 2] = 32767L;
                    this.ppos[i + 1] = 32767L;
                    this.ppos[i] = 32767L;
                }
                i += 3;
                ++s;
            }
            this.clifetime -= elapsed_time;
            if (this.clifetime < 0) {
                this.isActive = false;
                for (i = 0; i < this.ppos.length; ++i) {
                    this.ppos[i] = 32767L;
                }
            }
            if (this.enemy_set != null && !this.enemy_set.isEmpty()) {
                for (int e = 0; e < this.enemy_set.getEnemies().length; ++e) {
                    SCEnemy enemy = this.enemy_set.getEnemies()[e];
                    s = 0;
                    if (enemy.getEnemyClassId() == 10) continue;
                    int i2 = 0;
                    while (i2 < this.ppos.length) {
                        if (this.pactive[s] > 0 && enemy.isHit(this.ppos[i2], this.ppos[i2 + 1], this.ppos[i2 + 2])) {
                            enemy.applyHitpoints(-this.hitpoints);
                            this.pactive[s] = -1;
                            ++this.statsHitShots;
                            if (this.hit_explosion != null) {
                                this.hit_x = this.ppos[i2];
                                this.hit_y = this.ppos[i2 + 1];
                                this.hit_z = this.ppos[i2 + 2];
                                this.hit_explosion.getParticleSystem().setTranslation((int)(this.hit_x + SCLevel.global_tx), (int)this.hit_y, (int)(this.hit_z + SCLevel.global_tz));
                                this.hit_explosion.start();
                            }
                        }
                        i2 += 3;
                        ++s;
                    }
                }
            }
        }
        if (this.shoot_delay > 0) {
            this.shoot_delay -= elapsed_time;
        }
        if (this.hit_explosion != null && this.hit_explosion.isActive()) {
            this.hit_explosion.getParticleSystem().setTranslation((int)(this.hit_x + SCLevel.global_tx), (int)this.hit_y, (int)(this.hit_z + SCLevel.global_tz));
            this.hit_explosion.update(elapsed_time);
        }
    }

    public void shoot(AEGraphNode node) {
        if (this.shoot_delay <= 0) {
            int target_dx = node.getWorldPositionX() - SCLevel.getCurrentX();
            int target_dz = node.getWorldPositionZ() - SCLevel.getCurrentZ();
            target_dx = target_dx < 0 ? -target_dx : target_dx;
            int n = target_dz = target_dz < 0 ? -target_dz : target_dz;
            if (target_dx > 7000 || target_dz > 7000) {
                return;
            }
            this.isActive = true;
            this.clifetime = this.lifetime;
            switch (this.shoot_mode) {
                case 0: {
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.pdir[this.next_indx] = -node.getWorldDirectionX();
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.pdir[this.next_indx + 1] = -node.getWorldDirectionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx + 2] = -node.getWorldDirectionZ();
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    ++this.statsTotalShots;
                    break;
                }
                case 1: {
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx + (long)(node.getWorldRightX() * 128 >> 12);
                    this.ppos[this.next_indx + 1] = (long)node.getWorldPositionY() + (long)(node.getWorldRightY() * 128 >> 12);
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz + (long)(node.getWorldRightZ() * 128 >> 12);
                    this.pdir[this.next_indx] = -node.getWorldDirectionX();
                    this.pdir[this.next_indx + 1] = -node.getWorldDirectionY();
                    this.pdir[this.next_indx + 2] = -node.getWorldDirectionZ();
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx - (long)(node.getWorldRightX() * 128 >> 12);
                    this.ppos[this.next_indx + 1] = (long)node.getWorldPositionY() - (long)(node.getWorldRightY() * 128 >> 12);
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz - (long)(node.getWorldRightZ() * 128 >> 12);
                    this.pdir[this.next_indx] = -node.getWorldDirectionX();
                    this.pdir[this.next_indx + 1] = -node.getWorldDirectionY();
                    this.pdir[this.next_indx + 2] = -node.getWorldDirectionZ();
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.statsTotalShots += 2L;
                    break;
                }
                case 2: {
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx] = -node.getWorldDirectionX();
                    this.pdir[this.next_indx + 1] = -node.getWorldDirectionY();
                    this.pdir[this.next_indx + 2] = -node.getWorldDirectionZ();
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx + (long)(node.getWorldRightX() * 128 >> 12);
                    this.ppos[this.next_indx + 1] = (long)node.getWorldPositionY() + (long)(node.getWorldRightY() * 128 >> 12);
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz + (long)(node.getWorldRightZ() * 128 >> 12);
                    this.pdir[this.next_indx] = -node.getWorldDirectionX();
                    this.pdir[this.next_indx + 1] = -node.getWorldDirectionY();
                    this.pdir[this.next_indx + 2] = -node.getWorldDirectionZ();
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx - (long)(node.getWorldRightX() * 128 >> 12);
                    this.ppos[this.next_indx + 1] = (long)node.getWorldPositionY() - (long)(node.getWorldRightY() * 128 >> 12);
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz - (long)(node.getWorldRightZ() * 128 >> 12);
                    this.pdir[this.next_indx] = -node.getWorldDirectionX();
                    this.pdir[this.next_indx + 1] = -node.getWorldDirectionY();
                    this.pdir[this.next_indx + 2] = -node.getWorldDirectionZ();
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.statsTotalShots += 3L;
                    break;
                }
                case 3: {
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx] = -node.getWorldDirectionX();
                    this.pdir[this.next_indx + 1] = -node.getWorldDirectionY();
                    this.pdir[this.next_indx + 2] = -node.getWorldDirectionZ();
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx] = -(node.getWorldDirectionX() * 3584 >> 12) + (node.getWorldRightX() * 512 >> 12);
                    this.pdir[this.next_indx + 1] = -(node.getWorldDirectionY() * 3584 >> 12) + (node.getWorldRightY() * 512 >> 12);
                    this.pdir[this.next_indx + 2] = -(node.getWorldDirectionZ() * 3584 >> 12) + (node.getWorldRightZ() * 512 >> 12);
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx] = -(node.getWorldDirectionX() * 3584 >> 12) - (node.getWorldRightX() * 512 >> 12);
                    this.pdir[this.next_indx + 1] = -(node.getWorldDirectionY() * 3584 >> 12) - (node.getWorldRightY() * 512 >> 12);
                    this.pdir[this.next_indx + 2] = -(node.getWorldDirectionZ() * 3584 >> 12) - (node.getWorldRightZ() * 512 >> 12);
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.statsTotalShots += 3L;
                    break;
                }
                case 4: {
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx] = -(node.getWorldDirectionX() * 3840 >> 12) + (node.getWorldRightX() * 256 >> 12);
                    this.pdir[this.next_indx + 1] = -(node.getWorldDirectionY() * 3840 >> 12) + (node.getWorldRightY() * 256 >> 12);
                    this.pdir[this.next_indx + 2] = -(node.getWorldDirectionZ() * 3840 >> 12) + (node.getWorldRightZ() * 256 >> 12);
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx] = -(node.getWorldDirectionX() * 3840 >> 12) - (node.getWorldRightX() * 256 >> 12);
                    this.pdir[this.next_indx + 1] = -(node.getWorldDirectionY() * 3840 >> 12) - (node.getWorldRightY() * 256 >> 12);
                    this.pdir[this.next_indx + 2] = -(node.getWorldDirectionZ() * 3840 >> 12) - (node.getWorldRightZ() * 256 >> 12);
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx] = -(node.getWorldDirectionX() * 3328 >> 12) + (node.getWorldRightX() * 768 >> 12);
                    this.pdir[this.next_indx + 1] = -(node.getWorldDirectionY() * 3328 >> 12) + (node.getWorldRightY() * 768 >> 12);
                    this.pdir[this.next_indx + 2] = -(node.getWorldDirectionZ() * 3328 >> 12) + (node.getWorldRightZ() * 768 >> 12);
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
                    this.ppos[this.next_indx + 1] = node.getWorldPositionY();
                    this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
                    this.pdir[this.next_indx] = -(node.getWorldDirectionX() * 3328 >> 12) - (node.getWorldRightX() * 768 >> 12);
                    this.pdir[this.next_indx + 1] = -(node.getWorldDirectionY() * 3328 >> 12) - (node.getWorldRightY() * 768 >> 12);
                    this.pdir[this.next_indx + 2] = -(node.getWorldDirectionZ() * 3328 >> 12) - (node.getWorldRightZ() * 768 >> 12);
                    if (this.mode == 1) {
                        this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
                    }
                    this.pactive[this.next_indx / 3] = this.lifetime;
                    this.next_indx += 3;
                    this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
                    this.statsTotalShots += 4L;
                }
            }
            this.shoot_delay = this.fire_rate;
        }
    }

    public void shootBack(AEGraphNode node) {
        if (this.shoot_delay <= 0) {
            this.isActive = true;
            this.clifetime = this.lifetime;
            this.ppos[this.next_indx] = (long)node.getWorldPositionX() - SCLevel.global_tx;
            this.pdir[this.next_indx] = node.getWorldDirectionX();
            this.ppos[this.next_indx + 1] = node.getWorldPositionY();
            this.pdir[this.next_indx + 1] = node.getWorldDirectionY();
            this.ppos[this.next_indx + 2] = (long)node.getWorldPositionZ() - SCLevel.global_tz;
            this.pdir[this.next_indx + 2] = node.getWorldDirectionZ();
            if (this.mode == 1) {
                this.geometry_copy[this.next_indx / 3].setLocalTransform(node.getWorldTransform());
            }
            this.pactive[this.next_indx / 3] = this.lifetime;
            this.next_indx += 3;
            this.next_indx = this.next_indx == this.ppos.length ? 0 : this.next_indx;
            this.shoot_delay = this.fire_rate;
        }
    }

    public void render() {
        if (this.isActive) {
            switch (this.mode) {
                case 0: {
                    int[] pos = ((AEParticleAccess)((Object)this.geometry)).getPositions();
                    for (int i = 0; i < this.ppos.length; i += 3) {
                        pos[i] = (int)(this.ppos[i] + SCLevel.global_tx);
                        pos[i + 1] = (int)this.ppos[i + 1];
                        pos[i + 2] = (int)(this.ppos[i + 2] + SCLevel.global_tz);
                    }
                    this.renderer.render(this.geometry);
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.ppos.length; i += 3) {
                        this.geometry_copy[i / 3].setTranslation((int)(this.ppos[i] + SCLevel.global_tx), (int)this.ppos[i + 1], (int)(this.ppos[i + 2] + SCLevel.global_tz));
                        this.renderer.render(this.geometry_copy[i / 3]);
                    }
                    break;
                }
            }
            if (this.hit_explosion != null) {
                this.renderer.render(this.hit_explosion.getParticleSystem());
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void release() {
        this.enemy_set = null;
        this.renderer = null;
        this.geometry = null;
        for (int i = 0; this.geometry_copy != null && i < this.geometry_copy.length; ++i) {
            this.geometry_copy[i] = null;
        }
        this.geometry_copy = null;
        this.ppos = null;
        this.pdir = null;
        this.pactive = null;
        if (this.hit_explosion != null) {
            this.hit_explosion.release();
        }
        this.hit_explosion = null;
    }
}

