/*
 * Decompiled with CFR 0.152.
 */
package AppKit;

import AppKit.AEMenuPage;

public abstract class AEModule {
    public static final int KEY_NUM0 = 1;
    public static final int KEY_NUM1 = 2;
    public static final int KEY_NUM2 = 4;
    public static final int KEY_NUM3 = 8;
    public static final int KEY_NUM4 = 16;
    public static final int KEY_NUM5 = 32;
    public static final int KEY_NUM6 = 64;
    public static final int KEY_NUM7 = 128;
    public static final int KEY_NUM8 = 256;
    public static final int KEY_NUM9 = 512;
    public static final int KEY_STAR = 1024;
    public static final int KEY_POUND = 2048;
    public static final int KEY_FIRE = 4096;
    public static final int KEY_LEFT = 8192;
    public static final int KEY_RIGHT = 16384;
    public static final int KEY_UP = 32768;
    public static final int KEY_DOWN = 65536;
    public static final int KEY_SOFT_LEFT = 131072;
    public static final int KEY_SOFT_RIGHT = 262144;
    public static final int KEY_GAME_LEFT = 524288;
    public static final int KEY_GAME_RIGHT = 0x100000;
    public static final int KEY_BACK = 0x200000;
    public static final int KEY_CLEAR = 0x400000;
    public static final int KEY_ONLINE = 0x800000;
    public static final int KEY_LEFT_MASK = 8208;
    public static final int KEY_RIGHT_MASK = 16448;
    public static final int KEY_UP_MASK = 32772;
    public static final int KEY_DOWN_MASK = 65792;
    public static final long S_INITIALIZED = 1L;
    public static final long S_PAUSED = 2L;
    private long status;
    protected int keystate;
    protected long current_time;
    protected long last_time;
    protected long ingame_time;
    protected long elapsed_time;

    public AEMenuPage getPage() {
        return null;
    }

    public abstract int onInitialize();

    public abstract void onRelease();

    public abstract void onKeyPress(int var1);

    public abstract void onKeyRelease(int var1);

    public abstract void onStatusChange(long var1, long var3);

    public abstract void onUpdate();

    public abstract void onRender2D();

    public abstract void onRender3D();

    public int testSK(int x, int y) {
        return 0;
    }

    public final void keyReset() {
        this.keystate = 0;
    }

    public final void keyPress(int key) {
        switch (key) {
            case 48: 
            case 77: 
            case 109: {
                this.keystate |= 1;
                this.onKeyPress(1);
                break;
            }
            case 49: 
            case 82: 
            case 114: {
                this.keystate |= 2;
                this.onKeyPress(2);
                break;
            }
            case 50: 
            case 84: 
            case 116: {
                this.keystate |= 4;
                this.onKeyPress(4);
                break;
            }
            case 51: 
            case 89: 
            case 121: {
                this.keystate |= 8;
                this.onKeyPress(8);
                break;
            }
            case 52: 
            case 70: 
            case 102: {
                this.keystate |= 0x10;
                this.onKeyPress(16);
                break;
            }
            case 53: 
            case 71: 
            case 103: {
                this.keystate |= 0x20;
                this.onKeyPress(32);
                break;
            }
            case 54: 
            case 72: 
            case 104: {
                this.keystate |= 0x40;
                this.onKeyPress(64);
                break;
            }
            case 55: 
            case 86: 
            case 118: {
                this.keystate |= 0x80;
                this.onKeyPress(128);
                break;
            }
            case 56: 
            case 66: 
            case 98: {
                this.keystate |= 0x100;
                this.onKeyPress(256);
                break;
            }
            case 57: 
            case 78: 
            case 110: {
                this.keystate |= 0x200;
                this.onKeyPress(512);
                break;
            }
            case 42: 
            case 85: 
            case 117: {
                this.keystate |= 0x400;
                this.onKeyPress(1024);
                break;
            }
            case 35: 
            case 74: 
            case 106: {
                this.keystate |= 0x800;
                this.onKeyPress(2048);
                break;
            }
            case -5: {
                this.keystate |= 0x1000;
                this.onKeyPress(4096);
                break;
            }
            case -3: {
                this.keystate |= 0x2000;
                this.onKeyPress(8192);
                break;
            }
            case -4: {
                this.keystate |= 0x4000;
                this.onKeyPress(16384);
                break;
            }
            case -1: {
                this.keystate |= 0x8000;
                this.onKeyPress(32768);
                break;
            }
            case -2: {
                this.keystate |= 0x10000;
                this.onKeyPress(65536);
                break;
            }
            case -6: {
                this.keystate |= 0x20000;
                this.onKeyPress(131072);
                break;
            }
            case -7: {
                this.keystate |= 0x40000;
                this.onKeyPress(262144);
                break;
            }
            case -999: {
                this.keystate |= 0x80000;
                this.onKeyPress(524288);
                break;
            }
            case -666: {
                this.keystate |= 0x100000;
                this.onKeyPress(0x100000);
                break;
            }
            case -11: {
                this.keystate |= 0x200000;
                this.onKeyPress(0x200000);
                break;
            }
            case -8: {
                this.keystate |= 0x400000;
                this.onKeyPress(0x400000);
                break;
            }
            case -10: {
                this.keystate |= 0x800000;
                this.onKeyPress(0x800000);
            }
        }
    }

    public final void keyRelease(int key) {
        switch (key) {
            case 48: 
            case 77: 
            case 109: {
                this.keystate &= 0xFFFFFFFE;
                this.onKeyRelease(1);
                break;
            }
            case 49: 
            case 82: 
            case 114: {
                this.keystate &= 0xFFFFFFFD;
                this.onKeyRelease(2);
                break;
            }
            case 50: 
            case 84: 
            case 116: {
                this.keystate &= 0xFFFFFFFB;
                this.onKeyRelease(4);
                break;
            }
            case 51: 
            case 89: 
            case 121: {
                this.keystate &= 0xFFFFFFF7;
                this.onKeyRelease(8);
                break;
            }
            case 52: 
            case 70: 
            case 102: {
                this.keystate &= 0xFFFFFFEF;
                this.onKeyRelease(16);
                break;
            }
            case 53: 
            case 71: 
            case 103: {
                this.keystate &= 0xFFFFFFDF;
                this.onKeyRelease(32);
                break;
            }
            case 54: 
            case 72: 
            case 104: {
                this.keystate &= 0xFFFFFFBF;
                this.onKeyRelease(64);
                break;
            }
            case 55: 
            case 86: 
            case 118: {
                this.keystate &= 0xFFFFFF7F;
                this.onKeyRelease(128);
                break;
            }
            case 56: 
            case 66: 
            case 98: {
                this.keystate &= 0xFFFFFEFF;
                this.onKeyRelease(256);
                break;
            }
            case 57: 
            case 78: 
            case 110: {
                this.keystate &= 0xFFFFFDFF;
                this.onKeyRelease(512);
                break;
            }
            case 42: 
            case 85: 
            case 117: {
                this.keystate &= 0xFFFFFBFF;
                this.onKeyRelease(1024);
                break;
            }
            case 35: 
            case 74: 
            case 106: {
                this.keystate &= 0xFFFFF7FF;
                this.onKeyRelease(2048);
                break;
            }
            case -5: {
                this.keystate &= 0xFFFFEFFF;
                this.onKeyRelease(4096);
                break;
            }
            case -3: {
                this.keystate &= 0xFFFFDFFF;
                this.onKeyRelease(8192);
                break;
            }
            case -4: {
                this.keystate &= 0xFFFFBFFF;
                this.onKeyRelease(16384);
                break;
            }
            case -1: {
                this.keystate &= 0xFFFF7FFF;
                this.onKeyRelease(32768);
                break;
            }
            case -2: {
                this.keystate &= 0xFFFEFFFF;
                this.onKeyRelease(65536);
                break;
            }
            case -6: {
                this.keystate &= 0xFFFDFFFF;
                this.onKeyRelease(131072);
                break;
            }
            case -7: {
                this.keystate &= 0xFFFBFFFF;
                this.onKeyRelease(262144);
                break;
            }
            case -999: {
                this.keystate &= 0xFFF7FFFF;
                this.onKeyRelease(524288);
                break;
            }
            case -666: {
                this.keystate &= 0xFFEFFFFF;
                this.onKeyRelease(0x100000);
                break;
            }
            case -11: {
                this.keystate &= 0xFFDFFFFF;
                this.onKeyRelease(0x200000);
                break;
            }
            case -8: {
                this.keystate &= 0xFFBFFFFF;
                this.onKeyRelease(0x400000);
                break;
            }
            case -10: {
                this.keystate &= 0xFF7FFFFF;
                this.onKeyRelease(0x800000);
            }
        }
    }

    public final long getStatus() {
        return this.status;
    }

    public final void changeStatus(long status_on, long status_off) {
        this.status |= status_on;
        this.status &= status_off ^ 0xFFFFFFFFFFFFFFFFL;
        if (status_off == 2L) {
            this.current_time = this.last_time = System.currentTimeMillis();
            this.elapsed_time = 1L;
        }
        this.onStatusChange(status_on, status_off);
    }

    public final void resetStatus() {
        this.status = 0L;
    }

    public final void initTime() {
        this.current_time = this.last_time = System.currentTimeMillis();
        this.ingame_time = 0L;
        this.elapsed_time = 1L;
    }

    public final void updateTime() {
        this.last_time = this.current_time;
        this.current_time = System.currentTimeMillis();
        this.elapsed_time = this.current_time - this.last_time;
        if (this.elapsed_time == 0L || this.elapsed_time > 1000L) {
            this.elapsed_time = 1L;
            this.last_time = this.current_time;
        }
        if ((this.status & 2L) == 0L) {
            this.ingame_time += this.elapsed_time;
        }
    }
}

