/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AECamera;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AERenderer;
import AbyssEngine.AETexture;
import AbyssEngine.JSRDevice;
import AbyssEngine.JSRTexture;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Group;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Object3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;

public class JSRSkyBox
extends AEGeometry {
    private static Transform tmp_world = new Transform();
    private static float[] tmp_world_value = new float[16];
    private Node node;
    private static CompositingMode cm;

    public JSRSkyBox(String filename) {
        this.loadMeshFromFile(filename);
        this.culling_radius = 0;
        if (cm == null) {
            cm = new CompositingMode();
            cm.setDepthTestEnable(false);
            cm.setDepthWriteEnable(false);
        }
    }

    public JSRSkyBox(JSRSkyBox skybox) {
        this.culling_radius = 0;
        this.node = skybox.node;
        this.layer_id = skybox.layer_id;
        this.isVisible = skybox.isVisible;
    }

    private void loadMeshFromFile(String filename) {
        try {
            Object3D[] obj = Loader.load((String)(filename + ".m3g"));
            for (int i = 0; i < obj.length; ++i) {
                if (!(obj[i] instanceof Group)) continue;
                this.node = (Node)obj[i];
                break;
            }
        }
        catch (Exception e) {
            this.node = null;
        }
    }

    public void render() {
        this.render_matrix.getMatrix4x4F(tmp_world_value);
        JSRSkyBox.tmp_world_value[11] = 0.0f;
        JSRSkyBox.tmp_world_value[7] = 0.0f;
        JSRSkyBox.tmp_world_value[3] = 0.0f;
        tmp_world.set(tmp_world_value);
        JSRDevice.device.render(this.node, tmp_world);
    }

    public void prerender(AECamera camera, AERenderer renderer) {
        if (this.isVisible) {
            this.render_matrix = camera.world.getInverse(this.render_matrix);
            renderer.add2Layer(this.layer_id, this);
        }
    }

    public AEGraphNode copy() {
        return new JSRSkyBox(this);
    }

    public void setTexture(AETexture texture) {
        this.applyTexture((Group)this.node, ((JSRTexture)texture).getData());
    }

    private void applyTexture(Group g, Texture2D[] tex) {
        for (int i = 0; i < g.getChildCount(); ++i) {
            Node n = g.getChild(i);
            if (n instanceof Mesh) {
                int user_id = ((Mesh)n).getUserID();
                for (int k = 0; k < ((Mesh)n).getSubmeshCount(); ++k) {
                    Appearance ap = ((Mesh)n).getAppearance(k);
                    ap.setMaterial(null);
                    ap.setCompositingMode(cm);
                    if (ap.getTexture(0) == null) continue;
                    if (tex != null) {
                        if (user_id < tex.length) {
                            ap.setTexture(0, tex[user_id]);
                            continue;
                        }
                        ap.setTexture(0, tex[0]);
                        continue;
                    }
                    ap.setTexture(0, null);
                }
                continue;
            }
            if (!(n instanceof Group)) continue;
            this.applyTexture((Group)n, tex);
        }
    }

    public void release() {
        super.release();
    }
}

