/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;
import AbyssEngine.AEQuaternion;
import AbyssEngine.AEVector3D;

public class AETransform {
    public static final short ROT_XYZ = 0;
    public static final short ROT_XZY = 1;
    public static final short ROT_YXZ = 2;
    public static final short ROT_YZX = 3;
    public static final short ROT_ZXY = 4;
    public static final short ROT_ZYX = 5;
    private short rot;
    private int[] S = new int[3];
    private int[] R = new int[9];
    private int[] T = new int[3];
    private int rx;
    private int ry;
    private int rz;
    private boolean eulerNeedsUpdate;

    public AETransform() {
        this.setIdentity();
        this.rot = 0;
    }

    public AETransform(AETransform t) {
        System.arraycopy(t.S, 0, this.S, 0, this.S.length);
        System.arraycopy(t.R, 0, this.R, 0, this.R.length);
        System.arraycopy(t.T, 0, this.T, 0, this.T.length);
        this.rx = t.rx;
        this.ry = t.ry;
        this.rz = t.rz;
        this.eulerNeedsUpdate = t.eulerNeedsUpdate;
    }

    public void setIdentity() {
        this.S[2] = 4096;
        this.S[1] = 4096;
        this.S[0] = 4096;
        this.R[0] = 4096;
        this.R[3] = 0;
        this.R[6] = 0;
        this.R[1] = 0;
        this.R[4] = 4096;
        this.R[7] = 0;
        this.R[2] = 0;
        this.R[5] = 0;
        this.R[8] = 4096;
        this.T[2] = 0;
        this.T[1] = 0;
        this.T[0] = 0;
        this.rz = 0;
        this.ry = 0;
        this.rx = 0;
        this.eulerNeedsUpdate = false;
    }

    public void set(AETransform t) {
        System.arraycopy(t.S, 0, this.S, 0, this.S.length);
        System.arraycopy(t.R, 0, this.R, 0, this.R.length);
        System.arraycopy(t.T, 0, this.T, 0, this.T.length);
        this.rx = t.rx;
        this.ry = t.ry;
        this.rz = t.rz;
        this.eulerNeedsUpdate = t.eulerNeedsUpdate;
    }

    public void multiply(AETransform t) {
        int r0 = this.R[0];
        int r3 = this.R[3];
        int r6 = this.R[6];
        int r1 = this.R[1];
        int r4 = this.R[4];
        int r7 = this.R[7];
        int r2 = this.R[2];
        int r5 = this.R[5];
        int r8 = this.R[8];
        this.T[0] = this.T[0] + (this.S[0] * ((this.R[0] * t.T[0] >> 12) + (this.R[3] * t.T[1] >> 12) + (this.R[6] * t.T[2] >> 12)) >> 12);
        this.T[1] = this.T[1] + (this.S[1] * ((this.R[1] * t.T[0] >> 12) + (this.R[4] * t.T[1] >> 12) + (this.R[7] * t.T[2] >> 12)) >> 12);
        this.T[2] = this.T[2] + (this.S[2] * ((this.R[2] * t.T[0] >> 12) + (this.R[5] * t.T[1] >> 12) + (this.R[8] * t.T[2] >> 12)) >> 12);
        this.S[0] = this.S[0] * t.S[0] >> 12;
        this.S[1] = this.S[1] * t.S[1] >> 12;
        this.S[2] = this.S[2] * t.S[2] >> 12;
        this.R[0] = (r0 * t.R[0] >> 12) + (r3 * t.R[1] >> 12) + (r6 * t.R[2] >> 12);
        this.R[1] = (r1 * t.R[0] >> 12) + (r4 * t.R[1] >> 12) + (r7 * t.R[2] >> 12);
        this.R[2] = (r2 * t.R[0] >> 12) + (r5 * t.R[1] >> 12) + (r8 * t.R[2] >> 12);
        this.R[3] = (r0 * t.R[3] >> 12) + (r3 * t.R[4] >> 12) + (r6 * t.R[5] >> 12);
        this.R[4] = (r1 * t.R[3] >> 12) + (r4 * t.R[4] >> 12) + (r7 * t.R[5] >> 12);
        this.R[5] = (r2 * t.R[3] >> 12) + (r5 * t.R[4] >> 12) + (r8 * t.R[5] >> 12);
        this.R[6] = (r0 * t.R[6] >> 12) + (r3 * t.R[7] >> 12) + (r6 * t.R[8] >> 12);
        this.R[7] = (r1 * t.R[6] >> 12) + (r4 * t.R[7] >> 12) + (r7 * t.R[8] >> 12);
        this.R[8] = (r2 * t.R[6] >> 12) + (r5 * t.R[7] >> 12) + (r8 * t.R[8] >> 12);
        this.eulerNeedsUpdate = true;
    }

    public AETransform multiply(AETransform t, AETransform result) {
        result.T[0] = this.T[0] + (this.S[0] * ((this.R[0] * t.T[0] >> 12) + (this.R[3] * t.T[1] >> 12) + (this.R[6] * t.T[2] >> 12)) >> 12);
        result.T[1] = this.T[1] + (this.S[1] * ((this.R[1] * t.T[0] >> 12) + (this.R[4] * t.T[1] >> 12) + (this.R[7] * t.T[2] >> 12)) >> 12);
        result.T[2] = this.T[2] + (this.S[2] * ((this.R[2] * t.T[0] >> 12) + (this.R[5] * t.T[1] >> 12) + (this.R[8] * t.T[2] >> 12)) >> 12);
        result.S[0] = this.S[0] * t.S[0] >> 12;
        result.S[1] = this.S[1] * t.S[1] >> 12;
        result.S[2] = this.S[2] * t.S[2] >> 12;
        result.R[0] = (this.R[0] * t.R[0] >> 12) + (this.R[3] * t.R[1] >> 12) + (this.R[6] * t.R[2] >> 12);
        result.R[1] = (this.R[1] * t.R[0] >> 12) + (this.R[4] * t.R[1] >> 12) + (this.R[7] * t.R[2] >> 12);
        result.R[2] = (this.R[2] * t.R[0] >> 12) + (this.R[5] * t.R[1] >> 12) + (this.R[8] * t.R[2] >> 12);
        result.R[3] = (this.R[0] * t.R[3] >> 12) + (this.R[3] * t.R[4] >> 12) + (this.R[6] * t.R[5] >> 12);
        result.R[4] = (this.R[1] * t.R[3] >> 12) + (this.R[4] * t.R[4] >> 12) + (this.R[7] * t.R[5] >> 12);
        result.R[5] = (this.R[2] * t.R[3] >> 12) + (this.R[5] * t.R[4] >> 12) + (this.R[8] * t.R[5] >> 12);
        result.R[6] = (this.R[0] * t.R[6] >> 12) + (this.R[3] * t.R[7] >> 12) + (this.R[6] * t.R[8] >> 12);
        result.R[7] = (this.R[1] * t.R[6] >> 12) + (this.R[4] * t.R[7] >> 12) + (this.R[7] * t.R[8] >> 12);
        result.R[8] = (this.R[2] * t.R[6] >> 12) + (this.R[5] * t.R[7] >> 12) + (this.R[8] * t.R[8] >> 12);
        result.eulerNeedsUpdate = true;
        return result;
    }

    public void translate(int tx, int ty, int tz) {
        this.T[0] = this.T[0] + tx;
        this.T[1] = this.T[1] + ty;
        this.T[2] = this.T[2] + tz;
    }

    public void translate(AEVector3D pos) {
        this.T[0] = this.T[0] + pos.x;
        this.T[1] = this.T[1] + pos.y;
        this.T[2] = this.T[2] + pos.z;
    }

    public void setTranslation(int tx, int ty, int tz) {
        this.T[0] = tx;
        this.T[1] = ty;
        this.T[2] = tz;
    }

    public void setTranslation(AEVector3D pos) {
        this.T[0] = pos.x;
        this.T[1] = pos.y;
        this.T[2] = pos.z;
    }

    public void moveForward(int step) {
        this.T[0] = this.T[0] + (this.R[6] * step >> 12);
        this.T[1] = this.T[1] + (this.R[7] * step >> 12);
        this.T[2] = this.T[2] + (this.R[8] * step >> 12);
    }

    public void strafe(int step) {
        this.T[0] = this.T[0] + (this.R[0] * step >> 12);
        this.T[1] = this.T[1] + (this.R[1] * step >> 12);
        this.T[2] = this.T[2] + (this.R[2] * step >> 12);
    }

    public AEVector3D getPosition(AEVector3D result) {
        result.x = this.T[0];
        result.y = this.T[1];
        result.z = this.T[2];
        return result;
    }

    public AEVector3D getPosition() {
        return new AEVector3D(this.T[0], this.T[1], this.T[2]);
    }

    public int getPositionX() {
        return this.T[0];
    }

    public int getPositionY() {
        return this.T[1];
    }

    public int getPositionZ() {
        return this.T[2];
    }

    public int getDirectionX() {
        return this.R[6];
    }

    public int getDirectionY() {
        return this.R[7];
    }

    public int getDirectionZ() {
        return this.R[8];
    }

    public AEVector3D getDirection(AEVector3D result) {
        result.x = this.R[6];
        result.y = this.R[7];
        result.z = this.R[8];
        return result;
    }

    public AEVector3D getDirection() {
        return new AEVector3D(this.R[6], this.R[7], this.R[8]);
    }

    public AEVector3D getUpVector(AEVector3D result) {
        result.x = this.R[3];
        result.y = this.R[4];
        result.z = this.R[5];
        return result;
    }

    public AEVector3D getUpVector() {
        return new AEVector3D(this.R[3], this.R[4], this.R[5]);
    }

    public int getUpX() {
        return this.R[3];
    }

    public int getUpY() {
        return this.R[4];
    }

    public int getUpZ() {
        return this.R[5];
    }

    public AEVector3D getRightVector(AEVector3D result) {
        result.x = this.R[0];
        result.y = this.R[1];
        result.z = this.R[2];
        return result;
    }

    public AEVector3D getRightVector() {
        return new AEVector3D(this.R[0], this.R[1], this.R[2]);
    }

    public int getRightX() {
        return this.R[0];
    }

    public int getRightY() {
        return this.R[1];
    }

    public int getRightZ() {
        return this.R[2];
    }

    public void setRotationOrdering(short rot) {
        if (this.rot == rot) {
            return;
        }
        this.rot = rot;
        this.computeRotation();
        this.eulerNeedsUpdate = false;
    }

    public void rotate(int rx, int ry, int rz) {
        if (this.eulerNeedsUpdate) {
            this.computeRotation();
            this.eulerNeedsUpdate = false;
        }
        this.rx += rx;
        this.ry += ry;
        this.rz += rz;
        this.setRotation(this.rx, this.ry, this.rz);
    }

    public void setRotation(int rx, int ry, int rz) {
        this.rx = rx;
        this.ry = ry;
        this.rz = rz;
        this.eulerNeedsUpdate = false;
        int sx = AEMath.sin(rx);
        int sy = AEMath.sin(ry);
        int sz = AEMath.sin(rz);
        int cx = AEMath.cos(rx);
        int cy = AEMath.cos(ry);
        int cz = AEMath.cos(rz);
        switch (this.rot) {
            case 0: {
                this.R[0] = cy * cz >> 12;
                this.R[3] = -(cy * sz >> 12);
                this.R[6] = sy;
                this.R[1] = ((cz * sx >> 12) * sy >> 12) + (cx * sz >> 12);
                this.R[4] = (cx * cz >> 12) - ((sx * sy >> 12) * sz >> 12);
                this.R[7] = -(cy * sx >> 12);
                this.R[2] = -((cx * cz >> 12) * sy >> 12) + (sx * sz >> 12);
                this.R[5] = (cz * sx >> 12) + ((cx * sy >> 12) * sz >> 12);
                this.R[8] = cx * cy >> 12;
                break;
            }
            case 1: {
                this.R[0] = cy * cz >> 12;
                this.R[3] = -sz;
                this.R[6] = cz * sy >> 12;
                this.R[1] = (sx * sy >> 12) + ((cx * cy >> 12) * sz >> 12);
                this.R[4] = cx * cz >> 12;
                this.R[7] = -(cy * sx >> 12) + ((cx * sy >> 12) * sz >> 12);
                this.R[2] = -(cx * sy >> 12) + ((cy * sx >> 12) * sz >> 12);
                this.R[5] = cz * sx >> 12;
                this.R[8] = (cx * cy >> 12) + ((sx * sy >> 12) * sz >> 12);
                break;
            }
            case 2: {
                this.R[0] = (cy * cz >> 12) + ((sx * sy >> 12) * sz >> 12);
                this.R[3] = ((cz * sx >> 12) * sy >> 12) - (cy * sz >> 12);
                this.R[6] = cx * sy >> 12;
                this.R[1] = cx * sz >> 12;
                this.R[4] = cx * cz >> 12;
                this.R[7] = -sx;
                this.R[2] = -(cz * sy >> 12) + ((cy * sx >> 12) * sz >> 12);
                this.R[5] = ((cy * cz >> 12) * sx >> 12) + (sy * sz >> 12);
                this.R[8] = cx * cy >> 12;
                break;
            }
            case 3: {
                this.R[0] = cy * cz >> 12;
                this.R[3] = (sx * sy >> 12) - ((cx * cy >> 12) * sz >> 12);
                this.R[6] = (cx * sy >> 12) + ((cy * sx >> 12) * sz >> 12);
                this.R[1] = sz;
                this.R[4] = cx * cz >> 12;
                this.R[7] = -(cz * sx >> 12);
                this.R[2] = -(cz * sy >> 12);
                this.R[5] = (cy * sx >> 12) + ((cx * sy >> 12) * sz >> 12);
                this.R[8] = (cx * cy >> 12) - ((sx * sy >> 12) * sz >> 12);
                break;
            }
            case 4: {
                this.R[0] = (cy * cz >> 12) - ((sx * sy >> 12) * sz >> 12);
                this.R[3] = -(cx * sz >> 12);
                this.R[6] = (cz * sy >> 12) + ((cy * sx >> 12) * sz >> 12);
                this.R[1] = ((cz * sx >> 12) * sy >> 12) + (cy * sz >> 12);
                this.R[4] = cx * cz >> 12;
                this.R[7] = -((cy * cz >> 12) * sx >> 12) + (sy * sz >> 12);
                this.R[2] = -(cx * sy >> 12);
                this.R[5] = sx;
                this.R[8] = cx * cy >> 12;
                break;
            }
            case 5: {
                this.R[0] = cy * cz >> 12;
                this.R[3] = ((cz * sx >> 12) * sy >> 12) - (cx * sz >> 12);
                this.R[6] = ((cx * cz >> 12) * sy >> 12) + (sx * sz >> 12);
                this.R[1] = cy * sz >> 12;
                this.R[4] = (cx * cz >> 12) + ((sx * sy >> 12) * sz >> 12);
                this.R[7] = -(cz * sx >> 12) + ((cx * sy >> 12) * sz >> 12);
                this.R[2] = -sy;
                this.R[5] = cy * sx >> 12;
                this.R[8] = cx * cy >> 12;
            }
        }
    }

    public AEVector3D getRotation(AEVector3D result) {
        if (this.eulerNeedsUpdate) {
            this.computeRotation();
            this.eulerNeedsUpdate = false;
        }
        result.x = this.rx;
        result.y = this.ry;
        result.z = this.rz;
        return result;
    }

    public int getRotationX() {
        if (this.eulerNeedsUpdate) {
            this.computeRotation();
            this.eulerNeedsUpdate = false;
        }
        return this.rx;
    }

    public int getRotationY() {
        if (this.eulerNeedsUpdate) {
            this.computeRotation();
            this.eulerNeedsUpdate = false;
        }
        return this.ry;
    }

    public int getRotationZ() {
        if (this.eulerNeedsUpdate) {
            this.computeRotation();
            this.eulerNeedsUpdate = false;
        }
        return this.rz;
    }

    public AEVector3D getRotation() {
        return this.getRotation(new AEVector3D());
    }

    private void computeRotation() {
        switch (this.rot) {
            case 0: {
                this.ry = AEMath.asin(this.R[6]);
                if (this.ry < 2048) {
                    if (this.ry > -2048) {
                        this.rx = AEMath.atan2(-this.R[7], this.R[8]);
                        this.rz = AEMath.atan2(-this.R[3], this.R[0]);
                        break;
                    }
                    this.rx = -AEMath.atan2(this.R[1], this.R[4]);
                    this.rz = 0;
                    break;
                }
                this.rx = AEMath.atan2(this.R[1], this.R[4]);
                this.rz = 0;
                break;
            }
            case 1: {
                this.rz = AEMath.asin(-this.R[3]);
                if (this.rz < 2048) {
                    if (this.rz > -2048) {
                        this.rx = AEMath.atan2(this.R[5], this.R[4]);
                        this.ry = AEMath.atan2(this.R[6], this.R[0]);
                        break;
                    }
                    this.rx = -AEMath.atan2(-this.R[2], this.R[8]);
                    this.ry = 0;
                    break;
                }
                this.rx = AEMath.atan2(-this.R[2], this.R[8]);
                this.ry = 0;
                break;
            }
            case 2: {
                this.rx = AEMath.asin(-this.R[7]);
                if (this.rx < 2048) {
                    if (this.rx > -2048) {
                        this.ry = AEMath.atan2(this.R[6], this.R[8]);
                        this.rz = AEMath.atan2(this.R[1], this.R[4]);
                        break;
                    }
                    this.ry = -AEMath.atan2(-this.R[3], this.R[0]);
                    this.rz = 0;
                    break;
                }
                this.ry = AEMath.atan2(-this.R[3], this.R[0]);
                this.rz = 0;
                break;
            }
            case 3: {
                this.rz = AEMath.asin(this.R[1]);
                if (this.rz < 2048) {
                    if (this.rz > -2048) {
                        this.ry = AEMath.atan2(-this.R[2], this.R[0]);
                        this.rx = AEMath.atan2(-this.R[7], this.R[4]);
                        break;
                    }
                    this.ry = -AEMath.atan2(this.R[5], this.R[8]);
                    this.rx = 0;
                    break;
                }
                this.ry = AEMath.atan2(this.R[5], this.R[8]);
                this.rx = 0;
                break;
            }
            case 4: {
                this.rx = AEMath.asin(this.R[5]);
                if (this.rx < 2048) {
                    if (this.rx > -2048) {
                        this.rz = AEMath.atan2(-this.R[3], this.R[4]);
                        this.ry = AEMath.atan2(-this.R[2], this.R[8]);
                        break;
                    }
                    this.rz = -AEMath.atan2(this.R[6], this.R[0]);
                    this.ry = 0;
                    break;
                }
                this.rz = AEMath.atan2(this.R[6], this.R[0]);
                this.ry = 0;
                break;
            }
            case 5: {
                this.ry = AEMath.asin(-this.R[2]);
                if (this.ry < 2048) {
                    if (this.ry > -2048) {
                        this.rz = AEMath.atan2(this.R[1], this.R[0]);
                        this.rx = AEMath.atan2(this.R[5], this.R[8]);
                        break;
                    }
                    this.rz = -AEMath.atan2(-this.R[3], this.R[6]);
                    this.rx = 0;
                    break;
                }
                this.rz = AEMath.atan2(-this.R[3], this.R[6]);
                this.rx = 0;
            }
        }
    }

    public void setRotation(int x, int y, int z, int w) {
        this.R[0] = 4096 - (2 * y * y >> 12) - (2 * z * z >> 12);
        this.R[3] = (2 * x * y >> 12) - (2 * w * z >> 12);
        this.R[6] = (2 * x * z >> 12) + (2 * w * y >> 12);
        this.R[1] = (2 * x * y >> 12) + (2 * w * z >> 12);
        this.R[4] = 4096 - (2 * x * x >> 12) - (2 * z * z >> 12);
        this.R[7] = (2 * y * z >> 12) - (2 * w * x >> 12);
        this.R[2] = (2 * x * z >> 12) - (2 * w * y >> 12);
        this.R[5] = (2 * w * x >> 12) + (2 * y * z >> 12);
        this.R[8] = 4096 - (2 * x * x >> 12) - (2 * y * y >> 12);
        this.eulerNeedsUpdate = true;
    }

    public void setRotation(AEQuaternion q) {
        this.setRotation(q.x, q.y, q.z, q.w);
    }

    private int getColumn(int val) {
        return val < 2 ? val + 1 : 0;
    }

    public AEQuaternion getRotationQ(AEQuaternion result) {
        int trace = 4096 + this.R[0] + this.R[4] + this.R[8];
        int[] q = new int[3];
        if (trace > 0) {
            int s = AEMath.sqrt(trace);
            result.w = s >> 1;
            s = 0x800000 / s;
            result.x = (this.R[5] - this.R[7]) * s >> 12;
            result.y = (this.R[6] - this.R[2]) * s >> 12;
            result.z = (this.R[1] - this.R[3]) * s >> 12;
            return result;
        }
        int col = 0;
        if (this.R[4] > this.R[0]) {
            col = 1;
        }
        if (this.R[8] > this.R[col * 4]) {
            col = 2;
        }
        int temp = this.getColumn(col);
        int temp2 = this.getColumn(temp);
        int s = AEMath.sqrt(4096 + this.R[col * 4] - this.R[temp * 4] - this.R[temp2 * 4]);
        q[col] = s >> 1;
        if (s != 0) {
            s = 0x800000 / s;
        }
        q[temp] = (this.R[col + temp * 3] + this.R[temp + col * 3]) * s >> 12;
        q[temp2] = (this.R[col + temp2 * 3] + this.R[temp2 + col * 3]) * s >> 12;
        result.w = (this.R[temp + temp2 * 3] - this.R[temp2 + temp * 3]) * s >> 12;
        result.x = q[0];
        result.y = q[1];
        result.z = q[2];
        return result;
    }

    public AEQuaternion getRotationQ() {
        return this.getRotationQ(new AEQuaternion());
    }

    public void scale(int sx, int sy, int sz) {
        this.S[0] = this.S[0] * sx >> 12;
        this.S[1] = this.S[1] * sy >> 12;
        this.S[2] = this.S[2] * sz >> 12;
    }

    public void setScaling(int sx, int sy, int sz) {
        this.S[0] = sx;
        this.S[1] = sy;
        this.S[2] = sz;
    }

    public AEVector3D getScaling(AEVector3D result) {
        result.x = this.S[0];
        result.y = this.S[1];
        result.z = this.S[2];
        return result;
    }

    public int getScalingX() {
        return this.S[0];
    }

    public int getScalingY() {
        return this.S[1];
    }

    public int getScalingZ() {
        return this.S[2];
    }

    public AEVector3D getScaling() {
        return this.getScaling(new AEVector3D());
    }

    public AETransform getInverse(AETransform result) {
        result.S[0] = 0x1000000 / this.S[0];
        result.S[1] = 0x1000000 / this.S[1];
        result.S[2] = 0x1000000 / this.S[2];
        result.R[0] = this.R[0];
        result.R[3] = this.R[1];
        result.R[6] = this.R[2];
        result.R[1] = this.R[3];
        result.R[4] = this.R[4];
        result.R[7] = this.R[5];
        result.R[2] = this.R[6];
        result.R[5] = this.R[7];
        result.R[8] = this.R[8];
        result.T[0] = result.S[0] * (-(result.R[0] * this.T[0] >> 12) - (result.R[3] * this.T[1] >> 12) - (result.R[6] * this.T[2] >> 12)) >> 12;
        result.T[1] = result.S[1] * (-(result.R[1] * this.T[0] >> 12) - (result.R[4] * this.T[1] >> 12) - (result.R[7] * this.T[2] >> 12)) >> 12;
        result.T[2] = result.S[2] * (-(result.R[2] * this.T[0] >> 12) - (result.R[5] * this.T[1] >> 12) - (result.R[8] * this.T[2] >> 12)) >> 12;
        result.eulerNeedsUpdate = true;
        return result;
    }

    public AETransform getInverse() {
        return this.getInverse(new AETransform(this));
    }

    public void invert() {
        this.S[0] = 0x1000000 / this.S[0];
        this.S[1] = 0x1000000 / this.S[1];
        this.S[2] = 0x1000000 / this.S[2];
        int t1 = this.R[1];
        this.R[1] = this.R[3];
        this.R[3] = t1;
        t1 = this.R[2];
        this.R[2] = this.R[6];
        this.R[6] = t1;
        t1 = this.R[5];
        this.R[5] = this.R[7];
        this.R[7] = t1;
        t1 = this.T[0];
        int t2 = this.T[1];
        this.T[0] = this.S[0] * (-(this.R[0] * this.T[0] >> 12) - (this.R[3] * this.T[1] >> 12) - (this.R[6] * this.T[2] >> 12)) >> 12;
        this.T[1] = this.S[1] * (-(this.R[1] * t1 >> 12) - (this.R[4] * this.T[1] >> 12) - (this.R[7] * this.T[2] >> 12)) >> 12;
        this.T[2] = this.S[2] * (-(this.R[2] * t1 >> 12) - (this.R[5] * t2 >> 12) - (this.R[8] * this.T[2] >> 12)) >> 12;
        this.eulerNeedsUpdate = true;
    }

    public void setRotationMatrix(AEVector3D right, AEVector3D up, AEVector3D dir) {
        this.R[0] = right.x;
        this.R[3] = up.x;
        this.R[6] = dir.x;
        this.R[1] = right.y;
        this.R[4] = up.y;
        this.R[7] = dir.y;
        this.R[2] = right.z;
        this.R[5] = up.z;
        this.R[8] = dir.z;
        this.eulerNeedsUpdate = true;
    }

    public void getMatrix4x3I(int[] matrix) {
        matrix[0] = this.S[0] * this.R[0] >> 12;
        matrix[1] = this.S[1] * this.R[3] >> 12;
        matrix[2] = this.S[2] * this.R[6] >> 12;
        matrix[3] = this.T[0];
        matrix[4] = -(this.S[0] * this.R[1] >> 12);
        matrix[5] = -(this.S[1] * this.R[4] >> 12);
        matrix[6] = -(this.S[2] * this.R[7] >> 12);
        matrix[7] = -this.T[1];
        matrix[8] = -(this.S[0] * this.R[2] >> 12);
        matrix[9] = -(this.S[1] * this.R[5] >> 12);
        matrix[10] = -(this.S[2] * this.R[8] >> 12);
        matrix[11] = -this.T[2];
    }

    public void getMatrix4x4I(int[] matrix) {
        matrix[0] = this.S[0] * this.R[0] >> 12;
        matrix[2] = this.S[1] * this.R[3] >> 12;
        matrix[1] = this.S[2] * this.R[6] >> 12;
        matrix[3] = this.T[0];
        matrix[4] = -(this.S[0] * this.R[1] >> 12);
        matrix[6] = -(this.S[1] * this.R[4] >> 12);
        matrix[5] = -(this.S[2] * this.R[7] >> 12);
        matrix[7] = -this.T[1];
        matrix[8] = -(this.S[0] * this.R[2] >> 12);
        matrix[10] = -(this.S[1] * this.R[5] >> 12);
        matrix[9] = -(this.S[2] * this.R[8] >> 12);
        matrix[11] = -this.T[2];
        matrix[12] = 0;
        matrix[14] = 0;
        matrix[13] = 0;
        matrix[15] = 4096;
    }

    public void getMatrix4x3F(float[] matrix) {
        matrix[0] = (float)(this.S[0] * this.R[0]) * 5.9604645E-8f;
        matrix[1] = (float)(this.S[1] * this.R[3]) * 5.9604645E-8f;
        matrix[2] = (float)(this.S[2] * this.R[6]) * 5.9604645E-8f;
        matrix[3] = this.T[0];
        matrix[4] = (float)(this.S[0] * this.R[1]) * 5.9604645E-8f;
        matrix[5] = (float)(this.S[1] * this.R[4]) * 5.9604645E-8f;
        matrix[6] = (float)(this.S[2] * this.R[7]) * 5.9604645E-8f;
        matrix[7] = this.T[1];
        matrix[8] = (float)(this.S[0] * this.R[2]) * 5.9604645E-8f;
        matrix[9] = (float)(this.S[1] * this.R[5]) * 5.9604645E-8f;
        matrix[10] = (float)(this.S[2] * this.R[8]) * 5.9604645E-8f;
        matrix[11] = this.T[2];
    }

    public void getMatrix4x4F(float[] matrix) {
        matrix[0] = (float)(this.S[0] * this.R[0]) * 5.9604645E-8f;
        matrix[1] = (float)(this.S[1] * this.R[3]) * 5.9604645E-8f;
        matrix[2] = (float)(this.S[2] * this.R[6]) * 5.9604645E-8f;
        matrix[3] = this.T[0];
        matrix[4] = (float)(this.S[0] * this.R[1]) * 5.9604645E-8f;
        matrix[5] = (float)(this.S[1] * this.R[4]) * 5.9604645E-8f;
        matrix[6] = (float)(this.S[2] * this.R[7]) * 5.9604645E-8f;
        matrix[7] = this.T[1];
        matrix[8] = (float)(this.S[0] * this.R[2]) * 5.9604645E-8f;
        matrix[9] = (float)(this.S[1] * this.R[5]) * 5.9604645E-8f;
        matrix[10] = (float)(this.S[2] * this.R[8]) * 5.9604645E-8f;
        matrix[11] = this.T[2];
        matrix[12] = 0.0f;
        matrix[13] = 0.0f;
        matrix[14] = 0.0f;
        matrix[15] = 1.0f;
    }

    public String toString() {
        String result = "";
        result = result + "|\t" + (this.S[0] * this.R[0] >> 12) + ",\t" + (this.S[1] * this.R[3] >> 12) + ",\t" + (this.S[2] * this.R[6] >> 12) + ",\t" + this.T[0] + "\t|\n";
        result = result + "|\t" + (this.S[0] * this.R[1] >> 12) + ",\t" + (this.S[1] * this.R[4] >> 12) + ",\t" + (this.S[2] * this.R[7] >> 12) + ",\t" + this.T[1] + "\t|\n";
        result = result + "|\t" + (this.S[0] * this.R[2] >> 12) + ",\t" + (this.S[1] * this.R[5] >> 12) + ",\t" + (this.S[2] * this.R[8] >> 12) + ",\t" + this.T[2] + "\t|\n";
        return result;
    }

    public AEVector3D getTransformed(AEVector3D v, AEVector3D result) {
        result.x = ((this.S[0] * this.R[0] >> 12) * v.x >> 12) + ((this.S[1] * this.R[3] >> 12) * v.y >> 12) + ((this.S[2] * this.R[6] >> 12) * v.z >> 12) + this.T[0];
        result.y = ((this.S[0] * this.R[1] >> 12) * v.x >> 12) + ((this.S[1] * this.R[4] >> 12) * v.y >> 12) + ((this.S[2] * this.R[7] >> 12) * v.z >> 12) + this.T[1];
        result.z = ((this.S[0] * this.R[2] >> 12) * v.x >> 12) + ((this.S[1] * this.R[5] >> 12) * v.y >> 12) + ((this.S[2] * this.R[8] >> 12) * v.z >> 12) + this.T[2];
        return result;
    }

    public AEVector3D getRotated(AEVector3D v, AEVector3D result) {
        result.x = (this.R[0] * v.x >> 12) + (this.R[3] * v.y >> 12) + (this.R[6] * v.z >> 12);
        result.y = (this.R[1] * v.x >> 12) + (this.R[4] * v.y >> 12) + (this.R[7] * v.z >> 12);
        result.z = (this.R[2] * v.x >> 12) + (this.R[5] * v.y >> 12) + (this.R[8] * v.z >> 12);
        return result;
    }

    public AEVector3D getRotatedL(AEVector3D v, AEVector3D result) {
        long x = ((long)this.R[0] * (long)v.x >> 12) + ((long)this.R[3] * (long)v.y >> 12) + ((long)this.R[6] * (long)v.z >> 12);
        long y = ((long)this.R[1] * (long)v.x >> 12) + ((long)this.R[4] * (long)v.y >> 12) + ((long)this.R[7] * (long)v.z >> 12);
        long z = ((long)this.R[2] * (long)v.x >> 12) + ((long)this.R[5] * (long)v.y >> 12) + ((long)this.R[8] * (long)v.z >> 12);
        result.x = (int)x;
        result.y = (int)y;
        result.z = (int)z;
        return result;
    }

    public AEVector3D transform(AEVector3D result) {
        int x = result.x;
        int y = result.y;
        int z = result.z;
        result.x = ((this.S[0] * this.R[0] >> 12) * x >> 12) + ((this.S[1] * this.R[3] >> 12) * y >> 12) + ((this.S[2] * this.R[6] >> 12) * z >> 12) + this.T[0];
        result.y = ((this.S[0] * this.R[1] >> 12) * x >> 12) + ((this.S[1] * this.R[4] >> 12) * y >> 12) + ((this.S[2] * this.R[7] >> 12) * z >> 12) + this.T[1];
        result.z = ((this.S[0] * this.R[2] >> 12) * x >> 12) + ((this.S[1] * this.R[5] >> 12) * y >> 12) + ((this.S[2] * this.R[8] >> 12) * z >> 12) + this.T[2];
        return result;
    }

    public AEVector3D rotate(AEVector3D result) {
        int x = result.x;
        int y = result.y;
        int z = result.z;
        result.x = (this.R[0] * x >> 12) + (this.R[3] * y >> 12) + (this.R[6] * z >> 12);
        result.y = (this.R[1] * x >> 12) + (this.R[4] * y >> 12) + (this.R[7] * z >> 12);
        result.z = (this.R[2] * x >> 12) + (this.R[5] * y >> 12) + (this.R[8] * z >> 12);
        return result;
    }

    public AEVector3D[] getTransformed(AEVector3D[] v, AEVector3D[] result) {
        int m0 = this.S[0] * this.R[0] >> 12;
        int m3 = this.S[1] * this.R[3] >> 12;
        int m6 = this.S[2] * this.R[6] >> 12;
        int m1 = this.S[0] * this.R[1] >> 12;
        int m4 = this.S[1] * this.R[4] >> 12;
        int m7 = this.S[2] * this.R[7] >> 12;
        int m2 = this.S[0] * this.R[2] >> 12;
        int m5 = this.S[1] * this.R[5] >> 12;
        int m8 = this.S[2] * this.R[8] >> 12;
        for (int i = result.length - 1; i >= 0; --i) {
            result[i].x = (m0 * v[i].x >> 12) + (m3 * v[i].y >> 12) + (m6 * v[i].z >> 12) + this.T[0];
            result[i].y = (m1 * v[i].x >> 12) + (m4 * v[i].y >> 12) + (m7 * v[i].z >> 12) + this.T[1];
            result[i].z = (m2 * v[i].x >> 12) + (m5 * v[i].y >> 12) + (m8 * v[i].z >> 12) + this.T[2];
        }
        return result;
    }

    public AEVector3D[] getRotated(AEVector3D[] v, AEVector3D[] result) {
        for (int i = result.length - 1; i >= 0; --i) {
            result[i].x = (this.R[0] * v[i].x >> 12) + (this.R[3] * v[i].y >> 12) + (this.R[6] * v[i].z >> 12);
            result[i].y = (this.R[1] * v[i].x >> 12) + (this.R[4] * v[i].y >> 12) + (this.R[7] * v[i].z >> 12);
            result[i].z = (this.R[2] * v[i].x >> 12) + (this.R[5] * v[i].y >> 12) + (this.R[8] * v[i].z >> 12);
        }
        return result;
    }

    public AEVector3D[] getTransformed(AEVector3D[] result) {
        int m0 = this.S[0] * this.R[0] >> 12;
        int m3 = this.S[1] * this.R[3] >> 12;
        int m6 = this.S[2] * this.R[6] >> 12;
        int m1 = this.S[0] * this.R[1] >> 12;
        int m4 = this.S[1] * this.R[4] >> 12;
        int m7 = this.S[2] * this.R[7] >> 12;
        int m2 = this.S[0] * this.R[2] >> 12;
        int m5 = this.S[1] * this.R[5] >> 12;
        int m8 = this.S[2] * this.R[8] >> 12;
        for (int i = result.length - 1; i >= 0; --i) {
            int x = result[i].x;
            int y = result[i].y;
            int z = result[i].z;
            result[i].x = (m0 * x >> 12) + (m3 * y >> 12) + (m6 * z >> 12) + this.T[0];
            result[i].y = (m1 * x >> 12) + (m4 * y >> 12) + (m7 * z >> 12) + this.T[1];
            result[i].z = (m2 * x >> 12) + (m5 * y >> 12) + (m8 * z >> 12) + this.T[2];
        }
        return result;
    }

    public AEVector3D[] getRotated(AEVector3D[] result) {
        for (int i = result.length - 1; i >= 0; --i) {
            int x = result[i].x;
            int y = result[i].y;
            int z = result[i].z;
            result[i].x = (this.R[0] * x >> 12) + (this.R[3] * y >> 12) + (this.R[6] * z >> 12);
            result[i].y = (this.R[1] * x >> 12) + (this.R[4] * y >> 12) + (this.R[7] * z >> 12);
            result[i].z = (this.R[2] * x >> 12) + (this.R[5] * y >> 12) + (this.R[8] * z >> 12);
        }
        return result;
    }

    public AEVector3D inverseTransform(AEVector3D result) {
        int sx = 0x1000000 / this.S[0];
        int sy = 0x1000000 / this.S[1];
        int sz = 0x1000000 / this.S[2];
        int tx = sx * (-(this.R[0] * this.T[0] >> 12) - (this.R[1] * this.T[1] >> 12) - (this.R[2] * this.T[2] >> 12)) >> 12;
        int ty = sy * (-(this.R[3] * this.T[0] >> 12) - (this.R[4] * this.T[1] >> 12) - (this.R[5] * this.T[2] >> 12)) >> 12;
        int tz = sz * (-(this.R[6] * this.T[0] >> 12) - (this.R[7] * this.T[1] >> 12) - (this.R[8] * this.T[2] >> 12)) >> 12;
        int x = result.x;
        int y = result.y;
        int z = result.z;
        result.x = ((sx * this.R[0] >> 12) * x >> 12) + ((sy * this.R[1] >> 12) * y >> 12) + ((sz * this.R[2] >> 12) * z >> 12) + tx;
        result.y = ((sx * this.R[3] >> 12) * x >> 12) + ((sy * this.R[4] >> 12) * y >> 12) + ((sz * this.R[5] >> 12) * z >> 12) + ty;
        result.z = ((sx * this.R[6] >> 12) * x >> 12) + ((sy * this.R[7] >> 12) * y >> 12) + ((sz * this.R[8] >> 12) * z >> 12) + tz;
        return result;
    }

    public AEVector3D getInverseTransformed(AEVector3D v, AEVector3D result) {
        int sx = 0x1000000 / this.S[0];
        int sy = 0x1000000 / this.S[1];
        int sz = 0x1000000 / this.S[2];
        int tx = sx * (-(this.R[0] * this.T[0] >> 12) - (this.R[1] * this.T[1] >> 12) - (this.R[2] * this.T[2] >> 12)) >> 12;
        int ty = sy * (-(this.R[3] * this.T[0] >> 12) - (this.R[4] * this.T[1] >> 12) - (this.R[5] * this.T[2] >> 12)) >> 12;
        int tz = sz * (-(this.R[6] * this.T[0] >> 12) - (this.R[7] * this.T[1] >> 12) - (this.R[8] * this.T[2] >> 12)) >> 12;
        result.x = ((sx * this.R[0] >> 12) * v.x >> 12) + ((sy * this.R[3] >> 12) * v.y >> 12) + ((sz * this.R[6] >> 12) * v.z >> 12) + tx;
        result.y = ((sx * this.R[1] >> 12) * v.x >> 12) + ((sy * this.R[4] >> 12) * v.y >> 12) + ((sz * this.R[7] >> 12) * v.z >> 12) + ty;
        result.z = ((sx * this.R[2] >> 12) * v.x >> 12) + ((sy * this.R[5] >> 12) * v.y >> 12) + ((sz * this.R[8] >> 12) * v.z >> 12) + tz;
        return result;
    }

    public AEVector3D[] getInverseTransformed(AEVector3D[] result) {
        int sx = 0x1000000 / this.S[0];
        int sy = 0x1000000 / this.S[1];
        int sz = 0x1000000 / this.S[2];
        int m0 = sx * this.R[0] >> 12;
        int m3 = sy * this.R[3] >> 12;
        int m6 = sz * this.R[6] >> 12;
        int m1 = sx * this.R[1] >> 12;
        int m4 = sy * this.R[4] >> 12;
        int m7 = sz * this.R[7] >> 12;
        int m2 = sx * this.R[2] >> 12;
        int m5 = sy * this.R[5] >> 12;
        int m8 = sz * this.R[8] >> 12;
        for (int i = result.length - 1; i >= 0; --i) {
            int x = result[i].x;
            int y = result[i].y;
            int z = result[i].z;
            int tx = sx * (-(this.R[0] * this.T[0] >> 12) - (this.R[1] * this.T[1] >> 12) - (this.R[2] * this.T[2] >> 12)) >> 12;
            int ty = sy * (-(this.R[3] * this.T[0] >> 12) - (this.R[4] * this.T[1] >> 12) - (this.R[5] * this.T[2] >> 12)) >> 12;
            int tz = sz * (-(this.R[6] * this.T[0] >> 12) - (this.R[7] * this.T[1] >> 12) - (this.R[8] * this.T[2] >> 12)) >> 12;
            result[i].x = (m0 * x >> 12) + (m1 * y >> 12) + (m2 * z >> 12) + tx;
            result[i].y = (m3 * x >> 12) + (m4 * y >> 12) + (m5 * z >> 12) + ty;
            result[i].z = (m6 * x >> 12) + (m7 * y >> 12) + (m8 * z >> 12) + tz;
        }
        return result;
    }

    public AEVector3D[] getInverseTransformed(AEVector3D[] v, AEVector3D[] result) {
        int sx = 0x1000000 / this.S[0];
        int sy = 0x1000000 / this.S[1];
        int sz = 0x1000000 / this.S[2];
        int m0 = sx * this.R[0] >> 12;
        int m3 = sy * this.R[3] >> 12;
        int m6 = sz * this.R[6] >> 12;
        int m1 = sx * this.R[1] >> 12;
        int m4 = sy * this.R[4] >> 12;
        int m7 = sz * this.R[7] >> 12;
        int m2 = sx * this.R[2] >> 12;
        int m5 = sy * this.R[5] >> 12;
        int m8 = sz * this.R[8] >> 12;
        for (int i = result.length - 1; i >= 0; --i) {
            int tx = sx * (-(this.R[0] * this.T[0] >> 12) - (this.R[1] * this.T[1] >> 12) - (this.R[2] * this.T[2] >> 12)) >> 12;
            int ty = sy * (-(this.R[3] * this.T[0] >> 12) - (this.R[4] * this.T[1] >> 12) - (this.R[5] * this.T[2] >> 12)) >> 12;
            int tz = sz * (-(this.R[6] * this.T[0] >> 12) - (this.R[7] * this.T[1] >> 12) - (this.R[8] * this.T[2] >> 12)) >> 12;
            result[i].x = (m0 * v[i].x >> 12) + (m1 * v[i].y >> 12) + (m2 * v[i].z >> 12) + tx;
            result[i].y = (m3 * v[i].x >> 12) + (m4 * v[i].y >> 12) + (m5 * v[i].z >> 12) + ty;
            result[i].z = (m6 * v[i].x >> 12) + (m7 * v[i].y >> 12) + (m8 * v[i].z >> 12) + tz;
        }
        return result;
    }

    public AEVector3D inverseRotate(AEVector3D result) {
        int x = result.x;
        int y = result.y;
        int z = result.z;
        result.x = (this.R[0] * x >> 12) + (this.R[1] * y >> 12) + (this.R[2] * z >> 12);
        result.y = (this.R[3] * x >> 12) + (this.R[4] * y >> 12) + (this.R[5] * z >> 12);
        result.z = (this.R[6] * x >> 12) + (this.R[7] * y >> 12) + (this.R[8] * z >> 12);
        return result;
    }

    public AEVector3D getInverseRotated(AEVector3D v, AEVector3D result) {
        result.x = (this.R[0] * v.x >> 12) + (this.R[1] * v.y >> 12) + (this.R[2] * v.z >> 12);
        result.y = (this.R[3] * v.x >> 12) + (this.R[4] * v.y >> 12) + (this.R[5] * v.z >> 12);
        result.z = (this.R[6] * v.x >> 12) + (this.R[7] * v.y >> 12) + (this.R[8] * v.z >> 12);
        return result;
    }

    public AEVector3D[] getInverseRotated(AEVector3D[] result) {
        for (int i = result.length - 1; i >= 0; --i) {
            int x = result[i].x;
            int y = result[i].y;
            int z = result[i].z;
            result[i].x = (this.R[0] * x >> 12) + (this.R[1] * y >> 12) + (this.R[2] * z >> 12);
            result[i].y = (this.R[3] * x >> 12) + (this.R[4] * y >> 12) + (this.R[5] * z >> 12);
            result[i].z = (this.R[6] * x >> 12) + (this.R[7] * y >> 12) + (this.R[8] * z >> 12);
        }
        return result;
    }

    public AEVector3D[] getInverseRotated(AEVector3D[] v, AEVector3D[] result) {
        for (int i = result.length - 1; i >= 0; --i) {
            result[i].x = (this.R[0] * v[i].x >> 12) + (this.R[1] * v[i].y >> 12) + (this.R[2] * v[i].z >> 12);
            result[i].y = (this.R[3] * v[i].x >> 12) + (this.R[4] * v[i].y >> 12) + (this.R[5] * v[i].z >> 12);
            result[i].z = (this.R[6] * v[i].x >> 12) + (this.R[7] * v[i].y >> 12) + (this.R[8] * v[i].z >> 12);
        }
        return result;
    }
}

