/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEGeometry;
import AbyssEngine.AETexture;

public class AEResourceManager {
    public static final boolean VERBOSE = false;
    private static int[] texture_id;
    private static AETexture[] texture;
    private static String[] texture_filename;
    private static boolean[] texture_used;
    private static int[] geometry_id;
    private static AEGeometry[] geometry;
    private static int[] geometry_culling_radius;
    private static String[] geometry_filename;
    private static boolean[] geometry_used;
    private static int[] geometry_texture_id;
    private static int[] geometry_layer;
    public static final int NO_TEXTURE = Integer.MIN_VALUE;

    public static void addTextureResource(int id, String filename) {
        if (texture_filename == null) {
            texture_filename = new String[1];
            AEResourceManager.texture_filename[0] = filename;
            texture = new AETexture[1];
            texture_id = new int[1];
            AEResourceManager.texture_id[0] = id;
            texture_used = new boolean[1];
            AEResourceManager.texture_used[0] = false;
        } else {
            String[] new_texture_filename = new String[texture_filename.length + 1];
            System.arraycopy(texture_filename, 0, new_texture_filename, 0, texture_filename.length);
            new_texture_filename[AEResourceManager.texture_filename.length] = filename;
            texture_filename = new_texture_filename;
            AETexture[] new_texture = new AETexture[texture.length + 1];
            System.arraycopy(texture, 0, new_texture, 0, texture.length);
            texture = new_texture;
            int[] new_texture_id = new int[texture_id.length + 1];
            System.arraycopy(texture_id, 0, new_texture_id, 0, texture_id.length);
            new_texture_id[AEResourceManager.texture_id.length] = id;
            texture_id = new_texture_id;
            boolean[] new_texture_used = new boolean[texture_used.length + 1];
            System.arraycopy(texture_used, 0, new_texture_used, 0, texture_used.length);
            new_texture_used[AEResourceManager.texture_used.length] = false;
            texture_used = new_texture_used;
        }
    }

    public static void addGeometryResource(int id, String filename, int cullingradius, int texture_resource_id) {
        AEResourceManager.addGeometryResource(id, filename, cullingradius, texture_resource_id, -1);
    }

    public static void addGeometryResource(int id, String filename, int cullingradius, int texture_resource_id, int layer) {
        if (geometry_filename == null) {
            geometry_filename = new String[1];
            AEResourceManager.geometry_filename[0] = filename;
            geometry_culling_radius = new int[1];
            AEResourceManager.geometry_culling_radius[0] = cullingradius;
            geometry = new AEGeometry[1];
            geometry_id = new int[1];
            AEResourceManager.geometry_id[0] = id;
            geometry_used = new boolean[1];
            AEResourceManager.geometry_used[0] = false;
            geometry_texture_id = new int[1];
            AEResourceManager.geometry_texture_id[0] = texture_resource_id;
            geometry_layer = new int[1];
            AEResourceManager.geometry_layer[0] = layer;
        } else {
            String[] new_geometry_filename = new String[geometry_filename.length + 1];
            System.arraycopy(geometry_filename, 0, new_geometry_filename, 0, geometry_filename.length);
            new_geometry_filename[AEResourceManager.geometry_filename.length] = filename;
            geometry_filename = new_geometry_filename;
            int[] new_geometry_culling_radius = new int[geometry_culling_radius.length + 1];
            System.arraycopy(geometry_culling_radius, 0, new_geometry_culling_radius, 0, geometry_culling_radius.length);
            new_geometry_culling_radius[AEResourceManager.geometry_culling_radius.length] = cullingradius;
            geometry_culling_radius = new_geometry_culling_radius;
            AEGeometry[] new_geometry = new AEGeometry[geometry.length + 1];
            System.arraycopy(geometry, 0, new_geometry, 0, geometry.length);
            geometry = new_geometry;
            int[] new_geometry_id = new int[geometry_id.length + 1];
            System.arraycopy(geometry_id, 0, new_geometry_id, 0, geometry_id.length);
            new_geometry_id[AEResourceManager.geometry_id.length] = id;
            geometry_id = new_geometry_id;
            boolean[] new_geometry_used = new boolean[geometry_used.length + 1];
            System.arraycopy(geometry_used, 0, new_geometry_used, 0, geometry_used.length);
            new_geometry_used[AEResourceManager.geometry_used.length] = false;
            geometry_used = new_geometry_used;
            int[] new_geometry_texture_id = new int[geometry_texture_id.length + 1];
            System.arraycopy(geometry_texture_id, 0, new_geometry_texture_id, 0, geometry_texture_id.length);
            new_geometry_texture_id[AEResourceManager.geometry_texture_id.length] = texture_resource_id;
            geometry_texture_id = new_geometry_texture_id;
            int[] new_geometry_layer = new int[geometry_layer.length + 1];
            System.arraycopy(geometry_layer, 0, new_geometry_layer, 0, geometry_layer.length);
            new_geometry_layer[AEResourceManager.geometry_layer.length] = layer;
            geometry_layer = new_geometry_layer;
        }
    }

    public static void addGeometryResource(int id, String filename, int cullingradius) {
        AEResourceManager.addGeometryResource(id, filename, cullingradius, Integer.MIN_VALUE);
    }

    public static void addSkyBoxResource(int id, String filename, int texture_resource_id) {
        AEResourceManager.addGeometryResource(id, filename, -1, texture_resource_id);
    }

    public static void addSkyBoxResource(int id, String filename) {
        AEResourceManager.addGeometryResource(id, filename, -1);
    }

    public static AETexture getTextureResource(int id) {
        for (int i = 0; i < texture_id.length; ++i) {
            if (id != texture_id[i]) continue;
            AEResourceManager.texture_used[i] = true;
            if (texture[i] == null) {
                String[] tmp = new String[]{texture_filename[i]};
                AEResourceManager.texture[i] = AETexture.create(tmp);
                return texture[i];
            }
            return texture[i];
        }
        return null;
    }

    public static AEGeometry getGeometryResource(int id) {
        for (int i = 0; i < geometry_id.length; ++i) {
            if (id != geometry_id[i]) continue;
            AEResourceManager.geometry_used[i] = true;
            if (geometry[i] == null) {
                if (geometry_culling_radius[i] == -1) {
                    AEResourceManager.geometry[i] = AEGeometry.createSkyBox(geometry_filename[i]);
                } else {
                    AEResourceManager.geometry[i] = AEGeometry.createMesh(geometry_filename[i], geometry_culling_radius[i]);
                    if (geometry[i] != null) {
                        if (geometry_layer[i] == -1) {
                            geometry[i].setLayer(1);
                        } else {
                            geometry[i].setLayer(geometry_layer[i]);
                        }
                    }
                }
                if (geometry[i] != null && geometry_texture_id[i] != Integer.MIN_VALUE) {
                    geometry[i].setTexture(AEResourceManager.getTextureResource(geometry_texture_id[i]));
                }
                return geometry[i];
            }
            return (AEGeometry)geometry[i].copy();
        }
        return null;
    }

    public static AEGeometry getGeometryIntanceResource(int id) {
        for (int i = 0; i < geometry_id.length; ++i) {
            if (id != geometry_id[i]) continue;
            AEResourceManager.geometry_used[i] = true;
            if (geometry[i] == null) {
                if (geometry_culling_radius[i] == -1) {
                    AEResourceManager.geometry[i] = AEGeometry.createSkyBox(geometry_filename[i]);
                } else {
                    AEResourceManager.geometry[i] = AEGeometry.createMesh(geometry_filename[i], geometry_culling_radius[i]);
                    if (geometry_layer[i] == -1) {
                        geometry[i].setLayer(1);
                    } else {
                        geometry[i].setLayer(geometry_layer[i]);
                    }
                }
                if (geometry[i] != null && geometry_texture_id[i] != Integer.MIN_VALUE) {
                    geometry[i].setTexture(AEResourceManager.getTextureResource(geometry_texture_id[i]));
                }
                return geometry[i];
            }
            return geometry[i];
        }
        return null;
    }

    public static void releaseAllResources() {
    }

    public static void releaseGeometryResource(int id) {
        for (int i = 0; i < geometry_id.length; ++i) {
            if (id != geometry_id[i] || geometry[i] == null) continue;
            geometry[i].release();
            AEResourceManager.geometry[i] = null;
        }
    }

    public static void startNewResourceList() {
        int i;
        for (i = 0; i < geometry_used.length; ++i) {
            AEResourceManager.geometry_used[i] = false;
        }
        for (i = 0; i < texture_used.length; ++i) {
            AEResourceManager.texture_used[i] = false;
        }
    }

    public static void endNewResourceList() {
        int i;
        for (i = 0; i < geometry_used.length; ++i) {
            if (geometry_used[i]) continue;
            if (geometry[i] != null) {
                geometry[i].release();
            }
            AEResourceManager.geometry[i] = null;
        }
        for (i = 0; i < texture_used.length; ++i) {
            if (texture_used[i]) continue;
            if (texture[i] != null) {
                texture[i].release();
            }
            AEResourceManager.texture[i] = null;
        }
    }

    public static void prepareResourceList(int[] texture_resource_id, int[] geometry_resource_id) {
        int k;
        int i;
        AEResourceManager.startNewResourceList();
        block0: for (i = 0; i < texture.length; ++i) {
            for (k = 0; k < texture_resource_id.length; ++k) {
                if (texture_id[i] != texture_resource_id[k]) continue;
                AEResourceManager.texture_used[i] = true;
                continue block0;
            }
        }
        block2: for (i = 0; i < geometry.length; ++i) {
            for (k = 0; k < geometry_resource_id.length; ++k) {
                if (geometry_id[i] != geometry_resource_id[k]) continue;
                AEResourceManager.geometry_used[i] = true;
                continue block2;
            }
        }
        AEResourceManager.endNewResourceList();
    }

    public static String getString() {
        int i;
        String result = "\n\t------------------- AEResourceManager -------------------\n";
        for (i = 0; i < texture.length; ++i) {
            result = result + "\t*\tTEXTURE: \"" + texture_filename[i] + "\"\n" + "\t\t id: " + texture_id[i] + "\tused: " + texture_used[i] + "\tloaded: " + (texture[i] != null) + "\n";
        }
        result = result + "\t---------------------------------------------------------\n";
        for (i = 0; i < geometry.length; ++i) {
            result = result + "\t*\tGEOMETRY: \"" + geometry_filename[i] + "\" | culling-radius: " + geometry_culling_radius[i] + "\n" + "\t\t id: " + geometry_id[i] + "\tused: " + geometry_used[i] + "\tloaded: " + (geometry[i] != null) + "\n";
            result = geometry_texture_id[i] == Integer.MIN_VALUE ? result + "\t\t no texture-resource assigned.\n" : result + "\t\t texture-resource " + geometry_texture_id[i] + " assigned.\n";
        }
        result = result + "\t------------------- AEResourceManager -------------------\n\n";
        return result;
    }

    public static String getDuplicates() {
        boolean error = false;
        String result = "\n\t------------------- AEResourceManager | Duplicates -------------------\n";
        for (int i = 0; i < geometry.length; ++i) {
            for (int k = i + 1; k < geometry.length; ++k) {
                if (geometry_filename[i] == geometry_filename[k]) {
                    result = result + geometry_filename[i] + " with id: " + geometry_id[i] + " and id: " + geometry_id[k] + "\n";
                    error = true;
                }
                if (geometry_id[i] != geometry_id[k]) continue;
                result = result + geometry_id[i] + " with file: " + geometry_filename[i] + " and file: " + geometry_filename[k] + "\n";
                error = true;
            }
        }
        result = result + "\n\t------------------- AEResourceManager | Duplicates -------------------\n";
        if (error) {
            return result;
        }
        return "";
    }
}

