/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEExplosionInterface;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEParticleAccess;
import AbyssEngine.AETexture;
import java.util.Random;

public class AEExplosion
implements AEExplosionInterface {
    private AEGeometry particleSystem;
    private int[] p_lifetime;
    private int max_lifetime;
    private int max_size;
    private int max_posvariation;
    private int max_timevariation;

    public AEExplosion(int particle_count, AETexture texture, int tex_size, int u1, int v1, int u2, int v2, int size, int lifetime, int timevariation) {
        this(particle_count, texture, tex_size, u1, v1, u2, v2, size, lifetime, timevariation, size >> 1);
    }

    public AEExplosion(int particle_count, AETexture texture, int tex_size, int u1, int v1, int u2, int v2, int size, int lifetime, int timevariation, int posvariation) {
        this.max_size = size;
        this.max_lifetime = lifetime;
        this.max_timevariation = timevariation;
        this.max_posvariation = posvariation;
        this.p_lifetime = new int[particle_count];
        this.particleSystem = AEGeometry.createParticleSystem(tex_size, u1, v1, u2, v2, size, particle_count, (byte)2);
        this.particleSystem.setTexture(texture);
        AEParticleAccess pa = (AEParticleAccess)((Object)this.particleSystem);
        int[] p_pos = pa.getPositions();
        int[] p_size = pa.getSizes();
        Random rndm = new Random();
        for (int i = 0; i < particle_count; ++i) {
            p_pos[3 * i] = rndm.nextInt(this.max_posvariation) - (this.max_posvariation >> 1);
            p_pos[3 * i + 1] = rndm.nextInt(this.max_posvariation) - (this.max_posvariation >> 1);
            p_pos[3 * i + 2] = rndm.nextInt(this.max_posvariation) - (this.max_posvariation >> 1);
            p_size[i] = 0;
            this.p_lifetime[i] = rndm.nextInt(timevariation) - (timevariation >> 1) + this.max_lifetime;
        }
        this.particleSystem.setVisible(false);
    }

    public AEGeometry getParticleSystem() {
        return this.particleSystem;
    }

    public void start() {
        AEParticleAccess pa = (AEParticleAccess)((Object)this.particleSystem);
        int[] p_pos = pa.getPositions();
        int[] p_size = pa.getSizes();
        int[] p_color = pa.getColors();
        Random rndm = new Random();
        for (int i = 0; i < p_size.length; ++i) {
            p_pos[3 * i] = rndm.nextInt(this.max_posvariation) - (this.max_posvariation >> 1);
            p_pos[3 * i + 1] = rndm.nextInt(this.max_posvariation) - (this.max_posvariation >> 1);
            p_pos[3 * i + 2] = rndm.nextInt(this.max_posvariation) - (this.max_posvariation >> 1);
            p_size[i] = 0;
            p_color[i] = -1;
            this.p_lifetime[i] = rndm.nextInt(this.max_timevariation) - (this.max_timevariation >> 1) + this.max_lifetime;
        }
        this.particleSystem.setVisible(true);
    }

    public void update(int elapsed_time) {
        int[] p_size = ((AEParticleAccess)((Object)this.particleSystem)).getSizes();
        int[] p_color = ((AEParticleAccess)((Object)this.particleSystem)).getColors();
        int sizestep = elapsed_time * this.max_size / this.max_lifetime;
        this.particleSystem.setVisible(false);
        int i = 0;
        while (i < p_size.length) {
            if (this.p_lifetime[i] > 0 && this.p_lifetime[i] < this.max_lifetime) {
                int n = i;
                p_size[n] = p_size[n] + sizestep;
                this.particleSystem.setVisible(true);
            } else if (this.p_lifetime[i] > -1024) {
                int alpha = (p_color[i] >> 24 & 0xFF) - (elapsed_time >> 2);
                if (alpha < 0) {
                    alpha = 0;
                } else {
                    this.particleSystem.setVisible(true);
                }
                p_color[i] = alpha << 24 | 0xFFFFFF;
            } else {
                p_size[i] = 0;
            }
            int n = i++;
            this.p_lifetime[n] = this.p_lifetime[n] - elapsed_time;
        }
    }

    public boolean isActive() {
        return this.particleSystem.isVisible();
    }

    public void stop() {
        this.particleSystem.setVisible(false);
    }

    public void release() {
        if (this.particleSystem != null) {
            this.particleSystem.release();
        }
        this.particleSystem = null;
        this.p_lifetime = null;
    }
}

