/*
 * Decompiled with CFR 0.152.
 */
package contentHeliStrike.menu;

import AppKit.AEMenuButton;
import AppKit.AEToggleMenuAction;
import contentHeliStrike.GameText;
import contentHeliStrike.grh;
import contentHeliStrike.menu.StaticImages;

public class MenuToggleButton
extends AEMenuButton {
    private static final int TYPE_SPEED = 15;
    private boolean isSelected;
    private String caption;
    private int captionId;
    private int type_in;
    private int type_in_delay;
    private int type_out_delay;
    private int color;
    private int right_border;

    public MenuToggleButton(AEToggleMenuAction action, String caption) {
        super(action);
        this.caption = caption;
        this.captionId = -1;
    }

    public MenuToggleButton(AEToggleMenuAction action, int captionId) {
        super(action);
        this.caption = "";
        this.captionId = captionId;
    }

    public void draw() {
        if (this.isSelected) {
            StaticImages.drawCursor(this.x + grh.r_font.substringWidth(this.caption, 0, this.type_in), this.y);
            grh.r_g.setColor(16765707);
            if (this.type_in >= this.caption.length() && this.type_in != 0) {
                if (((AEToggleMenuAction)this.action).isToggled()) {
                    grh.r_g.drawString("On", this.right_border, this.y - grh.FONT_CORRECT_Y, 0x10 | 8);
                } else {
                    grh.r_g.drawString("Off", this.right_border, this.y - grh.FONT_CORRECT_Y, 0x10 | 8);
                }
            }
        } else {
            grh.r_g.setColor(this.color << 16 | this.color << 8 | this.color);
            if (this.type_in >= this.caption.length() && this.type_in != 0) {
                if (((AEToggleMenuAction)this.action).isToggled()) {
                    grh.r_g.drawString("On", this.right_border, this.y - grh.FONT_CORRECT_Y, 0x10 | 8);
                } else {
                    grh.r_g.drawString("Off", this.right_border, this.y - grh.FONT_CORRECT_Y, 0x10 | 8);
                }
            }
        }
        grh.r_g.drawString(this.caption.substring(0, this.type_in), this.x, this.y - grh.FONT_CORRECT_Y, 0);
        if (this.type_in > 0 && this.type_in < this.caption.length()) {
            StaticImages.drawCursorFull(this.x + grh.r_font.substringWidth(this.caption, 0, this.type_in), this.y);
        }
        this.color = this.color > 107 ? (this.color -= StaticImages.elapsed_time >> 3) : 107;
    }

    public void select() {
        this.isSelected = true;
    }

    public void deselect() {
        this.isSelected = false;
        this.color = 255;
    }

    public boolean isActive() {
        return this.action == null || this.action.isActive();
    }

    public void init() {
        if (this.captionId != -1) {
            this.caption = GameText.getText(this.captionId);
        }
        this.w = grh.r_font.stringWidth(this.caption);
        this.h = grh.r_font.getHeight();
        this.type_in = 0;
        this.type_out_delay = 0;
        this.type_in_delay = 0;
        this.color = 255;
    }

    public boolean fadeIn() {
        if (this.type_in < this.caption.length()) {
            this.type_in_delay += StaticImages.elapsed_time;
            this.type_in = this.type_in_delay / 15;
            this.type_in = this.type_in >= this.caption.length() ? this.caption.length() : this.type_in;
        }
        return this.type_in >= this.caption.length();
    }

    public boolean fadeOut() {
        this.deselect();
        if (this.type_in > 0) {
            this.type_out_delay += StaticImages.elapsed_time;
            this.type_in = this.caption.length() - this.type_out_delay / 15;
            this.type_in = this.type_in < 0 ? 0 : this.type_in;
        }
        return this.type_in == 0;
    }

    public void forceFadeIn() {
        this.type_in = this.caption.length();
    }

    public void setRightBorder(int right_border) {
        this.right_border = right_border;
    }
}

