/*
 * Decompiled with CFR 0.152.
 */
package AppKit;

import AppKit.AELoadingScreen;
import AppKit.AEModule;
import contentHeliStrike.grh;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class AEModuleHandle {
    private GameCanvas canvas;
    private AELoadingScreen loading_screen;
    private AEModule current_module;
    private AEModule next_module;
    private short state = (short)2;
    private static final short S_UPDATE = 0;
    private static final short S_RELEASE = 1;
    private static final short S_INIT = 2;
    static final int TS_FAKE_DPAD = 80;
    static int fakepadbtn = -1;
    static Font fpadFont = Font.getDefaultFont();

    public AEModuleHandle(GameCanvas canvas, AELoadingScreen loading_screen) {
        this.canvas = canvas;
        this.loading_screen = loading_screen;
        if (loading_screen != null) {
            loading_screen.setCanvas(canvas);
        }
    }

    public AEModuleHandle(GameCanvas canvas) {
        this(canvas, null);
    }

    public synchronized void setModule(AEModule module) {
        this.next_module = module;
        this.state = 1;
        if (this.next_module != null) {
            this.next_module.resetStatus();
        }
    }

    public synchronized void onKeyPress(int key) {
        if (this.current_module != null && this.state == 0) {
            this.current_module.keyPress(key);
        }
    }

    public synchronized void onKeyRelease(int key) {
        if (this.current_module != null && this.state == 0) {
            this.current_module.keyRelease(key);
        }
    }

    public synchronized void process() {
        switch (this.state) {
            case 0: {
                if (this.current_module == null) break;
                this.current_module.updateTime();
                this.current_module.onUpdate();
                this.current_module.onRender3D();
                this.current_module.onRender2D();
                this.flushGfxWithFakePad(this.canvas, grh.r_g);
                break;
            }
            case 1: {
                if (this.current_module != null) {
                    if (this.loading_screen != null) {
                        this.loading_screen.start();
                    }
                    this.current_module.onRelease();
                }
                this.current_module = this.next_module;
                if (this.current_module != null) {
                    this.current_module.keyReset();
                }
                this.state = (short)2;
                break;
            }
            case 2: {
                int remaining;
                if (this.current_module == null || (remaining = this.current_module.onInitialize()) > 0) break;
                if (this.loading_screen != null) {
                    this.loading_screen.stop();
                }
                this.state = 0;
                this.current_module.initTime();
            }
        }
    }

    public boolean isInitialized() {
        return this.state == 2;
    }

    public synchronized void pause() {
        if (this.current_module != null) {
            this.current_module.keyReset();
            this.current_module.changeStatus(2L, 0L);
        }
    }

    public synchronized void resume() {
        if (this.current_module != null) {
            this.current_module.keyReset();
            this.current_module.changeStatus(0L, 2L);
        }
    }

    public synchronized void resetKeyEvents() {
        if (this.current_module != null) {
            this.current_module.keyReset();
        }
    }

    public AEModule getCurrentModule() {
        return this.current_module;
    }

    void flushGfxWithFakePad(GameCanvas canvas, Graphics g) {
        AEModuleHandle.paintFakePad(g, canvas);
        canvas.flushGraphics();
    }

    static void paintFakePad(Graphics g, GameCanvas canvas) {
        if (canvas.getWidth() > canvas.getHeight()) {
            g.setColor(0);
            g.fillRect(0, 0, 640, 640);
            g.setFont(fpadFont);
            g.setColor(-1);
            g.drawString("Please change to portrait.", 1, 2, 20);
            return;
        }
    }

    static void paintFakePadMain(Graphics g, int offset) {
        g.fillRect(0, 80 + offset, 240, 1);
        g.fillRect(0, 160 + offset, 240, 1);
        g.fillRect(80 + offset, 0, 1, 240);
        g.fillRect(160 + offset, 0, 1, 240);
        g.drawChar('U', offset + 80 + 2, offset + 2, 20);
        g.drawChar('L', offset + 2, offset + 80 + 2, 20);
        g.drawChar('X', offset + 80 + 2, offset + 80 + 2, 20);
        g.drawChar('R', offset + 160 + 2, offset + 80 + 2, 20);
        g.drawChar('D', offset + 80 + 2, offset + 160 + 2, 20);
    }
}

