/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ImgAdjust {
    private static final boolean CYPHER = false;
    private static float handset_Factor_x;
    private static float handset_Factor_y;
    private static int w;
    private static int h;
    static /* synthetic */ Class class$java$lang$Class;

    public static void initialize(int weight, int height) {
        w = weight;
        h = height;
        handset_Factor_x = (float)w / 176.0f;
        handset_Factor_y = (float)h / 220.0f;
    }

    public static int adjustX(int x) {
        return (int)(handset_Factor_x * (float)x);
    }

    public static int adjustY(int y) {
        return (int)(handset_Factor_y * (float)y);
    }

    public byte[] readTexture(byte[] texture, String texName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(texName);
            DataInputStream dis = new DataInputStream(is);
            dis.read(texture, 0, texture.length);
            dis.close();
            return texture;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Image getAdjustImage(String filename) {
        Image orig = null;
        try {
            orig = ImgAdjust.getCypherImage(filename);
            if (w != 176 || h != 220) {
                float fact_x = (float)w / 176.0f;
                float fact_y = (float)h / 220.0f;
                int imgWidth = orig.getWidth();
                int imgHeight = orig.getHeight();
                int[] rgbData = new int[imgWidth * imgHeight];
                int[] rgbDataNew = new int[(int)((float)imgWidth * fact_x) * (int)((float)imgHeight * fact_y)];
                orig.getRGB(rgbData, 0, imgWidth, 0, 0, imgWidth, imgHeight);
                rgbDataNew = ImgAdjust.filterData(rgbData, rgbDataNew, imgWidth, (int)((float)imgWidth * fact_x));
                orig = Image.createRGBImage((int[])rgbDataNew, (int)((int)((float)imgWidth * fact_x)), (int)((int)((float)imgHeight * fact_y)), (boolean)true);
                rgbData = null;
                rgbDataNew = null;
                System.gc();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orig;
    }

    public static int[] filterData(int[] origData, int[] newData, int scanlength_orig, int scanlength_new) {
        int height_orig = origData.length / scanlength_orig;
        int height_new = newData.length / scanlength_new;
        for (int x = 0; x < scanlength_new; ++x) {
            for (int y = 0; y < height_new; ++y) {
                int yCorr;
                int xCorr = (int)Math.floor(x * (scanlength_orig - 1) / (scanlength_new - 1));
                newData[x + y * scanlength_new] = origData[xCorr + (yCorr = (int)Math.floor(y * (height_orig - 1) / (height_new - 1))) * scanlength_orig] == -1 ? 0xFFFFFF : origData[xCorr + yCorr * scanlength_orig];
            }
        }
        return newData;
    }

    public static Image getCypherImage(String filename) {
        Image img = null;
        try {
            img = Image.createImage((String)filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    public static byte[] getCypherBytes(String filename) {
        byte[] data = null;
        try {
            InputStream is = (class$java$lang$Class == null ? (class$java$lang$Class = ImgAdjust.class$("java.lang.Class")) : class$java$lang$Class).getResourceAsStream(filename);
            DataInputStream dis = new DataInputStream(is);
            int size = dis.available();
            data = new byte[size];
            dis.read(data, 0, size);
            dis.close();
        }
        catch (Exception e) {
            System.out.println("Image " + filename + " ist nicht verschl\u00fcsselt!");
        }
        return data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

