/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;

public class AEEaseInOut {
    public static final boolean MAXIMUM = true;
    public static final boolean MINIMUM = false;
    private int min_value;
    private int range_value;
    private int current_pos;
    private int current_value;

    public AEEaseInOut(int min_value, int max_value) {
        this.min_value = min_value;
        this.range_value = max_value - min_value;
        this.current_pos = 3072;
    }

    public void increase(int elapsed_time) {
        this.current_pos += elapsed_time;
        this.current_pos = this.current_pos > 5120 ? 5120 : this.current_pos;
        this.current_value = (((AEMath.sin(this.current_pos) >> 1) + 2048) * this.range_value >> 12) + this.min_value;
    }

    public void decrease(int elapsed_time) {
        this.current_pos -= elapsed_time;
        this.current_pos = this.current_pos < 3072 ? 3072 : this.current_pos;
        this.current_value = (((AEMath.sin(this.current_pos) >> 1) + 2048) * this.range_value >> 12) + this.min_value;
    }

    public void runOut(int elapsed_time) {
        if (this.current_pos > 4096) {
            this.current_pos -= elapsed_time;
            if (this.current_pos < 4096) {
                this.current_pos = 4096;
            }
        } else if (this.current_pos < 4096) {
            this.current_pos += elapsed_time;
            if (this.current_pos > 4096) {
                this.current_pos = 4096;
            }
        }
        this.current_value = (((AEMath.sin(this.current_pos) >> 1) + 2048) * this.range_value >> 12) + this.min_value;
    }

    public void moveToLimit(boolean isMax) {
        this.current_pos = isMax ? 5120 : 3072;
        this.current_value = (((AEMath.sin(this.current_pos) >> 1) + 2048) * this.range_value >> 12) + this.min_value;
    }

    public void setNewRange(int new_min_value, int new_max_value) {
        this.min_value = new_min_value;
        this.range_value = new_max_value - new_min_value;
        this.current_pos = 3072;
    }

    public int getMinValue() {
        return this.min_value;
    }

    public int getMaxValue() {
        return this.min_value + this.range_value;
    }

    public int getValue() {
        return this.current_value;
    }
}

