/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEGeometry;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AEMath;
import AbyssEngine.AEQuadListAccess;
import AbyssEngine.AETexture;
import AbyssEngine.JSRDevice;
import AbyssEngine.JSRTexture;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class JSRQuadList
extends AEGeometry
implements AEQuadListAccess {
    private static Transform tmp_world = new Transform();
    private static float[] tmp_world_value = new float[16];
    private Appearance ap;
    private static PolygonMode pm;
    private int count;
    private Mesh mesh;
    private VertexBuffer vb;
    private VertexArray vtx_pos;
    private VertexArray vtx_uv;
    private TriangleStripArray ib;
    private short[] pos_data;
    private byte[] uv_data;
    private static float[] pos_bias;
    private static float[] uv_bias;
    private int tex_size;
    private byte blend_mode;

    public JSRQuadList(int count, byte blend_mode) {
        this.blend_mode = blend_mode;
        this.ap = new Appearance();
        CompositingMode cm = new CompositingMode();
        switch (blend_mode) {
            case 1: 
            case 3: {
                cm.setBlending(64);
                cm.setDepthWriteEnable(false);
                cm.setDepthTestEnable(true);
                break;
            }
            case 2: {
                cm.setBlending(65);
                cm.setDepthWriteEnable(false);
                cm.setDepthTestEnable(true);
                break;
            }
            case 0: {
                cm.setBlending(68);
                cm.setDepthWriteEnable(true);
                cm.setDepthTestEnable(true);
            }
        }
        this.ap.setCompositingMode(cm);
        if (pm == null) {
            pm = new PolygonMode();
            pm.setCulling(162);
            pm.setShading(164);
            pm.setPerspectiveCorrectionEnable(false);
        }
        this.ap.setPolygonMode(pm);
        this.count = count;
        this.pos_data = new short[12 * count];
        this.uv_data = new byte[8 * count];
        this.vb = new VertexBuffer();
        this.vtx_pos = new VertexArray(4 * count, 3, 2);
        this.vtx_uv = new VertexArray(4 * count, 2, 1);
        this.vtx_pos.set(0, 4 * count, this.pos_data);
        this.vtx_uv.set(0, 4 * count, this.uv_data);
        this.vb.setPositions(this.vtx_pos, 1.0f, pos_bias);
        this.vb.setTexCoords(0, this.vtx_uv, 0.00390625f, uv_bias);
        int[] tri_strip = new int[6 * count];
        int current_id = 0;
        int i = 0;
        while (i < tri_strip.length) {
            tri_strip[i] = current_id;
            tri_strip[i + 1] = current_id + 2;
            tri_strip[i + 2] = current_id + 1;
            tri_strip[i + 3] = current_id + 3;
            tri_strip[i + 4] = current_id + 2;
            tri_strip[i + 5] = current_id;
            i += 6;
            current_id += 4;
        }
        int[] tri_strip_length = new int[2 * count];
        for (int i2 = 0; i2 < tri_strip_length.length; ++i2) {
            tri_strip_length[i2] = 3;
        }
        this.ib = new TriangleStripArray(tri_strip, tri_strip_length);
        this.mesh = new Mesh(this.vb, (IndexBuffer)this.ib, this.ap);
    }

    public JSRQuadList(JSRQuadList quadlist) {
        this.count = quadlist.count;
        this.mesh = quadlist.mesh;
        this.vb = quadlist.vb;
        this.vtx_pos = quadlist.vtx_pos;
        this.vtx_uv = quadlist.vtx_uv;
        this.ib = quadlist.ib;
        this.pos_data = quadlist.pos_data;
        this.uv_data = quadlist.uv_data;
        this.tex_size = quadlist.tex_size;
        this.culling_radius = quadlist.culling_radius;
        this.isVisible = quadlist.isVisible;
        this.layer_id = quadlist.layer_id;
        this.ap = quadlist.ap;
        this.blend_mode = quadlist.blend_mode;
    }

    public AEGraphNode copy() {
        return new JSRQuadList(this);
    }

    public void release() {
        super.release();
        this.ap = null;
        this.mesh = null;
        this.vb = null;
        this.vtx_pos = null;
        this.vtx_uv = null;
        this.ib = null;
        this.pos_data = null;
        this.uv_data = null;
    }

    public void render() {
        if (this.blend_mode == 0) {
            this.render_matrix.getMatrix4x4F(tmp_world_value);
            tmp_world.set(tmp_world_value);
            JSRDevice.device.render((Node)this.mesh, tmp_world);
        }
    }

    public void renderTransp() {
        if (this.blend_mode != 0) {
            this.render_matrix.getMatrix4x4F(tmp_world_value);
            tmp_world.set(tmp_world_value);
            JSRDevice.device.render((Node)this.mesh, tmp_world);
        }
    }

    public void set(int[] positions, int[] uv) {
        int i;
        for (i = 0; i < positions.length; ++i) {
            this.pos_data[i] = (short)positions[i];
        }
        this.vtx_pos.set(0, 4 * this.count, this.pos_data);
        this.vb.setPositions(this.vtx_pos, 1.0f, pos_bias);
        for (i = 0; i < uv.length; ++i) {
            this.uv_data[i] = (byte)uv[i];
        }
        this.vtx_uv.set(0, 4 * this.count, this.uv_data);
        this.vb.setTexCoords(0, this.vtx_uv, 1.0f / (float)this.tex_size, uv_bias);
        this.mesh = new Mesh(this.vb, (IndexBuffer)this.ib, this.ap);
        this.culling_radius = 0;
        for (i = 0; i < positions.length; i += 3) {
            int new_culling_radius = positions[i] * positions[i] + positions[i + 1] * positions[i + 1] + positions[i + 2] * positions[i + 2];
            if (this.culling_radius >= new_culling_radius) continue;
            this.culling_radius = new_culling_radius;
        }
        this.culling_radius = AEMath.sqrt(this.culling_radius);
    }

    public void setTexture(AETexture texture) {
        Texture2D tex = new Texture2D(((JSRTexture)texture).getData()[0].getImage());
        tex.setBlending(227);
        tex.setFiltering(208, 210);
        tex.setWrapping(240, 240);
        this.ap.setTexture(0, tex);
        this.tex_size = tex.getImage().getWidth();
    }

    static {
        pos_bias = new float[]{0.0f, 0.0f, 0.0f};
        uv_bias = new float[]{0.0f, 0.0f};
    }
}

