/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEBoundingSphere;
import AbyssEngine.AECamera;
import AbyssEngine.AEGroup;
import AbyssEngine.AEQuaternion;
import AbyssEngine.AERenderer;
import AbyssEngine.AETransform;
import AbyssEngine.AEVector3D;

public abstract class AEGraphNode {
    public static final byte ANIM_ONCE = 1;
    public static final byte ANIM_LOOP = 2;
    protected AEGroup parent = null;
    protected AEGraphNode next;
    protected boolean isVisible = true;
    protected boolean transformUpdate = true;
    protected boolean pathUpdate = true;
    protected AETransform local = new AETransform();
    protected AETransform world = new AETransform();
    protected AEBoundingSphere boundingSphere = new AEBoundingSphere();

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setParent(AEGroup parent) {
        this.next = parent.child;
        parent.child = this;
        this.parent = parent;
    }

    public AEGroup getParent() {
        return this.parent;
    }

    public AEGraphNode getNext() {
        return this.next;
    }

    public abstract void prerender(AECamera var1, AERenderer var2);

    public abstract void update(boolean var1);

    protected void notifyUpdate() {
        this.pathUpdate = true;
        if (this.parent != null) {
            this.parent.notifyUpdate();
        }
    }

    public AEBoundingSphere getBoundingSphere() {
        return this.boundingSphere;
    }

    public String toString() {
        return this.toString("", 0);
    }

    protected abstract String toString(String var1, int var2);

    public void translate(int tx, int ty, int tz) {
        this.local.translate(tx, ty, tz);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void translate(AEVector3D pos) {
        this.local.translate(pos);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void setTranslation(int tx, int ty, int tz) {
        this.local.setTranslation(tx, ty, tz);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void setTranslation(AEVector3D pos) {
        this.local.setTranslation(pos);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void moveForward(int step) {
        this.local.moveForward(step);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void strafe(int step) {
        this.local.strafe(step);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public AEVector3D getPosition(AEVector3D result) {
        return this.local.getPosition(result);
    }

    public AEVector3D getWorldPosition(AEVector3D result) {
        return this.world.getPosition(result);
    }

    public AEVector3D getPosition() {
        return this.local.getPosition();
    }

    public AEVector3D getWorldPosition() {
        return this.world.getPosition();
    }

    public int getPositionX() {
        return this.local.getPositionX();
    }

    public int getWorldPositionX() {
        return this.world.getPositionX();
    }

    public int getPositionY() {
        return this.local.getPositionY();
    }

    public int getWorldPositionY() {
        return this.world.getPositionY();
    }

    public int getPositionZ() {
        return this.local.getPositionZ();
    }

    public int getWorldPositionZ() {
        return this.world.getPositionZ();
    }

    public int getDirectionX() {
        return this.local.getDirectionX();
    }

    public int getDirectionY() {
        return this.local.getDirectionY();
    }

    public int getDirectionZ() {
        return this.local.getDirectionZ();
    }

    public int getWorldDirectionX() {
        return this.world.getDirectionX();
    }

    public int getWorldDirectionY() {
        return this.world.getDirectionY();
    }

    public int getWorldDirectionZ() {
        return this.world.getDirectionZ();
    }

    public AEVector3D getDirection(AEVector3D result) {
        return this.local.getDirection(result);
    }

    public AEVector3D getWorldDirection(AEVector3D result) {
        return this.world.getDirection(result);
    }

    public AEVector3D getDirection() {
        return this.local.getDirection();
    }

    public AEVector3D getWorldDirection() {
        return this.world.getDirection();
    }

    public AEVector3D getUpVector(AEVector3D result) {
        return this.local.getUpVector(result);
    }

    public AEVector3D getWorldUpVector(AEVector3D result) {
        return this.world.getUpVector(result);
    }

    public AEVector3D getUpVector() {
        return this.local.getUpVector();
    }

    public AEVector3D getWorldUpVector() {
        return this.world.getUpVector();
    }

    public AEVector3D getRightVector(AEVector3D result) {
        return this.local.getRightVector(result);
    }

    public AEVector3D getWorldRightVector(AEVector3D result) {
        return this.world.getRightVector(result);
    }

    public AEVector3D getRightVector() {
        return this.local.getRightVector();
    }

    public int getRightX() {
        return this.local.getRightX();
    }

    public int getRightY() {
        return this.local.getRightY();
    }

    public int getRightZ() {
        return this.local.getRightZ();
    }

    public AEVector3D getWorldRightVector() {
        return this.world.getRightVector();
    }

    public int getWorldRightX() {
        return this.world.getRightX();
    }

    public int getWorldRightY() {
        return this.world.getRightY();
    }

    public int getWorldRightZ() {
        return this.world.getRightZ();
    }

    public int getWorldUpX() {
        return this.world.getUpX();
    }

    public int getWorldUpY() {
        return this.world.getUpY();
    }

    public int getWorldUpZ() {
        return this.world.getUpZ();
    }

    public void setRotationOrdering(short rot) {
        this.local.setRotationOrdering(rot);
        this.world.setRotationOrdering(rot);
    }

    public void rotate(int rx, int ry, int rz) {
        this.local.rotate(rx, ry, rz);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void setRotation(int rx, int ry, int rz) {
        this.local.setRotation(rx, ry, rz);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public AEVector3D getRotation(AEVector3D result) {
        return this.local.getRotation(result);
    }

    public AEQuaternion getRotationQ() {
        return this.local.getRotationQ();
    }

    public AEVector3D getWorldRotation(AEVector3D result) {
        return this.world.getRotation(result);
    }

    public AEVector3D getRotation() {
        return this.local.getRotation();
    }

    public int getRotationX() {
        return this.local.getRotationX();
    }

    public int getRotationY() {
        return this.local.getRotationY();
    }

    public int getRotationZ() {
        return this.local.getRotationZ();
    }

    public AEVector3D getWorldRotation() {
        return this.world.getRotation();
    }

    public void setRotation(int x, int y, int z, int w) {
        this.local.setRotation(x, y, z, w);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void setRotation(AEQuaternion q) {
        this.local.setRotation(q);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public AEQuaternion getRotationQ(AEQuaternion result) {
        return this.local.getRotationQ(result);
    }

    public AEQuaternion getWorldRotation(AEQuaternion result) {
        return this.world.getRotationQ(result);
    }

    public void scale(int sx, int sy, int sz) {
        this.local.scale(sx, sy, sz);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void setScaling(int sx, int sy, int sz) {
        this.local.setScaling(sx, sy, sz);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public AEVector3D getScaling(AEVector3D result) {
        return this.local.getScaling(result);
    }

    public AEVector3D getWorldScaling(AEVector3D result) {
        return this.world.getScaling(result);
    }

    public AEVector3D getScaling() {
        return this.local.getScaling();
    }

    public AEVector3D getWorldScaling() {
        return this.world.getScaling();
    }

    public AETransform getLocalTransform() {
        return this.local;
    }

    public AETransform getWorldTransform() {
        return this.world;
    }

    public void setLocalTransform(AETransform transform) {
        this.local.set(transform);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public AETransform getInverse(AETransform result) {
        return this.local.getInverse(result);
    }

    public AETransform getWorldInverse(AETransform result) {
        return this.world.getInverse(result);
    }

    public AETransform getInverse() {
        return this.local.getInverse();
    }

    public AETransform getWorldInverse() {
        return this.world.getInverse();
    }

    public void setRotationMatrix(AEVector3D right, AEVector3D up, AEVector3D dir) {
        this.local.setRotationMatrix(right, up, dir);
        this.transformUpdate = true;
        this.notifyUpdate();
    }

    public void getMatrix4x3I(int[] matrix) {
        this.local.getMatrix4x3I(matrix);
    }

    public void getMatrix4x4I(int[] matrix) {
        this.local.getMatrix4x4I(matrix);
    }

    public void getMatrix4x3F(float[] matrix) {
        this.local.getMatrix4x3F(matrix);
    }

    public void getMatrix4x4F(float[] matrix) {
        this.local.getMatrix4x4F(matrix);
    }

    public void getWorldMatrix4x3I(int[] matrix) {
        this.world.getMatrix4x3I(matrix);
    }

    public void getWorldMatrix4x4I(int[] matrix) {
        this.world.getMatrix4x4I(matrix);
    }

    public void getWorldMatrix4x3F(float[] matrix) {
        this.world.getMatrix4x3F(matrix);
    }

    public void getWorldMatrix4x4F(float[] matrix) {
        this.world.getMatrix4x4F(matrix);
    }

    public void setAnimRange(int start_frame, int stop_frame) {
    }

    public void playAnim(byte mode) {
    }

    public void stopAnim() {
    }

    public void stopAnim(int frame) {
    }

    public boolean isPlaying() {
        return false;
    }

    public int getCurrentFrame() {
        return 0;
    }

    public void release() {
        this.boundingSphere = null;
        this.local = null;
        this.world = null;
        this.parent = null;
        if (this.next != null) {
            this.next.release();
        }
        this.next = null;
    }
}

