/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;

public class AEEaseInOutSym {
    private int mid_value;
    private int up_range_value;
    private int down_range_value;
    private int current_pos;
    private int current_value;
    private boolean up;

    public AEEaseInOutSym(int min_value, int max_value, int mid_value) {
        this.mid_value = mid_value;
        this.up_range_value = max_value - mid_value;
        this.down_range_value = -min_value - mid_value;
        this.current_pos = 3072;
        this.up = true;
    }

    public void increase(int elapsed_time) {
        this.current_pos += elapsed_time;
        if (this.up && this.current_pos > 5120) {
            this.current_pos = 5120;
        } else if (!this.up && this.current_pos > 5120) {
            this.current_pos = 3072;
            this.up = true;
        }
        this.current_value = this.up ? (((AEMath.sin(this.current_pos) >> 1) + 2048) * this.up_range_value >> 12) + this.mid_value : (((AEMath.sin(this.current_pos) >> 1) - 2048) * this.down_range_value >> 12) + this.mid_value;
    }

    public void decrease(int elapsed_time) {
        this.current_pos -= elapsed_time;
        if (!this.up && this.current_pos < 3072) {
            this.current_pos = 3072;
        } else if (this.up && this.current_pos < 3072) {
            this.current_pos = 5120;
            this.up = false;
        }
        this.current_value = this.up ? (((AEMath.sin(this.current_pos) >> 1) + 2048) * this.up_range_value >> 12) + this.mid_value : (((AEMath.sin(this.current_pos) >> 1) - 2048) * this.down_range_value >> 12) + this.mid_value;
    }

    public void runOut(int elapsed_time) {
        this.current_pos = this.up ? (this.current_pos -= elapsed_time) : (this.current_pos += elapsed_time);
        this.current_pos = this.current_pos < 3072 ? 3072 : (this.current_pos > 5120 ? 5120 : this.current_pos);
        this.current_value = this.up ? (((AEMath.sin(this.current_pos) >> 1) + 2048) * this.up_range_value >> 12) + this.mid_value : (((AEMath.sin(this.current_pos) >> 1) - 2048) * this.down_range_value >> 12) + this.mid_value;
    }

    public int getValue() {
        return this.current_value;
    }
}

