/*
 * Decompiled with CFR 0.152.
 */
package menu;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import menu.MainMenu;
import resource.RMS;
import resource.ResInit;
import start.MainMID;

public class MenuRanking
extends Canvas
implements Runnable {
    private Thread thread = null;
    private MainMenu mainMenu = null;
    private byte mainFormNum = 0;

    public MenuRanking(MainMenu mainMenu) {
        this.mainMenu = mainMenu;
        this.setFullScreenMode(true);
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void paint(Graphics g) {
        g.drawImage(ResInit.mainFormImage[this.mainFormNum], 0, 0, 20);
        this.showRanking(g);
    }

    protected void keyPressed(int key) {
        this.mainMenu.playSound();
        if (key == -7) {
            this.thread = null;
            MainMID.display.setCurrent((Displayable)this.mainMenu);
            this.mainMenu = null;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mainFormNum = (byte)(this.mainFormNum + 1);
            this.mainFormNum = (byte)(this.mainFormNum % 4);
            this.repaint();
        }
    }

    private void showRanking(Graphics g) {
        int y = 89;
        RMS.readScoreData();
        RMS.closeRMS();
        g.drawImage(ResInit.rankingImage, 0, 0, 20);
        int i = 0;
        while (i < 11) {
            byte level = (byte)(RMS.gSaveData[i][0] / 10);
            byte name = (byte)(RMS.gSaveData[i][0] - level * 10);
            int loadScore = RMS.gSaveData[i][1];
            String str = this.int2string(loadScore);
            if (i == 0 && level > 0) {
                g.drawImage(ResInit.levelImage[level - 1], 148, 56, 20);
                this.drawString((short)130, (short)81, str, 2, g);
                g.drawImage(ResInit.characterImage[name], 180, 56, 20);
            } else if (i == 0) {
                g.drawImage(ResInit.otherImage[8], 154, 60, 20);
                g.drawImage(ResInit.otherImage[8], 154, 81, 20);
            }
            if (level > 0 && i > 0) {
                g.drawImage(ResInit.levelImage[level - 1], 56, y + 1, 20);
                g.drawImage(ResInit.characterImage[name], 88, y + 1, 20);
                if (i == RMS.lastScoreIndex - 1) {
                    this.drawString((short)140, (short)(y + 5), str, 2, g);
                } else {
                    this.drawString((short)140, (short)(y + 5), str, 1, g);
                }
            } else if (i > 0) {
                g.drawImage(ResInit.otherImage[7], 60, 95 + i * 18, 20);
                g.drawImage(ResInit.otherImage[7], 92, 95 + i * 18, 20);
                g.drawImage(ResInit.otherImage[7], 160, 95 + i * 18, 20);
            }
            y = (short)(y + 18);
            i = (byte)(i + 1);
        }
    }

    String int2string(int value) {
        String str = String.valueOf(value);
        int len = str.length();
        if (len < 7) {
            int i = 0;
            while (i < 7 - len) {
                str = "0" + str;
                ++i;
            }
        }
        return str;
    }

    void drawString(short x1, short y1, String num, int mode, Graphics g) {
        int lx = x1;
        short ly = y1;
        int y = 0;
        int w = 8;
        int h = 7;
        int j = 0;
        while (j < num.length()) {
            short x = (short)((num.charAt(j) - 48) * w);
            if (1 == mode) {
                g.drawRegion(ResInit.numberImage[1], (int)x, y, w, h, 0, lx, (int)ly, 20);
            } else {
                g.drawRegion(ResInit.numberImage[2], (int)x, y, w, h, 0, lx, (int)ly, 20);
            }
            lx += w + 2;
            ++j;
        }
    }
}

