/*
 * Decompiled with CFR 0.152.
 */
package menu;

import game.SelectPlayer;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import menu.MenuConfig;
import menu.MenuHelp;
import menu.MenuRanking;
import resource.RMS;
import resource.ResInit;
import start.MainMID;

public class MainMenu
extends Canvas
implements Runnable {
    public static short screenWidth;
    public static short screenHeight;
    public static short screenX;
    public static short screenY;
    public static MainMID midlet;
    private Thread thread = null;
    private MenuConfig menuConfig = null;
    private MenuRanking menuRanking = null;
    private MenuHelp menuHelp = null;
    private SelectPlayer selectPlayer = null;
    public Player[] menuSound = null;
    private VolumeControl vc = null;
    private InputStream is = null;
    private byte menuNum = 0;
    private byte mainFormNum = 0;
    private boolean isPicLoaded = false;

    static {
        screenX = 0;
        screenY = 0;
    }

    public MainMenu(MainMID midlet) {
        this.init(midlet);
    }

    public MainMenu(MainMID midlet, Display display) {
        this.init(midlet);
    }

    public void init(MainMID midlet) {
        MainMenu.midlet = midlet;
        if (this.getWidth() < 240) {
            screenWidth = (short)this.getWidth();
            screenHeight = (short)this.getHeight();
        } else {
            screenWidth = (short)240;
            screenHeight = (short)320;
        }
        ResInit.loadPicInit();
        RMS.readConfigData();
        RMS.closeRMS();
        if (RMS.gConfigData[1] == -1) {
            this.loadSound(true);
        }
        this.setFullScreenMode(true);
        MainMID.display.setCurrent((Displayable)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void loadSound(boolean isLoad) {
        if (!isLoad) {
            if (this.menuSound != null) {
                int i = 0;
                while (i < 2) {
                    if (this.menuSound[i].getState() == 400) {
                        try {
                            this.menuSound[i].stop();
                        }
                        catch (MediaException e) {
                            e.printStackTrace();
                        }
                    }
                    this.menuSound[i].deallocate();
                    this.menuSound[i].close();
                    this.menuSound[i] = null;
                    ++i;
                }
                this.menuSound = null;
                System.gc();
            }
            return;
        }
        if (this.menuSound != null) {
            return;
        }
        this.menuSound = new Player[2];
        try {
            this.is = this.getClass().getResourceAsStream("/sound/0MenuSelect.wav");
            this.menuSound[1] = Manager.createPlayer((InputStream)this.is, (String)"audio/x-wav");
            this.menuSound[1].realize();
            this.is = this.getClass().getResourceAsStream("/sound/13MenuMusic.wav");
            this.menuSound[0] = Manager.createPlayer((InputStream)this.is, (String)"audio/x-wav");
            this.menuSound[0].realize();
            this.is = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
        this.setVolume(RMS.gConfigData[2] * 10);
        try {
            this.menuSound[0].setLoopCount(-1);
            this.menuSound[0].start();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void playSound() {
        if (this.menuSound == null || this.menuSound[1].getState() == 400) {
            return;
        }
        try {
            this.menuSound[1].start();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public void setVolume(int volume) {
        this.vc = null;
        int i = 0;
        while (i < 2) {
            this.vc = (VolumeControl)this.menuSound[i].getControl("VolumeControl");
            this.vc.setLevel(volume);
            ++i;
        }
        this.vc = null;
    }

    protected void paint(Graphics g) {
        if (!this.isPicLoaded) {
            g.drawImage(ResInit.otherImage[1], 0, 0, 20);
            g.drawImage(ResInit.otherImage[2], screenWidth - ResInit.otherImage[2].getWidth(), screenHeight - ResInit.otherImage[2].getHeight(), 20);
            return;
        }
        g.drawImage(ResInit.mainFormImage[this.mainFormNum], 0, 0, 20);
        g.drawImage(ResInit.titleImage, (screenWidth - 190) / 2, 25, 20);
        g.drawImage(ResInit.menuImage[this.menuNum], (screenWidth - 100) / 2, (screenHeight + 82 - 150) / 2, 20);
    }

    protected void keyPressed(int key) {
        if (!this.isPicLoaded) {
            return;
        }
        this.playSound();
        switch (key) {
            case -3: 
            case -1: {
                this.menuNum = (byte)(this.menuNum - 1);
                break;
            }
            case -4: 
            case -2: {
                this.menuNum = (byte)(this.menuNum + 1);
                break;
            }
            case -5: {
                this.dealSelection(this.menuNum);
                break;
            }
            case -7: {
                midlet.exit();
                break;
            }
        }
        this.menuNum = this.menuNum < 0 ? (byte)(this.menuNum + 5) : (byte)(this.menuNum % 5);
        this.repaint();
    }

    private void dealSelection(int selected) {
        switch (selected) {
            case 0: {
                this.selectPlayer = null;
                this.selectPlayer = new SelectPlayer(this);
                MainMID.display.setCurrent((Displayable)this.selectPlayer);
                break;
            }
            case 1: {
                this.menuConfig = null;
                this.menuConfig = new MenuConfig(this);
                MainMID.display.setCurrent((Displayable)this.menuConfig);
                break;
            }
            case 2: {
                this.menuRanking = null;
                this.menuRanking = new MenuRanking(this);
                MainMID.display.setCurrent((Displayable)this.menuRanking);
                break;
            }
            case 3: {
                this.menuHelp = null;
                this.menuHelp = new MenuHelp(this);
                MainMID.display.setCurrent((Displayable)this.menuHelp);
                break;
            }
            case 4: {
                midlet.exit();
                break;
            }
        }
    }

    public void run() {
        ResInit.loadMenuPic(false);
        this.isPicLoaded = true;
        while (this.isPicLoaded) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mainFormNum = (byte)(this.mainFormNum + 1);
            this.mainFormNum = (byte)(this.mainFormNum % 4);
            this.repaint();
        }
    }
}

