/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameCanvas;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import menu.MainMenu;
import resource.ResInit;
import start.MainMID;

public class SelectPlayer
extends Canvas
implements Runnable {
    private Thread thread = null;
    private MainMenu mainMenu = null;
    private GameCanvas firstStage;
    private int playerNum = 0;
    private int mainFormNum = 0;
    private int selectFrameNum = 3;
    private boolean isLoadGame = false;

    public SelectPlayer(MainMenu mainMenu) {
        this.mainMenu = mainMenu;
        this.setFullScreenMode(true);
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void paint(Graphics g) {
        if (this.isLoadGame) {
            g.drawImage(ResInit.otherImage[1], 0, 0, 20);
            g.drawImage(ResInit.otherImage[2], MainMenu.screenWidth - ResInit.otherImage[2].getWidth(), MainMenu.screenHeight - ResInit.otherImage[2].getHeight(), 20);
            return;
        }
        g.drawImage(ResInit.mainFormImage[this.mainFormNum], 0, 0, 20);
        g.drawImage(ResInit.playerSelectImage[this.playerNum], (this.getWidth() - 224) / 2, (this.getHeight() - 154) / 2, 20);
        g.drawImage(ResInit.playerSelectImage[this.selectFrameNum], this.getWidth() / 2 - 20 + 42 * this.playerNum, this.getHeight() / 2 + 42, 20);
    }

    protected void keyPressed(int key) {
        this.mainMenu.playSound();
        switch (key) {
            case -3: 
            case -1: {
                --this.playerNum;
                break;
            }
            case -4: 
            case -2: {
                ++this.playerNum;
                break;
            }
            case -5: {
                this.isLoadGame = true;
                this.repaint();
                this.serviceRepaints();
                if (this.firstStage != null) {
                    this.firstStage = null;
                }
                this.firstStage = new GameCanvas(this.mainMenu, this, (byte)this.playerNum);
                this.mainMenu.loadSound(false);
                MainMID.display.setCurrent((Displayable)this.firstStage);
                this.thread = null;
                break;
            }
            case -7: {
                MainMID.display.setCurrent((Displayable)this.mainMenu);
            }
        }
        this.playerNum = this.playerNum < 0 ? (this.playerNum += 3) : (this.playerNum %= 3);
        this.repaint();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.selectFrameNum = this.selectFrameNum == 3 ? 4 : 3;
            ++this.mainFormNum;
            this.mainFormNum %= 4;
            this.repaint();
        }
    }
}

