/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int _iStatus;
    private int _iInteruption = 0;
    private int _iSelectedCompId;
    private int _iTextOffsetY;
    public static int _WIDTH = 0;
    public static int _HEIGHT = 0;
    private boolean _bNeedRepaint;
    private boolean _bScrollUP = false;
    private boolean _bScrollDOWN = true;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_RESTARTSCREEN = 5;
    private static final int STATUS_REALY_QUIT = 6;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int TOTAL_COMP_IDS = 9;
    private static final int COMP_ID_RESTART_TXT = 0;
    private static final int COMP_ID_SOUNDS_TXT = 1;
    private static final int COMP_ID_MAINMENU_TXT = 2;
    private static final int COMP_ID_INSTRUCTION_TXT = 3;
    private static final int TOTAL_COMP_IDS_TXT = 9;
    private int[][] _animationSequence = new int[7][9];
    private AnimationComponent[] _animationComponents = new AnimationComponent[17];
    private Rectangle[] _rectItems_TXT = new Rectangle[9];
    private Rectangle[] _rectItems = new Rectangle[9];
    private Rectangle _rectGameArea;
    private Rectangle _rectPanel;
    private Rectangle _rectText;
    private Rectangle _rectScore;
    private Rectangle _rectBestScore;
    private Rectangle _rectBB_BACK;
    private Rectangle _rectBB_MENU;
    private Rectangle _rectTopBig;
    private Rectangle _rectTopLittle;
    private Rectangle _rectTopLittleTXT;
    private Rectangle _rectTitle;
    private static PreparedText menuItem;
    private static PreparedText _ptInstructions;
    private static PreparedText _ptMessage;
    private static PreparedText actualScore;
    private static PreparedText navigationKeysBB;
    private Image _imgBackground;
    private Image _imgWindow;
    private Image _imgGameLogo;
    private Image _imgButton;
    private Image _imgButtonTop;
    private Image _imgButtonSelector;
    private Image _imgColorTile;
    private Sprite _sprArrows;
    private Sprite _sprIcons;
    int bestScoreSave = 0;
    private int scoresCount = 0;
    int _finalHeight;
    int _off;
    int cycle = 10;
    private int _sequenceStop = 0;
    private int _sequenceShow = 1;
    private int _sequenceHide = 2;
    private int _sequence = 0;
    boolean changeSequence = false;
    private int nextScreen;
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;
    int posX = 0;
    int posY = 0;

    public ScreenGame(MainCanvas mainCanvas, boolean tutorial) {
        this.mainCanvas = mainCanvas;
        this.initDimensions();
        this._iStatus = 0;
    }

    public void beforeShow() {
        this.loadResources();
        this.initImages();
        this.initSprites();
        this.calculatePositions();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.prepareTxt();
        RMSObjects.game.restartGame(this._rectGameArea);
        this.startAnimation(true, 0);
    }

    public void afterHide() {
        this.freeGraphics();
        this.freeResources();
    }

    private void loadResources() {
        Resources.loadImages(new int[]{3, 1, 8, 9, 10, 11, 12, 5, 7, 6});
        Resources.loadSprites(new int[]{0, 2});
        Resources.loadGFonts(new int[]{0, 1, 2, 3, 4, 5});
    }

    private void freeResources() {
        Resources.freeImages(new int[]{3, 1, 8, 9, 10, 11, 12, 5, 7, 6});
        Resources.freeSprites(new int[]{0, 2});
        Resources.freeGFonts(new int[]{0, 1, 2, 3, 4, 5});
    }

    private void initDimensions() {
        _WIDTH = this.mainCanvas.getWidth();
        _HEIGHT = this.mainCanvas.getHeight();
    }

    private void initImages() {
        this._imgBackground = Resources.resImgs[3];
        this._imgGameLogo = Resources.resImgs[1];
        this._imgWindow = Resources.resImgs[8];
        this._imgButton = Resources.resImgs[5];
        this._imgButtonTop = Resources.resImgs[6];
        this._imgButtonSelector = Resources.resImgs[7];
        this._imgColorTile = Resources.resImgs[9];
    }

    private void initSprites() {
        this._sprArrows = Resources.resSprs[2];
        this._sprIcons = Resources.resSprs[0];
    }

    public void initTxt() {
        Resources.loadText(0);
        menuItem = new PreparedText(Resources.resGFonts[2]);
        _ptInstructions = new PreparedText(Resources.resGFonts[1]);
        _ptMessage = new PreparedText(Resources.resGFonts[1]);
        menuItem = new PreparedText(Resources.resGFonts[0]);
        actualScore = new PreparedText(Resources.resGFonts[1]);
        navigationKeysBB = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 12;
        this._animationSequence[0][1] = 10;
        this._animationSequence[0][2] = -1;
        this._animationSequence[0][3] = -1;
        this._animationSequence[0][4] = -1;
        this._animationSequence[0][5] = -1;
        this._animationSequence[0][6] = -1;
        this._animationSequence[0][7] = -1;
        this._animationSequence[0][8] = -1;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[1][3] = 3;
        this._animationSequence[1][4] = 4;
        this._animationSequence[1][5] = 5;
        this._animationSequence[1][6] = 6;
        this._animationSequence[1][7] = 7;
        this._animationSequence[1][8] = 14;
        this._animationSequence[3][0] = 10;
        this._animationSequence[3][1] = 11;
        this._animationSequence[3][2] = 8;
        this._animationSequence[3][3] = 9;
        this._animationSequence[3][4] = -1;
        this._animationSequence[3][5] = -1;
        this._animationSequence[3][6] = -1;
        this._animationSequence[3][7] = -1;
        this._animationSequence[3][8] = -1;
        this._animationSequence[6][0] = 8;
        this._animationSequence[6][1] = 9;
        this._animationSequence[6][2] = -1;
        this._animationSequence[6][3] = -1;
        this._animationSequence[6][4] = -1;
        this._animationSequence[6][5] = -1;
        this._animationSequence[6][6] = -1;
        this._animationSequence[6][7] = -1;
        this._animationSequence[6][8] = -1;
        this._animationSequence[5][0] = 8;
        this._animationSequence[5][1] = 9;
        this._animationSequence[5][2] = -1;
        this._animationSequence[5][3] = -1;
        this._animationSequence[5][4] = -1;
        this._animationSequence[5][5] = -1;
        this._animationSequence[5][6] = -1;
        this._animationSequence[5][7] = -1;
        this._animationSequence[5][8] = -1;
        this._animationSequence[2][0] = 8;
        this._animationSequence[2][1] = 9;
        this._animationSequence[2][2] = -1;
        this._animationSequence[2][3] = -1;
        this._animationSequence[2][4] = -1;
        this._animationSequence[2][5] = -1;
        this._animationSequence[2][6] = -1;
        this._animationSequence[2][7] = -1;
        this._animationSequence[2][8] = -1;
        this._animationSequence[4][0] = 10;
        this._animationSequence[4][1] = 11;
        this._animationSequence[4][2] = 8;
        this._animationSequence[4][3] = -1;
        this._animationSequence[4][4] = -1;
        this._animationSequence[4][5] = -1;
        this._animationSequence[4][6] = -1;
        this._animationSequence[4][7] = -1;
        this._animationSequence[4][8] = -1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectItems[3], _WIDTH, _HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectItems_TXT[0], _WIDTH, _HEIGHT);
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this._rectItems[4], _WIDTH, _HEIGHT);
        this._animationComponents[3] = new AnimationComponent(this.mainCanvas, this._rectItems_TXT[1], _WIDTH, _HEIGHT);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4] = new AnimationComponent(this.mainCanvas, this._rectItems[6], _WIDTH, _HEIGHT);
        this._animationComponents[5] = new AnimationComponent(this.mainCanvas, this._rectItems_TXT[3], _WIDTH, _HEIGHT);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(0);
        this._animationComponents[6] = new AnimationComponent(this.mainCanvas, this._rectItems[5], _WIDTH, _HEIGHT);
        this._animationComponents[7] = new AnimationComponent(this.mainCanvas, this._rectItems_TXT[2], _WIDTH, _HEIGHT);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8] = new AnimationComponent(this.mainCanvas, this._rectPanel, _WIDTH, _HEIGHT);
        this._animationComponents[8].startShowAnimation(3);
        this._animationComponents[9] = new AnimationComponent(this.mainCanvas, this._rectText, _WIDTH, _HEIGHT);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10] = new AnimationComponent(this.mainCanvas, this._rectTopLittle, _WIDTH, _HEIGHT);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11] = new AnimationComponent(this.mainCanvas, this._rectTopLittleTXT, _WIDTH, _HEIGHT);
        this._animationComponents[11].startShowAnimation(2);
        this._animationComponents[12] = new AnimationComponent(this.mainCanvas, this._rectScore, _WIDTH, _HEIGHT);
        this._animationComponents[12].startShowAnimation(2);
        this._animationComponents[13] = new AnimationComponent(this.mainCanvas, this._rectScore, _WIDTH, _HEIGHT);
        this._animationComponents[13].startShowAnimation(0);
        this._animationComponents[14] = new AnimationComponent(this.mainCanvas, this._rectTopBig, _WIDTH, _HEIGHT);
        this._animationComponents[14].startShowAnimation(2);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(0);
        this._animationComponents[1].startShowAnimation(0);
        this._animationComponents[2].startShowAnimation(1);
        this._animationComponents[3].startShowAnimation(1);
        this._animationComponents[4].startShowAnimation(0);
        this._animationComponents[5].startShowAnimation(0);
        this._animationComponents[6].startShowAnimation(1);
        this._animationComponents[7].startShowAnimation(1);
        this._animationComponents[8].startShowAnimation(3);
        this._animationComponents[9].startShowAnimation(3);
        this._animationComponents[10].startShowAnimation(2);
        this._animationComponents[11].startShowAnimation(2);
        this._animationComponents[12].startShowAnimation(1);
        this._animationComponents[13].startShowAnimation(0);
        this._animationComponents[14].startShowAnimation(2);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(0);
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
        this._animationComponents[3].startHideAnimation(1);
        this._animationComponents[4].startHideAnimation(0);
        this._animationComponents[5].startHideAnimation(0);
        this._animationComponents[6].startHideAnimation(1);
        this._animationComponents[7].startHideAnimation(1);
        this._animationComponents[8].startHideAnimation(3);
        this._animationComponents[9].startHideAnimation(3);
        this._animationComponents[10].startHideAnimation(2);
        this._animationComponents[11].startHideAnimation(2);
        this._animationComponents[12].startHideAnimation(1);
        this._animationComponents[13].startHideAnimation(0);
        this._animationComponents[14].startHideAnimation(2);
    }

    private void freeGraphics() {
        this._sprIcons = null;
        this._imgGameLogo = null;
    }

    private void prepareTxt() {
        this.initTxt();
        String controls = "";
        controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n" + "\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(16);
        _ptInstructions.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this._rectText.width);
        _ptInstructions.setLineHeightCorrection(-2);
        this.loadBestScore();
    }

    private void loadBestScore() {
        Vector scores;
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
        }
        if ((scores = RMSObjects.bestScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.bestScoreSave = scoreItem.scoreValue;
        }
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        if (RMSObjects.game.getScore() > this.bestScoreSave) {
            scoreItem.scoreValue = RMSObjects.game.getScore();
            RMSObjects.bestScores.userName = Integer.toString(0);
            RMSObjects.bestScores.insertScoreItem(scoreItem, 0);
            if (!RMSObjects.rmsConnects[1].isExist()) {
                RMSObjects.rmsConnects[1].create();
            }
            RMSObjects.rmsConnects[1].save();
        }
    }

    public void beforeInteruption() {
        if (this._iStatus == 0) {
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        int _xGameOffset = _WIDTH - (this._imgColorTile.getWidth() << 1) >> 1;
        int _yGameOffset = _HEIGHT - (this._imgColorTile.getHeight() << 1) >> 1;
        int itemHeight = Resources.resGFonts[0].getHeight();
        int itemWidth = _WIDTH;
        int posX = _WIDTH >> 1;
        int posY = (_HEIGHT >> 1) - (itemHeight << 1);
        int _rectPanelY = this._imgButton.getHeight();
        int _rectTextOffsetX = this._sprIcons.getWidth();
        int _rectTextOffsetY = this._sprIcons.getHeight();
        this._rectPanel = new Rectangle(0, _rectPanelY, _WIDTH, _HEIGHT - _rectPanelY);
        System.out.println("_yGameOffset: " + _yGameOffset);
        this._rectGameArea = new Rectangle(_xGameOffset, _yGameOffset, this._imgColorTile.getWidth() << 1, this._imgColorTile.getHeight() << 1);
        System.out.println("_rectGameArea: " + this._rectGameArea.y);
        this._rectScore = new Rectangle(0, 0, _WIDTH, this._imgButtonTop.getHeight());
        this._rectText = new Rectangle(_rectTextOffsetX, this._rectPanel.y + _rectTextOffsetY, _WIDTH - (_rectTextOffsetX << 1), this._rectPanel.height - (this._rectPanel.y + _rectTextOffsetY));
        this._rectTitle = new Rectangle(posX, itemHeight / 2, itemWidth, itemHeight);
        posX = _WIDTH - itemWidth >> 1;
        posY = this._rectPanel.getTop() + itemHeight;
        posX = 0;
        posY = this._imgGameLogo.getHeight() + (_HEIGHT - this._imgGameLogo.getHeight() - 4 * (itemHeight + (this._imgButton.getHeight() >> 1)) >> 1);
        this._rectItems[3] = new Rectangle(posX, posY, itemWidth, itemHeight);
        this._rectItems[4] = new Rectangle(posX, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this._rectItems[6] = new Rectangle(posX, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this._rectItems[5] = new Rectangle(posX, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this._rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - this._sprIcons.getHeight(), this._sprIcons.getWidth(), this._sprIcons.getHeight());
        this._rectItems[1] = new Rectangle(MainCanvas.WIDTH - this._sprIcons.getWidth(), MainCanvas.HEIGHT - this._sprIcons.getHeight(), this._sprIcons.getWidth(), this._sprIcons.getHeight());
        posX = 0;
        posY = this._imgGameLogo.getHeight() + (_HEIGHT - this._imgGameLogo.getHeight() - 4 * (itemHeight + (this._imgButton.getHeight() >> 1)) >> 1);
        this._rectItems_TXT[0] = new Rectangle(0, posY, itemWidth, itemHeight);
        this._rectItems_TXT[1] = new Rectangle(0, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this._rectItems_TXT[3] = new Rectangle(0, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this._rectItems_TXT[2] = new Rectangle(0, posY += itemHeight + (this._imgButton.getHeight() >> 1), itemWidth, itemHeight);
        this._rectBB_BACK = new Rectangle(0, MainCanvas.HEIGHT - itemHeight, _WIDTH - this._sprIcons.getWidth(), itemHeight);
        this._rectBB_MENU = new Rectangle(this._sprIcons.getWidth(), MainCanvas.HEIGHT - itemHeight, _WIDTH, itemHeight);
        this._rectTopBig = new Rectangle(_WIDTH >> 1, 0, this._imgGameLogo.getWidth(), this._imgGameLogo.getHeight());
        this._rectTopLittle = new Rectangle(0, 0, _WIDTH, this._imgButtonTop.getHeight());
        this._rectTopLittleTXT = new Rectangle(0, 0, _WIDTH, this._imgButtonTop.getHeight());
    }

    public void update(long lastRunLenght) {
        if (MainCanvas._iInteruption_nokia == 0) {
            if (this.cycle > 0) {
                --this.cycle;
            } else if (MainCanvas.nokia == 1) {
                MainCanvas.nokia = 0;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                this.cycle = 10;
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
        if (this._iStatus == 0) {
            if (this.nextScreen == 2) {
                return;
            }
            RMSObjects.game.update(lastRunLenght);
            if (RMSObjects.game.isGameOver()) {
                this.startAnimation(true, 2);
            }
            this.mainCanvas.repaint();
        }
        if (this._iStatus == 2) {
            this.mainCanvas.repaint();
        }
        if (this._iStatus == 3) {
            this._bNeedRepaint = false;
            this.textMove();
            if (this._bNeedRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this._iStatus == 1) {
            // empty if block
        }
    }

    public void textMove() {
        this._bNeedRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY < 0) {
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
            }
            this._bNeedRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = _ptInstructions.getTextHeight() - this._rectText.height;
            if (Resources.sysFont) {
                this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            } else {
                this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
                this._bScrollUP = true;
                this._bScrollDOWN = true;
            }
            if (this._iTextOffsetY > maxOffsetY) {
                this._iTextOffsetY = maxOffsetY;
                this._bScrollUP = true;
                this._bScrollDOWN = false;
            }
            this._bNeedRepaint = true;
        }
        if (this._bNeedRepaint) {
            this.mainCanvas.repaint();
        }
    }

    private boolean animationController() {
        if (this.changeSequence) {
            if (this._sequence == this._sequenceShow) {
                this.showAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceHide) {
                this.hideAnimationComponent();
                this.changeSequence = false;
            } else if (this._sequence == this._sequenceStop) {
                this.changeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this._iStatus].length; ++i) {
            if (this._animationSequence[this._iStatus][i] == -1 || this._animationComponents[this._animationSequence[this._iStatus][i]] == null || this._animationComponents[this._animationSequence[this._iStatus][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this._iStatus][i]].update();
            if (this._iStatus == 0) {
                // empty if block
            }
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._sequence == this._sequenceHide) {
                this._sequence = this._sequenceShow;
                this._iStatus = this.nextScreen;
                this.changeSequence = true;
            } else if (this._sequence == this._sequenceShow) {
                this._sequence = this._sequenceStop;
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextScreen) {
        this.changeSequence = changeSequencem;
        this.nextScreen = nextScreen;
        this._sequence = this._sequenceHide;
    }

    public void paint(Graphics g) {
        this.paintBackgroundColor(g);
        switch (this._iStatus) {
            case 0: {
                this.paintBackground(g);
                this.paintPanelTop(g);
                RMSObjects.game.paint(g);
                break;
            }
            case 1: {
                this.paintGameLogo(g);
                this.paintMenuDialogItems(g);
                break;
            }
            case 2: {
                this.paintMessage(g);
                break;
            }
            case 3: {
                this.paintInstructions(g);
                this.paintArrows(g);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.paintMessage(g);
                break;
            }
            case 6: {
                this.paintMessage(g);
            }
        }
        this.paintFK(g);
    }

    public void paintBackgroundColor(Graphics g) {
        g.setColor(15790841);
        g.fillRect(0, 0, _WIDTH, _HEIGHT);
    }

    public void paintBackground(Graphics g) {
        g.drawImage(this._imgBackground, _WIDTH >> 1, _HEIGHT >> 1, 3);
    }

    public void paintGameLogo(Graphics g) {
        g.drawImage(this._imgGameLogo, this._rectTopBig.x, this._rectTopBig.y, 17);
    }

    private void paintMessage(Graphics g) {
        if (this._iStatus == 6) {
            _ptMessage.prepareText(Resources.resTexts[0].getHashedString(77), this._rectText.width);
            _ptMessage.drawText(g, this._rectText, _ptMessage.getTextHeight() >> 1, 3);
        } else if (this._iStatus == 5) {
            _ptMessage.prepareText(Resources.resTexts[0].getHashedString(78), this._rectText.width);
            _ptMessage.drawText(g, this._rectText, _ptMessage.getTextHeight() >> 1, 3);
        } else if (this._iStatus == 2) {
            String text = Resources.resTexts[0].getHashedString(13) + "\n" + Resources.resTexts[0].getHashedString(10) + " : " + RMSObjects.game.getScore() + "\n" + Resources.resTexts[0].getHashedString(52);
            if (_ptMessage == null) {
                System.out.println("_ptMessage is null");
                return;
            }
            _ptMessage.prepareText(text, this._rectText.width);
            _ptMessage.drawText(g, this._rectText, _ptMessage.getTextHeight() >> 1, 3);
        }
    }

    private void paintArrows(Graphics g) {
        menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this._rectTitle.width);
        menuItem.drawText(g, this._rectTopLittleTXT, 0, 3);
        if (this._bScrollDOWN && this._bScrollUP) {
            this._sprArrows.setPosition((this._rectPanel.x + this._rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this._rectPanel.y);
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
            this._sprArrows.setPosition((this._rectPanel.x + this._rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this._rectPanel.y + this._rectPanel.height - this._sprArrows.getWidth());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        } else if (!this._bScrollDOWN && this._bScrollUP) {
            this._sprArrows.setPosition((this._rectPanel.x + this._rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this._rectPanel.y);
            this._sprArrows.setFrame(0);
            this._sprArrows.paint(g);
        }
        if (this._bScrollDOWN && !this._bScrollUP) {
            this._sprArrows.setPosition((this._rectPanel.x + this._rectPanel.width >> 1) - (this._sprArrows.getWidth() >> 2), this._rectPanel.y + this._rectPanel.height - this._sprArrows.getWidth());
            this._sprArrows.setFrame(1);
            this._sprArrows.paint(g);
        }
    }

    private void paintInstructions(Graphics g) {
        _ptInstructions.drawText(g, this._rectText, this._iTextOffsetY, 20);
    }

    private void paintPanelTop(Graphics g) {
        g.drawImage(this._imgButtonTop, this._rectTopLittle.getCenterX(), this._rectTopLittle.getCenterY(), 3);
        String score = RMSObjects.game.getScore() + "";
        String addscore = "000000";
        addscore = score.length() == 1 ? "000" : (score.length() == 2 ? "00" : (score.length() == 3 ? "0" : ""));
        actualScore.prepareText(addscore + RMSObjects.game.getScore(), this._rectTopLittle.width);
        actualScore.drawText(g, this._rectTopLittle, 0, 3);
    }

    public void paintTop(Graphics g) {
        if (this._iStatus == 3) {
            menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this._rectText.width);
            menuItem.drawText(g, this._rectTopLittleTXT, 0, 3);
        } else if (this._iStatus == 4) {
            // empty if block
        }
    }

    private void paintFK(Graphics g) {
        if (this._iStatus == 0) {
            this._sprIcons.setFrame(0);
            this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), this.mainCanvas.getHeight() - this._sprIcons.getWidth());
            this._sprIcons.paint(g);
        } else if (this._iStatus == 4) {
            this._sprIcons.setFrame(9);
            this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), this.mainCanvas.getHeight() - this._sprIcons.getWidth());
            this._sprIcons.paint(g);
        } else if (this._iStatus == 1) {
            this._sprIcons.setFrame(9);
            this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), this.mainCanvas.getHeight() - this._sprIcons.getWidth());
            this._sprIcons.paint(g);
        } else if (this._iStatus == 3) {
            this._sprIcons.setFrame(9);
            this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), this.mainCanvas.getHeight() - this._sprIcons.getWidth());
            this._sprIcons.paint(g);
        } else if (this._iStatus == 5) {
            this._sprIcons.setFrame(6);
            this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), this.mainCanvas.getHeight() - this._sprIcons.getWidth());
            this._sprIcons.paint(g);
            this._sprIcons.setFrame(7);
            this._sprIcons.setPosition(0, this.mainCanvas.getHeight() - this._sprIcons.getWidth());
            this._sprIcons.paint(g);
        } else if (this._iStatus == 6) {
            this._sprIcons.setFrame(6);
            this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), this.mainCanvas.getHeight() - this._sprIcons.getWidth());
            this._sprIcons.paint(g);
            this._sprIcons.setFrame(7);
            this._sprIcons.setPosition(0, this.mainCanvas.getHeight() - this._sprIcons.getWidth());
            this._sprIcons.paint(g);
        } else if (this._iStatus == 2) {
            if (RMSObjects.game.isGameOver()) {
                this._sprIcons.setFrame(6);
                this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), this.mainCanvas.getHeight() - this._sprIcons.getWidth());
                this._sprIcons.paint(g);
                this._sprIcons.setFrame(7);
                this._sprIcons.setPosition(0, this.mainCanvas.getHeight() - this._sprIcons.getWidth());
                this._sprIcons.paint(g);
            } else {
                this._sprIcons.setFrame(6);
                this._sprIcons.setPosition(this.mainCanvas.getWidth() - this._sprIcons.getWidth(), this.mainCanvas.getHeight() - this._sprIcons.getWidth());
                this._sprIcons.paint(g);
                this._sprIcons.setFrame(7);
                this._sprIcons.setPosition(0, this.mainCanvas.getHeight() - this._sprIcons.getWidth());
                this._sprIcons.paint(g);
            }
        }
    }

    private void paintMenuDialogItems(Graphics g) {
        if (this._iSelectedCompId == 3) {
            this.paintButton(g, 3, 0, true);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(25), this._rectItems_TXT[0].width);
            menuItem.drawText(g, this._rectItems_TXT[0], 0, 3);
        } else {
            this.paintButton(g, 3, 0, false);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(25), this._rectItems_TXT[0].width);
            menuItem.drawText(g, this._rectItems_TXT[0], 0, 3);
        }
        if (this._iSelectedCompId == 6) {
            this.paintButton(g, 6, 1, true);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this._rectItems_TXT[3].width);
            menuItem.drawText(g, this._rectItems_TXT[3], 0, 3);
        } else {
            this.paintButton(g, 6, 1, false);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this._rectItems_TXT[3].width);
            menuItem.drawText(g, this._rectItems_TXT[3], 0, 3);
        }
        if (this._iSelectedCompId == 4) {
            this.paintButton(g, 4, 1, true);
            menuItem.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this._rectItems_TXT[1].width);
            menuItem.drawText(g, this._rectItems_TXT[1], 0, 3);
        } else {
            this.paintButton(g, 4, 1, false);
            menuItem.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this._rectItems_TXT[1].width);
            menuItem.drawText(g, this._rectItems_TXT[1], 0, 3);
        }
        if (this._iSelectedCompId == 5) {
            this.paintButton(g, 5, 2, true);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(19), this._rectItems_TXT[2].width);
            menuItem.drawText(g, this._rectItems_TXT[2], 0, 3);
        } else {
            this.paintButton(g, 5, 2, false);
            menuItem.prepareText(Resources.resTexts[0].getHashedString(19), this._rectItems_TXT[2].width);
            menuItem.drawText(g, this._rectItems_TXT[2], 0, 3);
        }
    }

    private void paintButton(Graphics g, int _type, int frame, boolean active) {
        if (active) {
            g.drawImage(this._imgButtonSelector, this._rectItems[_type].getCenterX(), this._rectItems[_type].getCenterY(), 3);
        } else {
            g.drawImage(this._imgButton, this._rectItems[_type].getCenterX(), this._rectItems[_type].getCenterY(), 3);
        }
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this._iStatus) {
            case 4: {
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 0);
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                }
                if (Keys.isFKLeftCode(keyCode)) break;
                if (keyCode == 49) {
                    RMSObjects.game.selectFirstColor();
                    break;
                }
                if (keyCode == 51) {
                    RMSObjects.game.selectSecondColor();
                    break;
                }
                if (keyCode == 57) {
                    RMSObjects.game.selectThirdColor();
                    break;
                }
                if (keyCode != 55) break;
                RMSObjects.game.selectFourthColor();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                this._iTextOffsetY = 0;
                this._bScrollUP = false;
                this._bScrollDOWN = true;
                this._iSelectedCompId = 6;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                    if (!MainCanvas.soundManager.IsSoundOn()) break;
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
                break;
            }
            case 5: {
                if (Keys.isFKLeftCode(keyCode)) {
                    RMSObjects.game.restartGame(this._rectGameArea);
                    this.startAnimation(true, 0);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.startAnimation(true, 1);
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        this.startAnimation(true, 1);
        this._iSelectedCompId = 3;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this._iSelectedCompId) {
            case 2: {
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 4;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 5);
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.SetSoundOn(false);
                    Settings.musicOn = false;
                    MainCanvas.soundManager.Stop();
                    break;
                }
                MainCanvas.soundManager.SetSoundOn(true);
                Settings.musicOn = true;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 4;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 3);
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this._iSelectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this._iSelectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.startAnimation(true, 6);
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.startAnimation(true, 0);
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.loadBestScore();
                RMSObjects.game.restartGame(this._rectGameArea);
                this.startAnimation(true, 0);
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                // empty if block
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        if (this._iStatus == 0 && this._rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block5: for (int i = 0; i < this._rectItems.length; ++i) {
            if (!this.existComponentInState(i, this._iStatus) || this._rectItems[i] == null || !this._rectItems[i].contains(x, y)) continue;
            this._iSelectedCompId = i;
            switch (this._iSelectedCompId) {
                case 0: {
                    if (this._iStatus != 1) {
                        Keys.keyPressed(-6);
                        continue block5;
                    }
                    Keys.keyPressed(-6);
                    continue block5;
                }
                case 1: {
                    if (this._iStatus == 3) {
                        this.startAnimation(true, 1);
                        this._iTextOffsetY = 0;
                        this._bScrollUP = false;
                        this._bScrollDOWN = true;
                        this.mainCanvas.repaint();
                        continue block5;
                    }
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    this.mainCanvas.repaint();
                    continue block5;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int _iStatus) {
        if (_iStatus == 0) {
            if (i == 1) {
                return true;
            }
        } else if (_iStatus == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (_iStatus == 3) {
            if (i == 1) {
                return true;
            }
        } else if (_iStatus == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 5) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (_iStatus == 3) {
            if (i == 1) {
                return true;
            }
        } else if (_iStatus == 4) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this._iStatus == 3) {
            if (this.posY > y) {
                this.dragUp();
            } else if (this.posY < y) {
                this.dragDown();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this._iStatus == 4) {
            this.startAnimation(true, 0);
            return;
        }
        if (this._iStatus == 0 && this._rectGameArea.contains(x, y)) {
            RMSObjects.game.pointerReleased(x, y);
            return;
        }
        switch (this._iSelectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                break;
            }
            case 1: {
                if (Keys.isKeyPressed(-7)) {
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                }
                this.mainCanvas.repaint();
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this._iStatus != 1) break;
                this._iSelectedCompId = 1;
                this.mainCanvas.repaint();
            }
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this._iTextOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY < 0) {
            this._iTextOffsetY = 0;
            this._bScrollUP = false;
            this._bScrollDOWN = true;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = _ptInstructions.getTextHeight() - this._rectPanel.height;
        if (Resources.sysFont) {
            this._iTextOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        } else {
            this._iTextOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this._bScrollUP = true;
            this._bScrollDOWN = true;
        }
        if (this._iTextOffsetY > maxOffsetY) {
            this._iTextOffsetY = maxOffsetY;
            this._bScrollUP = true;
            this._bScrollDOWN = false;
        }
        this._bNeedRepaint = true;
        this.mainCanvas.repaint();
    }
}

