/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import jazzlib.DataFormatException;
import jazzlib.StreamManipulator;
import multime.MultiME;

public class InflaterHuffmanTree {
    private static final int MAX_BITLEN = 15;
    private short[] tree;
    public static InflaterHuffmanTree defLitLenTree;
    public static InflaterHuffmanTree defDistTree;
    private static final String bit4Reverse = "\u0000\b\u0004\f\u0002\n\u0006\u000e\u0001\t\u0005\r\u0003\u000b\u0007\u000f";

    public InflaterHuffmanTree(byte[] byArray) throws DataFormatException {
        this.buildTree(byArray);
    }

    private void buildTree(byte[] byArray) throws DataFormatException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        for (n7 = 0; n7 < byArray.length; ++n7) {
            n6 = byArray[n7];
            if (n6 <= 0) continue;
            int n8 = n6;
            nArray[n8] = nArray[n8] + 1;
        }
        n7 = 0;
        n6 = 512;
        for (n5 = 1; n5 <= 15; ++n5) {
            nArray2[n5] = n7;
            n7 += nArray[n5] << 16 - n5;
            if (n5 < 10) continue;
            n4 = nArray2[n5] & 0x1FF80;
            n3 = n7 & 0x1FF80;
            n6 += n3 - n4 >> 16 - n5;
        }
        if (n7 != 65536) {
            throw new DataFormatException("Code lengths don't add up properly.");
        }
        this.tree = new short[n6];
        n5 = 512;
        for (n4 = 15; n4 >= 10; --n4) {
            n3 = n7 & 0x1FF80;
            for (n2 = n = (n7 -= nArray[n4] << 16 - n4) & 0x1FF80; n2 < n3; n2 += 128) {
                this.tree[InflaterHuffmanTree.bitReverse((int)n2)] = (short)(-n5 << 4 | n4);
                n5 += 1 << n4 - 9;
            }
        }
        for (n4 = 0; n4 < byArray.length; ++n4) {
            n3 = byArray[n4];
            if (n3 == 0) continue;
            n7 = nArray2[n3];
            n = InflaterHuffmanTree.bitReverse(n7);
            if (n3 <= 9) {
                do {
                    this.tree[n] = (short)(n4 << 4 | n3);
                } while ((n += 1 << n3) < 512);
            } else {
                n2 = this.tree[n & 0x1FF];
                int n9 = 1 << (n2 & 0xF);
                n2 = -(n2 >> 4);
                do {
                    this.tree[n2 | n >> 9] = (short)(n4 << 4 | n3);
                } while ((n += 1 << n3) < n9);
            }
            nArray2[n3] = n7 + (1 << 16 - n3);
        }
    }

    public int getSymbol(StreamManipulator streamManipulator) throws DataFormatException {
        int n;
        int n2 = streamManipulator.bits_in_buffer < 9 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & 0x1FF) : (n = streamManipulator.buffer & 0x1FF);
        if (n2 >= 0) {
            short s = this.tree[n];
            if (s >= 0) {
                streamManipulator.buffer >>>= s & 0xF;
                streamManipulator.bits_in_buffer -= s & 0xF;
                return s >> 4;
            }
            int n3 = -(s >> 4);
            int n4 = s & 0xF;
            int n5 = streamManipulator.bits_in_buffer < n4 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & (1 << n4) - 1) : (n = streamManipulator.buffer & (1 << n4) - 1);
            if (n5 >= 0) {
                s = this.tree[n3 | n >> 9];
                streamManipulator.buffer >>>= s & 0xF;
                streamManipulator.bits_in_buffer -= s & 0xF;
                return s >> 4;
            }
            int n6 = streamManipulator.getAvailableBits();
            n = streamManipulator.bits_in_buffer < n6 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & (1 << n6) - 1) : streamManipulator.buffer & (1 << n6) - 1;
            s = this.tree[n3 | n >> 9];
            if ((s & 0xF) <= n6) {
                streamManipulator.buffer >>>= s & 0xF;
                streamManipulator.bits_in_buffer -= s & 0xF;
                return s >> 4;
            }
            return -1;
        }
        int n7 = streamManipulator.getAvailableBits();
        n = streamManipulator.bits_in_buffer < n7 ? (streamManipulator.window_start == streamManipulator.window_end ? -1 : (streamManipulator.buffer |= (streamManipulator.window[streamManipulator.window_start++] & 0xFF | (streamManipulator.window[streamManipulator.window_start++] & 0xFF) << 8) << (streamManipulator.bits_in_buffer += 16) - 16) & (1 << n7) - 1) : streamManipulator.buffer & (1 << n7) - 1;
        short s = this.tree[n];
        if (s >= 0 && (s & 0xF) <= n7) {
            streamManipulator.buffer >>>= s & 0xF;
            streamManipulator.bits_in_buffer -= s & 0xF;
            return s >> 4;
        }
        return -1;
    }

    static short bitReverse(int n) {
        return (short)(bit4Reverse.charAt(n & 0xF) << 12 | bit4Reverse.charAt(n >> 4 & 0xF) << 8 | bit4Reverse.charAt(n >> 8 & 0xF) << 4 | bit4Reverse.charAt(n >> 12));
    }

    static {
        MultiME.classLoaded("jazzlib.InflaterHuffmanTree");
        try {
            byte[] byArray = new byte[288];
            int n = 0;
            while (n < 144) {
                byArray[n++] = 8;
            }
            while (n < 256) {
                byArray[n++] = 9;
            }
            while (n < 280) {
                byArray[n++] = 7;
            }
            while (n < 288) {
                byArray[n++] = 8;
            }
            defLitLenTree = new InflaterHuffmanTree(byArray);
            byArray = new byte[32];
            n = 0;
            while (n < 32) {
                byArray[n++] = 5;
            }
            defDistTree = new InflaterHuffmanTree(byArray);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("jazzlib.InflaterHuffmanTree");
        try {
            byte[] byArray = new byte[288];
            int n = 0;
            while (n < 144) {
                byArray[n++] = 8;
            }
            while (n < 256) {
                byArray[n++] = 9;
            }
            while (n < 280) {
                byArray[n++] = 7;
            }
            while (n < 288) {
                byArray[n++] = 8;
            }
            defLitLenTree = new InflaterHuffmanTree(byArray);
            byArray = new byte[32];
            n = 0;
            while (n < 32) {
                byArray[n++] = 5;
            }
            defDistTree = new InflaterHuffmanTree(byArray);
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
    }

    public static void staticSuperCleaningRoutine() {
        defLitLenTree = null;
        defDistTree = null;
    }
}

