/*
 * Decompiled with CFR 0.152.
 */
package jazzlib;

import multime.MultiME;

class StreamManipulator {
    public byte[] window;
    public int window_start = 0;
    public int window_end = 0;
    public int buffer = 0;
    public int bits_in_buffer = 0;

    public final int getBits(int n) {
        int n2;
        int n3 = this.bits_in_buffer < n ? (this.window_start == this.window_end ? -1 : (this.buffer |= (this.window[this.window_start++] & 0xFF | (this.window[this.window_start++] & 0xFF) << 8) << (this.bits_in_buffer += 16) - 16) & (1 << n) - 1) : (n2 = this.buffer & (1 << n) - 1);
        if (n2 >= 0) {
            this.buffer >>>= n;
        }
        this.bits_in_buffer -= n;
        return n2;
    }

    public final int getAvailableBits() {
        return this.bits_in_buffer;
    }

    public final int getAvailableBytes() {
        return this.window_end - this.window_start + (this.bits_in_buffer >> 3);
    }

    public void skipToByteBoundary() {
        this.buffer >>= this.bits_in_buffer & 7;
        this.bits_in_buffer &= 0xFFFFFFF8;
    }

    public final boolean needsInput() {
        return this.window_start == this.window_end;
    }

    public int copyBytes(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("length negative");
        }
        if ((this.bits_in_buffer & 7) != 0) {
            throw new IllegalStateException("Bit buffer is not aligned!");
        }
        int n3 = 0;
        while (this.bits_in_buffer > 0 && n2 > 0) {
            byArray[n++] = (byte)this.buffer;
            this.buffer >>>= 8;
            this.bits_in_buffer -= 8;
            --n2;
            ++n3;
        }
        if (n2 == 0) {
            return n3;
        }
        int n4 = this.window_end - this.window_start;
        if (n2 > n4) {
            n2 = n4;
        }
        System.arraycopy(this.window, this.window_start, byArray, n, n2);
        this.window_start += n2;
        if ((this.window_start - this.window_end & 1) != 0) {
            this.buffer = this.window[this.window_start++] & 0xFF;
            this.bits_in_buffer = 8;
        }
        return n3 + n2;
    }

    public void reset() {
        this.bits_in_buffer = 0;
        this.buffer = 0;
        this.window_end = 0;
        this.window_start = 0;
    }

    public void setInput(byte[] byArray, int n, int n2) {
        if (this.window_start < this.window_end) {
            throw new IllegalStateException("Old input was not completely processed");
        }
        int n3 = n + n2;
        if (0 > n || n > n3 || n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if ((n2 & 1) != 0) {
            this.buffer |= (byArray[n++] & 0xFF) << this.bits_in_buffer;
            this.bits_in_buffer += 8;
        }
        this.window = byArray;
        this.window_start = n;
        this.window_end = n3;
    }

    static {
        MultiME.classLoaded("jazzlib.StreamManipulator");
    }

    public static void staticClinitSuperClone() {
        MultiME.classLoaded("jazzlib.StreamManipulator");
    }

    public static void staticSuperCleaningRoutine() {
    }
}

