/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;

public class CoordinateLayout
extends Layout {
    private int a;
    private int b;

    public CoordinateLayout() {
        this.a = -1;
        this.b = -1;
    }

    public CoordinateLayout(int n, int n2) {
        this.a = n;
        this.b = n2;
    }

    public CoordinateLayout(Dimension dimension) {
        this(dimension.getWidth(), dimension.getHeight());
    }

    public void layoutContainer(Container container) {
        if (this.a < 0) {
            return;
        }
        int n = container.getComponentCount();
        int n2 = container.getWidth();
        int n3 = container.getHeight();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponentAt(i);
            int n4 = component.getX() * n2 / this.a;
            int n5 = component.getY() * n3 / this.b;
            component.setX(n4);
            component.setY(n5);
            component.setWidth(component.getPreferredW());
            component.setHeight(component.getPreferredH());
        }
        this.a = n2;
        this.b = n3;
    }

    public Dimension getPreferredSize(Container container) {
        Dimension dimension = new Dimension();
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponentAt(i);
            dimension.setWidth(Math.max(dimension.getWidth(), component.getX() + component.getPreferredW()));
            dimension.setHeight(Math.max(dimension.getHeight(), component.getY() + component.getPreferredH()));
        }
        return dimension;
    }

    public boolean isOverlapSupported() {
        return true;
    }
}

