/*
 * Decompiled with CFR 0.152.
 */
package Samsung.ApiVersion;

import Samsung.ApiVersion.SidCanvasList;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

class TextCanvas
extends Canvas
implements CommandListener {
    boolean firstTime = true;
    boolean stringLeft = false;
    boolean lastStringLeft;
    boolean startStringLeft;
    Font font;
    int height;
    int curX;
    int curY;
    int curLineWidth;
    int width;
    int startString;
    int lastString;
    int lineHeight;
    int subtractX;
    int subtractY;
    String[] textDetail;
    SidCanvasList mas;
    public static Command CMD_OK;
    Display display;
    String selectedSubString;
    String selectedSublist;

    public TextCanvas(SidCanvasList mas, String[] textDetail) {
        this.mas = mas;
        this.textDetail = textDetail;
    }

    public TextCanvas(String[] textDetail, Display display, String selectedSubString) {
        this.textDetail = textDetail;
        this.display = display;
        this.selectedSubString = selectedSubString;
        this.setTitle(selectedSubString);
        CMD_OK = new Command("Ok", 4, 0);
        this.addCommand(CMD_OK);
        this.setCommandListener(this);
    }

    public TextCanvas(SidCanvasList mas, String[] textDetail, Display display, String selectedSublist) {
        this.mas = mas;
        this.textDetail = textDetail;
        this.display = display;
        this.selectedSublist = selectedSublist;
        this.setTitle(selectedSublist);
        CMD_OK = new Command("Ok", 4, 0);
        this.addCommand(CMD_OK);
        this.setCommandListener(this);
    }

    public TextCanvas(Display display, String[] textDetail, String selectedSublist) {
        this.textDetail = textDetail;
        this.display = display;
        this.setTitle(selectedSublist);
        CMD_OK = new Command("Ok", 4, 0);
        this.addCommand(CMD_OK);
        this.setCommandListener(this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == CMD_OK && this.selectedSubString == null) {
            this.display.setCurrent((Displayable)this.mas);
        }
    }

    public void paint(Graphics g) {
        if (this.firstTime) {
            this.font = g.getFont();
            this.firstTime = false;
            this.stringLeft = false;
            this.lastStringLeft = false;
            this.lineHeight = this.font.getHeight();
            this.width = this.getWidth() - 6;
            this.height = this.getHeight() - this.getHeight() / this.lineHeight;
            this.curX = 0;
            this.curY = 0;
            this.subtractX = 0;
            this.subtractY = 0;
            this.lastString = 0;
        }
        this.curX = 0 - this.subtractX;
        this.curY = 0 - this.subtractY;
        this.startStringLeft = true;
        g.setColor(48);
        g.fillRect(-10, -10, this.getWidth() + 20, this.getHeight() + 20);
        g.setColor(0xFFFFFF);
        for (int i = 0; i < this.textDetail.length; ++i) {
            if (this.textDetail[i].equals("\n")) {
                this.curY += this.lineHeight;
                continue;
            }
            this.drawText(g, this.textDetail[i], i);
            if (!this.stringLeft) continue;
            return;
        }
    }

    protected void keyPressed(int keyCode) {
        int k = this.getGameAction(keyCode);
        if (k == 6) {
            if (this.stringLeft) {
                this.subtractY += this.lineHeight;
            }
        } else if (k == 1) {
            if (this.subtractY != 0) {
                this.subtractY -= this.lineHeight;
            }
        } else if (k == 8) {
            // empty if block
        }
        this.repaint();
    }

    protected void keyRepeated(int keyCode) {
        int k = this.getGameAction(keyCode);
        if (k == 6) {
            if (this.stringLeft) {
                this.subtractY += this.lineHeight;
            }
        } else if (k == 1 && this.subtractY != 0) {
            this.subtractY -= this.lineHeight;
        }
        this.repaint();
    }

    private void drawText(Graphics g, String str, int typeOfPrinted) {
        int countCharWidth = 0;
        int substrStart = 0;
        int substrEnd = 0;
        boolean x = false;
        int currentChar = 0;
        char[] charArray = str.toCharArray();
        int showStringLength = str.length();
        int totalStringWidth = this.font.charsWidth(charArray, 0, showStringLength);
        boolean endOfStr = false;
        boolean widthOfWord = false;
        boolean incrementCurString = false;
        boolean drawTextExecuted = false;
        this.lastStringLeft = false;
        for (int totalLengthDrawn = 0; totalLengthDrawn < totalStringWidth; totalLengthDrawn += countCharWidth) {
            if (this.curY >= this.height) {
                this.stringLeft = true;
                if (!drawTextExecuted) break;
                this.lastStringLeft = true;
                break;
            }
            this.stringLeft = false;
            endOfStr = false;
            widthOfWord = false;
            this.curLineWidth = this.width;
            for (countCharWidth = 0; countCharWidth < this.curLineWidth && currentChar < showStringLength; countCharWidth += this.font.charWidth(charArray[currentChar])) {
                if (charArray[currentChar] == ' ') {
                    int widthSpaces = countCharWidth;
                    int currentSpaceChar = currentChar;
                    do {
                        if (currentSpaceChar >= showStringLength - 1) {
                            endOfStr = true;
                            break;
                        }
                        widthSpaces += this.font.charWidth(charArray[currentSpaceChar]);
                    } while (charArray[++currentSpaceChar] != ' ');
                    if (widthSpaces > this.curLineWidth) {
                        widthOfWord = true;
                        break;
                    }
                }
                substrEnd = ++currentChar;
            }
            g.drawString(str.substring(substrStart, substrEnd), this.curX, this.curY, 0x10 | 4);
            if (this.curY == 0) {
                this.startString = typeOfPrinted;
            }
            drawTextExecuted = true;
            this.lastString = typeOfPrinted;
            this.curY += this.lineHeight;
            this.curX = 0;
            if (this.curY >= this.height) {
                this.stringLeft = true;
                if (!drawTextExecuted) break;
                this.lastStringLeft = true;
                break;
            }
            this.stringLeft = false;
            if (currentChar >= showStringLength) break;
            substrStart = substrEnd;
        }
    }
}

