/*
 * Decompiled with CFR 0.152.
 */
package com.mt.vid.util;

public class ConvertUtils {
    public static String[] convertByteToStrArray(long fileSize) {
        if (fileSize == -1L) {
            fileSize = 0L;
        }
        String[] str = new String[2];
        if (fileSize < 1024L) {
            str[0] = String.valueOf(fileSize);
            str[1] = "byte";
        } else if (fileSize < 0x100000L) {
            str[0] = ConvertUtils.convertByteToKb(fileSize);
            str[1] = "Kb";
        } else if (fileSize < 0x40000000L) {
            str[0] = ConvertUtils.convertByteToMb(fileSize);
            str[1] = "Mb";
        } else {
            str[0] = ConvertUtils.convertByteToGb(fileSize);
            str[1] = "Gb";
        }
        return str;
    }

    public static String convertByteToStr(long fileSize) {
        if (fileSize == -1L) {
            fileSize = 0L;
        }
        String str = fileSize < 1024L ? String.valueOf(String.valueOf(String.valueOf(fileSize))) + " byte" : (fileSize < 0x100000L ? String.valueOf(String.valueOf(ConvertUtils.convertByteToKb(fileSize))) + " Kb" : (fileSize < 0x40000000L ? String.valueOf(String.valueOf(ConvertUtils.convertByteToMb(fileSize))) + " Mb" : String.valueOf(String.valueOf(ConvertUtils.convertByteToGb(fileSize))) + " Gb"));
        return str;
    }

    public static String convertByteToKb(long fileSize) {
        float lengthInMb = (float)fileSize / 1024.0f;
        String size = String.valueOf(ConvertUtils.round(lengthInMb, 1));
        return size;
    }

    public static String convertByteToMb(long fileSize) {
        float lengthInMb = (float)fileSize / 1048576.0f;
        String size = String.valueOf(ConvertUtils.round(lengthInMb, 1));
        return size;
    }

    public static String convertByteToGb(long fileSize) {
        float lengthInMb = (float)fileSize / 1.0737418E9f;
        String size = String.valueOf(ConvertUtils.round(lengthInMb, 1));
        return size;
    }

    private static double round(double num, int numDecim) {
        long p = 1L;
        int i = 0;
        while (i < numDecim) {
            p *= 10L;
            ++i;
        }
        return (double)((int)((double)p * num + 0.5)) / (double)p;
    }
}

