/*
 * Decompiled with CFR 0.152.
 */
package com.mt.vid.ui;

import com.mt.vid.model.VideoModel;
import com.mt.vid.ui.ScreenBase;
import com.mt.vid.util.ImageUtils;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;

public class ScreenVideoDetails
extends ScreenBase
implements CommandListener {
    private Form mForm = new Form("Details");
    private VideoModel mData;
    private Command mCommandPlay = new Command("Play/Save", 4, 1);
    private ScreenVideoDetailsListener mListener;

    public void addScreenVideoDetailsListener(ScreenVideoDetailsListener listener) {
        this.mListener = listener;
    }

    public ScreenVideoDetails() {
        this.mForm.addCommand(this.mCommandPlay);
        this.mForm.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.mCommandPlay) {
            if (this.mListener != null) {
                this.mListener.showScreenPlayOptions(this.mData);
            }
        } else if (this.mNavigateListener != null) {
            this.mNavigateListener.commandActionAlready(c, d);
        }
    }

    public Displayable getScreen() {
        return this.mForm;
    }

    public void setData(VideoModel data) {
        this.mData = data;
        this.mForm.deleteAll();
        this.mForm.setTitle(data.getTitle());
        try {
            this.mForm.append(ImageUtils.loadImage(data.getThumbnailURL()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mForm.append(data.getDesc());
    }

    public static interface ScreenVideoDetailsListener {
        public void showScreenPlayOptions(VideoModel var1);

        public void showScreenPlay(VideoModel var1);
    }
}

