/*
 * Decompiled with CFR 0.152.
 */
package com.mt.vid.ui;

import com.mt.vid.model.VideoModel;
import com.mt.vid.task.CateTask;
import com.mt.vid.task.SearchTask;
import com.mt.vid.ui.ScreenBase;
import com.mt.vid.util.ImageUtils;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class ScreenSearchResult
extends ScreenBase
implements CommandListener,
SearchTask.SearchTaskListener,
CateTask.CateTaskListener {
    private List mList;
    private VideoModel[] mResults;
    private ScreenSearchResultListener mListener;

    public void addScreenSearchResultListener(ScreenSearchResultListener listener) {
        this.mListener = listener;
    }

    public ScreenSearchResult() {
        String[] listName = new String[]{};
        Image[] listImage = new Image[]{};
        this.mList = new List("Result:", 3, listName, listImage);
        this.mList.setSelectCommand(List.SELECT_COMMAND);
        this.mList.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == List.SELECT_COMMAND) {
            if (this.mListener != null) {
                this.mListener.showScreenVideoDetails(this.mResults[this.mList.getSelectedIndex()]);
            }
        } else if (this.mNavigateListener != null) {
            this.mNavigateListener.commandActionAlready(c, d);
        }
    }

    public Displayable getScreen() {
        return this.mList;
    }

    public void search(String keyWord) {
        SearchTask searchTask = new SearchTask(keyWord);
        searchTask.addSearchTaskListener(this);
        searchTask.start();
    }

    public void cate(int cateCode) {
        CateTask searchTask = new CateTask(cateCode);
        searchTask.addCateTaskListener(this);
        searchTask.start();
    }

    public void onResultAlready(VideoModel[] results) {
        this.mResults = results;
        this.mList.deleteAll();
        if (this.mResults != null) {
            int i = 0;
            while (i < this.mResults.length) {
                VideoModel videoItem = this.mResults[i];
                if (videoItem != null) {
                    Image image = null;
                    try {
                        image = ImageUtils.loadImage(videoItem.getThumbnailURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.mList.append(videoItem.getTitle(), image);
                }
                ++i;
            }
        }
        if (this.mListener != null) {
            this.mListener.onSearchFinished();
        }
    }

    public static interface ScreenSearchResultListener {
        public void showScreenVideoDetails(VideoModel var1);

        public void onSearchFinished();
    }
}

