/*
 * Decompiled with CFR 0.152.
 */
package com.mt.vid.ui;

import com.mt.vid.model.VideoFormatModel;
import com.mt.vid.model.VideoModel;
import com.mt.vid.task.ParseTask;
import com.mt.vid.ui.ScreenBase;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class ScreenPlayOptions
extends ScreenBase
implements CommandListener,
ParseTask.ParseTaskListener {
    private List mList = new List("Play Options", 3, new String[0], new Image[0]);
    private VideoModel mData;
    private VideoFormatModel[] mResults;
    private String[] mOptionNames = new String[]{"Play", "Download", "Can't download this video"};
    private ScreenPlayOptionsListener mListener;

    public void addScreenPlayOptionsListener(ScreenPlayOptionsListener listener) {
        this.mListener = listener;
    }

    public ScreenPlayOptions() {
        this.mList.setSelectCommand(List.SELECT_COMMAND);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == List.SELECT_COMMAND) {
            if (this.mListener != null) {
                switch (this.mList.getSelectedIndex()) {
                    case 0: {
                        this.mListener.showScreenPlay(null, this.mData.getVideoURL());
                        break;
                    }
                    case 1: {
                        this.mListener.showScreenDownload(this.mData, this.mResults[0]);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (this.mNavigateListener != null) {
            this.mNavigateListener.commandActionAlready(c, d);
        }
    }

    public Displayable getScreen() {
        return this.mList;
    }

    public void parse(VideoModel data) {
        this.mList.setCommandListener(null);
        this.mList.deleteAll();
        this.mList.append("Parsing...", null);
        this.mData = data;
        ParseTask parseTask = new ParseTask(this.mData);
        parseTask.addParseTaskListener(this);
        parseTask.start();
    }

    public void onResultAlready(VideoFormatModel[] results) {
        this.mList.deleteAll();
        this.mResults = results;
        if (this.mResults != null && this.mResults.length > 0) {
            this.mList.append(this.mOptionNames[0], null);
            this.mList.append(this.mOptionNames[1], null);
        } else {
            this.mList.append(this.mOptionNames[0], null);
            this.mList.append(this.mOptionNames[2], null);
        }
        this.mList.setCommandListener((CommandListener)this);
    }

    public static interface ScreenPlayOptionsListener {
        public void showScreenPlay(String var1, String var2);

        public void showScreenDownload(VideoModel var1, VideoFormatModel var2);
    }
}

