/*
 * Decompiled with CFR 0.152.
 */
package com.mt.vid.ui;

import com.mt.vid.model.VideoFormatModel;
import com.mt.vid.model.VideoModel;
import com.mt.vid.task.DownloadTask;
import com.mt.vid.ui.ScreenBase;
import com.mt.vid.util.ConvertUtils;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class ScreenDownload
extends ScreenBase
implements CommandListener,
DownloadTask.DownloadTaskListener {
    private Form mForm = new Form("Downloading");
    private VideoModel mVideoData;
    private VideoFormatModel mFormatData;
    private ScreenDownloadListener mListener;
    private Command mCommandStop;
    private Command mCommandStart;
    private StringItem mStringItem = new StringItem("Downloading...", "");
    private TextField mFilePath = new TextField("Title", "", 200, 131072);
    private DownloadTask mDownloadTask;

    public void addScreenDownloadListener(ScreenDownloadListener listener) {
        this.mListener = listener;
    }

    public ScreenDownload() {
        this.mForm.append((Item)this.mFilePath);
        this.mForm.append((Item)this.mStringItem);
        this.mCommandStop = new Command("Stop", 4, 1);
        this.mCommandStart = new Command("Start", 4, 1);
        this.mForm.addCommand(this.mCommandStop);
        this.mForm.setCommandListener((CommandListener)this);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.mCommandStop) {
            if (this.mDownloadTask != null) {
                this.mDownloadTask.stop();
            }
        } else if (c == this.mCommandStart) {
            if (this.mDownloadTask != null) {
                this.startDownloadWorker();
            }
        } else if (this.mNavigateListener != null) {
            this.mNavigateListener.commandActionAlready(c, d);
        }
    }

    public Displayable getScreen() {
        return this.mForm;
    }

    private void startDownloadWorker() {
        this.toggleStartStop(false);
        this.mDownloadTask = new DownloadTask(this.mVideoData, this.mFormatData);
        this.mDownloadTask.addDownloadTaskListener(this);
        this.mDownloadTask.start();
    }

    public void download(VideoModel videoData, VideoFormatModel formatData) {
        this.mVideoData = videoData;
        this.mFormatData = formatData;
        this.mForm.setTitle("Downloading");
        this.mFilePath.setLabel("Title");
        this.mFilePath.setString(videoData.getTitle());
        this.startDownloadWorker();
    }

    public void onDownloadFinished(String filePath, long fileSize) {
        this.mForm.setTitle("Downloaded");
        this.mFilePath.setLabel("Path");
        this.mFilePath.setString(filePath);
        this.mStringItem.setLabel("Size");
        this.mStringItem.setText(ConvertUtils.convertByteToStr(fileSize));
        this.toggleStartStop(true);
    }

    public void onDownloadError() {
        this.mStringItem.setText("Download error. Please try later!");
        this.toggleStartStop(true);
    }

    public void onProgress(long total, long downloaded) {
        this.mStringItem.setText(String.valueOf(String.valueOf(ConvertUtils.convertByteToStr(downloaded))) + " of " + ConvertUtils.convertByteToStr(total));
    }

    public void onStopped() {
        this.mStringItem.setText("Download Stopped");
        this.toggleStartStop(true);
    }

    private void toggleStartStop(boolean stopped) {
        if (stopped) {
            this.mForm.removeCommand(this.mCommandStop);
            this.mForm.addCommand(this.mCommandStart);
        } else {
            this.mForm.removeCommand(this.mCommandStart);
            this.mForm.addCommand(this.mCommandStop);
        }
    }

    public static interface ScreenDownloadListener {
    }
}

