/*
 * Decompiled with CFR 0.152.
 */
package com.mt.vid.task;

import com.mt.vid.model.VideoFormatModel;
import com.mt.vid.model.VideoModel;
import com.mt.vid.util.URLUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public class DownloadTask
extends Thread {
    private VideoFormatModel mFormatData;
    private VideoModel mVideoData;
    private DownloadTaskListener mListener;
    private boolean mThreadDead;

    public void addDownloadTaskListener(DownloadTaskListener listener) {
        this.mListener = listener;
    }

    public void stop() {
        this.mThreadDead = true;
    }

    public DownloadTask(VideoModel videoData, VideoFormatModel formatData) {
        this.mFormatData = formatData;
        this.mVideoData = videoData;
    }

    public void run() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("file:///E:/");
            stringBuffer.append("VideoDownloader");
            stringBuffer.append("/");
            stringBuffer.append(URLUtils.urlEncode(this.mVideoData.getTitle().substring(0, 10)));
            stringBuffer.append(".");
            stringBuffer.append(this.mFormatData.getExt());
            String filePath = stringBuffer.toString();
            FileConnection downloadedFile = (FileConnection)Connector.open((String)filePath, (int)3);
            if (!downloadedFile.exists()) {
                downloadedFile.create();
            }
            DataOutputStream ops = new DataOutputStream(downloadedFile.openOutputStream());
            String url = this.mFormatData.getUrlStreaming();
            HttpConnection hc = this.establishConnection(url);
            url = hc.getHeaderField("Location");
            hc.close();
            System.out.println(url);
            hc = this.establishConnection(url);
            if (hc.getResponseCode() == 200) {
                long size = hc.getLength();
                InputStream ips = hc.openInputStream();
                if (size > 0L) {
                    int len;
                    byte[] buf = new byte[1024];
                    DataInputStream dis = new DataInputStream(ips);
                    long downloadedSize = 0L;
                    while ((len = dis.read(buf)) != -1) {
                        if (this.mThreadDead) break;
                        ops.write(buf, 0, len);
                        downloadedSize += (long)len;
                        if (this.mListener == null) continue;
                        this.mListener.onProgress(size, downloadedSize);
                    }
                    ops.close();
                    dis.close();
                    if (this.mListener != null) {
                        if (!this.mThreadDead) {
                            this.mListener.onDownloadFinished(filePath, downloadedSize);
                        } else {
                            this.mListener.onStopped();
                        }
                        return;
                    }
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (this.mListener != null) {
            this.mListener.onDownloadError();
        }
    }

    private HttpConnection establishConnection(String url) {
        try {
            HttpConnection hc = (HttpConnection)Connector.open((String)url);
            hc.setRequestMethod("GET");
            hc.setRequestProperty("User-Agent", "Profile/MIDP-1.0 Configuration/CLDC-1.0");
            System.out.println("Msg: " + hc.getResponseMessage());
            System.out.println("Code: " + hc.getResponseCode());
            return hc;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static interface DownloadTaskListener {
        public void onDownloadFinished(String var1, long var2);

        public void onDownloadError();

        public void onProgress(long var1, long var3);

        public void onStopped();
    }
}

